/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.business.resready;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRValByConditions;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.formula.excel.ExecuteContext;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.ExprParser;
import kd.bos.formula.excel.MapExecuteContext;
import kd.bos.formula.excel.VerifyVisitor;
import kd.bos.formula.excel.Visitor;
import kd.bos.formula.platform.api.IFormulaFunctions;
import kd.bos.formula.platform.engine.FormulaEngine;
import kd.bos.formula.platform.engine.RunFormulaException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.mmc.pom.business.resready.mro.IResReadyRule;
import kd.mmc.pom.common.resready.CustomMethodStruct;
import kd.mmc.pom.common.resready.FetchDataQueryModule;
import kd.mmc.pom.common.resready.ReportException;
import kd.mmc.pom.common.resready.consts.ResReadyReportField;
import kd.mmc.pom.common.resready.entity.SrcBillDataParamBean;
import kd.mmc.pom.common.resready.util.CustomMethodUtils;
import kd.mmc.pom.common.resready.util.DataSetListTransUtil;
import kd.mmc.pom.common.resready.util.POMCustFormulaFuntions;
import kd.mmc.pom.common.resready.util.ResReadyBussinessUtil;

public class ResReadySearchBussiness {
    private static final Log logger = LogFactory.getLog(ResReadySearchBussiness.class);
    private static final String DATA_UNIQUE_FLAG = "datauniqueflag";
    private static final String BILL_UNIQUE_FLAG = "billuniqueflag";
    private static final String CHECKBILL_FILED = "id,billno,treeentryentity.workcard.id,treeentryentity.workcard.name,treeentryentity.workcard.majorflag,treeentryentity.multprojecttask.fbasedataid_id,treeentryentity.multprojecttask.fbasedataid.number,treeentryentity.multprojecttask.fbasedataid.name,treeentryentity.area,treeentryentity.ataid,treeentryentity.zone,treeentryentity.materielmtc,treeentryentity.execondition,remark";
    private static String[] customField = ResReadyReportField.getCustomField();
    private static final String ENTRY_CALCULATE_EXC_TAG = "entrycalculateexc_tag";
    private static final String PREFIX = "entryentity.";
    private static final String MRP_BILLFILED_TRANSFER = "mrp_billfieldtransfer";
    private static final String MRP_RESOURCE_DATACONFIG = "mrp_resource_dataconfig";
    private static final String FMM_READYRULE = "fmm_readyrule";
    private static final String POM_MROORDER = "pom_mroorder";
    private static final String SFC_MROMANUFTECH = "sfc_mromanuftech";
    private static final String RESREADYPLAN = "resreadyplan";
    private static final String FMM_READYPLAN = "fmm_readyplan";
    private HashMap<String, List<Map<String, Object>>> deSourceDataMap = new HashMap();
    private HashMap<String, List<Map<String, Object>>> supSourceDataMap = new HashMap();
    private HashMap<Long, List<Map<String, Object>>> resourceDataMap = new HashMap();
    private Map<Object, DynamicObject> calcDOMap = new HashMap<Object, DynamicObject>(128);
    private Long resRegisterDemandPK = 0L;
    private Long resRegisterSupPK = 0L;
    private static final String ONE_ENTITY_ROWIDEX = "one_entity_rowindex";
    private static final String TWO_ENTITY_ROWIDEX = "two_entity_rowindex";
    private static final String[] ORDERY_MROORDER = new String[]{"projectnumber", "checkebill", "readystatusrestype", "billnumber"};
    private static final String[] ORDERY_TASK = new String[]{"projectnumber", "projecttask", "checkebill", "restype", "billnumber"};
    private static final String EQUIPMENT_RESTYPE = "1";
    private static final String NO_ADVANCE = "D";
    private Map<String, Map<String, String>> propResInfo = new HashMap<String, Map<String, String>>();
    private static final String MATE_FLAG = "mateflag";
    private static final String FIELD = "field";
    private static String[] noAdvanceField = new String[]{"billtype", "billentryseq", "billnumber", "material", "billdate", "demandqty", "baseunit", "estimatereadydate", "actualreadydate", "resourcenumber", "resourcename", "readystatusmroorder", "readystatusprotask", "remark", "atachapterno", "functionlocation", "area"};

    public DataSet getReportData(long orgId, QFilter[] qFilters, String businessAngle, String viewDimen) {
        DataSet retDataSet = null;
        try {
            Map<String, Object> pomSystemParam = this.getPomSystemParam(orgId);
            DynamicObject resReadyPlanDO = this.getSysParamResReadyPlan(pomSystemParam);
            if (resReadyPlanDO == null) {
                throw new ReportException(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u8d44\u6e90\u5c31\u7eea\u68c0\u67e5\u65b9\u6848", (String)"ResReadySearchBussiness_0", (String)"mmc-pom-business", (Object[])new Object[0]));
            }
            if (!StringUtils.equals((CharSequence)"C", (CharSequence)resReadyPlanDO.getString("status"))) {
                String number = resReadyPlanDO.getString("number");
                throw new ReportException(String.format(ResManager.loadKDString((String)"\u7f16\u7801%1$s,\u8d44\u6e90\u5c31\u7eea\u68c0\u67e5\u65b9\u6848\u672a\u5ba1\u6838", (String)"ResReadySearchBussiness_1", (String)"mmc-pom-business", (Object[])new Object[0]), number));
            }
            HashSet<String> sysMroOrderTypeSet = new HashSet<String>(8);
            Object mulMroOrderTypeObj = pomSystemParam.get("mulmroorderrestype");
            if (mulMroOrderTypeObj != null) {
                String sysParmValue = String.valueOf(mulMroOrderTypeObj);
                String[] splits = sysParmValue.split(",");
                for (int i = 0; i < splits.length; ++i) {
                    if (StringUtils.isEmpty((CharSequence)splits[i])) continue;
                    sysMroOrderTypeSet.add(splits[i]);
                }
            }
            boolean isPlan = true;
            String entryEntity = "entryentity";
            if (StringUtils.equals((CharSequence)businessAngle, (CharSequence)EQUIPMENT_RESTYPE)) {
                isPlan = false;
                entryEntity = "entryentityexe";
            }
            long startTime = System.currentTimeMillis();
            List<SrcBillDataParamBean> srcBillDataParamBeans = this.readyQueryData(resReadyPlanDO, isPlan);
            long endTime = System.currentTimeMillis();
            logger.info("\u53c2\u6570\u51c6\u5907\u5b8c\u6210\u3002\u65f6\u957f\uff1a" + (endTime - startTime));
            startTime = System.currentTimeMillis();
            this.resourceDataMap = this.queryResSourceData(srcBillDataParamBeans);
            endTime = System.currentTimeMillis();
            logger.info("\u539f\u59cb\u6570\u636e\u4e0e\u9700\u6c42\u6570\u636e\u67e5\u8be2\u5b8c\u6210\u3002\u65f6\u957f\uff1a" + (endTime - startTime));
            List<Map<String, Object>> resModelOriginalDataList = this.resourceDataMap.get(this.resRegisterDemandPK);
            startTime = System.currentTimeMillis();
            this.handleCheckBillData(resModelOriginalDataList, viewDimen);
            endTime = System.currentTimeMillis();
            logger.info("\u67e5\u8be2\u68c0\u4fee\u5de5\u5355\u76f8\u5173\u6570\u636e\u3002\u65f6\u957f\uff1a" + (endTime - startTime));
            startTime = System.currentTimeMillis();
            List<Map<String, Object>> resRegisterModelDataMap = this.getQFilterData(qFilters, resModelOriginalDataList, viewDimen);
            endTime = System.currentTimeMillis();
            logger.info("\u6309\u67e5\u8be2\u6761\u4ef6\u8fc7\u6ee4\u9700\u6c42\u6570\u636e\u3002\u65f6\u957f\uff1a" + (endTime - startTime));
            if (resRegisterModelDataMap == null || resRegisterModelDataMap.isEmpty()) {
                retDataSet = DataSetListTransUtil.parseToReportDataSet((Object)this, resRegisterModelDataMap);
                return retDataSet;
            }
            this.handleProjectDevices(resRegisterModelDataMap);
            startTime = System.currentTimeMillis();
            this.deSourceDataMap = this.getQFilterSrcData(resRegisterModelDataMap, this.deSourceDataMap);
            endTime = System.currentTimeMillis();
            this.handleResourceInfo(this.deSourceDataMap);
            startTime = System.currentTimeMillis();
            DynamicObjectCollection resReadyPlanDetailDOC = resReadyPlanDO.getDynamicObjectCollection(entryEntity);
            Map<String, HashMap<String, List<Map<String, Object>>>> srcBillDataGroup = this.arrangeData(resReadyPlanDetailDOC, resRegisterModelDataMap, isPlan);
            resRegisterModelDataMap = ResReadyBussinessUtil.excludeNullCheckBill(resRegisterModelDataMap, (String)EQUIPMENT_RESTYPE);
            endTime = System.currentTimeMillis();
            logger.info("\u6309\u8d44\u6e90\u7c7b\u578b\u5206\u7ec4\uff0c\u5305\u62ec\u539f\u59cb\u6570\u636e\u3002\u65f6\u957f\uff1a" + (endTime - startTime));
            logger.info("\u6309\u9700\u6c42\u6570\u636e\u8fc7\u6ee4\u539f\u59cb\u6570\u636e\u3002\u65f6\u957f\uff1a" + (endTime - startTime));
            this.getPlanAngle(srcBillDataGroup, resRegisterModelDataMap, resReadyPlanDO, businessAngle, viewDimen, true);
            if (!isPlan) {
                List<Map<String, Object>> exeCalcResModelData = this.getExeCalcData(resRegisterModelDataMap);
                this.getPlanAngle(srcBillDataGroup, exeCalcResModelData, resReadyPlanDO, businessAngle, viewDimen, false);
            }
            DynamicObject planReadyLevel = resReadyPlanDO.getDynamicObject("readylevel");
            logger.info("\u8ba1\u7b97\u5c31\u7eea\u72b6\u6001-\u8d44\u6e90\u7c7b\u578b\u3002");
            startTime = System.currentTimeMillis();
            this.calcResReadyStatus(resRegisterModelDataMap, viewDimen, planReadyLevel, "readystatusrestype");
            endTime = System.currentTimeMillis();
            logger.info("\u8ba1\u7b97\u5c31\u7eea\u72b6\u6001-\u8d44\u6e90\u7c7b\u578b\u3002\u65f6\u957f\uff1a" + (endTime - startTime));
            logger.info("\u8ba1\u7b97\u5c31\u7eea\u72b6\u6001-\u68c0\u4fee\u5de5\u5355\u3002");
            startTime = System.currentTimeMillis();
            this.calcResReadyStatus(resRegisterModelDataMap, viewDimen, planReadyLevel, "readystatusmroorder");
            endTime = System.currentTimeMillis();
            logger.info("\u8ba1\u7b97\u5c31\u7eea\u72b6\u6001-\u68c0\u4fee\u5de5\u5355\u65f6\u957f\uff1a" + (endTime - startTime));
            if (!StringUtils.equals((CharSequence)viewDimen, (CharSequence)"0")) {
                logger.info("\u8ba1\u7b97\u5c31\u7eea\u72b6\u6001-\u9879\u76ee\u4efb\u52a1  \u53ea\u6709\u5f53\u9879\u76ee\u4efb\u52a1\u89c6\u89d2\u3002");
                this.calcResReadyStatus(resRegisterModelDataMap, viewDimen, planReadyLevel, "readystatusprotask");
            }
            resRegisterModelDataMap = this.supplementNoAdvanceData(sysMroOrderTypeSet, resReadyPlanDetailDOC, resRegisterModelDataMap, isPlan, viewDimen);
            String sqlFilter = this.getQFilterSql(qFilters, viewDimen);
            startTime = System.currentTimeMillis();
            retDataSet = DataSetListTransUtil.parseToReportDataSet((Object)this, resRegisterModelDataMap);
            endTime = System.currentTimeMillis();
            logger.info("List\u8f6cDataSet\u3002\u65f6\u957f\uff1a" + (endTime - startTime));
            retDataSet = retDataSet.where(sqlFilter);
            String[] orderByField = StringUtils.equals((CharSequence)viewDimen, (CharSequence)"0") ? ORDERY_MROORDER : ORDERY_TASK;
            startTime = System.currentTimeMillis();
            retDataSet = retDataSet.orderBy(orderByField);
            endTime = System.currentTimeMillis();
            logger.info("DataSet\u6700\u7ec8\u6392\u5e8f\u3002\u65f6\u957f\uff1a" + (endTime - startTime));
            return retDataSet;
        }
        catch (ReportException rex) {
            throw new KDBizException((Throwable)rex, new ErrorCode("report-error", rex.getMessage()), new Object[0]);
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("report-error", ResManager.loadKDString((String)"\u8d44\u6e90\u5c31\u7eea\u660e\u7ec6\u8868\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458", (String)"ResReadySearchBussiness_11", (String)"mmc-pom-business", (Object[])new Object[0])), new Object[0]);
        }
    }

    private void handleProjectDevices(List<Map<String, Object>> resRegisterModelDataMap) {
        if (resRegisterModelDataMap == null || resRegisterModelDataMap.isEmpty()) {
            return;
        }
        HashSet<Long> projectSet = new HashSet<Long>(8);
        HashSet<Long> materialGroupSet = new HashSet<Long>(8);
        for (int i = 0; i < resRegisterModelDataMap.size(); ++i) {
            Object materialGroup;
            Map<String, Object> modelDataMap = resRegisterModelDataMap.get(i);
            Object projectNumbeID = modelDataMap.get("entryentity.projectnumber");
            if (projectNumbeID instanceof Long) {
                projectSet.add(Long.valueOf(projectNumbeID.toString()));
            }
            if (!((materialGroup = modelDataMap.get("entryentity.materialcontrolgroup")) instanceof Long)) continue;
            materialGroupSet.add(Long.valueOf(materialGroup.toString()));
        }
        DynamicObjectCollection projectDOC = QueryServiceHelper.query((String)"pmpd_project", (String)"id,devices", (QFilter[])new QFilter[]{new QFilter("id", "in", projectSet)});
        if (projectDOC == null || projectDOC.isEmpty()) {
            return;
        }
        HashMap<Long, Long> projectMap = new HashMap<Long, Long>(8);
        for (DynamicObject projectDO : projectDOC) {
            Long pkValue = projectDO.getLong("id");
            Long devices = projectDO.getLong("devices");
            projectMap.put(pkValue, devices);
        }
        DynamicObjectCollection professionaDOC = QueryServiceHelper.query((String)"mpdm_professiona", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", materialGroupSet)});
        if (professionaDOC == null || professionaDOC.isEmpty()) {
            return;
        }
        HashMap<Long, String> professionaMap = new HashMap<Long, String>(8);
        for (DynamicObject professionaDO : professionaDOC) {
            Long pkValue = professionaDO.getLong("id");
            String name = professionaDO.getString("name");
            professionaMap.put(pkValue, name);
        }
        resRegisterModelDataMap.stream().forEach(dataMap -> {
            Object projectObj = dataMap.get("entryentity.projectnumber");
            Object materialGroupObj = dataMap.get("entryentity.materialcontrolgroup");
            if (projectObj instanceof Long) {
                Long project = Long.valueOf(projectObj.toString());
                dataMap.put("materielmtc", projectMap.get(project));
            }
            if (materialGroupObj instanceof Long) {
                Long materialGroup = Long.valueOf(materialGroupObj.toString());
                if (materialGroup == 0L) {
                    dataMap.put("entryentity.materialcontrolgroup", "");
                } else {
                    dataMap.put("entryentity.materialcontrolgroup", professionaMap.get(materialGroup));
                }
            } else {
                dataMap.put("entryentity.materialcontrolgroup", "");
            }
        });
    }

    private void handleResourceInfo(HashMap<String, List<Map<String, Object>>> deSourceDataMap) {
        if (deSourceDataMap == null) {
            return;
        }
        for (Map.Entry<String, List<Map<String, Object>>> entry : deSourceDataMap.entrySet()) {
            String entryKey = entry.getKey();
            Map<String, String> mateFieldMap = this.propResInfo.get(entryKey);
            if (mateFieldMap == null) continue;
            String mateFlag = mateFieldMap.get(MATE_FLAG);
            String field = mateFieldMap.get(FIELD);
            List<Map<String, Object>> value = entry.getValue();
            ResReadyBussinessUtil.writeResourceInfo((String)mateFlag, (String)field, value);
        }
    }

    private List<Map<String, Object>> supplementNoAdvanceData(Set<String> sysMroOrderTypeSet, DynamicObjectCollection resReadyPlanDetailDOC, List<Map<String, Object>> resModelDataList, boolean isPlan, String viewDimen) {
        if (sysMroOrderTypeSet == null || resReadyPlanDetailDOC == null || resModelDataList == null) {
            return resModelDataList;
        }
        String entryResType = "entryentity";
        entryResType = isPlan ? "entryplanrestype" : "entryexerestype";
        HashSet<String> supplementResTypeSet = new HashSet<String>(resReadyPlanDetailDOC.size());
        for (DynamicObject resReadyPlanDetailDO : resReadyPlanDetailDOC) {
            String planResType = resReadyPlanDetailDO.getString(entryResType);
            if (!sysMroOrderTypeSet.contains(planResType)) continue;
            supplementResTypeSet.add(planResType);
        }
        HashMap<String, Set> checkBillTypeMap = new HashMap<String, Set>(resModelDataList.size());
        HashMap<String, Map> checkBillMap = new HashMap<String, Map>(resModelDataList.size());
        for (Map map : resModelDataList) {
            Object checkBillObj = map.get("checkebill");
            String checkBill = checkBillObj == null ? "" : checkBillObj.toString();
            Object resTypeObj = map.get("restype");
            String resType = resTypeObj == null ? "" : resTypeObj.toString();
            Set checkBillTypeSet = checkBillTypeMap.getOrDefault(checkBill, new HashSet());
            checkBillTypeSet.add(resType);
            checkBillMap.put(checkBill, map);
            checkBillTypeMap.put(checkBill, checkBillTypeSet);
        }
        ArrayList<Map<String, Object>> noAdvanceDataList = new ArrayList<Map<String, Object>>(checkBillTypeMap.size());
        for (Map.Entry checkBillEntry : checkBillTypeMap.entrySet()) {
            String entryKey = (String)checkBillEntry.getKey();
            Set checkBillSet = (Set)checkBillEntry.getValue();
            if (checkBillSet == null || checkBillSet.isEmpty()) continue;
            for (String resType : supplementResTypeSet) {
                if (checkBillSet.contains(resType)) continue;
                Map checkBill = (Map)checkBillMap.get(entryKey);
                Map<String, Object> generateCheckBill = this.generateNoAdvanceData(resType, checkBill);
                noAdvanceDataList.add(generateCheckBill);
            }
        }
        resModelDataList.addAll(noAdvanceDataList);
        return resModelDataList;
    }

    private Map<String, Object> generateNoAdvanceData(String resType, Map<String, Object> checkBill) {
        if (StringUtils.isEmpty((CharSequence)resType) || checkBill == null || checkBill.isEmpty()) {
            return null;
        }
        HashMap<String, Object> advanceMap = new HashMap<String, Object>(64);
        advanceMap.putAll(checkBill);
        if (StringUtils.equals((CharSequence)resType, (CharSequence)EQUIPMENT_RESTYPE)) {
            if (checkBill.containsKey("entryentity.checkebill")) {
                advanceMap.put("entryentity.checkebill", null);
            }
            advanceMap.put("checkebill", null);
            advanceMap.put("projecttask", null);
            advanceMap.put("progroup", null);
            advanceMap.put("mulbasedatafield", null);
        }
        advanceMap.put("restype", resType);
        for (int i = 0; i < noAdvanceField.length; ++i) {
            advanceMap.put(noAdvanceField[i], null);
            if (!advanceMap.containsKey(PREFIX + noAdvanceField[i])) continue;
            advanceMap.put(PREFIX + noAdvanceField[i], null);
        }
        advanceMap.put("readystatusmaterial", null);
        advanceMap.put("readystatusrestype", NO_ADVANCE);
        return advanceMap;
    }

    public void getPlanAngle(Map<String, HashMap<String, List<Map<String, Object>>>> srcBillDataGroup, List<Map<String, Object>> resRegisterModelDataMap, DynamicObject resReadyPlanDO, String businessAngle, String viewDimen, boolean isPlan) {
        if (resRegisterModelDataMap == null || resReadyPlanDO == null) {
            return;
        }
        DynamicObject planReadyLevel = resReadyPlanDO.getDynamicObject("readylevel");
        String entryEntity = "entryentity";
        if (!isPlan) {
            entryEntity = "entryentityexe";
        }
        DynamicObjectCollection resReadyPlanDetailDOC = resReadyPlanDO.getDynamicObjectCollection(entryEntity);
        HashMap<Long, DynamicObject> fieldTransferMap = new HashMap<Long, DynamicObject>();
        HashMap<Long, DynamicObject> checkRuleMap = new HashMap<Long, DynamicObject>();
        logger.info("\u4ece\u8d44\u6e90\u5c31\u7eea\u68c0\u67e5\u65b9\u6848\u6570\u636e\u3002");
        this.getfromCheckPlanToData(resReadyPlanDetailDOC, fieldTransferMap, checkRuleMap, isPlan);
        logger.info("\u5bf9\u8d44\u6e90\u5c31\u7eea\u68c0\u67e5\u65b9\u6848\u5206\u5f55\u6392\u5e8f\u3002");
        this.resDetailDOCSort(resReadyPlanDetailDOC, isPlan);
        logger.info("\u5f00\u59cb\u8ba1\u7b97\u72b6\u6001\u3002");
        long startTime = System.currentTimeMillis();
        this.calcMaterialStatus(resReadyPlanDetailDOC, fieldTransferMap, checkRuleMap, srcBillDataGroup, resRegisterModelDataMap, planReadyLevel, isPlan);
        long endTime = System.currentTimeMillis();
        logger.info("\u8ba1\u7b97\u72b6\u6001\u3002\u65f6\u957f\uff1a" + (endTime - startTime));
        logger.info("\u5c06\u8ba1\u7b97\u5b8c\u7684\u6570\u636e\u4ece\u6e90\u6570\u636e\u4e2d\u5199\u5165\u5230\u6a21\u578b\u6570\u636e\u3002");
        startTime = System.currentTimeMillis();
        this.writeBackRegisterModelData(resRegisterModelDataMap, srcBillDataGroup, businessAngle);
        endTime = System.currentTimeMillis();
        logger.info("\u5c06\u8ba1\u7b97\u5b8c\u7684\u6570\u636e\u4ece\u6e90\u6570\u636e\u4e2d\u5199\u5165\u5230\u6a21\u578b\u6570\u636e\u3002\u65f6\u957f\uff1a" + (endTime - startTime));
    }

    private void handleCheckBillData(List<Map<String, Object>> resModelOriginalDataList, String viewDimen) {
        if (resModelOriginalDataList == null) {
            return;
        }
        ArrayList<String> checkeBillStrList = new ArrayList<String>(64);
        ArrayList<Long> checkeBillLongList = new ArrayList<Long>(64);
        for (Map<String, Object> resMap : resModelOriginalDataList) {
            Object checkBillObj = resMap.get("entryentity.checkebill");
            if (checkBillObj instanceof Long) {
                checkeBillLongList.add((Long)checkBillObj);
                continue;
            }
            if (checkBillObj == null) continue;
            checkeBillStrList.add(String.valueOf(checkBillObj));
        }
        HashMap<Object, List<Map<String, Object>>> procjectTaskMap = new HashMap<Object, List<Map<String, Object>>>(32);
        HashMap<String, Set<String>> checkGroupMap = new HashMap<String, Set<String>>(32);
        HashMap<String, Set<String>> checkfessionaMap = new HashMap<String, Set<String>>(32);
        Map<Object, DynamicObject> checkBillMap = this.queryCheckBillMap(checkeBillStrList, checkeBillLongList, procjectTaskMap, checkGroupMap, checkfessionaMap);
        this.writeCheckBillInfo(resModelOriginalDataList, checkBillMap, procjectTaskMap, checkGroupMap, checkfessionaMap, viewDimen);
    }

    private List<Map<String, Object>> getExeCalcData(List<Map<String, Object>> resModelDataMap) {
        ArrayList<Map<String, Object>> resultData = new ArrayList<Map<String, Object>>(64);
        if (resModelDataMap == null) {
            return resultData;
        }
        for (Map<String, Object> modelData : resModelDataMap) {
            String materialStatus = String.valueOf(modelData.get("readystatusmaterial"));
            if (StringUtils.equals((CharSequence)"A", (CharSequence)materialStatus)) continue;
            resultData.add(modelData);
        }
        return resultData;
    }

    private void resDetailDOCSort(DynamicObjectCollection resDetailDOC, boolean isPlan) {
        String resTypeField = "entryplanrestype";
        String orderField = "entryplanorder";
        String resBillNumberField = "entryplanresbill.number";
        if (!isPlan) {
            resTypeField = "entryexerestype";
            orderField = "entryexeorder";
            resBillNumberField = "entryexeresbill.number";
        }
        String finalResTypeField = resTypeField;
        String finalResBillNumberField = resBillNumberField;
        String finalOrderField = orderField;
        resDetailDOC.sort((o1, o2) -> {
            String o1PlanResType = o1.getString(finalResTypeField);
            String o2PlanResType = o2.getString(finalResTypeField);
            String o1Order = o1.getString(finalOrderField);
            String o2Order = o2.getString(finalOrderField);
            String o1Resbill = o1.getString(finalResBillNumberField);
            String o2Resbill = o2.getString(finalResBillNumberField);
            int i = o1PlanResType.compareTo(o2PlanResType);
            if (i == 0) {
                i = o1Resbill.compareTo(o2Resbill);
            }
            if (i == 0) {
                i = o1Order.compareTo(o2Order);
            }
            return i;
        });
    }

    private void calcMaterialStatus(DynamicObjectCollection resPlanDetailDOC, Map<Long, DynamicObject> fieldTransferMap, Map<Long, DynamicObject> checkRuleMap, Map<String, HashMap<String, List<Map<String, Object>>>> srcBillDataGroup, List<Map<String, Object>> resModelDataMap, DynamicObject planReadyLevel, boolean isPlan) {
        if (resPlanDetailDOC == null || srcBillDataGroup == null) {
            return;
        }
        String resTypeField = "entryplanrestype";
        String resbillField = "entryplanresbill";
        String orderField = "entryplanorder";
        String fieldTransField = "entryplanfieldtransfer";
        String readyRuleField = "entryplanreadyrule";
        String entryField = "entryentity";
        if (!isPlan) {
            resTypeField = "entryexerestype";
            resbillField = "entryexeresbill";
            orderField = "entryexeorder";
            fieldTransField = "entryexefieldtransfer";
            readyRuleField = "entryexereadyrule";
            entryField = "entryentityexe";
        }
        Integer entryPlanOrder = -1;
        String entryPlanResType = "";
        String entryPlanResbill = "";
        for (DynamicObject resReadyPlanDetailDO : resPlanDetailDOC) {
            HashMap<String, List<Map<String, Object>>> srcBillDataList;
            String restype = resReadyPlanDetailDO.getString(resTypeField);
            DynamicObject planResbillDO = resReadyPlanDetailDO.getDynamicObject(resbillField);
            String sbillNumber = "";
            if (planResbillDO != null) {
                sbillNumber = String.valueOf(planResbillDO.getPkValue());
            }
            int order = Integer.parseInt(resReadyPlanDetailDO.getString(orderField));
            DynamicObject fieldTransDO = resReadyPlanDetailDO.getDynamicObject(fieldTransField);
            DynamicObject fieldTransCompleteDO = null;
            if (fieldTransDO != null) {
                fieldTransCompleteDO = fieldTransferMap.get(Long.parseLong(String.valueOf(fieldTransDO.getPkValue())));
            }
            if (fieldTransCompleteDO == null) continue;
            DynamicObject readyRuleDO = resReadyPlanDetailDO.getDynamicObject(readyRuleField);
            DynamicObject readyRuleCompleteDO = null;
            if (readyRuleDO != null) {
                readyRuleCompleteDO = checkRuleMap.get(Long.parseLong(String.valueOf(readyRuleDO.getPkValue())));
            }
            if (readyRuleCompleteDO == null || (srcBillDataList = srcBillDataGroup.get(restype)) == null || srcBillDataList.isEmpty()) continue;
            if (StringUtils.equals((CharSequence)entryPlanResType, (CharSequence)restype) && StringUtils.equals((CharSequence)entryPlanResbill, (CharSequence)sbillNumber) && order > entryPlanOrder) {
                this.checkResReadyStatus(resModelDataMap, srcBillDataList, sbillNumber, fieldTransCompleteDO, readyRuleCompleteDO, planReadyLevel, restype, true);
            } else {
                this.checkResReadyStatus(resModelDataMap, srcBillDataList, sbillNumber, fieldTransCompleteDO, readyRuleCompleteDO, planReadyLevel, restype, false);
            }
            entryPlanOrder = order;
            entryPlanResType = restype;
            entryPlanResbill = sbillNumber;
        }
    }

    private List<Map<String, Object>> filterResTypeData(List<Map<String, Object>> resModelDataMap, List<Map<String, Object>> srcBillDataList, String restype, List<Map<String, Object>> srcBillResultData) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(64);
        if (resModelDataMap == null || srcBillDataList == null || StringUtils.isEmpty((CharSequence)restype)) {
            return resultList;
        }
        HashSet<String> uniqueFlagSet = new HashSet<String>(resModelDataMap.size());
        for (Map<String, Object> modelDataMap : resModelDataMap) {
            Object uniqueObj;
            Object restypeObj = modelDataMap.get("restype");
            if (restypeObj == null || !StringUtils.equals((CharSequence)restypeObj.toString(), (CharSequence)restype) || (uniqueObj = modelDataMap.get(DATA_UNIQUE_FLAG)) == null) continue;
            uniqueFlagSet.add(uniqueObj.toString());
            resultList.add(modelDataMap);
        }
        if (srcBillResultData == null) {
            return resultList;
        }
        for (Map<String, Object> srcBillMap : srcBillDataList) {
            Object uniqueObj = srcBillMap.get(DATA_UNIQUE_FLAG);
            if (uniqueObj == null || !uniqueFlagSet.contains(uniqueObj.toString())) continue;
            srcBillResultData.add(srcBillMap);
        }
        return resultList;
    }

    private void writeBackRegisterModelData(List<Map<String, Object>> resRegisterModelDataMap, Map<String, HashMap<String, List<Map<String, Object>>>> srcBillDataGroup, String businessAngle) {
        if (resRegisterModelDataMap == null) {
            return;
        }
        for (Map<String, Object> resMap : resRegisterModelDataMap) {
            List<Map<String, Object>> srcDataList;
            String uniqueKey = String.valueOf(resMap.get(DATA_UNIQUE_FLAG));
            String billFlagKey = String.valueOf(resMap.get(BILL_UNIQUE_FLAG));
            String resTypeKey = String.valueOf(resMap.get("restype"));
            HashMap<String, List<Map<String, Object>>> srcBillModelDataList = srcBillDataGroup.get(resTypeKey);
            if (srcBillModelDataList == null || srcBillModelDataList.isEmpty() || (srcDataList = srcBillModelDataList.get(billFlagKey)) == null || srcDataList.isEmpty()) continue;
            for (Map<String, Object> srcDataMap : srcDataList) {
                String srcUniqueKey = String.valueOf(srcDataMap.get(DATA_UNIQUE_FLAG));
                if (!StringUtils.equals((CharSequence)uniqueKey, (CharSequence)srcUniqueKey)) continue;
                this.setResRegisterData(resMap, srcDataMap, businessAngle);
            }
            Object statusMaterialObj = resMap.get("readystatusmaterial");
            if (statusMaterialObj != null && !StringUtils.isEmpty((CharSequence)String.valueOf(statusMaterialObj))) continue;
            resMap.put("readystatusmaterial", "A");
        }
    }

    private Map<String, HashMap<String, List<Map<String, Object>>>> arrangeData(DynamicObjectCollection resReadyDetailDOC, List<Map<String, Object>> resModelDataMap, boolean isPlan) {
        HashMap<String, HashMap<String, List<Map<String, Object>>>> resultData = new HashMap<String, HashMap<String, List<Map<String, Object>>>>(128);
        if (resReadyDetailDOC == null || resModelDataMap == null) {
            return resultData;
        }
        String resTypeName = "";
        String resbillName = "";
        if (isPlan) {
            resTypeName = "entryplanrestype";
            resbillName = "entryplanresbill";
        } else {
            resTypeName = "entryexerestype";
            resbillName = "entryexeresbill";
        }
        HashMap billExsitFlagSet = new HashMap(16);
        HashSet<String> billExsitSet = new HashSet<String>(16);
        for (int i = 0; i < resReadyDetailDOC.size(); ++i) {
            DynamicObject resReadyDetailDO = (DynamicObject)resReadyDetailDOC.get(i);
            String resType = resReadyDetailDO.getString(resTypeName);
            DynamicObject resBillDO = resReadyDetailDO.getDynamicObject(resbillName);
            if (resBillDO == null) continue;
            Object resBillVObj = resBillDO.getPkValue();
            if (resBillDO == null) continue;
            String resBillV = String.valueOf(resBillVObj.toString());
            HashMap<String, List<Map<String, Object>>> orDefault = resultData.getOrDefault(resType, new HashMap());
            List<Map<String, Object>> maps = this.deSourceDataMap.get(resBillV);
            orDefault.put(resBillV, maps);
            resultData.put(resType, orDefault);
            List billModeDate = resModelDataMap.stream().filter(dataMap -> {
                boolean flag = false;
                Object billUniqueObj = dataMap.get(BILL_UNIQUE_FLAG);
                if (billUniqueObj instanceof String) {
                    flag = StringUtils.equals((CharSequence)billUniqueObj.toString(), (CharSequence)resBillV);
                }
                return flag;
            }).collect(Collectors.toList());
            if (billModeDate == null || billModeDate.isEmpty()) continue;
            String flagKey = resType + ":" + resBillV;
            if (!billExsitSet.contains(flagKey) && billExsitFlagSet.containsKey(resBillV)) {
                List billExsitList = (List)billExsitFlagSet.get(resBillV);
                if (billExsitList == null || billExsitList.isEmpty()) continue;
                ArrayList copyList = new ArrayList(billExsitList.size());
                for (Map dataModelMap : billExsitList) {
                    if (dataModelMap == null) continue;
                    HashMap<String, Object> copyMap = new HashMap<String, Object>(dataModelMap.size());
                    copyMap.putAll(dataModelMap);
                    copyMap.put("restype", resType);
                    Object uniqueFlag = dataModelMap.get(DATA_UNIQUE_FLAG);
                    String uniqueFlagStr = "";
                    if (uniqueFlag != null) {
                        uniqueFlagStr = uniqueFlag.toString();
                    }
                    UUID dataUuid = UUID.randomUUID();
                    copyMap.put(DATA_UNIQUE_FLAG, dataUuid);
                    this.copySrcData(resBillV, uniqueFlagStr, maps, dataUuid);
                    copyList.add(copyMap);
                }
                if (copyList.isEmpty()) continue;
                resModelDataMap.addAll(copyList);
                billExsitSet.add(flagKey);
                continue;
            }
            if (billExsitSet.contains(flagKey)) continue;
            for (Map dataModelMap : billModeDate) {
                dataModelMap.put("restype", resType);
            }
            billExsitFlagSet.put(resBillV, billModeDate);
            billExsitSet.add(flagKey);
        }
        return resultData;
    }

    private void copySrcData(String resBillV, String uniqueFlagStr, List<Map<String, Object>> maps, UUID dataUuid) {
        if (maps == null || StringUtils.isEmpty((CharSequence)uniqueFlagStr) || dataUuid == null) {
            return;
        }
        ArrayList copyData = new ArrayList(maps.size());
        for (Map<String, Object> dataMap : maps) {
            Object dataUnique = dataMap.get(DATA_UNIQUE_FLAG);
            String dataUniqueStr = "";
            if (dataUnique == null || !StringUtils.isNotEmpty((CharSequence)(dataUniqueStr = dataUnique.toString())) || !StringUtils.equals((CharSequence)uniqueFlagStr, (CharSequence)dataUniqueStr)) continue;
            HashMap<String, Object> copyDataMap = new HashMap<String, Object>(dataMap.size());
            copyDataMap.putAll(dataMap);
            copyDataMap.put(DATA_UNIQUE_FLAG, dataUuid);
            copyData.add(copyDataMap);
            break;
        }
        maps.addAll(copyData);
    }

    private HashMap<String, List<Map<String, Object>>> getQFilterSrcData(List<Map<String, Object>> resRegisterModelDataMap, HashMap<String, List<Map<String, Object>>> deSrcDataMap) {
        if (resRegisterModelDataMap == null) {
            return null;
        }
        HashMap<String, List<Map<String, Object>>> srcDataMap = new HashMap<String, List<Map<String, Object>>>(64);
        if (deSrcDataMap == null) {
            return srcDataMap;
        }
        HashSet<String> dataUniqueFlagSet = new HashSet<String>(64);
        for (Map<String, Object> map : resRegisterModelDataMap) {
            String dataUniqueFlag = String.valueOf(map.get(DATA_UNIQUE_FLAG));
            dataUniqueFlagSet.add(dataUniqueFlag);
        }
        for (Map.Entry entry : deSrcDataMap.entrySet()) {
            String deSourceKey = (String)entry.getKey();
            List deSourceDataList = (List)entry.getValue();
            List srcDataList = srcDataMap.getOrDefault(deSourceKey, new ArrayList());
            if (deSourceDataList == null || deSourceDataList.isEmpty()) continue;
            for (Map deSourceDataListMap : deSourceDataList) {
                String deDataUniqueFlag = String.valueOf(deSourceDataListMap.get(DATA_UNIQUE_FLAG));
                if (!dataUniqueFlagSet.contains(deDataUniqueFlag)) continue;
                srcDataList.add(deSourceDataListMap);
            }
            srcDataMap.put(deSourceKey, srcDataList);
        }
        return srcDataMap;
    }

    private List<Map<String, Object>> getQFilterData(QFilter[] qFilters, List<Map<String, Object>> resModelOriginalDataList, String viewDimen) {
        List<Object> filterData = new ArrayList(64);
        filterData = qFilters != null && qFilters.length > 0 && resModelOriginalDataList != null ? resModelOriginalDataList.stream().filter(dataMp -> {
            boolean flag = false;
            for (QFilter qFilter : qFilters) {
                String dataValueStr;
                String property = qFilter.getProperty();
                String propStr = this.getFilterPropFiled(property);
                Object dataValue = dataMp.get(propStr);
                Object filterValue = qFilter.getValue();
                if (StringUtils.equals((CharSequence)"restype", (CharSequence)propStr) || StringUtils.equals((CharSequence)"readystatusmroorder", (CharSequence)propStr) || StringUtils.equals((CharSequence)"readystatusprotask", (CharSequence)propStr) || StringUtils.equals((CharSequence)"readystatusmaterial", (CharSequence)propStr)) {
                    flag = true;
                    continue;
                }
                if (StringUtils.equals((CharSequence)"projecttask", (CharSequence)propStr)) {
                    String string = dataValueStr = dataValue != null ? dataValue.toString() : "";
                    if (!StringUtils.equals((CharSequence)EQUIPMENT_RESTYPE, (CharSequence)viewDimen)) {
                        flag = this.isExistValue(dataValueStr, filterValue);
                        if (!flag) {
                            flag = false;
                            break;
                        }
                    } else if (filterValue instanceof List) {
                        List fileterList = (List)filterValue;
                        if (fileterList.contains(dataValueStr)) {
                            flag = true;
                            continue;
                        }
                        flag = false;
                        break;
                    }
                }
                if (StringUtils.equals((CharSequence)"progroup", (CharSequence)propStr) || StringUtils.equals((CharSequence)"mulbasedatafield", (CharSequence)propStr)) {
                    dataValueStr = dataValue != null ? dataValue.toString() : "";
                    flag = this.isExistValue(dataValueStr, filterValue);
                    if (flag) continue;
                    flag = false;
                    break;
                }
                if (StringUtils.equals((CharSequence)"remark", (CharSequence)propStr)) {
                    if (dataValue instanceof String && filterValue instanceof String) {
                        String filterRplaceV = String.valueOf(filterValue).replace("%", "");
                        if (String.valueOf(dataValue).contains(filterRplaceV)) {
                            flag = true;
                            continue;
                        }
                        flag = false;
                        break;
                    }
                    flag = false;
                    break;
                }
                if (filterValue != null) {
                    if (dataValue != null && filterValue instanceof List) {
                        List filterValueList = (List)filterValue;
                        flag = filterValueList.contains(dataValue);
                        if (!flag) break;
                        continue;
                    }
                    if (dataValue != null && StringUtils.equals((CharSequence)dataValue.toString(), (CharSequence)filterValue.toString())) {
                        flag = true;
                        continue;
                    }
                    flag = false;
                    break;
                }
                flag = true;
            }
            return flag;
        }).collect(Collectors.toList()) : resModelOriginalDataList;
        return filterData;
    }

    private boolean isExistValue(String dataValueStr, Object filterValue) {
        boolean result = true;
        if (!(filterValue instanceof List)) {
            return result;
        }
        if (StringUtils.isNotEmpty((CharSequence)dataValueStr)) {
            List filterVList = (List)filterValue;
            String[] split = dataValueStr.split("\uff1b");
            if (split == null) {
                split = dataValueStr.split(";");
            }
            if (split != null && split.length != ((List)filterValue).size()) {
                result = false;
                return result;
            }
            for (int i = 0; i < filterVList.size(); ++i) {
                String filterVStr = (String)filterVList.get(i);
                if (dataValueStr.contains(filterVStr)) continue;
                result = false;
                break;
            }
        } else {
            result = false;
        }
        return result;
    }

    private String getFilterPropFiled(String property) {
        String result = "";
        switch (property) {
            case "projectnumber": 
            case "checkebill": 
            case "materialcontrolgroup": {
                result = PREFIX + property;
                break;
            }
            default: {
                result = property;
            }
        }
        return result;
    }

    private void calcResReadyStatus(List<Map<String, Object>> modelDataMap, String viewDimen, DynamicObject levelDO, String type) {
        HashMap<String, String> resTypeStatusMap = new HashMap<String, String>(64);
        ArrayList<String> keyFieldList = new ArrayList<String>();
        keyFieldList.add("entryentity.projectnumber");
        String srcStatus = "";
        String destStatus = "";
        switch (type) {
            case "readystatusrestype": {
                srcStatus = "readystatusmaterial";
                destStatus = "readystatusrestype";
                if (StringUtils.equals((CharSequence)viewDimen, (CharSequence)"0")) {
                    keyFieldList.add("checkebill");
                    keyFieldList.add("restype");
                    break;
                }
                keyFieldList.add("projecttask");
                keyFieldList.add("checkebill");
                keyFieldList.add("restype");
                break;
            }
            case "readystatusmroorder": {
                srcStatus = "readystatusrestype";
                destStatus = "readystatusmroorder";
                if (StringUtils.equals((CharSequence)viewDimen, (CharSequence)"0")) {
                    keyFieldList.add("checkebill");
                    break;
                }
                keyFieldList.add("projecttask");
                keyFieldList.add("checkebill");
                break;
            }
            case "readystatusprotask": {
                srcStatus = "readystatusmroorder";
                destStatus = "readystatusprotask";
                if (StringUtils.equals((CharSequence)viewDimen, (CharSequence)"0")) break;
                keyFieldList.add("projecttask");
            }
        }
        HashMap<String, List> restypeMap = new HashMap<String, List>(8);
        Map levelMap = ResReadyBussinessUtil.getLeveLRelationMap((DynamicObject)levelDO);
        for (Map<String, Object> map : modelDataMap) {
            StringBuilder resStatusKey = new StringBuilder();
            for (String keyField : keyFieldList) {
                String value = map.get(keyField) == null ? "" : String.valueOf(map.get(keyField).toString());
                resStatusKey.append(value).append(":");
            }
            String resStatus = (String)resTypeStatusMap.get(resStatusKey.toString());
            String materialStatus = String.valueOf(map.get(srcStatus));
            String finalStatus = this.getLevelToStatus(resStatus, materialStatus, levelMap);
            resTypeStatusMap.put(resStatusKey.toString(), finalStatus);
            List resTypeORDefault = restypeMap.getOrDefault(resStatusKey.toString(), new ArrayList());
            resTypeORDefault.add(map);
            restypeMap.put(resStatusKey.toString(), resTypeORDefault);
        }
        for (Map.Entry entry : restypeMap.entrySet()) {
            String statusKey = (String)entry.getKey();
            List value = (List)entry.getValue();
            String resultStatus = (String)resTypeStatusMap.get(statusKey);
            for (Map dataMap : value) {
                dataMap.put(destStatus, resultStatus);
            }
        }
    }

    private String getLevelToStatus(String finalStatus, String processStatus, Map<String, Integer> levelMap) {
        Integer preLevel = levelMap.get(finalStatus) == null ? Integer.valueOf(-1) : levelMap.get(finalStatus);
        Integer curLevel = levelMap.get(processStatus) == null ? Integer.valueOf(-1) : levelMap.get(processStatus);
        String status = "";
        status = curLevel >= preLevel ? processStatus : finalStatus;
        switch (status) {
            case "A": 
            case "B": 
            case "C": {
                return status;
            }
        }
        return "A";
    }

    private void writeCheckBillInfo(List<Map<String, Object>> resRegisterModelDataMap, Map<Object, DynamicObject> checkBillMap, Map<Object, List<Map<String, Object>>> projectTaskMap, Map<String, Set<String>> checkGroupMap, Map<String, Set<String>> checkfessionaMap, String viewDimen) {
        if (resRegisterModelDataMap == null || resRegisterModelDataMap.isEmpty()) {
            return;
        }
        if (checkBillMap == null || checkBillMap.isEmpty()) {
            return;
        }
        ArrayList addRowDataList = new ArrayList(4);
        resRegisterModelDataMap.stream().forEach(dataMap -> {
            Object checkBillObj = dataMap.get("entryentity.checkebill");
            if (checkBillObj != null) {
                DynamicObject checkBillDO = (DynamicObject)checkBillMap.get(checkBillObj);
                if (checkBillDO == null) {
                    return;
                }
                Long pkValue = checkBillDO.getLong("id");
                String billno = checkBillDO.getString("billno");
                dataMap.put("checkebill", billno);
                dataMap.put("checkebillid", pkValue);
                if (projectTaskMap == null) {
                    return;
                }
                List projectTaskList = (List)projectTaskMap.get(checkBillObj);
                if (projectTaskList == null || projectTaskList.isEmpty()) {
                    return;
                }
                if (!StringUtils.equals((CharSequence)viewDimen, (CharSequence)EQUIPMENT_RESTYPE)) {
                    this.writeCheckBillDemensionInfo((Map<String, Object>)dataMap, projectTaskList);
                    this.writeRelationGroupFession((Map<String, Object>)dataMap, checkGroupMap, checkfessionaMap, pkValue);
                    return;
                }
                this.writeTaskDemensionInfo((Map<String, Object>)dataMap, projectTaskList, addRowDataList, checkGroupMap, checkfessionaMap, pkValue);
            }
        });
        resRegisterModelDataMap.addAll(addRowDataList);
    }

    private void writeTaskDemensionInfo(Map<String, Object> dataMap, List<Map<String, Object>> projectTaskList, List<Map<String, Object>> addRowDataList, Map<String, Set<String>> checkGroupMap, Map<String, Set<String>> checkfessionaMap, Long pkValue) {
        if (dataMap == null || projectTaskList == null || addRowDataList == null) {
            return;
        }
        HashSet<Object> idSet = new HashSet<Object>();
        for (int i = 0; i < projectTaskList.size(); ++i) {
            Map<String, Object> chickBillInfoMap = projectTaskList.get(i);
            String taskName = chickBillInfoMap.get("taskname") == null ? "" : String.valueOf(chickBillInfoMap.get("taskname"));
            Object taskId = chickBillInfoMap.get("id");
            long area = ResReadyBussinessUtil.getLongToMapValue(chickBillInfoMap, (String)"area");
            long functionlocation = ResReadyBussinessUtil.getLongToMapValue(chickBillInfoMap, (String)"functionlocation");
            long atachapterNo = ResReadyBussinessUtil.getLongToMapValue(chickBillInfoMap, (String)"atachapterno");
            String remark = ResReadyBussinessUtil.getStringToMapValue(chickBillInfoMap, (String)"remark");
            String materielmtc = ResReadyBussinessUtil.getStringToMapValue(chickBillInfoMap, (String)"materielmtc");
            String execondition = ResReadyBussinessUtil.getStringToMapValue(chickBillInfoMap, (String)"execondition");
            String majorflag = ResReadyBussinessUtil.getStringToMapValue(chickBillInfoMap, (String)"majorflag");
            Object workcardname = chickBillInfoMap.get("workcardname");
            if (i == 0) {
                dataMap.put("projecttask", taskName);
                dataMap.put("projecttaskid", taskId);
                dataMap.put("mrocard", workcardname);
                dataMap.put("area", area);
                dataMap.put("functionlocation", functionlocation);
                dataMap.put("atachapterno", atachapterNo);
                dataMap.put("remark", remark);
                dataMap.put("materielmtc", materielmtc);
                dataMap.put("execondition", execondition);
                dataMap.put("majorflag", majorflag);
                this.writeRelationGroupFession(dataMap, checkGroupMap, checkfessionaMap, pkValue);
                idSet.add(taskId);
                continue;
            }
            if (!idSet.add(taskId)) continue;
            HashMap<String, Object> rowDataMap = new HashMap<String, Object>(dataMap.size());
            rowDataMap.putAll(dataMap);
            rowDataMap.put("projecttask", taskName);
            rowDataMap.put("projecttaskid", taskId);
            this.writeRelationGroupFession(rowDataMap, checkGroupMap, checkfessionaMap, pkValue);
            addRowDataList.add(rowDataMap);
        }
    }

    private void writeRelationGroupFession(Map<String, Object> dataMap, Map<String, Set<String>> checkGroupMap, Map<String, Set<String>> checkfessionaMap, Long pkValue) {
        String pkValueStr;
        if (dataMap == null) {
            return;
        }
        String string = pkValueStr = pkValue == null ? "" : pkValue.toString();
        if (checkGroupMap != null && checkGroupMap.get(pkValueStr) != null) {
            String groupStr = this.getListToString(checkGroupMap.get(pkValueStr));
            dataMap.put("progroup", groupStr);
        }
        if (checkfessionaMap != null && checkfessionaMap.get(pkValueStr) != null) {
            String fessionaIDS = this.getListToString(checkfessionaMap.get(pkValueStr));
            dataMap.put("mulbasedatafield", fessionaIDS);
        }
    }

    private void writeCheckBillDemensionInfo(Map<String, Object> dataMap, List<Map<String, Object>> projectTaskList) {
        String workCardShowStr;
        String taskIDStr;
        if (dataMap == null || projectTaskList == null) {
            return;
        }
        StringBuilder nameBuild = new StringBuilder();
        StringBuilder idBuild = new StringBuilder();
        HashSet<Object> idSet = new HashSet<Object>(64);
        StringBuilder workCardnameBuild = new StringBuilder();
        HashSet<Object> workCardidSet = new HashSet<Object>(64);
        long area = 0L;
        long functionlocation = 0L;
        long atachapterNo = 0L;
        String remark = "";
        long materielmtc = 0L;
        long execondition = 0L;
        String majorflag = "";
        for (int i = 0; i < projectTaskList.size(); ++i) {
            Map<String, Object> chickBillInfoMap = projectTaskList.get(i);
            this.appendValue(chickBillInfoMap, idSet, nameBuild, "id", "taskname", i, projectTaskList.size());
            this.appendValue(chickBillInfoMap, idSet, idBuild, "id", "id", i, projectTaskList.size());
            this.appendValue(chickBillInfoMap, workCardidSet, workCardnameBuild, "workcardid", "workcardname", i, projectTaskList.size());
            area = ResReadyBussinessUtil.getLongToMapValue(chickBillInfoMap, (String)"area");
            functionlocation = ResReadyBussinessUtil.getLongToMapValue(chickBillInfoMap, (String)"functionlocation");
            atachapterNo = ResReadyBussinessUtil.getLongToMapValue(chickBillInfoMap, (String)"atachapterno");
            remark = ResReadyBussinessUtil.getStringToMapValue(chickBillInfoMap, (String)"remark");
            execondition = ResReadyBussinessUtil.getLongToMapValue(chickBillInfoMap, (String)"execondition");
            majorflag = ResReadyBussinessUtil.getStringToMapValue(chickBillInfoMap, (String)"majorflag");
        }
        String showStr = nameBuild.toString();
        if (StringUtils.equals((CharSequence)"\uff1b", (CharSequence)showStr.trim())) {
            showStr = "";
        }
        if (StringUtils.equals((CharSequence)"\uff1b", (CharSequence)(taskIDStr = idBuild.toString()).trim())) {
            taskIDStr = "";
        }
        if (StringUtils.equals((CharSequence)"\uff1b", (CharSequence)(workCardShowStr = workCardnameBuild.toString()).trim())) {
            workCardShowStr = "";
        }
        dataMap.put("projecttask", showStr);
        dataMap.put("projecttaskid", taskIDStr);
        dataMap.put("mrocard", workCardShowStr);
        dataMap.put("area", area);
        dataMap.put("functionlocation", functionlocation);
        dataMap.put("atachapterno", atachapterNo);
        dataMap.put("remark", remark);
        dataMap.put("execondition", execondition);
        dataMap.put("majorflag", majorflag);
    }

    private void appendValue(Map<String, Object> chickBillInfoMap, Set<Object> idSet, StringBuilder nameBuild, String fieldId, String fieldName, int i, int size) {
        if (chickBillInfoMap == null || idSet == null || nameBuild == null) {
            return;
        }
        String taskName = chickBillInfoMap.get(fieldName) == null ? "" : String.valueOf(chickBillInfoMap.get(fieldName));
        Object taskid = chickBillInfoMap.get(fieldId);
        if (!idSet.contains(taskid)) {
            if (i < size - 1) {
                nameBuild.append(taskName).append("\uff1b");
            } else {
                nameBuild.append(taskName);
            }
            idSet.add(taskid);
        }
    }

    private String getListToString(Set<String> strSet) {
        StringBuilder str = new StringBuilder();
        if (strSet != null) {
            String[] objects = strSet.toArray(new String[strSet.size()]);
            for (int i = 0; i < objects.length; ++i) {
                String object = objects[i];
                if (StringUtils.isEmpty((CharSequence)object)) continue;
                str.append(object);
                if (strSet.size() <= 1 || i == objects.length - 1) continue;
                str.append("\uff1b");
            }
        }
        return str.toString();
    }

    private Map<Object, DynamicObject> queryCheckBillMap(List<String> checkeBillStrList, List<Long> checkeBillLongList, Map<Object, List<Map<String, Object>>> procjectTaskMap, Map<String, Set<String>> checkGroupMap, Map<String, Set<String>> checkfessionaMap) {
        HashMap<Object, DynamicObject> checkBillMap = new HashMap<Object, DynamicObject>(64);
        if ((checkeBillStrList == null || checkeBillStrList.isEmpty()) && (checkeBillLongList == null || checkeBillLongList.isEmpty())) {
            return checkBillMap;
        }
        try {
            QFilter mroQFilter;
            DynamicObjectCollection mroManuftechDOC;
            ArrayList qFilters = new ArrayList(2);
            QFilter qFilter = null;
            boolean pkType = false;
            if (checkeBillLongList != null && !checkeBillLongList.isEmpty()) {
                qFilter = new QFilter("id", "in", checkeBillLongList);
                pkType = true;
            }
            if (checkeBillStrList != null && !checkeBillStrList.isEmpty()) {
                if (qFilter == null) {
                    qFilter = new QFilter("billno", "in", checkeBillStrList);
                } else {
                    qFilter.or(new QFilter("billno", "in", checkeBillStrList));
                }
                pkType = false;
            }
            DynamicObjectCollection checkBillDOC = QueryServiceHelper.query((String)POM_MROORDER, (String)CHECKBILL_FILED, (QFilter[])new QFilter[]{qFilter});
            ArrayList<String> mroManuFilterList = new ArrayList<String>(64);
            if (checkBillDOC != null) {
                for (DynamicObject value : checkBillDOC) {
                    Object projectTaskKey;
                    if (value == null) continue;
                    Long pkValue = value.getLong("id");
                    mroManuFilterList.add(pkValue.toString());
                    String billNo = value.getString("billno");
                    if (pkType) {
                        checkBillMap.put(pkValue, value);
                        projectTaskKey = pkValue;
                    } else {
                        checkBillMap.put(billNo, value);
                        projectTaskKey = billNo;
                    }
                    if (procjectTaskMap == null) continue;
                    List orDefault = procjectTaskMap.getOrDefault(projectTaskKey, new ArrayList());
                    Map taskMap = ResReadyBussinessUtil.setCheckBillInfoMap((DynamicObject)value);
                    orDefault.add(taskMap);
                    procjectTaskMap.put(projectTaskKey, orDefault);
                }
            }
            if ((mroManuftechDOC = QueryServiceHelper.query((String)SFC_MROMANUFTECH, (String)"id,manufactureorderid,oprentryentity.oprprocessgroup.number,oprentryentity.oprprocessgroup.name,oprentryentity.oprprofessiona.number,oprentryentity.oprprofessiona.name", (QFilter[])new QFilter[]{mroQFilter = new QFilter("manufactureorderid", "in", mroManuFilterList)})) != null) {
                for (DynamicObject value : mroManuftechDOC) {
                    if (value == null) continue;
                    String manufactureOrderID = value.getString("manufactureorderid");
                    Set groupIDS = checkGroupMap.getOrDefault(manufactureOrderID, new HashSet());
                    Set proFessionaIDS = checkfessionaMap.getOrDefault(manufactureOrderID, new HashSet());
                    groupIDS.add(value.getString("oprentryentity.oprprocessgroup.name"));
                    proFessionaIDS.add(value.getString("oprentryentity.oprprofessiona.name"));
                    checkGroupMap.put(manufactureOrderID, groupIDS);
                    checkfessionaMap.put(manufactureOrderID, proFessionaIDS);
                }
            }
        }
        catch (Exception e) {
            throw new ReportException((Throwable)e, new ErrorCode("querymrooder-error", ResManager.loadKDString((String)"\u68c0\u4fee\u5de5\u5355\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7", (String)"ResReadySearchBussiness_10", (String)"mmc-pom-business", (Object[])new Object[0])), new Object[0]);
        }
        return checkBillMap;
    }

    private String getQFilterSql(QFilter[] qFilters, String viewDimen) {
        StringBuilder sql = new StringBuilder();
        sql.append(" 1=1 ");
        if (qFilters != null) {
            for (int i = 0; i < qFilters.length; ++i) {
                Object value;
                if (StringUtils.equals((CharSequence)"progroup", (CharSequence)qFilters[i].getProperty()) || StringUtils.equals((CharSequence)"mulbasedatafield", (CharSequence)qFilters[i].getProperty()) || StringUtils.equals((CharSequence)"projecttask", (CharSequence)qFilters[i].getProperty()) || !StringUtils.equals((CharSequence)EQUIPMENT_RESTYPE, (CharSequence)viewDimen) && StringUtils.equals((CharSequence)"readystatusprotask", (CharSequence)qFilters[i].getProperty()) || (value = qFilters[i].getValue()) == null || value instanceof String && StringUtils.isEmpty((CharSequence)value.toString())) continue;
                if (StringUtils.isEmpty((CharSequence)sql.toString())) {
                    sql.append(qFilters[i].toString());
                    continue;
                }
                sql.append(" AND ").append(qFilters[i].toString());
            }
        }
        return sql.toString();
    }

    private void setResRegisterData(Map<String, Object> resMap, Map<String, Object> srcDataMap, String businessAngle) {
        String[] showFields = ResReadyReportField.getCustomField();
        if (showFields != null) {
            for (int i = 0; i < showFields.length; ++i) {
                if ("progroup".equals(showFields[i]) || "mulbasedatafield".equals(showFields[i]) || "checkebill".equals(showFields[i]) || "checkebillid".equals(showFields[i]) || "restype".equals(showFields[i]) || "projecttask".equals(showFields[i]) || "projecttaskid".equals(showFields[i]) || "area".equals(showFields[i]) || "functionlocation".equals(showFields[i]) || "atachapterno".equals(showFields[i]) || "remark".equals(showFields[i]) || "materielmtc".equals(showFields[i]) || "execondition".equals(showFields[i]) || "majorflag".equals(showFields[i]) || "materialcontrolgroup".equals(showFields[i]) || "baseunit".equals(showFields[i]) || "materialname".equals(showFields[i])) continue;
                resMap.put(showFields[i], srcDataMap.get(showFields[i]));
            }
            resMap.put("businessangle", businessAngle);
        }
    }

    private void checkResReadyStatus(List<Map<String, Object>> resModelDataMap, HashMap<String, List<Map<String, Object>>> srcBillDataTypeMap, String sbillNumber, DynamicObject fieldTransCompleteDO, DynamicObject readyRuleCompleteDO, DynamicObject planReadyLevel, String restype, boolean isHandle) {
        ArrayList<Map<String, Object>> srcBillDataFilterList;
        List<Map<String, Object>> resModelFilterDataMap;
        if (srcBillDataTypeMap == null) {
            return;
        }
        List<Map<String, Object>> srcBillDataList = srcBillDataTypeMap.get(sbillNumber);
        if (isHandle) {
            srcBillDataList = this.filterOrderSrcBill(srcBillDataList);
        }
        if ((resModelFilterDataMap = this.filterResTypeData(resModelDataMap, srcBillDataList, restype, srcBillDataFilterList = new ArrayList<Map<String, Object>>(64))) == null || resModelFilterDataMap.isEmpty()) {
            return;
        }
        String msg = "matching pre source data list: ";
        this.writeLoggerListData(msg, srcBillDataList);
        DynamicObject destBillDO = fieldTransCompleteDO.getDynamicObject("destbill");
        List<Map<String, Object>> destBillDataList = null;
        String fieldDestBill = "";
        if (destBillDO == null) {
            return;
        }
        fieldDestBill = String.valueOf(destBillDO.getPkValue());
        destBillDataList = this.supSourceDataMap.get(fieldDestBill);
        String destMsg = "matching pre dset data list: ";
        this.writeLoggerListData(destMsg, destBillDataList);
        String fieldSrcBill = "";
        DynamicObject srcBillDO = fieldTransCompleteDO.getDynamicObject("srcbill");
        if (srcBillDO == null) {
            return;
        }
        fieldSrcBill = String.valueOf(srcBillDO.getPkValue());
        boolean isCheck = true;
        boolean isAllMatch = false;
        if (StringUtils.equals((CharSequence)fieldSrcBill, (CharSequence)fieldDestBill)) {
            isAllMatch = true;
        }
        List<Object> srcBillDataCheckList = new ArrayList();
        HashMap<String, List<Map<String, Object>>> matchDataUnique = new HashMap<String, List<Map<String, Object>>>(32);
        MainEntityType srcType = MetadataServiceHelper.getDataEntityType((String)fieldSrcBill);
        MainEntityType destType = MetadataServiceHelper.getDataEntityType((String)fieldDestBill);
        Map<String, IDataEntityProperty> allSrcFields = ResReadySearchBussiness.getAllEntityProp(srcType);
        Map<String, IDataEntityProperty> allDestFields = ResReadySearchBussiness.getAllEntityProp(destType);
        if (!isAllMatch) {
            DynamicObjectCollection fieldMappingAll = fieldTransCompleteDO.getDynamicObjectCollection("entryentity");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (DynamicObject mapping : fieldMappingAll) {
                String destField = mapping.getString("destfieldflag");
                String srcField = mapping.getString("sourcefieldflag");
                IDataEntityProperty srcProp = allSrcFields.get(srcField);
                if (StringUtils.equals((CharSequence)"entryentity.material", (CharSequence)srcField) || srcProp instanceof MaterielProp) {
                    srcField = ResReadySearchBussiness.transMaterial(null, null, allSrcFields, srcField);
                }
                IDataEntityProperty destProp = allDestFields.get(destField);
                if (StringUtils.equals((CharSequence)"entryentity.material", (CharSequence)destField) || destProp instanceof MaterielProp) {
                    destField = ResReadySearchBussiness.transMaterial(null, null, allDestFields, destField);
                }
                if (StringUtils.isEmpty((CharSequence)destField)) {
                    isCheck = false;
                    return;
                }
                hashMap.put(srcField, destField);
            }
            List<Map<String, Object>> finalDestBillDataList = destBillDataList;
            srcBillDataCheckList = srcBillDataFilterList.stream().filter(srcBillDataMap -> {
                boolean result = false;
                if (finalDestBillDataList != null) {
                    for (Map destBillDataMap : finalDestBillDataList) {
                        boolean isMaching = false;
                        for (Map.Entry entry : fieldRelationMap.entrySet()) {
                            Object destBillFieldValue;
                            Object srcBillFieldValue = srcBillDataMap.get(entry.getKey());
                            if (this.isFieldEqual(srcBillFieldValue, destBillFieldValue = destBillDataMap.get(entry.getValue()))) {
                                isMaching = true;
                                continue;
                            }
                            isMaching = false;
                            break;
                        }
                        if (!isMaching) continue;
                        String srcUnique = String.valueOf(srcBillDataMap.get(DATA_UNIQUE_FLAG));
                        List orDefault = matchDataUnique.getOrDefault(srcUnique, new ArrayList());
                        orDefault.add(destBillDataMap);
                        matchDataUnique.put(srcUnique, orDefault);
                        result = true;
                    }
                }
                return result;
            }).collect(Collectors.toList());
            String matchMsg = "matching data list: ";
            this.writeLogMapInfo2(matchMsg, matchDataUnique);
            if (srcBillDataCheckList != null && !srcBillDataCheckList.isEmpty()) {
                this.execCheckRule(resModelFilterDataMap, srcBillDataCheckList, matchDataUnique, readyRuleCompleteDO, planReadyLevel, allSrcFields, allDestFields, isHandle);
            }
        } else {
            srcBillDataCheckList = srcBillDataFilterList;
            for (Map map : srcBillDataCheckList) {
                String srcUnique = String.valueOf(map.get(DATA_UNIQUE_FLAG));
                List orDefault = matchDataUnique.getOrDefault(srcUnique, new ArrayList());
                orDefault.add(map);
                matchDataUnique.put(srcUnique, orDefault);
            }
            String curMsg = "dest = src data list: ";
            this.writeLoggerListData(curMsg, destBillDataList);
            if (srcBillDataCheckList != null && !srcBillDataCheckList.isEmpty()) {
                this.execCheckRule(resModelFilterDataMap, srcBillDataCheckList, matchDataUnique, readyRuleCompleteDO, planReadyLevel, allSrcFields, allDestFields, isHandle);
            }
        }
    }

    private List<Map<String, Object>> filterOrderSrcBill(List<Map<String, Object>> srcBillDataList) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(64);
        if (srcBillDataList == null) {
            return resultList;
        }
        for (Map<String, Object> dataMap : srcBillDataList) {
            Object materialStatus = dataMap.get("readystatusmaterial");
            if (materialStatus != null) continue;
            resultList.add(dataMap);
        }
        return resultList;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void execCheckRule(List<Map<String, Object>> resModelDataMap, List<Map<String, Object>> srcBillDataList, Map<String, List<Map<String, Object>>> matchDataUnique, DynamicObject readyRuleCompleteDO, DynamicObject planReadyLevel, Map<String, IDataEntityProperty> allSrcFields, Map<String, IDataEntityProperty> allDestFields, boolean isHandle) {
        if (readyRuleCompleteDO == null || srcBillDataList == null) {
            return;
        }
        ruleEntryDOC = readyRuleCompleteDO.getDynamicObjectCollection("entryentity");
        ruleEntryDOC.sort((Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$execCheckRule$6(kd.bos.dataentity.entity.DynamicObject kd.bos.dataentity.entity.DynamicObject ), (Lkd/bos/dataentity/entity/DynamicObject;Lkd/bos/dataentity/entity/DynamicObject;)I)());
        readylevel = readyRuleCompleteDO.getDynamicObject("readylevel");
        if (readylevel == null) {
            readylevel = planReadyLevel;
        }
        levelMap = ResReadyBussinessUtil.getLeveLRelationMap((DynamicObject)readylevel);
        ruleBillFieldTransDO = readyRuleCompleteDO.getDynamicObject("billfieldtransfer");
        for (DynamicObject ruleDO : ruleEntryDOC) {
            if (ruleDO == null) continue;
            srcField = ruleDO.getString("entrysourcefiledflag");
            relationField = ruleDO.getString("entryrelationfiledflag");
            srcProp = allSrcFields.get(srcField);
            if (StringUtils.equals((CharSequence)"entryentity.material", (CharSequence)srcField) || srcProp instanceof MaterielProp) {
                srcField = ResReadySearchBussiness.transMaterial(null, null, allSrcFields, srcField);
            }
            destProp = allDestFields.get(relationField);
            if (StringUtils.equals((CharSequence)"entryentity.material", (CharSequence)relationField) || destProp instanceof MaterielProp) {
                relationField = ResReadySearchBussiness.transMaterial(null, null, allDestFields, relationField);
            }
            ruleType = ruleDO.getString("entryruletype");
            algoImpDO = ruleDO.getDynamicObject("entryalgoregister");
            algoimpletcalss = "";
            if (algoImpDO != null) {
                algoimpletcalss = algoImpDO.getString("algoimpletcalss");
            }
            resDataStatus = new HashMap<String, Map<String, Object>>();
            if (StringUtils.equals((CharSequence)ruleType, (CharSequence)"A")) {
                this.queryCalcDynamicObject(ruleBillFieldTransDO, srcBillDataList, matchDataUnique);
                formulaStr = ruleDO.getString("entrycalculateexc_tag");
                for (Object srcBillDataMap : srcBillDataList) {
                    uniqueKey = String.valueOf(srcBillDataMap.get("datauniqueflag"));
                    if (matchDataUnique == null) continue;
                    srcBillID = srcBillDataMap.get("id");
                    srcBillFlag = srcBillDataMap.get("billuniqueflag") != null ? String.valueOf(srcBillDataMap.get("billuniqueflag")) : null;
                    srcRowIndex = this.getModeRowIndex(uniqueKey, resModelDataMap);
                    destList = matchDataUnique.get(uniqueKey);
                    destBillID = null;
                    destBillFlag = null;
                    destRowIndex = -1;
                    if (destList != null && !destList.isEmpty()) {
                        relationMap = destList.get(0);
                        destBillID = relationMap.get("id");
                        destBillDataUnique = relationMap.get("datauniqueflag");
                        destBillFlag = relationMap.get("billuniqueflag") != null ? String.valueOf(relationMap.get("billuniqueflag")) : null;
                        destModelList = this.resourceDataMap.get(this.resRegisterSupPK);
                        destRowIndex = StringUtils.equals((CharSequence)srcBillFlag, (CharSequence)destBillFlag) != false ? srcRowIndex : this.getModeRowIndex(destBillDataUnique, destModelList);
                    }
                    varValues = new HashMap<String, Object>();
                    varValues.put(srcBillFlag, this.calcDOMap.get(srcBillID));
                    varValues.put(destBillFlag, this.calcDOMap.get(destBillID));
                    varValues.put("one_entity_rowindex", srcRowIndex - 1);
                    varValues.put("two_entity_rowindex", destRowIndex - 1);
                    try {
                        FormulaEngine.registerFunctions((IFormulaFunctions)new POMCustFormulaFuntions());
                        result = FormulaEngine.runFormula((String)formulaStr, varValues);
                        statusMap = this.handleCalcResult(result);
                        resDataStatus.put(uniqueKey, statusMap);
                    }
                    catch (RunFormulaException exp) {
                        throw new ReportException((Throwable)exp, new ErrorCode("plugin-error", ResManager.loadKDString((String)"\u516c\u5f0f\u6267\u884c\u5931\u8d25,\u8bf7\u68c0\u67e5\u516c\u5f0f\u8bed\u6cd5\u662f\u5426\u6b63\u786e", (String)"ResReadySearchBussiness_4", (String)"mmc-pom-business", (Object[])new Object[0])), new Object[0]);
                    }
                    catch (NullPointerException poexp) {
                        throw new ReportException((Throwable)poexp, new ErrorCode("plugin-error", ResManager.loadKDString((String)"\u516c\u5f0f\u6267\u884c\u5931\u8d25,\u8bf7\u68c0\u67e5\u516c\u5f0f\u8bed\u6cd5\u662f\u5426\u6b63\u786e", (String)"ResReadySearchBussiness_4", (String)"mmc-pom-business", (Object[])new Object[0])), new Object[0]);
                    }
                    catch (Exception e) {
                        throw new ReportException((Throwable)e, new ErrorCode("plugin-error", ResManager.loadKDString((String)"\u516c\u5f0f\u6267\u884c\u5931\u8d25,\u8bf7\u68c0\u67e5\u516c\u5f0f\u8bed\u6cd5\u662f\u5426\u6b63\u786e", (String)"ResReadySearchBussiness_4", (String)"mmc-pom-business", (Object[])new Object[0])), new Object[0]);
                    }
                }
            } else {
                try {
                    impl = this.getIResReadyRule(algoimpletcalss);
                    if (impl == null) ** GOTO lbl97
                    srcmsg = "exec custom plugin status: ";
                    srcBillDataMap = srcBillDataList.iterator();
                    while (srcBillDataMap.hasNext()) {
                        srcBillDataMap = srcBillDataMap.next();
                        uniqueKey = String.valueOf(srcBillDataMap.get("datauniqueflag"));
                        if (matchDataUnique == null) continue;
                        srcValueObj = srcBillDataMap.get(srcField);
                        destList = matchDataUnique.get(uniqueKey);
                        destValueList = this.parseParamList(destList, relationField);
                        resReadyStatus = impl.getResReadyStatus(srcValueObj, destValueList, readylevel);
                        resDataStatus.put(uniqueKey, resReadyStatus);
                    }
                    this.writeLogMapInfo(srcmsg, resDataStatus);
                }
                catch (ClassNotFoundException e) {
                    throw new ReportException((Throwable)e, new ErrorCode("plugin-error", String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u63d2\u4ef6%1$s,\u8bf7\u68c0\u67e5\u8d44\u6e90\u5c31\u7eea\u68c0\u67e5\u89c4\u5219\u914d\u7f6e", (String)"ResReadySearchBussiness_5", (String)"mmc-pom-business", (Object[])new Object[0]), new Object[]{algoimpletcalss})), new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw new ReportException((Throwable)e, new ErrorCode("plugin-error", String.format(ResManager.loadKDString((String)"\u65e0\u63d2\u4ef6%1$s\u4e2d\u65b9\u6cd5\u7684\u8bbf\u95ee\u6743\u9650,\u8bf7\u68c0\u67e5\u8d44\u6e90\u5c31\u7eea\u68c0\u67e5\u89c4\u5219\u914d\u7f6e", (String)"ResReadySearchBussiness_6", (String)"mmc-pom-business", (Object[])new Object[0]), new Object[]{algoimpletcalss})), new Object[0]);
                }
                catch (InvocationTargetException e) {
                    throw new ReportException((Throwable)e, new ErrorCode("plugin-error", String.format(ResManager.loadKDString((String)"\u63d2\u4ef6%1$s\u6267\u884c\u5f02\u5e38,\u8bf7\u68c0\u67e5\u63d2\u4ef6", (String)"ResReadySearchBussiness_7", (String)"mmc-pom-business", (Object[])new Object[0]), new Object[]{algoimpletcalss})), new Object[0]);
                }
                catch (InstantiationException e) {
                    throw new ReportException((Throwable)e, new ErrorCode("plugin-error", String.format(ResManager.loadKDString((String)"\u63d2\u4ef6%1$s\u65e0\u6cd5\u5b9e\u4f8b\u5316,\u8bf7\u68c0\u67e5\u63d2\u4ef6", (String)"ResReadySearchBussiness_8", (String)"mmc-pom-business", (Object[])new Object[0]), new Object[]{algoimpletcalss})), new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new ReportException((Throwable)e, new ErrorCode("plugin-error", String.format(ResManager.loadKDString((String)"\u63d2\u4ef6%1$s\u627e\u4e0d\u5230\u76ee\u6807\u65b9\u6cd5,\u8bf7\u68c0\u67e5\u63d2\u4ef6", (String)"ResReadySearchBussiness_9", (String)"mmc-pom-business", (Object[])new Object[0]), new Object[]{algoimpletcalss})), new Object[0]);
                }
            }
lbl97:
            // 5 sources

            for (Map<String, Object> srcBillMap : srcBillDataList) {
                uniqueKey = String.valueOf(srcBillMap.get("datauniqueflag"));
                preStatusMaterial = String.valueOf(srcBillMap.get("readystatusmaterial"));
                curResDataStatusMap = (Map)resDataStatus.get(uniqueKey);
                if (curResDataStatusMap == null) continue;
                curStatus = String.valueOf(curResDataStatusMap.get("resReadyStatus"));
                resReadyDateObj = curResDataStatusMap.get("resReadyDateTime");
                resReadyDate = null;
                if (resReadyDateObj instanceof Date) {
                    resReadyDate = (Date)resReadyDateObj;
                } else if (resReadyDateObj instanceof Long) {
                    resReadyDate = new Date(Long.parseLong(String.valueOf(resReadyDateObj)));
                }
                this.writeSrcBillStatus(srcBillMap, "readystatusmaterial", curStatus, resReadyDate, levelMap, isHandle);
            }
        }
        infoMsg = "calc result status:";
        this.writeLoggerListData(infoMsg, srcBillDataList);
    }

    private Map<String, Object> handleCalcResult(Object calcResult) {
        HashMap<String, Object> statusMap = new HashMap<String, Object>(2);
        if (calcResult == null) {
            statusMap.put("resReadyStatus", "A");
            statusMap.put("resReadyDateTime", null);
            return statusMap;
        }
        String status = "A";
        Date resDate = null;
        if (calcResult instanceof String) {
            String calcResultStr = calcResult.toString();
            String[] split = null;
            split = calcResultStr.contains("\uff0c") ? calcResultStr.split("\uff0c") : (calcResultStr.contains(";") ? calcResultStr.split(";") : (calcResultStr.contains("\uff1b") ? calcResultStr.split("\uff1b") : calcResultStr.split(",")));
            switch (split[0].trim()) {
                case "\u672a\u5c31\u7eea": 
                case "A": {
                    status = "A";
                    break;
                }
                case "\u9884\u8ba1\u5c31\u7eea": 
                case "B": {
                    status = "B";
                    break;
                }
                case "\u5b9e\u9645\u5c31\u7eea": 
                case "C": {
                    status = "C";
                    break;
                }
                case "\u672a\u63d0\u51fa\u9700\u6c42": 
                case "D": {
                    status = NO_ADVANCE;
                    break;
                }
                default: {
                    status = "A";
                }
            }
            if (split.length > 1) {
                String dateStr = split[1];
                SimpleDateFormat sdf = null;
                if (dateStr.contains("-")) {
                    sdf = dateStr.contains(":") ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss") : new SimpleDateFormat("yyyy-MM-dd");
                } else if (dateStr.contains("/")) {
                    sdf = dateStr.contains(":") ? new SimpleDateFormat("yyyy/MM/dd HH:mm:ss") : new SimpleDateFormat("yyyy/MM/dd");
                } else if (dateStr.contains(".")) {
                    sdf = dateStr.contains(":") ? new SimpleDateFormat("yyyy.MM.dd HH:mm:ss") : new SimpleDateFormat("yyyy.MM.dd");
                }
                Date parse = null;
                if (sdf != null) {
                    try {
                        parse = sdf.parse(dateStr);
                    }
                    catch (ParseException e) {
                        logger.info("\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff1a" + e.toString());
                    }
                }
                if (parse != null) {
                    resDate = parse;
                }
            }
        }
        statusMap.put("resReadyStatus", status);
        statusMap.put("resReadyDateTime", resDate);
        return statusMap;
    }

    private int getModeRowIndex(Object srcBillID, List<Map<String, Object>> resModelDataMap) {
        int result = -1;
        if (resModelDataMap == null) {
            return result;
        }
        if (srcBillID == null) {
            return result;
        }
        Object entrySeqDO = null;
        for (Map<String, Object> modelDataMap : resModelDataMap) {
            Object modelDataID = modelDataMap.get(DATA_UNIQUE_FLAG);
            if (modelDataID == null || !StringUtils.equals((CharSequence)String.valueOf(modelDataID), (CharSequence)String.valueOf(srcBillID))) continue;
            entrySeqDO = modelDataMap.get("entryentity.billentryseq");
            break;
        }
        String partern = "^[0-9][0-9]*$";
        if (entrySeqDO instanceof Integer) {
            result = (Integer)entrySeqDO;
        } else if (entrySeqDO instanceof String && Pattern.matches(partern, String.valueOf(entrySeqDO))) {
            result = Integer.parseInt(String.valueOf(entrySeqDO));
        }
        return result;
    }

    private void queryCalcDynamicObject(DynamicObject ruleBillFieldTransDO, List<Map<String, Object>> srcBillDataList, Map<String, List<Map<String, Object>>> matchDataUnique) {
        DynamicObject destBill;
        if (ruleBillFieldTransDO == null) {
            return;
        }
        String srcBillFlag = "";
        String destBillFlag = "";
        DynamicObject srcBill = ruleBillFieldTransDO.getDynamicObject("srcbill");
        if (srcBill != null) {
            srcBillFlag = srcBill.getString("number");
        }
        HashSet<Object> srcBillIDList = new HashSet<Object>(64);
        HashSet<Object> destBillIDList = new HashSet<Object>(64);
        if (srcBillDataList != null) {
            for (Map<String, Object> srcBillMap : srcBillDataList) {
                List<Map<String, Object>> destDataList;
                if (srcBillMap == null) continue;
                srcBillIDList.add(srcBillMap.get("id"));
                Object dataUnique = srcBillMap.get(DATA_UNIQUE_FLAG);
                if (dataUnique == null || dataUnique == null || (destDataList = matchDataUnique.get(String.valueOf(dataUnique))) == null) continue;
                for (Map<String, Object> destDataMap : destDataList) {
                    destBillIDList.add(destDataMap.get("id"));
                }
            }
        }
        Map srcDataMapDO = null;
        if (StringUtils.isNotEmpty((CharSequence)srcBillFlag)) {
            srcDataMapDO = BusinessDataServiceHelper.loadFromCache((Object[])srcBillIDList.toArray(new Object[srcBillIDList.size()]), (String)srcBillFlag);
        }
        if (srcDataMapDO != null) {
            this.calcDOMap.putAll(srcDataMapDO);
        }
        if ((destBill = ruleBillFieldTransDO.getDynamicObject("destbill")) != null) {
            destBillFlag = destBill.getString("number");
        }
        Map destDataMapDO = null;
        if (StringUtils.isNotEmpty((CharSequence)destBillFlag)) {
            destDataMapDO = BusinessDataServiceHelper.loadFromCache((Object[])destBillIDList.toArray(new Object[destBillIDList.size()]), (String)destBillFlag);
        }
        if (destDataMapDO != null) {
            this.calcDOMap.putAll(destDataMapDO);
        }
    }

    private void writeSrcBillStatus(Map<String, Object> srcBillMap, String statusField, String curStatus, Date curDate, Map<String, Integer> levelMap, boolean isPlan) {
        if (srcBillMap == null) {
            return;
        }
        String preStatus = String.valueOf(srcBillMap.get(statusField));
        Date preEstimateDate = (Date)srcBillMap.get("estimatereadydate");
        Date preActualDate = (Date)srcBillMap.get("actualreadydate");
        Integer preLevel = levelMap.get(preStatus) == null ? Integer.valueOf(-1) : levelMap.get(preStatus);
        Integer curLevel = levelMap.get(curStatus) == null ? Integer.valueOf(-1) : levelMap.get(curStatus);
        String status = "";
        Date actualDate = null;
        Date estimateDate = null;
        status = curLevel >= preLevel ? curStatus : preStatus;
        actualDate = curDate != null ? curDate : preActualDate;
        estimateDate = curDate != null ? curDate : preEstimateDate;
        Timestamp actualTime = null;
        Timestamp estimateTime = null;
        if (actualDate != null) {
            actualTime = new Timestamp(actualDate.getTime());
        }
        if (estimateDate != null) {
            estimateTime = new Timestamp(estimateDate.getTime());
        }
        switch (status) {
            case "A": {
                srcBillMap.put("readystatusmaterial", status);
                srcBillMap.put("estimatereadydate", null);
                srcBillMap.put("actualreadydate", null);
                break;
            }
            case "B": {
                srcBillMap.put("readystatusmaterial", status);
                srcBillMap.put("estimatereadydate", estimateTime);
                break;
            }
            case "C": {
                srcBillMap.put("readystatusmaterial", status);
                srcBillMap.put("actualreadydate", actualTime);
                break;
            }
            case "D": {
                srcBillMap.put("readystatusmaterial", NO_ADVANCE);
                srcBillMap.put("estimatereadydate", null);
                srcBillMap.put("actualreadydate", null);
            }
        }
    }

    private String getStatus(String curStatus) {
        String status = "";
        switch (curStatus) {
            case "A": 
            case "B": 
            case "C": {
                status = curStatus;
                break;
            }
            default: {
                status = "A";
            }
        }
        return status;
    }

    private List<Object> parseParamList(List<Map<String, Object>> destList, String relationField) {
        ArrayList<Object> resultList = new ArrayList<Object>(4);
        if (destList == null || destList.isEmpty()) {
            return resultList;
        }
        for (Map<String, Object> map : destList) {
            Object relationObj = map.get(relationField);
            resultList.add(relationObj);
        }
        return resultList;
    }

    private IResReadyRule getIResReadyRule(String implClassName) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException {
        Class<?> c = Class.forName(implClassName);
        Class<?>[] interfaces = c.getInterfaces();
        boolean flag = false;
        for (int i = 0; i < interfaces.length; ++i) {
            String rootClassName;
            Class<?> anInterface = interfaces[i];
            String string = rootClassName = anInterface == null ? "" : anInterface.getName();
            if (!rootClassName.contains("IResReadyRule")) continue;
            flag = true;
            break;
        }
        if (!flag) {
            return null;
        }
        Object implClass = c.newInstance();
        return (IResReadyRule)implClass;
    }

    private boolean isFieldEqual(Object srcBillFieldValue, Object destBillFieldValue) {
        String destBillTypeName;
        boolean fieldValueEqual = true;
        if (srcBillFieldValue == null && destBillFieldValue == null) {
            return fieldValueEqual;
        }
        if (srcBillFieldValue != null && destBillFieldValue == null || srcBillFieldValue == null && destBillFieldValue != null) {
            return false;
        }
        String srcBillTypeName = srcBillFieldValue.getClass().getTypeName();
        if (!StringUtils.equals((CharSequence)srcBillTypeName, (CharSequence)(destBillTypeName = destBillFieldValue.getClass().getTypeName()))) {
            fieldValueEqual = false;
        } else {
            String sbillValue = "";
            String dbillValue = "";
            if (srcBillFieldValue instanceof Date && destBillFieldValue instanceof Date) {
                sbillValue = "" + ((Date)srcBillFieldValue).getTime();
                sbillValue = "" + ((Date)srcBillFieldValue).getTime();
            } else {
                sbillValue = "" + String.valueOf(srcBillFieldValue);
                dbillValue = "" + String.valueOf(destBillFieldValue);
            }
            fieldValueEqual = StringUtils.equals((CharSequence)sbillValue, (CharSequence)dbillValue);
        }
        return fieldValueEqual;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<Long, List<Map<String, Object>>> queryResSourceData(List<SrcBillDataParamBean> srcBillDataParamBeans) {
        if (srcBillDataParamBeans == null || srcBillDataParamBeans.isEmpty()) {
            return null;
        }
        HashMap<Long, List<Map<String, Object>>> rawDataMap = new HashMap<Long, List<Map<String, Object>>>(16);
        ORM orm = ORM.create();
        for (SrcBillDataParamBean paramBean : srcBillDataParamBeans) {
            DynamicObject billFieldTransferDO = paramBean.getBillFieldTransfer();
            DynamicObject sourceDataDO = paramBean.getSourceData();
            String filterContent = sourceDataDO.getString("filter_tag");
            FetchDataQueryModule dataQueryModule = this.resolveFilterContent(filterContent, billFieldTransferDO, null, null);
            if (dataQueryModule == null) continue;
            String mt = dataQueryModule.getMt();
            String oql = dataQueryModule.getOql();
            String className = this.getClass().getName();
            QFilter[] qFilters = dataQueryModule.getqFilters();
            DataSet ds = null;
            DataSet modelDs = null;
            try {
                ds = this.loadRealTimeDatas(orm, mt, qFilters, sourceDataDO, className, oql);
                if (ds == null || (ds = this.addDataSetUUID(ds, paramBean.getSrcBill())) == null) continue;
                modelDs = ds.copy();
                List mapList = DataSetListTransUtil.parseToList((DataSet)ds);
                String curMsg = "query data list: ";
                this.writeLoggerListData(curMsg, mapList);
                Long cgnumber = paramBean.getCgnumber();
                HashMap<String, List<Map<String, Object>>> dataMap = null;
                dataMap = this.resRegisterDemandPK.equals(cgnumber) ? this.deSourceDataMap : this.supSourceDataMap;
                List orDefault = dataMap.getOrDefault(paramBean.getSrcBill(), new ArrayList(64));
                orDefault.addAll(mapList);
                dataMap.put(paramBean.getSrcBill(), orDefault);
                modelDs = this.getDataSetByModel(dataQueryModule, modelDs);
                List resOrsupList = DataSetListTransUtil.parseToList((DataSet)modelDs);
                List rawDataDefaultList = rawDataMap.getOrDefault(cgnumber, new ArrayList(64));
                rawDataDefaultList.addAll(resOrsupList);
                rawDataMap.put(cgnumber, rawDataDefaultList);
            }
            finally {
                if (ds != null) {
                    ds.close();
                }
                if (modelDs == null) continue;
                modelDs.close();
            }
        }
        return rawDataMap;
    }

    private DataSet addDataSetUUID(DataSet ds, String billName) {
        if (ds == null) {
            return ds;
        }
        ds = this.addCustomField(ds);
        RowMeta rowMeta = ds.getRowMeta();
        List maps = DataSetListTransUtil.parseToList((DataSet)ds);
        if (maps == null) {
            return ds;
        }
        for (Map map : maps) {
            UUID dataUuid = UUID.randomUUID();
            map.put(DATA_UNIQUE_FLAG, dataUuid);
            map.put(BILL_UNIQUE_FLAG, billName);
        }
        ds = DataSetListTransUtil.parseToDataSet((Object)this, (List)maps, (RowMeta)rowMeta);
        return ds;
    }

    private DataSet addCustomField(DataSet ds) {
        if (ds != null) {
            Field[] fields = ds.getRowMeta().getFields();
            List<String> list = Arrays.asList(customField);
            HashSet<String> fieldSet = new HashSet<String>(fields.length);
            for (Field field : fields) {
                fieldSet.add(field.getName());
            }
            for (int i = 0; i < list.size(); ++i) {
                if (fieldSet.contains(list.get(i))) continue;
                ds = ds.addNullField(list.get(i));
            }
        }
        return ds;
    }

    private List<String> addResourceField(List<String> allField) {
        if (allField != null) {
            HashSet<String> strSet = new HashSet<String>(16);
            for (String str : allField) {
                String[] strs = str.split("AS");
                if (strs.length <= 1) continue;
                strSet.add(strs[1]);
            }
            for (int i = 0; i < customField.length; ++i) {
                if (strSet.contains(customField[i]) || strSet.contains(PREFIX + customField[i])) continue;
                allField.add(customField[i]);
            }
            allField = allField.stream().distinct().collect(Collectors.toList());
        }
        return allField;
    }

    private DataSet loadRealTimeDatas(ORM orm, String mt, QFilter[] filters, DynamicObject mrpDs, String className, String oql) {
        if (StringUtils.isNotEmpty((CharSequence)oql)) {
            String[] split = oql.split(",");
            boolean flag = false;
            for (int i = 0; i < split.length; ++i) {
                if (!StringUtils.equals((CharSequence)split[i].trim(), (CharSequence)"id")) continue;
                flag = true;
            }
            if (!flag) {
                oql = oql + ",id";
            }
        }
        try {
            return orm.queryDataSet(className, mt, oql, filters, null);
        }
        catch (RuntimeException e) {
            String message = e.getCause().getMessage();
            throw new ReportException((Throwable)e, new ErrorCode("query-data-error", String.format(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u914d\u7f6e\uff0c%1$s", (String)"ResReadySearchBussiness_12", (String)"mmc-pom-business", (Object[])new Object[0]), message)), new Object[0]);
        }
        catch (Exception e) {
            throw new ReportException((Throwable)e, new ErrorCode("query-data-error", ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u914d\u7f6e", (String)"ResReadySearchBussiness_2", (String)"mmc-pom-business", (Object[])new Object[0])), new Object[0]);
        }
    }

    public static String getFieldsSet(String oql, String algoStr) {
        StringBuilder fieldsbuilder = new StringBuilder();
        fieldsbuilder.append(oql);
        String[] fields = oql.split("[,]");
        HashSet<String> fieldSet = new HashSet<String>(fields.length);
        for (String field : fields) {
            fieldSet.add(field.trim());
        }
        Set<String> fieldList = ResReadySearchBussiness.getFields(algoStr);
        for (String field : fieldList) {
            if (fieldSet.contains(field)) continue;
            fieldsbuilder.append(',').append(field);
        }
        return fieldsbuilder.toString();
    }

    public static Set<String> getFields(String value) {
        HashSet<String> keyWordset = new HashSet<String>(4);
        keyWordset.add("and");
        keyWordset.add("or");
        keyWordset.add("in");
        keyWordset.add("is");
        keyWordset.add("null");
        HashSet<String> fieldList = new HashSet<String>(16);
        char[] fields = value.toCharArray();
        StringBuilder fieldName = new StringBuilder();
        for (int i = 0; i < fields.length; ++i) {
            char field = fields[i];
            if (fieldName.length() > 0 && (field >= 'a' && field <= 'z' || field >= 'A' && field <= 'Z' || field >= '0' && field <= '9' || field == '.' || field == '_')) {
                fieldName.append(field);
                continue;
            }
            if (field >= 'a' && field <= 'z' || field >= 'A' && field <= 'Z') {
                fieldName.append(field);
                continue;
            }
            if (fieldName.length() > 0 && (field == '(' || field == '\'' || field == '\"')) {
                fieldName.setLength(0);
                continue;
            }
            if (fieldName.length() > 0 && !keyWordset.contains(fieldName.toString())) {
                fieldList.add(fieldName.toString());
                fieldName.setLength(0);
                continue;
            }
            if (!keyWordset.contains(fieldName.toString())) continue;
            fieldName.setLength(0);
        }
        if (fieldName.length() > 0 && !keyWordset.contains(fieldName.toString())) {
            fieldList.add(fieldName.toString());
            fieldName.setLength(0);
        }
        return fieldList;
    }

    private FetchDataQueryModule resolveFilterContent(String filterContent, DynamicObject billFieldTransferDO, Set<Long> masterIdSet, QFilter filter) {
        if (billFieldTransferDO == null) {
            return null;
        }
        DynamicObjectCollection fieldMappingAll = billFieldTransferDO.getDynamicObjectCollection("entryentity");
        DynamicObject srcBillEntity = billFieldTransferDO.getDynamicObject("srcbill");
        MainEntityType srcType = MetadataServiceHelper.getDataEntityType((String)srcBillEntity.getString("id"));
        String srcTypeName = srcType.getName();
        String algoStr = "";
        HashMap<String, CustomMethodStruct> customMethodStructMap = new HashMap<String, CustomMethodStruct>(16);
        if (filter == null && !StringUtils.isEmpty((CharSequence)filterContent)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterContent, FilterCondition.class);
            FilterBuilder fb = new FilterBuilder(srcType, filterCondition);
            UserService userService = new UserService();
            fb.setUserService((IUserService)userService);
            fb.buildFilter(false);
            filter = fb.getQFilter();
        }
        if (filter == null) {
            filter = new QFilter(EQUIPMENT_RESTYPE, "=", (Object)EQUIPMENT_RESTYPE, true);
        }
        Map<String, IDataEntityProperty> allFields = ResReadySearchBussiness.getAllEntityProp(srcType);
        HashSet<String> formulaSrcFields = new HashSet<String>(8);
        HashMap<Object, String> formulaDestToSrcMap = new HashMap<Object, String>(8);
        for (DynamicObject mapping : fieldMappingAll) {
            String destField = mapping.getString("destfieldflag");
            String srcField = mapping.getString("sourcefieldflag");
            String formula = mapping.getString("calculateexc_tag");
            String type = mapping.getString("converttype");
            if (StringUtils.isEmpty((CharSequence)srcField)) {
                String formulaStr;
                if (Objects.equals(type, "2")) {
                    Object item2;
                    CRValByConditions valByConditions = (CRValByConditions)SerializationUtils.fromJsonString((String)formula, CRValByConditions.class);
                    MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)srcTypeName);
                    StringBuilder sb = new StringBuilder(128);
                    sb.append("CASE");
                    for (Object item2 : valByConditions.getItems()) {
                        String upperCase;
                        FilterCondition filterCondition = item2.getCondition().getFilterCondition();
                        FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, filterCondition);
                        String[] strings = filterBuilder.buildFilterScript();
                        String conditionFormula = strings[0];
                        String valFormula = item2.getFormula().getExpression();
                        valFormula = valFormula.replace(srcTypeName + ".", "");
                        IDataEntityProperty prop = allFields.get(valFormula);
                        if (StringUtils.equals((CharSequence)"entryentity.material", (CharSequence)destField) || prop instanceof MaterielProp) {
                            valFormula = ResReadySearchBussiness.transMaterial(masterIdSet, filter, allFields, valFormula);
                        }
                        if ((upperCase = valFormula.toUpperCase(Locale.ENGLISH)).startsWith("NOW(") || upperCase.startsWith("DATE(") || upperCase.startsWith("TO_DATE(") || upperCase.startsWith("DATEADD(")) {
                            valFormula = "cast(" + valFormula + " AS Timestamp)";
                        }
                        valFormula = ResReadySearchBussiness.getConditionFormulaVariable(valFormula, formulaSrcFields, mainEntityType);
                        conditionFormula = ResReadySearchBussiness.getConditionFormulaVariable(conditionFormula, formulaSrcFields, mainEntityType);
                        sb.append(" WHEN ").append(conditionFormula).append(" THEN ").append(valFormula);
                    }
                    String formulaStr2 = sb.append(" END").toString();
                    formulaDestToSrcMap.put(destField, formulaStr2);
                    if (!StringUtils.equals((CharSequence)"entryentity.material", (CharSequence)destField)) continue;
                    item2 = ResReadyBussinessUtil.getMetaFlagFromEntityType((MainEntityType)srcType, (String)formulaStr2);
                    continue;
                }
                boolean isUnSet = StringUtils.isEmpty((CharSequence)formula);
                JSONObject jo = isUnSet ? null : JSON.parseObject((String)formula);
                String string = formulaStr = jo == null ? null : jo.getString("expression");
                if (formulaStr == null || StringUtils.isEmpty((CharSequence)formulaStr)) {
                    throw new ReportException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u3010%1$s, id: %2$s\u3011\u7684\u53d6\u6570\u8bbe\u7f6e\u3010%3$s, id: %4$s\u3011\u5b57\u6bb5\u3010%5$s\u3011\u672a\u8bbe\u7f6e\u3002", (String)"ResReadySearchBussiness_3", (String)"mmc-pom-business", (Object[])new Object[0]), billFieldTransferDO.getString("name"), billFieldTransferDO.getString("id"), billFieldTransferDO.getString("name"), billFieldTransferDO.getString("id"), destField));
                }
                formulaStr = formulaStr.replace(srcTypeName + ".", "");
                IDataEntityProperty prop = allFields.get(formulaStr);
                if (StringUtils.equals((CharSequence)"entryentity.material", (CharSequence)destField) || prop instanceof MaterielProp) {
                    formulaStr = ResReadySearchBussiness.transMaterial(masterIdSet, filter, allFields, formulaStr);
                }
                formulaStr = ResReadySearchBussiness.getFormulaVariable(formulaStr, formulaSrcFields);
                formulaDestToSrcMap.put(destField, formulaStr);
                if (!StringUtils.equals((CharSequence)"entryentity.material", (CharSequence)destField)) continue;
                String mateflag = ResReadyBussinessUtil.getMetaFlagFromEntityType((MainEntityType)srcType, (String)formulaStr);
                HashMap<String, String> mateFieldMap = new HashMap<String, String>(2);
                if (!StringUtils.isNotEmpty((CharSequence)mateflag)) continue;
                mateFieldMap.put(MATE_FLAG, mateflag);
                mateFieldMap.put(FIELD, formulaStr);
                this.propResInfo.put(srcTypeName, mateFieldMap);
                continue;
            }
            String formulaStr = srcField;
            IDataEntityProperty prop = allFields.get(formulaStr);
            if (StringUtils.equals((CharSequence)"entryentity.material", (CharSequence)destField) || prop instanceof MaterielProp) {
                formulaStr = ResReadySearchBussiness.transMaterial(masterIdSet, filter, allFields, formulaStr);
                HashMap<String, String> mateFieldMap = new HashMap<String, String>(2);
                mateFieldMap.put(MATE_FLAG, "bd_material");
                mateFieldMap.put(FIELD, formulaStr);
                this.propResInfo.put(srcTypeName, mateFieldMap);
            }
            formulaStr = ResReadySearchBussiness.getFormulaVariable(formulaStr, formulaSrcFields);
            formulaDestToSrcMap.put(destField, formulaStr);
        }
        ArrayList<String> selFields = new ArrayList<String>(16);
        StringBuilder queryField = new StringBuilder();
        for (String src : formulaSrcFields) {
            queryField.append(src).append(", ");
        }
        for (DynamicObject mapping : fieldMappingAll) {
            String col = mapping.getString("destfieldflag");
            String formulaSrcField = (String)formulaDestToSrcMap.get(col);
            if (formulaSrcField == null) {
                selFields.add("null " + col);
                continue;
            }
            CustomMethodStruct customMethod = CustomMethodUtils.getCustomMethodStructByCalFields((String)formulaSrcField);
            if (customMethod != null) {
                customMethodStructMap.put(col, customMethod);
                continue;
            }
            selFields.add(String.format("(%s) AS %s", formulaSrcField, col));
        }
        queryField.setLength(queryField.length() - 2);
        String oql = queryField.toString();
        oql = ResReadySearchBussiness.getFieldsSet(oql, algoStr);
        return new FetchDataQueryModule(srcTypeName, oql, new QFilter[]{filter}, selFields, algoStr, customMethodStructMap);
    }

    public static String getFormulaVariable(String formula, Set<String> vars) {
        Expr expr = ExprParser.parse((String)formula);
        VerifyVisitor visitor = new VerifyVisitor((ExecuteContext)new MapExecuteContext());
        expr.accept((Visitor)visitor);
        List invalidSymboList = visitor.getInvalidSymboList();
        for (String s : invalidSymboList) {
            vars.add(s.toLowerCase());
        }
        return formula;
    }

    public static String transMaterial(Set<Long> masterIdSet, QFilter filter, Map<String, IDataEntityProperty> allFields, String formulaStr) {
        boolean hasMaterialFilter;
        IDataEntityProperty prop;
        boolean hasMtField = false;
        if (StringUtils.isNotEmpty((CharSequence)formulaStr)) {
            formulaStr = formulaStr.trim();
        }
        if ((prop = allFields.get(formulaStr)) == null) {
            int indexOf;
            while ((indexOf = formulaStr.lastIndexOf(46)) > -1 && (prop = allFields.get(formulaStr = formulaStr.substring(0, indexOf))) == null) {
            }
        }
        if (prop instanceof MaterielProp) {
            String baseEntityId = ((MaterielProp)prop).getBaseEntityId();
            if (!"bd_material".equalsIgnoreCase(baseEntityId)) {
                formulaStr = formulaStr + ".masterid";
            }
            hasMtField = true;
        } else if (prop instanceof MasterBasedataProp) {
            hasMtField = true;
        }
        boolean bl = hasMaterialFilter = masterIdSet != null;
        if (hasMaterialFilter) {
            if (hasMtField) {
                filter.and(new QFilter(formulaStr, "in", masterIdSet));
            } else {
                filter.and(new QFilter(EQUIPMENT_RESTYPE, "!=", (Object)EQUIPMENT_RESTYPE, true));
            }
        }
        return formulaStr;
    }

    private List<SrcBillDataParamBean> readyQueryData(DynamicObject resReadyPlanDO, boolean isPlan) {
        Map billFTranMap;
        DynamicObject resregisterSupplyDO;
        ArrayList<SrcBillDataParamBean> srcBillDataParamBeans = new ArrayList<SrcBillDataParamBean>(8);
        if (resReadyPlanDO == null) {
            return srcBillDataParamBeans;
        }
        String entityName = "entryentity";
        if (!isPlan) {
            entityName = "entryentityexe";
        }
        DynamicObjectCollection resReadyPlanDetailDOC = resReadyPlanDO.getDynamicObjectCollection(entityName);
        Set<String> billSet = this.getQueryBill(resReadyPlanDetailDOC, isPlan);
        Long[] resRegisterPK = new Long[2];
        DynamicObject resregisterDemandDO = resReadyPlanDO.getDynamicObject("resregisterdemand");
        if (resregisterDemandDO != null) {
            Long resregisterDemandPK;
            this.resRegisterDemandPK = resregisterDemandPK = Long.valueOf(Long.parseLong(String.valueOf(resregisterDemandDO.getPkValue())));
            resRegisterPK[0] = resregisterDemandPK;
        }
        if ((resregisterSupplyDO = resReadyPlanDO.getDynamicObject("resregistersupply")) != null) {
            Long resregisterSupplyPK;
            this.resRegisterSupPK = resregisterSupplyPK = Long.valueOf(Long.parseLong(String.valueOf(resregisterSupplyDO.getPkValue())));
            resRegisterPK[1] = resregisterSupplyPK;
        }
        QFilter dataConfigFilter = new QFilter("cgnumber", "in", (Object)resRegisterPK);
        DynamicObjectCollection dataConfigDOC = QueryServiceHelper.query((String)MRP_RESOURCE_DATACONFIG, (String)"id,cgnumber,billfieldtransfer.id,billfieldtransfer.srcbill,billfieldtransfer.destbill,filter_tag", (QFilter[])new QFilter[]{dataConfigFilter});
        HashSet<Long> billFieldTransferPKSet = new HashSet<Long>(8);
        HashMap<Long, SrcBillDataParamBean> billFTDataParam = new HashMap<Long, SrcBillDataParamBean>(8);
        if (dataConfigDOC != null && !dataConfigDOC.isEmpty()) {
            for (DynamicObject dataConfigDO : dataConfigDOC) {
                String srcBill = String.valueOf(dataConfigDO.get("billfieldtransfer.srcbill"));
                if (!billSet.contains(srcBill)) continue;
                SrcBillDataParamBean sBillDPBean = new SrcBillDataParamBean();
                String destBill = String.valueOf(dataConfigDO.get("billfieldtransfer.destbill"));
                long cgnumber = dataConfigDO.getLong("cgnumber");
                long dataConfigPK = dataConfigDO.getLong("id");
                long billFiledTransFerPK = dataConfigDO.getLong("billfieldtransfer.id");
                billFieldTransferPKSet.add(billFiledTransFerPK);
                sBillDPBean.setResDataConfigPK(Long.valueOf(dataConfigPK));
                sBillDPBean.setSrcBill(srcBill);
                sBillDPBean.setDestBill(destBill);
                sBillDPBean.setCgnumber(Long.valueOf(cgnumber));
                sBillDPBean.setSourceData(dataConfigDO);
                srcBillDataParamBeans.add(sBillDPBean);
                billFTDataParam.put(billFiledTransFerPK, sBillDPBean);
            }
        }
        if ((billFTranMap = BusinessDataServiceHelper.loadFromCache((Object[])billFieldTransferPKSet.stream().toArray(), (String)MRP_BILLFILED_TRANSFER)) != null && !billFTranMap.isEmpty()) {
            for (Map.Entry entry : billFTranMap.entrySet()) {
                Object nextKey = entry.getKey();
                if (!(nextKey instanceof Long)) continue;
                DynamicObject billFTranDO = (DynamicObject)entry.getValue();
                SrcBillDataParamBean srcBillDataParamBean = (SrcBillDataParamBean)billFTDataParam.get(nextKey);
                if (srcBillDataParamBean == null) continue;
                srcBillDataParamBean.setBillFieldTransfer(billFTranDO);
            }
        }
        billFTDataParam.clear();
        return srcBillDataParamBeans;
    }

    private Set<String> getQueryBill(DynamicObjectCollection resReadyPlanDetailDOC, boolean isPlan) {
        HashSet<String> resultSet = new HashSet<String>(4);
        if (resReadyPlanDetailDOC == null || resReadyPlanDetailDOC.isEmpty()) {
            return resultSet;
        }
        String transField = "entryplanfieldtransfer";
        if (!isPlan) {
            transField = "entryexefieldtransfer";
        }
        for (DynamicObject resPlanDO : resReadyPlanDetailDOC) {
            DynamicObject planFieldTransferDO = resPlanDO.getDynamicObject(transField);
            if (planFieldTransferDO == null) continue;
            String srcbill = planFieldTransferDO.getString("srcbill.id");
            String destbill = planFieldTransferDO.getString("destbill.id");
            if (isPlan) {
                resultSet.add(srcbill);
                resultSet.add(destbill);
                continue;
            }
            if (!this.deSourceDataMap.containsKey(srcbill)) {
                resultSet.add(srcbill);
            }
            if (this.supSourceDataMap.containsKey(destbill)) continue;
            resultSet.add(destbill);
        }
        resultSet.remove("mrp_resourcereq");
        resultSet.remove("mrp_resourcesup");
        return resultSet;
    }

    public static Map<String, IDataEntityProperty> getAllEntityProp(MainEntityType mainType) {
        HashMap<String, IDataEntityProperty> result = new HashMap<String, IDataEntityProperty>(32);
        String name = mainType.getName();
        Map allEntities = mainType.getAllEntities();
        for (Map.Entry entry : allEntities.entrySet()) {
            EntityType value = (EntityType)entry.getValue();
            String entryName = value.getName();
            if (name.equals(entryName)) {
                result.putAll(value.getFields());
                continue;
            }
            Map fields = value.getFields();
            for (Map.Entry e : fields.entrySet()) {
                String entryKey = entryName + "." + (String)e.getKey();
                result.put(entryKey, (IDataEntityProperty)e.getValue());
            }
        }
        return result;
    }

    private static String getConditionFormulaVariable(String formula, Set<String> vars, MainEntityType mainEntityType) {
        Expr expr = ExprParser.parse((String)formula);
        VerifyVisitor visitor = new VerifyVisitor((ExecuteContext)new MapExecuteContext());
        expr.accept((Visitor)visitor);
        List invalidSymboList = visitor.getInvalidSymboList();
        for (String s : invalidSymboList) {
            if (mainEntityType.findProperty(s) == null) continue;
            String absoluteFieldName = ResReadySearchBussiness.getAbsolutePropertyName(mainEntityType.findProperty(s));
            vars.add(absoluteFieldName);
            if (absoluteFieldName.equals(s)) continue;
            formula = formula.replaceAll("\\(" + s + " ", "(" + absoluteFieldName + " ");
            formula = formula.replaceAll(" " + s + "\\)", " " + absoluteFieldName + ")");
            formula = formula.replaceAll(" " + s + " ", " " + absoluteFieldName + " ");
        }
        return formula;
    }

    public static String getAbsolutePropertyName(IDataEntityProperty property) {
        StringBuilder fieldName = new StringBuilder();
        Stack<String> stack = new Stack<String>();
        if (property != null) {
            stack.push(property.getName());
            if (property.getParent() != null && property.getParent() instanceof EntryType) {
                EntryType parent = (EntryType)property.getParent();
                stack.push(parent.getName());
                while (parent.getParent() != null && parent.getParent() instanceof EntryType) {
                    parent = (EntryType)parent.getParent();
                    stack.push(parent.getName());
                }
            }
        }
        while (!stack.isEmpty()) {
            fieldName.append((String)stack.pop()).append('.');
        }
        if (fieldName.length() > 0) {
            return fieldName.substring(0, fieldName.length() - 1);
        }
        return fieldName.toString();
    }

    private Boolean getSysParamResRange(Map<String, Object> pomSystemParam, Boolean allSelectBox, String boxName) {
        Boolean resultBool = Boolean.FALSE;
        if (pomSystemParam != null) {
            resultBool = allSelectBox != false ? Boolean.TRUE : Boolean.valueOf(Boolean.parseBoolean(String.valueOf(pomSystemParam.get(boxName))));
        }
        return resultBool;
    }

    private DynamicObject getSysParamResReadyPlan(Map<String, Object> pomSystemParam) {
        DynamicObject resReadyPlanDO = null;
        if (pomSystemParam != null) {
            Object resReadyPlanObj = pomSystemParam.get(RESREADYPLAN);
            Long resReadyPlanPK = 0L;
            if (resReadyPlanObj instanceof Map) {
                Map resReadyPlanMap = (Map)resReadyPlanObj;
                resReadyPlanPK = Long.parseLong(String.valueOf(resReadyPlanMap.get("id")));
                resReadyPlanDO = BusinessDataServiceHelper.loadSingle((Object)resReadyPlanPK, (String)FMM_READYPLAN);
            } else if (resReadyPlanObj instanceof DynamicObject) {
                Object pkValue = ((DynamicObject)resReadyPlanObj).getPkValue();
                resReadyPlanDO = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)FMM_READYPLAN);
            }
        }
        return resReadyPlanDO;
    }

    public Map<String, Object> getPomSystemParam(long orgId) {
        DynamicObject bizApp = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_devportal_bizapp", (String)"id,orgfunc", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"pom")});
        Map<String, Object> syPparams = ResReadySearchBussiness.getAppParam(bizApp.getString("id"), bizApp.getString("orgfunc"), orgId, 0L);
        return syPparams;
    }

    public static Map<String, Object> getAppParam(String appId, String viewType, long orgId, long bookId) {
        AppParam appParam = new AppParam();
        appParam.setAppId(appId);
        appParam.setViewType(viewType);
        appParam.setOrgId(Long.valueOf(orgId));
        appParam.setActBookId(Long.valueOf(bookId));
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
    }

    public DataSet getDataSetByModel(FetchDataQueryModule queryMD, DataSet ds) {
        List<String> allField = new LinkedList<String>(queryMD.getSelFields());
        Map customMethodStructMap = queryMD.getCustomMethodStructMap();
        for (Map.Entry entry : customMethodStructMap.entrySet()) {
            String targetField = (String)entry.getKey();
            allField.add(targetField);
            CustomMethodStruct customMethodStruct = (CustomMethodStruct)entry.getValue();
            MapFunction function = CustomMethodUtils.buildAlgoMapFunction((RowMeta)(ds = ds.addNullField(targetField)).getRowMeta(), (String)targetField, (CustomMethodStruct)customMethodStruct);
            if (function == null) continue;
            ds = ds.map(function);
        }
        allField = this.addResourceField(allField);
        ds = ds.select(allField.toArray(new String[0]));
        return ds;
    }

    private void getfromCheckPlanToData(DynamicObjectCollection resReadyDetailDOC, Map<Long, DynamicObject> fieldTransferMap, Map<Long, DynamicObject> checkRuleMap, boolean isPlan) {
        DynamicObject[] readyRuleDOC;
        if (resReadyDetailDOC == null || fieldTransferMap == null || checkRuleMap == null) {
            return;
        }
        fieldTransferMap.clear();
        checkRuleMap.clear();
        String fileTransferName = "";
        String checkRuleName = "";
        if (isPlan) {
            fileTransferName = "entryplanfieldtransfer";
            checkRuleName = "entryplanreadyrule";
        } else {
            fileTransferName = "entryexefieldtransfer";
            checkRuleName = "entryexereadyrule";
        }
        HashSet<Long> fieldTranPKSet = new HashSet<Long>(4);
        HashSet<Long> checkRulePKSet = new HashSet<Long>(4);
        for (DynamicObject[] resReadyDetailDO : resReadyDetailDOC) {
            DynamicObject fieldTransferDO = resReadyDetailDO.getDynamicObject(fileTransferName);
            DynamicObject checkRuleDO = resReadyDetailDO.getDynamicObject(checkRuleName);
            if (fieldTransferDO != null) {
                fieldTranPKSet.add(Long.parseLong(String.valueOf(fieldTransferDO.getPkValue())));
            }
            if (checkRuleDO == null) continue;
            checkRulePKSet.add(Long.parseLong(String.valueOf(checkRuleDO.getPkValue())));
        }
        DynamicObject[] fieldTranDOC = BusinessDataServiceHelper.load((Object[])fieldTranPKSet.toArray(new Object[fieldTranPKSet.size()]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)MRP_BILLFILED_TRANSFER));
        if (fieldTranDOC != null) {
            for (DynamicObject fieldTranDO : fieldTranDOC) {
                fieldTransferMap.put(Long.parseLong(String.valueOf(fieldTranDO.getPkValue())), fieldTranDO);
            }
        }
        if ((readyRuleDOC = BusinessDataServiceHelper.load((Object[])checkRulePKSet.toArray(new Object[checkRulePKSet.size()]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)FMM_READYRULE))) != null) {
            for (DynamicObject readyRuleDO : readyRuleDOC) {
                checkRuleMap.put(Long.parseLong(String.valueOf(readyRuleDO.getPkValue())), readyRuleDO);
            }
        }
    }

    private String writeLogMapInfo(Map<String, Object> srcBillDataMap) {
        StringBuilder str = new StringBuilder();
        if (srcBillDataMap != null) {
            srcBillDataMap.forEach((strKey, mapData) -> {
                String info = mapData == null ? "" : mapData.toString();
                str.append((String)strKey).append(":").append(info);
                str.append(",");
            });
        }
        return str.toString();
    }

    public void writeLogMapInfo(String msg, Map<String, Map<String, Object>> dataMap) {
        StringBuilder str = new StringBuilder();
        str.append(msg).append("\n");
        if (dataMap == null) {
            return;
        }
        for (Map.Entry<String, Map<String, Object>> data : dataMap.entrySet()) {
            String entryKey = data.getKey();
            str.append(entryKey).append(" : ");
            Map<String, Object> value = data.getValue();
            str.append(this.writeLogMapInfo(value)).append("\uff1b");
            str.append("\n");
        }
        logger.info(str.toString());
    }

    public void writeLogMapInfo2(String msg, Map<String, List<Map<String, Object>>> dataMap) {
        StringBuilder str = new StringBuilder();
        str.append(msg).append("\n");
        for (Map.Entry<String, List<Map<String, Object>>> data : dataMap.entrySet()) {
            String entryKey = data.getKey();
            str.append(entryKey).append(" : ");
            List<Map<String, Object>> value = data.getValue();
            for (Map<String, Object> billDataMap : value) {
                str.append(this.writeLogMapInfo(billDataMap));
                str.append("\uff1a \t");
            }
            str.append("\uff1b");
            str.append("\n");
        }
        logger.info(str.toString());
    }

    private void writeLoggerListData(String msg, List<Map<String, Object>> billDataList) {
        StringBuilder str = new StringBuilder();
        str.append(msg).append("\uff1a \n");
        if (billDataList != null) {
            for (Map<String, Object> billDataMap : billDataList) {
                str.append(this.writeLogMapInfo(billDataMap));
                str.append("\uff1a \n");
            }
        }
        logger.info(str.toString());
    }

    private static /* synthetic */ int lambda$execCheckRule$6(DynamicObject o1, DynamicObject o2) {
        int calcOrder1 = o1.getInt("entrycalcorder");
        int calcOrder2 = o2.getInt("entrycalcorder");
        return calcOrder1 - calcOrder2;
    }
}

