/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.business.threadop;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kd.bd.mpdm.common.mftorder.utils.OrderOpUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.param.ParameterReader;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.mmc.pom.business.batchexecute.MroOrderBatchOpTask;
import kd.mmc.pom.business.utils.OrderClearLockUtils;

public class MroOrderTheadOpBusiness {
    private static final Log logger = LogFactory.getLog(MroOrderTheadOpBusiness.class);
    private static final int MAXBATCHSAVECOUNT = 100;
    public volatile Map<String, Boolean> rcErrorMap = null;

    public JSONObject batchExecuteOrdersOp(List<Long> billIDList, Map<Long, List<Long>> billentryMap, String operationType, String entityNumber, boolean throwException, boolean isTotalError) {
        int allSize = billIDList.size();
        if (allSize <= 5) {
            return this.executeOrdersOp(billIDList, billentryMap, operationType, entityNumber, throwException, isTotalError);
        }
        int threadCount = this.getThreadCount();
        int batchCount = this.getBatchCount(allSize, threadCount);
        int times = this.getTimes(allSize, batchCount);
        Long startdate = System.currentTimeMillis();
        List<Long> subList = null;
        JSONObject returnJsonObject = new JSONObject();
        logger.info("batchExecuteOrdersOp begin execute datas:times = " + times + ",allSize=" + allSize + ",operationType=" + operationType + ",entityNumber=" + entityNumber);
        ThreadPool pool = ThreadPools.newFixedThreadPool((String)("MroOrderTheadOpBusiness-batchExecuteOrdersOp-" + UUID.randomUUID()), (int)threadCount);
        ArrayList<Future> resultFuture = new ArrayList<Future>(times);
        String errorString = "";
        this.initThreadError();
        for (int i = 1; i <= times; ++i) {
            if (this.isThreadError(isTotalError)) {
                returnJsonObject.put("status", (Object)false);
                returnJsonObject.put("msg", (Object)"thread execute failed,isinterrupt.");
                returnJsonObject.put("billIDList", billIDList);
            }
            subList = i < times ? billIDList.subList(batchCount * (i - 1), batchCount * i) : billIDList.subList(batchCount * (i - 1), allSize);
            logger.info("batchExecuteOrdersOp execute datas:current  step times = " + i + ",alltimes = " + times + ",operationType=" + operationType + ",entityNumber=" + entityNumber);
            try {
                Future result = pool.submit((Callable)new MroOrderBatchOpTask(subList, this.getEntryIdList(subList, billentryMap), operationType, entityNumber, this.rcErrorMap, RequestContext.get(), isTotalError), RequestContext.get());
                resultFuture.add(result);
                continue;
            }
            catch (Exception e) {
                pool.close();
                this.putThreadError();
                errorString = this.getErrorString(e);
                logger.info("batchExecuteOrdersOp  step times = " + i + ",alltimes = " + times + ",operationType=" + operationType + ",entityNumber=" + entityNumber + ",execute datas error : " + errorString);
                if (throwException) {
                    throw e;
                }
                returnJsonObject.put("status", (Object)false);
                returnJsonObject.put("msg", (Object)errorString);
                returnJsonObject.put("billIDList", billIDList);
            }
        }
        String entityName = this.getEntityName(entityNumber);
        String operationName = this.getEntityName(operationType);
        ArrayList allSucessPkIds = new ArrayList(allSize);
        for (int i = 0; i < resultFuture.size(); ++i) {
            if (this.isThreadError(isTotalError)) {
                returnJsonObject.put("status", (Object)false);
                returnJsonObject.put("msg", (Object)"thread execute failed,isinterrupt.");
                returnJsonObject.put("billIDList", billIDList);
            }
            try {
                String msg;
                Object pkjs;
                Future futureTask = (Future)resultFuture.get(i);
                Map returnMap = (Map)futureTask.get();
                boolean status = (Boolean)returnMap.get("status");
                Object pkids = returnMap.get("sucessPkIds");
                if (pkids instanceof JSONArray) {
                    pkjs = (JSONArray)pkids;
                    if (pkjs.size() > 0) {
                        allSucessPkIds.addAll(new ArrayList(pkjs));
                    }
                } else {
                    pkjs = (ArrayList)pkids;
                    if (pkjs.size() > 0) {
                        allSucessPkIds.addAll((ArrayList)pkids);
                    }
                }
                String string = msg = returnMap.get("msg") == null ? "" : returnMap.get("msg").toString();
                if (status) continue;
                this.putThreadError();
                if (errorString == null || "".equals(errorString) || errorString.equals("thread execute failed,isinterrupt.")) {
                    errorString = msg;
                }
                if (throwException) {
                    pool.close();
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6267\u884c[%1$s]\u7684[%2$s]\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff1a%3$s", (String)"MroOrderTheadOpBusiness_0", (String)"mmc-pom-business", (Object[])new Object[0]), entityName, operationName, msg));
                }
                returnJsonObject.put("status", (Object)false);
                returnJsonObject.put("msg", (Object)errorString);
                returnJsonObject.put("billIDList", billIDList);
                returnJsonObject.put("sucessPkIds", allSucessPkIds);
                continue;
            }
            catch (InterruptedException | ExecutionException e) {
                pool.close();
                this.putThreadError();
                logger.info(" thread get InterruptedException or ExecutionException ", (Object)e);
                errorString = this.getErrorString(e);
                logger.info("batchExecuteOrdersOp execute datas InterruptedException or ExecutionException error : " + errorString);
                if (throwException) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6267\u884c[%1$s]\u7684[%2$s]\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff1a%3$s", (String)"MroOrderTheadOpBusiness_0", (String)"mmc-pom-business", (Object[])new Object[0]), entityName, operationName, errorString));
                }
                returnJsonObject.put("status", (Object)false);
                returnJsonObject.put("msg", (Object)errorString);
                returnJsonObject.put("billIDList", billIDList);
                returnJsonObject.put("sucessPkIds", allSucessPkIds);
                continue;
            }
            catch (Exception e) {
                this.putThreadError();
                pool.close();
                logger.info(" thread get Exception ", (Object)e);
                errorString = this.getErrorString(e);
                logger.info("batchExecuteOrdersOp execute datas error : " + errorString);
                if (throwException) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6267\u884c[%1$s]\u7684[%2$s]\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff1a%3$s", (String)"MroOrderTheadOpBusiness_0", (String)"mmc-pom-business", (Object[])new Object[0]), entityName, operationName, errorString));
                }
                returnJsonObject.put("status", (Object)false);
                returnJsonObject.put("msg", (Object)errorString);
                returnJsonObject.put("billIDList", billIDList);
                returnJsonObject.put("sucessPkIds", allSucessPkIds);
            }
        }
        pool.close();
        Long enddate = System.currentTimeMillis() - startdate;
        logger.info("batchExecuteOrdersOp end ,cost:" + enddate + "ms,operationType=" + operationType + ",entityNumber=" + entityNumber);
        if (this.isThreadError(true)) {
            returnJsonObject.put("status", (Object)false);
            returnJsonObject.put("msg", (Object)errorString);
            returnJsonObject.put("sucessPkIds", allSucessPkIds);
            return returnJsonObject;
        }
        returnJsonObject.put("status", (Object)true);
        returnJsonObject.put("msg", (Object)"");
        returnJsonObject.put("billIDList", billIDList);
        returnJsonObject.put("sucessPkIds", allSucessPkIds);
        return returnJsonObject;
    }

    public List<Long> getEntryIdList(List<Long> subList, Map<Long, List<Long>> billentryMap) {
        ArrayList<Long> entryIdAllList = new ArrayList<Long>(subList.size());
        if (billentryMap == null || billentryMap.isEmpty()) {
            return entryIdAllList;
        }
        for (int i = 0; i < subList.size(); ++i) {
            List<Long> entryIdList = billentryMap.get(subList.get(i));
            if (entryIdList == null || entryIdList.isEmpty()) continue;
            entryIdAllList.addAll(entryIdList);
        }
        return entryIdAllList;
    }

    private boolean isSubmit(String operationType) {
        return "submit".equalsIgnoreCase(operationType);
    }

    private String getErrorString(Exception e) {
        if (e.getCause() != null && e.getCause().getMessage() != null) {
            return e.getCause().getMessage();
        }
        return e.getMessage() == null ? "" : e.getMessage();
    }

    private int getThreadCount() {
        DynamicObject billParameter = ParameterReader.getBillParameter((String)"pom_mroorder");
        int threadCount = billParameter.getInt("createorderthreadcount");
        if (threadCount == 0) {
            threadCount = 1;
        }
        logger.info("getThreadCount = " + threadCount);
        return threadCount;
    }

    private int getTimes(int allCount, int batchCount) {
        int times = allCount / batchCount;
        if (allCount % batchCount > 0) {
            ++times;
        }
        return times;
    }

    private int getBatchCount(int allCount, int threadCount) {
        if (allCount <= threadCount) {
            return 1;
        }
        int times = this.getTimes(allCount, threadCount);
        if (times >= 100) {
            return 100;
        }
        return times;
    }

    private String getEntityName(String entityNumber) {
        if ("pom_mroorder".equalsIgnoreCase(entityNumber)) {
            return ResManager.loadKDString((String)"\u68c0\u4fee\u5de5\u5355", (String)"MroOrderTheadOpBusiness_3", (String)"mmc-pom-business", (Object[])new Object[0]);
        }
        if ("sfc_mromanuftech".equalsIgnoreCase(entityNumber)) {
            return ResManager.loadKDString((String)"\u68c0\u4fee\u5de5\u5e8f\u8ba1\u5212", (String)"MroOrderTheadOpBusiness_4", (String)"mmc-pom-business", (Object[])new Object[0]);
        }
        if ("pom_mrostock".equalsIgnoreCase(entityNumber)) {
            return ResManager.loadKDString((String)"\u68c0\u4fee\u7ec4\u4ef6\u6e05\u5355", (String)"MroOrderTheadOpBusiness_5", (String)"mmc-pom-business", (Object[])new Object[0]);
        }
        return entityNumber;
    }

    private synchronized void putThreadError() {
        if (this.rcErrorMap == null) {
            this.rcErrorMap = new HashMap<String, Boolean>(16);
        }
        this.rcErrorMap.put("threadErrorKey", true);
    }

    private void initThreadError() {
        this.rcErrorMap = new HashMap<String, Boolean>(16);
        this.rcErrorMap.put("threadErrorKey", false);
    }

    private synchronized boolean isThreadError(boolean isTotalError) {
        if (!isTotalError) {
            return false;
        }
        if (this.rcErrorMap != null) {
            return this.rcErrorMap.get("threadErrorKey");
        }
        return false;
    }

    private String getOpName(String operationKey) {
        if ("submit".equalsIgnoreCase(operationKey)) {
            return ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"MroOrderTheadOpBusiness_6", (String)"mmc-pom-business", (Object[])new Object[0]);
        }
        if ("audit".equalsIgnoreCase(operationKey)) {
            return ResManager.loadKDString((String)"\u5ba1\u6838", (String)"MroOrderTheadOpBusiness_7", (String)"mmc-pom-business", (Object[])new Object[0]);
        }
        if ("unaudit".equalsIgnoreCase(operationKey)) {
            return ResManager.loadKDString((String)"\u53cd\u5ba1\u6838", (String)"MroOrderTheadOpBusiness_8", (String)"mmc-pom-business", (Object[])new Object[0]);
        }
        if ("multransmit".equalsIgnoreCase(operationKey)) {
            return ResManager.loadKDString((String)"\u91cd\u4e0b\u8fbe", (String)"MroOrderTheadOpBusiness_9", (String)"mmc-pom-business", (Object[])new Object[0]);
        }
        if ("beginwork".equalsIgnoreCase(operationKey)) {
            return ResManager.loadKDString((String)"\u5f00\u5de5", (String)"MroOrderTheadOpBusiness_10", (String)"mmc-pom-business", (Object[])new Object[0]);
        }
        if ("endwork".equalsIgnoreCase(operationKey)) {
            return ResManager.loadKDString((String)"\u5b8c\u5de5", (String)"MroOrderTheadOpBusiness_11", (String)"mmc-pom-business", (Object[])new Object[0]);
        }
        if ("invalid".equalsIgnoreCase(operationKey)) {
            return ResManager.loadKDString((String)"\u4f5c\u5e9f", (String)"MroOrderTheadOpBusiness_12", (String)"mmc-pom-business", (Object[])new Object[0]);
        }
        if ("cancel".equalsIgnoreCase(operationKey)) {
            return ResManager.loadKDString((String)"\u53d6\u6d88", (String)"MroOrderTheadOpBusiness_13", (String)"mmc-pom-business", (Object[])new Object[0]);
        }
        if ("unsubmit".equalsIgnoreCase(operationKey)) {
            return ResManager.loadKDString((String)"\u64a4\u9500", (String)"MroOrderTheadOpBusiness_14", (String)"mmc-pom-business", (Object[])new Object[0]);
        }
        if ("delete".equalsIgnoreCase(operationKey)) {
            return ResManager.loadKDString((String)"\u5220\u9664", (String)"MroOrderTheadOpBusiness_15", (String)"mmc-pom-business", (Object[])new Object[0]);
        }
        if ("transmit".equalsIgnoreCase(operationKey)) {
            return ResManager.loadKDString((String)"\u4e0b\u8fbe", (String)"MroOrderTheadOpBusiness_16", (String)"mmc-pom-business", (Object[])new Object[0]);
        }
        if ("untransmit".equalsIgnoreCase(operationKey)) {
            return ResManager.loadKDString((String)"\u53cd\u4e0b\u8fbe", (String)"MroOrderTheadOpBusiness_17", (String)"mmc-pom-business", (Object[])new Object[0]);
        }
        if ("donothing_unplan".equalsIgnoreCase(operationKey)) {
            return ResManager.loadKDString((String)"\u53cd\u6267\u884c\u81f3\u8ba1\u5212", (String)"MroOrderTheadOpBusiness_18", (String)"mmc-pom-business", (Object[])new Object[0]);
        }
        return operationKey;
    }

    public JSONObject executeOrdersOp(List<Long> billIDList, Map<Long, List<Long>> billentryMap, String operationType, String entityNumber, boolean throwException, boolean isTotalError) {
        OperateOption operateOption = OrderClearLockUtils.getOperateOption();
        JSONObject returnJsonObject = new JSONObject();
        List<Long> billEntryIdList = this.getEntryIdList(billIDList, billentryMap);
        if ("sfc_mromanuftech".equalsIgnoreCase(entityNumber) && billEntryIdList != null && !billEntryIdList.isEmpty()) {
            operateOption.setVariableValue("orderBillType", "pom_mroorder");
            operateOption.setVariableValue("orderBillName", ResManager.loadKDString((String)"\u68c0\u4fee\u5de5\u5355", (String)"MroOrderTheadOpBusiness_3", (String)"mmc-pom-business", (Object[])new Object[0]));
            operateOption.setVariableValue("stockBillType", "pom_mrostock");
            ArrayList<Long> message = new ArrayList<Long>(billEntryIdList.size());
            for (Long entryID : billEntryIdList) {
                message.add(entryID);
            }
            String sb = JSON.toJSONString(message);
            operateOption.setVariableValue("operateOption", sb);
        }
        OperationResult opResult = OperationServiceHelper.executeOperate((String)operationType, (String)entityNumber, (Object[])billIDList.toArray(), (OperateOption)operateOption);
        List sucessPkIds = opResult.getSuccessPkIds();
        if (!opResult.isSuccess()) {
            String errDetail;
            String errorString = "";
            if (opResult.getMessage() != null) {
                errorString = opResult.getMessage();
            }
            if (StringUtils.isNotEmpty((CharSequence)(errDetail = OrderOpUtils.getErrDetail((OperationResult)opResult)))) {
                errorString = errDetail;
            }
            errorString = "operationType:" + operationType + ",entityNumber:" + entityNumber + ",errorString:" + errorString;
            logger.info(String.format("executeOrdersOp \u64cd\u4f5c\u5931\u8d25%s", errorString));
            returnJsonObject.put("status", (Object)false);
            returnJsonObject.put("msg", (Object)errorString);
            returnJsonObject.put("sucessPkIds", (Object)sucessPkIds);
            return returnJsonObject;
        }
        returnJsonObject.put("status", (Object)true);
        returnJsonObject.put("msg", (Object)"");
        returnJsonObject.put("billIDList", billIDList);
        returnJsonObject.put("sucessPkIds", (Object)sucessPkIds);
        return returnJsonObject;
    }
}

