/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.business.utils;

import com.google.common.base.Joiner;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.mftorder.utils.CalendarUtils;
import kd.bd.mpdm.common.query.helper.TransactionTypeQueryHelper;
import kd.bd.mpdm.common.stockchange.utils.EntityNameUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.mmc.pom.common.mftorder.utils.PomDyObjUtil;

public class MftStockReturnData {
    private int rowcount;
    private IDataModel model;
    private StringBuilder err;
    private StringBuilder confirmstr = new StringBuilder();

    public MftStockReturnData() {
    }

    public MftStockReturnData(int rowcount, IDataModel model) {
        this.rowcount = rowcount;
        this.model = model;
    }

    public StringBuilder getErr() {
        return this.err;
    }

    public StringBuilder getConfirmstr() {
        return this.confirmstr;
    }

    public MftStockReturnData invoke(IDataModel model) {
        DynamicObject[] warehouses;
        ArrayList<Integer> materialList = new ArrayList<Integer>();
        ArrayList<Integer> warehouseList = new ArrayList<Integer>();
        ArrayList<Integer> locationList = new ArrayList<Integer>();
        ArrayList<Integer> backflushtimeList = new ArrayList<Integer>();
        ArrayList<Integer> overissuecontrlList = new ArrayList<Integer>();
        ArrayList<Integer> outorgunit = new ArrayList<Integer>();
        ArrayList<Integer> wastagerateList = new ArrayList<Integer>();
        ArrayList<Integer> supplierList = new ArrayList<Integer>();
        ArrayList<Integer> supplyorgList = new ArrayList<Integer>();
        ArrayList<Integer> isbackflushList = new ArrayList<Integer>();
        ArrayList<Integer> issuemodeList = new ArrayList<Integer>();
        List<Object> replaceList = new ArrayList();
        List<Object> equalsMainList = new ArrayList();
        String stockName = model.getDataEntityType().getName();
        if (!EntityNameUtils.getAllStockChangeName().contains(stockName)) {
            replaceList = this.getReplaceList();
        }
        DynamicObject transactionType = (DynamicObject)model.getValue("transactiontypeid");
        String bizBomType = "";
        boolean checkMain = false;
        if (transactionType != null) {
            if ("mpdm_transactout".equals(transactionType.getDataEntityType().getName())) {
                bizBomType = transactionType.getString("feedtype");
                checkMain = !"E".equals(bizBomType);
            } else if ("mpdm_transactproduct".equals(transactionType.getDataEntityType().getName())) {
                bizBomType = transactionType.getString("stockmaterials");
                boolean bl = checkMain = !"B".equals(bizBomType);
                if (TransactionTypeQueryHelper.isReworkTransType((DynamicObject)transactionType)) {
                    checkMain = false;
                }
            }
        }
        if (checkMain) {
            equalsMainList = this.getEqualsMainList(model.getDataEntityType().getName());
        }
        ArrayList<Long> wareHouseList = new ArrayList<Long>(16);
        for (int index = 0; index < this.rowcount; ++index) {
            Object warehouse = model.getValue("warehouseid", index);
            Long wareHouseId = PomDyObjUtil.getDyObjId((Object)warehouse);
            if (!PomDyObjUtil.isNotEmptyId((Long)wareHouseId)) continue;
            wareHouseList.add(wareHouseId);
        }
        HashMap<Long, DynamicObject> wareHouseAndDynMap = new HashMap<Long, DynamicObject>(16);
        QFilter wareHouseFilter = new QFilter("id", "in", wareHouseList);
        for (DynamicObject warehouse : warehouses = BusinessDataServiceHelper.load((String)"bd_warehouse", (String)"id,isopenlocation", (QFilter[])new QFilter[]{wareHouseFilter})) {
            wareHouseAndDynMap.put(warehouse.getLong("id"), warehouse);
        }
        HashMap calendarInfoMap = new HashMap(16);
        for (int index = 0; index < this.rowcount; ++index) {
            DynamicObject supplyorg;
            String wastagerate;
            DynamicObject tran;
            boolean s;
            Object outorg;
            Boolean isstockallot;
            String overissuecontrl;
            String backflushtime;
            String isbackflush;
            DynamicObject materialMft = (DynamicObject)model.getValue("materialid", index);
            if (materialMft == null) {
                materialList.add(index + 1);
            }
            if (!("A".equals(isbackflush = (String)model.getValue("isbackflush", index)) || "B".equals(isbackflush) || "C".equals(isbackflush))) {
                isbackflushList.add(index + 1);
            }
            String issuemode = (String)model.getValue("issuemode", index);
            Object warehouseObj = model.getValue("warehouseid", index);
            DynamicObject warehouse = (DynamicObject)wareHouseAndDynMap.get(PomDyObjUtil.getDyObjId((Object)warehouseObj));
            if (warehouse == null && "B".equals(isbackflush) && ("A".equals(issuemode) || "B".equals(issuemode))) {
                warehouseList.add(index + 1);
            }
            if ("B".equals(isbackflush) && ("A".equals(issuemode) || "B".equals(issuemode)) && !"A".equals(backflushtime = (String)model.getValue("backflushtime", index)) && !"B".equals(backflushtime)) {
                backflushtimeList.add(index + 1);
            }
            if (!"A".equals(overissuecontrl = (String)model.getValue("overissuecontrl", index)) && !"B".equals(overissuecontrl) && ("A".equals(issuemode) || "B".equals(issuemode))) {
                overissuecontrlList.add(index + 1);
            }
            if (warehouse != null && ("A".equals(issuemode) || "B".equals(issuemode))) {
                Boolean isopenlocation = warehouse.getBoolean("isopenlocation");
                if ("B".equals(isbackflush) && isopenlocation.booleanValue() && model.getValue("location", index) == null) {
                    locationList.add(index + 1);
                }
            }
            if ((isstockallot = (Boolean)model.getValue("isstockallot", index)).booleanValue() && StringUtils.equals((CharSequence)"om_mftstock", (CharSequence)stockName) && (outorg = model.getValue("outorgunitid", index)) == null && ("A".equals(issuemode) || "B".equals(issuemode))) {
                outorgunit.add(index + 1);
            }
            if ((s = (tran = (DynamicObject)model.getValue("transactiontypeid")).getBoolean("isconsiderloss")) && !"A".equals(wastagerate = (String)model.getValue("wastagerateformula", index)) && !"B".equals(wastagerate)) {
                wastagerateList.add(index + 1);
            }
            String supplyfield = (String)model.getValue("supplymode", index);
            DynamicObject supply = (DynamicObject)model.getValue("supplierid", index);
            if ("bos_org".equals(supplyfield) && supply == null && ("A".equals(issuemode) || "B".equals(issuemode))) {
                supplierList.add(index + 1);
            }
            if ((supplyorg = (DynamicObject)model.getValue("supplyorgid", index)) == null && ("A".equals(issuemode) || "B".equals(issuemode))) {
                supplyorgList.add(index + 1);
            }
            if (!("A".equals(issuemode) || "B".equals(issuemode) || "C".equals(issuemode))) {
                issuemodeList.add(index + 1);
            }
            Date demanddate = (Date)model.getValue("demanddate", index);
            DynamicObject orderdym = (DynamicObject)model.getValue("orderentryid");
            if (StringUtils.equals((CharSequence)model.getDataEntityType().getName(), (CharSequence)"om_componentlist") || StringUtils.equals((CharSequence)model.getDataEntityType().getName(), (CharSequence)"om_xxcomponentlist") || (orderdym = EntityNameUtils.getAllStockChangeName().contains(model.getDataEntityType().getName()) ? (DynamicObject)model.getValue("entryorderentryid", index) : (DynamicObject)model.getValue("orderentryid")) == null) continue;
            Date planendtime = orderdym.getDate("planendtime");
            Date planbeginime = orderdym.getDate("planbegintime");
            if (demanddate == null) {
                demanddate = planbeginime;
            }
            if (demanddate.after(planendtime)) {
                demanddate = planendtime;
            }
            DynamicObject org = (DynamicObject)model.getValue("org");
            Date workDate = CalendarUtils.getRecentleWorkDateNew((DynamicObject)org, (Date)demanddate, calendarInfoMap);
            ArrayList<String> infoList = new ArrayList<String>(10);
            if (null == workDate) {
                model.setValue("demanddate", (Object)demanddate, index);
                infoList.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u672a\u627e\u5230\u751f\u4ea7\u7ec4\u7ec7\u8bbe\u7f6e\u7684\u751f\u4ea7\u65e5\u5386\u6216\u9700\u6c42\u65e5\u671f\uff08%2$s\uff09\u4e0d\u5728\u65e5\u5386\u8bbe\u7f6e\u4e2d\u65e5\u5386\u7684\u6709\u6548\u671f\u8303\u56f4\u5185", (String)"MftStockReturnData_29", (String)"mmc-pom-business", (Object[])new Object[0]), index + 1, demanddate));
            } else if (!CalendarUtils.compateDateAccurateDay((Date)demanddate, (Date)workDate)) {
                model.setValue("demanddate", (Object)demanddate, index);
                infoList.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u9700\u6c42\u65e5\u671f\uff08%2$s\uff09\u4e0d\u5728\u5de5\u4f5c\u65e5\u5185", (String)"MftStockReturnData_30", (String)"mmc-pom-business", (Object[])new Object[0]), index + 1, demanddate));
            } else {
                model.setValue("demanddate", (Object)demanddate, index);
                this.updateDemandDateView(model);
            }
            if (!CollectionUtils.isNotEmpty(infoList)) continue;
            String info = String.format(ResManager.loadKDString((String)"%1$s\uff0c\u662f\u5426\u7ee7\u7eed\u63d0\u4ea4\uff1f\n", (String)"MftStockReturnData_31", (String)"mmc-pom-business", (Object[])new Object[0]), Joiner.on((String)"\uff0c").join(infoList));
            this.confirmstr.append(info);
        }
        this.err = new StringBuilder();
        if (!equalsMainList.isEmpty()) {
            this.err.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u7684\u7ec4\u4ef6\u7f16\u7801\u540c\u5de5\u5355\u5206\u5f55\u4ea7\u54c1\u7f16\u7801\u76f8\u540c\u3002", (String)"MftStockReturnData_15", (String)"mmc-pom-business", (Object[])new Object[0]), equalsMainList.stream().map(String::valueOf).collect(Collectors.joining(","))));
        }
        if (!replaceList.isEmpty()) {
            this.err.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u5bf9\u5e94\u7684\u66ff\u4ee3\u5173\u7cfb\u4f7f\u7528\u6bd4\u4f8b\u4e4b\u548c\u4e0d\u7b49\u4e8e100%\u3002", (String)"MftStockReturnData_16", (String)"mmc-pom-business", (Object[])new Object[0]), replaceList.stream().map(String::valueOf).collect(Collectors.joining(","))));
        }
        if (!materialList.isEmpty()) {
            this.err.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff0c\u8bf7\u586b\u5199\u201c\u7ec4\u4ef6\u7f16\u7801\u201d\u3002", (String)"MftStockReturnData_17", (String)"mmc-pom-business", (Object[])new Object[0]), materialList.stream().map(String::valueOf).collect(Collectors.joining(","))));
        }
        if (!warehouseList.isEmpty()) {
            this.err.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u7684\u201c\u5012\u51b2\u201d\u4e3a\u201c\u59cb\u7ec8\u5012\u51b2\u201d\uff0c\u8bf7\u586b\u5199\u201c\u4f9b\u8d27\u4ed3\u5e93\u201d\u3002", (String)"MftStockReturnData_18", (String)"mmc-pom-business", (Object[])new Object[0]), warehouseList.stream().map(String::valueOf).collect(Collectors.joining(","))));
        }
        if (!locationList.isEmpty()) {
            this.err.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u7684\u201c\u5012\u51b2\u201d\u4e3a\u201c\u59cb\u7ec8\u5012\u51b2\u201d\uff0c\u4e14\u4f9b\u8d27\u4ed3\u5e93\u542f\u7528\u4e86\u4ed3\u4f4d\u7ba1\u7406\uff0c\u8bf7\u586b\u5199\u201c\u4f9b\u8d27\u4ed3\u4f4d\u201d\u3002", (String)"MftStockReturnData_19", (String)"mmc-pom-business", (Object[])new Object[0]), locationList.stream().map(String::valueOf).collect(Collectors.joining(","))));
        }
        if (!backflushtimeList.isEmpty()) {
            this.err.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u7684\u201c\u5012\u51b2\u201d\u4e3a\u201c\u59cb\u7ec8\u5012\u51b2\u201d\uff0c\u8bf7\u586b\u5199\u201c\u5012\u51b2\u65f6\u673a\u201d\u3002", (String)"MftStockReturnData_20", (String)"mmc-pom-business", (Object[])new Object[0]), backflushtimeList.stream().map(String::valueOf).collect(Collectors.joining(","))));
        }
        if (!overissuecontrlList.isEmpty()) {
            this.err.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff0c\u8bf7\u586b\u5199\u201c\u8d85\u53d1\u63a7\u5236\u201d\u3002", (String)"MftStockReturnData_21", (String)"mmc-pom-business", (Object[])new Object[0]), overissuecontrlList.stream().map(String::valueOf).collect(Collectors.joining(","))));
        }
        if (!outorgunit.isEmpty()) {
            this.err.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u7684\u7269\u6599\u542f\u7528\u5907\u6599\u8c03\u62e8\uff0c\u8bf7\u586b\u5199\u201c\u8c03\u51fa\u7ec4\u7ec7\u201d\u3002", (String)"MftStockReturnData_22", (String)"mmc-pom-business", (Object[])new Object[0]), outorgunit.stream().map(String::valueOf).collect(Collectors.joining(","))));
        }
        if (!wastagerateList.isEmpty()) {
            this.err.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff0c\u8bf7\u586b\u5199\u201c\u635f\u8017\u8ba1\u7b97\u516c\u5f0f\u201d\u3002", (String)"MftStockReturnData_23", (String)"mmc-pom-business", (Object[])new Object[0]), wastagerateList.stream().map(String::valueOf).collect(Collectors.joining(","))));
        }
        if (!supplierList.isEmpty()) {
            this.err.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u7684\u201c\u8d27\u4e3b\u7c7b\u578b\u201d\u4e3a\u201c\u4e1a\u52a1\u5355\u5143\u201d\uff0c\u8bf7\u586b\u5199\u201c\u8d27\u4e3b\u201d\u3002", (String)"MftStockReturnData_24", (String)"mmc-pom-business", (Object[])new Object[0]), supplierList.stream().map(String::valueOf).collect(Collectors.joining(","))));
        }
        if (!supplyorgList.isEmpty()) {
            this.err.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff0c\u8bf7\u586b\u5199\u201c\u4f9b\u8d27\u7ec4\u7ec7\u201d\u3002", (String)"MftStockReturnData_25", (String)"mmc-pom-business", (Object[])new Object[0]), supplyorgList.stream().map(String::valueOf).collect(Collectors.joining(","))));
        }
        if (!isbackflushList.isEmpty()) {
            this.err.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff0c\u8bf7\u586b\u5199\u201c\u5012\u51b2\u201d\u3002", (String)"MftStockReturnData_26", (String)"mmc-pom-business", (Object[])new Object[0]), isbackflushList.stream().map(String::valueOf).collect(Collectors.joining(","))));
        }
        if (!issuemodeList.isEmpty()) {
            this.err.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff0c\u8bf7\u586b\u5199\u201c\u9886\u9001\u6599\u65b9\u5f0f\u201d\u3002", (String)"MftStockReturnData_27", (String)"mmc-pom-business", (Object[])new Object[0]), issuemodeList.stream().map(String::valueOf).collect(Collectors.joining(","))));
        }
        return this;
    }

    private void updateDemandDateView(IDataModel model) {
        Object seqf = model.getValue("seqfield");
        if (seqf != null) {
            int i = (Integer)seqf;
            Date demand = (Date)model.getValue("demanddate", i - 1);
            model.setValue("demanddatefield", (Object)demand);
        }
    }

    private List<Integer> getReplaceList() {
        ArrayList<Integer> replaceList = new ArrayList<Integer>();
        ArrayList<String> replaceIdList = new ArrayList<String>();
        DynamicObjectCollection entryEntity = this.model.getEntryEntity("stockentry");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            DynamicObject replacePlan = entry.getDynamicObject("replaceplan");
            if (replacePlan == null) continue;
            boolean isUsed = false;
            for (int j = 0; j < replaceIdList.size(); ++j) {
                if (!((String)replaceIdList.get(j)).equals(replacePlan.getPkValue().toString())) continue;
                isUsed = true;
            }
            if (isUsed) continue;
            replaceIdList.add(replacePlan.getPkValue().toString());
        }
        for (int m = 0; m < replaceIdList.size(); ++m) {
            int parentIndex = -1;
            ArrayList<Integer> childList = new ArrayList<Integer>(16);
            BigDecimal childUseratio = BigDecimal.ZERO;
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject entry = (DynamicObject)entryEntity.get(i);
                DynamicObject replacePlan = entry.getDynamicObject("replaceplan");
                if (replacePlan == null) continue;
                if (replacePlan.getPkValue().toString().equals(replaceIdList.get(m)) && "0".equals(entry.getString("pid")) && entry.getBoolean("ismainreplace")) {
                    parentIndex = i;
                    childUseratio = childUseratio.add(entry.getBigDecimal("useratio"));
                }
                if (!replacePlan.getPkValue().toString().equals(replaceIdList.get(m)) || "0".equals(entry.getString("pid"))) continue;
                boolean isUsed = false;
                Integer childPriority = entry.getInt("priority");
                for (int j = 0; j < childList.size(); ++j) {
                    if (!childPriority.equals(childList.get(j))) continue;
                    isUsed = true;
                }
                if (isUsed) continue;
                childUseratio = childUseratio.add(entry.getBigDecimal("useratio"));
                childList.add(childPriority);
            }
            if (childUseratio.compareTo(new BigDecimal(100)) == 0 || parentIndex == -1) continue;
            replaceList.add(parentIndex + 1);
        }
        return replaceList;
    }

    private List<Integer> getEqualsMainList(String entityName) {
        ArrayList<Integer> equalsMainList = new ArrayList<Integer>();
        DynamicObjectCollection entryEntity = this.model.getEntryEntity("stockentry");
        if (EntityNameUtils.getAllStockChangeName().contains(entityName)) {
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject entry = (DynamicObject)entryEntity.get(i);
                String changeType = entry.getString("entrychangetype");
                if (!"A".equals(changeType)) continue;
                String productId = "";
                DynamicObject productDym = entry.getDynamicObject("productno");
                if (productDym != null) {
                    productId = productDym.getPkValue().toString();
                }
                DynamicObject material = entry.getDynamicObject("materialid");
                String materialId = "";
                if (material != null) {
                    materialId = material.getPkValue().toString();
                }
                if (!productId.equals(materialId)) continue;
                equalsMainList.add(i + 1);
            }
        } else if (entityName.equals("om_componentlist")) {
            String productId = "";
            DynamicObject productDym = (DynamicObject)this.model.getValue("productid");
            if (productDym != null) {
                productId = productDym.getDynamicObject("masterid").getPkValue().toString();
            }
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject entry = (DynamicObject)entryEntity.get(i);
                DynamicObject material = entry.getDynamicObject("materialid");
                String materialId = "";
                if (material != null) {
                    materialId = material.getDynamicObject("masterid").getPkValue().toString();
                }
                if (!productId.equals(materialId)) continue;
                equalsMainList.add(i + 1);
            }
        } else {
            String productId = "";
            DynamicObject productDym = (DynamicObject)this.model.getValue("productid");
            if (productDym != null) {
                productId = productDym.getPkValue().toString();
            }
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject entry = (DynamicObject)entryEntity.get(i);
                DynamicObject material = entry.getDynamicObject("materialid");
                String materialId = "";
                if (material != null) {
                    materialId = material.getPkValue().toString();
                }
                if (!productId.equals(materialId)) continue;
                equalsMainList.add(i + 1);
            }
        }
        return equalsMainList;
    }
}

