/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.business.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.form.operate.MutexHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.mmc.pom.business.threadop.MroOrderTheadOpBusiness;

public class OrderClearLockUtils {
    private static final Log logger = LogFactory.getLog(OrderClearLockUtils.class);
    public static final DBRoute scmDBRoute = new DBRoute("scm");
    public static final DBRoute sysDBRoute = new DBRoute("sys");
    private static final String MROMANUFTECHENTITYNUMBER = "sfc_mromanuftech";
    private static final String MROSTOCKENTITYNUMBER = "pom_mrostock";
    private static final String MROORDERENTITYNUMBER = "pom_mroorder";

    public static void clearMroOrderLockData(List<Long> orderIDList) {
        List<Long> manuftechnicsIdList = OrderClearLockUtils.getManuftechIdList(orderIDList);
        List<Long> stockIdList = OrderClearLockUtils.getStockIdList(orderIDList);
        OrderClearLockUtils.clearLockData(orderIDList, MROORDERENTITYNUMBER);
        OrderClearLockUtils.clearLockData(manuftechnicsIdList, MROMANUFTECHENTITYNUMBER);
        OrderClearLockUtils.clearLockData(stockIdList, MROSTOCKENTITYNUMBER);
    }

    public static List<Long> getManuftechIdList(List<Long> orderIDList) {
        SqlBuilder bf = new SqlBuilder();
        ArrayList<Long> existsDbIdList = new ArrayList<Long>(orderIDList.size());
        List<String> orderIdStringList = OrderClearLockUtils.toListString(orderIDList);
        bf.append(" Select fid from t_sfc_mromanuftech where ", new Object[0]);
        bf.appendIn("fmanufactureorderid", orderIdStringList.toArray());
        try (DataSet ds = DB.queryDataSet((String)"mmc-OrderClearLockUtils-getManuftechIdList", (DBRoute)scmDBRoute, (SqlBuilder)bf);){
            for (Row row : ds) {
                existsDbIdList.add(row.getLong("fid"));
            }
        }
        return existsDbIdList;
    }

    public static List<Long> getStockIdList(List<Long> orderIDList) {
        SqlBuilder bf = new SqlBuilder();
        ArrayList<Long> existsDbIdList = new ArrayList<Long>(orderIDList.size());
        List<String> orderIdStringList = OrderClearLockUtils.toListString(orderIDList);
        bf.append(" Select fid from t_pom_mrostock where ", new Object[0]);
        bf.appendIn("forderid", orderIdStringList.toArray());
        try (DataSet ds = DB.queryDataSet((String)"mmc-OrderClearLockUtils-getStockIdList", (DBRoute)scmDBRoute, (SqlBuilder)bf);){
            for (Row row : ds) {
                existsDbIdList.add(row.getLong("fid"));
            }
        }
        return existsDbIdList;
    }

    public static boolean isNullList(List aList) {
        return aList == null || aList.isEmpty();
    }

    public static void clearLockData(List<Long> idLongList, String entityNumber) {
        if (!OrderClearLockUtils.isNullList(idLongList)) {
            OrderClearLockUtils.releaseLockData(OrderClearLockUtils.toListString(idLongList), entityNumber);
        }
    }

    public static List<String> toListString(List<Long> longList) {
        return longList.stream().map(String::valueOf).collect(Collectors.toList());
    }

    public static void releaseLockData(List<String> billIdList, String entityNumber) {
        SqlBuilder bf = new SqlBuilder();
        bf.append(" Select foperationkey,fobjectid from t_mutex_datalock where ", new Object[0]);
        bf.appendIn("fobjectid", new ArrayList<String>(billIdList));
        bf.append(" and fentitykey = '" + entityNumber + "'", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)"mmc-batchSave-releaseLockData", (DBRoute)sysDBRoute, (SqlBuilder)bf);){
            for (Row row : ds) {
                MutexHelper.release((String)entityNumber, (String)row.getString("foperationkey"), (String)row.getString("fobjectid"));
            }
        }
    }

    public static OperateOption getOperateOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignorewarn", String.valueOf(true));
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        option.setVariableValue("strictvalidation", String.valueOf(false));
        option.setVariableValue("ignoreValidation", String.valueOf(true));
        option.setVariableValue("WF", "false");
        option.setVariableValue("isStrict", "false");
        return option;
    }

    public static String deleteOrders(Set<Long> allIDSet) {
        MroOrderTheadOpBusiness batchop;
        MroOrderTheadOpBusiness batchop2;
        Map<String, List<Long>> orderStatusMap = OrderClearLockUtils.getSavedIdSetMap(allIDSet);
        if (orderStatusMap.isEmpty()) {
            return "";
        }
        List<Long> auditOrderIdList = orderStatusMap.get("C");
        List<Long> submitOrderIdList = orderStatusMap.get("B");
        List<Long> saveIdOrderList = orderStatusMap.get("A");
        if (saveIdOrderList == null) {
            saveIdOrderList = new ArrayList<Long>(allIDSet.size());
        }
        List<Long> allOrderIDList = OrderClearLockUtils.getAllListFromMap(orderStatusMap);
        Map<String, List<Long>> manuftechStatusMap = OrderClearLockUtils.getManuftechIdMap(allOrderIDList);
        Map<String, List<Long>> stockStatusMap = OrderClearLockUtils.getStockIdMap(allOrderIDList);
        List<Long> auditManuftechIdList = manuftechStatusMap.get("C");
        List<Long> auditStockIdList = stockStatusMap.get("C");
        OrderClearLockUtils.clearLockData(auditOrderIdList, MROORDERENTITYNUMBER);
        OrderClearLockUtils.clearLockData(auditManuftechIdList, MROMANUFTECHENTITYNUMBER);
        OrderClearLockUtils.clearLockData(auditStockIdList, MROSTOCKENTITYNUMBER);
        if (!OrderClearLockUtils.isNullList(auditManuftechIdList)) {
            ArrayList technicsIdList;
            Map<String, Object> techMap = OrderClearLockUtils.getManuftechReleaseEntryIdMap(auditManuftechIdList);
            if (!techMap.isEmpty() && !(technicsIdList = (ArrayList)techMap.get("technicsIdList")).isEmpty()) {
                HashMap billentryMap = (HashMap)techMap.get("billentryMap");
                MroOrderTheadOpBusiness batchop3 = new MroOrderTheadOpBusiness();
                batchop3.batchExecuteOrdersOp(technicsIdList, billentryMap, "donothing_unplan", MROMANUFTECHENTITYNUMBER, false, false);
            }
            batchop2 = new MroOrderTheadOpBusiness();
            batchop2.batchExecuteOrdersOp(auditManuftechIdList, null, "unaudit", MROMANUFTECHENTITYNUMBER, false, false);
        }
        if (!OrderClearLockUtils.isNullList(auditStockIdList)) {
            MroOrderTheadOpBusiness batchop4 = new MroOrderTheadOpBusiness();
            batchop4.batchExecuteOrdersOp(auditStockIdList, null, "unaudit", MROSTOCKENTITYNUMBER, false, false);
        }
        if (!OrderClearLockUtils.isNullList(auditOrderIdList)) {
            ArrayList orderBillIdList;
            Map<String, Object> orderMap = OrderClearLockUtils.getOrderReleaseEntryIdMap(auditOrderIdList);
            if (!orderMap.isEmpty() && !(orderBillIdList = (ArrayList)orderMap.get("orderBillIdList")).isEmpty()) {
                batchop = new MroOrderTheadOpBusiness();
                batchop.batchExecuteOrdersOp(orderBillIdList, null, "untransmit", MROORDERENTITYNUMBER, false, false);
            }
            batchop2 = new MroOrderTheadOpBusiness();
            batchop2.batchExecuteOrdersOp(auditOrderIdList, null, "unaudit", MROORDERENTITYNUMBER, false, false);
            saveIdOrderList.addAll(auditOrderIdList);
        }
        List<Long> submitManuftechIdList = manuftechStatusMap.get("B");
        List<Long> submitStockIdList = stockStatusMap.get("B");
        OrderClearLockUtils.clearLockData(submitOrderIdList, MROORDERENTITYNUMBER);
        OrderClearLockUtils.clearLockData(submitManuftechIdList, MROMANUFTECHENTITYNUMBER);
        OrderClearLockUtils.clearLockData(submitStockIdList, MROSTOCKENTITYNUMBER);
        if (!OrderClearLockUtils.isNullList(submitManuftechIdList)) {
            batchop = new MroOrderTheadOpBusiness();
            batchop.batchExecuteOrdersOp(submitManuftechIdList, null, "unsubmit", MROMANUFTECHENTITYNUMBER, false, false);
        }
        if (!OrderClearLockUtils.isNullList(submitStockIdList)) {
            batchop = new MroOrderTheadOpBusiness();
            batchop.batchExecuteOrdersOp(submitStockIdList, null, "unsubmit", MROSTOCKENTITYNUMBER, false, false);
        }
        if (!OrderClearLockUtils.isNullList(submitOrderIdList)) {
            batchop = new MroOrderTheadOpBusiness();
            batchop.batchExecuteOrdersOp(submitOrderIdList, null, "unsubmit", MROORDERENTITYNUMBER, false, false);
            saveIdOrderList.addAll(submitOrderIdList);
        }
        if (!OrderClearLockUtils.isNullList(saveIdOrderList)) {
            OrderClearLockUtils.clearLockData(saveIdOrderList, MROORDERENTITYNUMBER);
            OrderClearLockUtils.clearLockData(OrderClearLockUtils.getAllListFromMap(manuftechStatusMap), MROMANUFTECHENTITYNUMBER);
            OrderClearLockUtils.clearLockData(OrderClearLockUtils.getAllListFromMap(stockStatusMap), MROSTOCKENTITYNUMBER);
            batchop = new MroOrderTheadOpBusiness();
            batchop.batchExecuteOrdersOp(saveIdOrderList, null, "delete", MROORDERENTITYNUMBER, false, false);
        }
        return "";
    }

    public static String deleteOrdersByDB(Set<Long> allIDSet) {
        QFilter qFilter;
        Map<String, List<Long>> orderStatusMap = OrderClearLockUtils.getSavedIdSetMap(allIDSet);
        List<Long> allOrderIDList = OrderClearLockUtils.getAllListFromMap(orderStatusMap);
        Map<String, List<Long>> manuftechStatusMap = OrderClearLockUtils.getManuftechIdMap(allOrderIDList);
        Map<String, List<Long>> stockStatusMap = OrderClearLockUtils.getStockIdMap(allOrderIDList);
        List<Long> technicsIDList = OrderClearLockUtils.getAllListFromMap(manuftechStatusMap);
        List<Long> stockIDList = OrderClearLockUtils.getAllListFromMap(stockStatusMap);
        if (!OrderClearLockUtils.isNullList(stockIDList)) {
            logger.info("OrderClearLockUtils deleteOrdersByDB---stockIDList=:" + stockIDList.toString());
            qFilter = new QFilter("id", "in", stockIDList);
            DeleteServiceHelper.delete((String)MROSTOCKENTITYNUMBER, (QFilter[])new QFilter[]{qFilter});
        }
        if (!OrderClearLockUtils.isNullList(technicsIDList)) {
            logger.info("OrderClearLockUtils deleteOrdersByDB---technicsIDList=:" + stockIDList.toString());
            qFilter = new QFilter("id", "in", technicsIDList);
            DeleteServiceHelper.delete((String)MROMANUFTECHENTITYNUMBER, (QFilter[])new QFilter[]{qFilter});
        }
        if (!OrderClearLockUtils.isNullList(allOrderIDList)) {
            logger.info("OrderClearLockUtils deleteOrdersByDB---allOrderIDList=:" + stockIDList.toString());
            qFilter = new QFilter("id", "in", allOrderIDList);
            DeleteServiceHelper.delete((String)MROORDERENTITYNUMBER, (QFilter[])new QFilter[]{qFilter});
        }
        return "";
    }

    private static List<Long> getAllListFromMap(Map<String, List<Long>> aMap) {
        if (aMap == null || aMap.isEmpty()) {
            return new ArrayList<Long>(16);
        }
        ArrayList<Long> allList = new ArrayList<Long>(1000);
        for (Map.Entry<String, List<Long>> list : aMap.entrySet()) {
            List<Long> tmpList = list.getValue();
            allList.addAll(tmpList);
        }
        return allList;
    }

    private static Map<String, List<Long>> getSavedIdSetMap(Set<Long> allIDSet) {
        SqlBuilder bf = new SqlBuilder();
        HashMap<String, List<Long>> statusMap = new HashMap<String, List<Long>>(4);
        int iSize = allIDSet.size();
        if (iSize <= 0) {
            return statusMap;
        }
        ArrayList<Long> existsDbIdList = null;
        bf.append(" Select fid,fbillstatus from t_pom_mroorder where ", new Object[0]);
        bf.appendIn("fid", new ArrayList<Long>(allIDSet));
        try (DataSet ds = DB.queryDataSet((String)"mmc-batchSave-getSavedIdSetMap", (DBRoute)scmDBRoute, (SqlBuilder)bf);){
            for (Row row : ds) {
                String fbillstatus = row.getString("fbillstatus");
                existsDbIdList = (ArrayList<Long>)statusMap.get(fbillstatus);
                if (existsDbIdList == null) {
                    existsDbIdList = new ArrayList<Long>(iSize);
                }
                existsDbIdList.add(row.getLong("fid"));
                statusMap.put(fbillstatus, existsDbIdList);
            }
        }
        return statusMap;
    }

    private static Map<String, List<Long>> getManuftechIdMap(List<Long> orderIDList) {
        SqlBuilder bf = new SqlBuilder();
        HashMap<String, List<Long>> statusMap = new HashMap<String, List<Long>>(4);
        int iSize = orderIDList.size();
        if (iSize <= 0) {
            return statusMap;
        }
        List<String> orderIdStringList = OrderClearLockUtils.toListString(orderIDList);
        ArrayList<Long> existsDbIdList = null;
        bf.append(" Select fid,fbillstatus from t_sfc_mromanuftech where ", new Object[0]);
        bf.appendIn("fmanufactureorderid", orderIdStringList.toArray());
        try (DataSet ds = DB.queryDataSet((String)"mmc-batchSave-getManuftechIdSetMap", (DBRoute)scmDBRoute, (SqlBuilder)bf);){
            for (Row row : ds) {
                String fbillstatus = row.getString("fbillstatus");
                existsDbIdList = (ArrayList<Long>)statusMap.get(fbillstatus);
                if (existsDbIdList == null) {
                    existsDbIdList = new ArrayList<Long>(iSize);
                }
                existsDbIdList.add(row.getLong("fid"));
                statusMap.put(fbillstatus, existsDbIdList);
            }
        }
        return statusMap;
    }

    private static Map<String, Object> getManuftechReleaseEntryIdMap(List<Long> techIdList) {
        SqlBuilder bf = new SqlBuilder();
        HashMap<String, Object> entryMap = new HashMap<String, Object>(4);
        ArrayList<Long> technicsIdList = new ArrayList<Long>(techIdList.size());
        ArrayList<Long> technicsEntryIdList = null;
        HashMap<Long, ArrayList<Long>> billentryMap = new HashMap<Long, ArrayList<Long>>(techIdList.size());
        bf.append(" Select fentryid,fid from t_sfc_mromanftechentry where ", new Object[0]);
        bf.appendIn("fid", techIdList.toArray());
        bf.append(" and foprstatus = 'D' ", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)"mmc-batchSave-getManuftechReleaseEntryIdMap", (DBRoute)scmDBRoute, (SqlBuilder)bf);){
            for (Row row : ds) {
                Long entryID = row.getLong("fentryid");
                Long id = row.getLong("fid");
                if (!technicsIdList.contains(id)) {
                    technicsIdList.add(id);
                }
                if ((technicsEntryIdList = (ArrayList<Long>)billentryMap.get(id)) == null) {
                    technicsEntryIdList = new ArrayList<Long>(16);
                }
                technicsEntryIdList.add(entryID);
                billentryMap.put(id, technicsEntryIdList);
            }
        }
        entryMap.put("technicsIdList", technicsIdList);
        entryMap.put("billentryMap", billentryMap);
        return entryMap;
    }

    private static Map<String, Object> getOrderReleaseEntryIdMap(List<Long> orderIdList) {
        SqlBuilder bf = new SqlBuilder();
        HashMap<String, Object> entryMap = new HashMap<String, Object>(4);
        ArrayList<Long> orderBillIdList = new ArrayList<Long>(orderIdList.size());
        ArrayList<Long> ordersEntryIdList = null;
        HashMap<Long, ArrayList<Long>> billentryMap = new HashMap<Long, ArrayList<Long>>(orderIdList.size());
        bf.append(" Select fentryid,fid from t_pom_mroorderentry where ", new Object[0]);
        bf.appendIn("fid", orderIdList.toArray());
        bf.append(" and fplanstatus = 'C' ", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)"mmc-batchSave-getOrderReleaseEntryIdMap", (DBRoute)scmDBRoute, (SqlBuilder)bf);){
            for (Row row : ds) {
                Long entryID = row.getLong("fentryid");
                Long id = row.getLong("fid");
                if (!orderBillIdList.contains(id)) {
                    orderBillIdList.add(id);
                }
                if ((ordersEntryIdList = (ArrayList<Long>)billentryMap.get(id)) == null) {
                    ordersEntryIdList = new ArrayList<Long>(16);
                }
                ordersEntryIdList.add(entryID);
                billentryMap.put(id, ordersEntryIdList);
            }
        }
        entryMap.put("orderBillIdList", orderBillIdList);
        entryMap.put("billentryMap", billentryMap);
        return entryMap;
    }

    private static Map<String, List<Long>> getStockIdMap(List<Long> orderIDList) {
        SqlBuilder bf = new SqlBuilder();
        HashMap<String, List<Long>> statusMap = new HashMap<String, List<Long>>(4);
        int iSize = orderIDList.size();
        if (iSize <= 0) {
            return statusMap;
        }
        List<String> orderIdStringList = OrderClearLockUtils.toListString(orderIDList);
        ArrayList<Long> existsDbIdList = null;
        bf.append(" Select fid,fbillstatus from t_pom_mrostock where ", new Object[0]);
        bf.appendIn("forderid", orderIdStringList.toArray());
        try (DataSet ds = DB.queryDataSet((String)"mmc-batchSave-getStockIdSetMap", (DBRoute)scmDBRoute, (SqlBuilder)bf);){
            for (Row row : ds) {
                String fbillstatus = row.getString("fbillstatus");
                existsDbIdList = (ArrayList<Long>)statusMap.get(fbillstatus);
                if (existsDbIdList == null) {
                    existsDbIdList = new ArrayList<Long>(iSize);
                }
                existsDbIdList.add(row.getLong("fid"));
                statusMap.put(fbillstatus, existsDbIdList);
            }
        }
        return statusMap;
    }
}

