/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.formplugin.botp;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.ConvertBill;
import kd.bos.entity.botp.ConvertOpType;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.ConvertOpParameter;
import kd.bos.entity.botp.runtime.ConvertOpRule;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.GetTargetOptionalOrgsArgs;
import kd.bos.entity.botp.runtime.GetTargetOptionalOrgsResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.botp.Push;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;

public class MftConvertOpFormEdit
extends AbstractFormPlugin {
    private static final String Key_FBill = "fbill";
    private static final String Key_FRule = "frule";
    private static final String Key_FRelationOrg = "frelationorg";
    private static final String Key_ShowReport = "showreport";
    private static final String Key_OutFormula = "outformula";
    private static final String Key_OK = "btnok";
    private ConvertOpParameter opParameter;

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{Key_OK});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.fillBillCombo();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getConvertOpParamter().getOpType().compareTo((Enum)ConvertOpType.Push) != 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{Key_ShowReport, Key_OutFormula});
        }
    }

    public void click(EventObject evt) {
        ConvertOpParameter copParameter;
        super.click(evt);
        Control srcCtrl = (Control)evt.getSource();
        if (Key_OK.equalsIgnoreCase(srcCtrl.getKey()) && (copParameter = this.getConvertOpParamter()).getOpType() == ConvertOpType.Push) {
            this.doPush(copParameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equalsIgnoreCase(Key_FBill)) {
            this.fillRuleCombo(null);
            this.fillOrgCombo(null);
        }
    }

    private void doPush(ConvertOpParameter opParameter) {
        String targetEntityNumber = (String)this.getModel().getValue(Key_FBill);
        String ruleId = (String)this.getModel().getValue(Key_FRule);
        String defOrgId = (String)this.getModel().getValue(Key_FRelationOrg);
        Boolean showReport = (Boolean)this.getModel().getValue(Key_ShowReport);
        PushArgs args = new PushArgs();
        if (StringUtils.isNotBlank((CharSequence)opParameter.getAppId())) {
            args.setAppId(opParameter.getAppId());
        } else {
            args.setAppId(this.getView().getFormShowParameter().getCheckRightAppId());
        }
        args.setSourceEntityNumber(opParameter.getEntityNumber());
        args.setTargetEntityNumber(targetEntityNumber);
        args.setHasRight(opParameter.isHasRight());
        args.addCustomParam("requiredatamutex", String.valueOf(true));
        args.setAutoSave(true);
        for (ConvertBill bill : opParameter.getBills()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)targetEntityNumber, (CharSequence)bill.getEntityNumber())) continue;
            for (ConvertOpRule rule : bill.getRules()) {
                args.getRuleIds().add(rule.getRuleId());
            }
        }
        if (!"@all".equals(ruleId)) {
            args.setRuleId(ruleId);
        }
        if (!StringUtils.isBlank((CharSequence)defOrgId) && !StringUtils.equals((CharSequence)"0", (CharSequence)defOrgId)) {
            args.setDefOrgId(Long.valueOf(defOrgId));
        }
        args.setSelectedRows((List)opParameter.getSelectedRows());
        args.setBuildConvReport(true);
        if (this.getModel().getProperty(Key_OutFormula) != null) {
            Boolean outFormula = (Boolean)this.getModel().getValue(Key_OutFormula);
            args.addCustomParam(Key_OutFormula, String.valueOf(outFormula));
        }
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        Push.addPushByBillOption((IFormView)parentView, (AbstractConvertServiceArgs)args);
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)args);
        if (!result.isSuccess() || result.getCachePageIds().size() + result.getTargetBillIds().size() == 0) {
            Push.showReport((IFormView)this.getView(), (AbstractConvertServiceArgs)args, (ConvertOperationResult)result);
        } else if (result.getCachePageIds().size() + result.getTargetBillIds().size() == 1) {
            Push.showTargetBill((IFormView)parentView, (PushArgs)args, (ConvertOperationResult)result, (boolean)showReport);
            this.getView().sendFormAction(parentView);
            this.getView().close();
        } else {
            Push.showMultiTargetBills((IFormView)parentView, (PushArgs)args, (ConvertOperationResult)result, (boolean)showReport);
            this.getView().sendFormAction(parentView);
            this.getView().close();
        }
    }

    private void fillBillCombo() {
        ConvertOpParameter copParameter = this.getConvertOpParamter();
        ConvertBill defTargetBill = null;
        ArrayList<ComboItem> billItems = new ArrayList<ComboItem>(10);
        ComboItem blankItem = new ComboItem();
        blankItem.setValue("");
        blankItem.setCaption(new LocaleString());
        billItems.add(blankItem);
        HashMap<String, Integer> entityNameCounts = new HashMap<String, Integer>(copParameter.getBills().size());
        for (ConvertBill bill : copParameter.getBills()) {
            Integer count;
            if (StringUtils.isBlank((CharSequence)bill.getEntityName())) {
                bill.setEntityName(bill.getEntityNumber());
            }
            if ((count = (Integer)entityNameCounts.get(bill.getEntityName())) == null) {
                entityNameCounts.put(bill.getEntityName(), 1);
                continue;
            }
            entityNameCounts.put(bill.getEntityName(), count + 1);
        }
        for (ConvertBill bill : copParameter.getBills()) {
            ComboItem billItem = new ComboItem();
            billItem.setValue(bill.getEntityNumber());
            if (StringUtils.isBlank((CharSequence)bill.getEntityName())) {
                billItem.setCaption(new LocaleString(Lang.get().getLocale().toString(), bill.getEntityNumber()));
            } else if ((Integer)entityNameCounts.get(bill.getEntityName()) > 1) {
                billItem.setCaption(new LocaleString(Lang.get().getLocale().toString(), bill.getEntityName() + " (" + bill.getEntityNumber() + ")"));
            } else {
                billItem.setCaption(new LocaleString(Lang.get().getLocale().toString(), bill.getEntityName()));
            }
            billItems.add(billItem);
        }
        ComboEdit billEditor = (ComboEdit)this.getView().getControl(Key_FBill);
        billEditor.setComboItems(billItems);
        if (copParameter.getBills().size() > 0) {
            if (defTargetBill == null) {
                defTargetBill = (ConvertBill)copParameter.getBills().get(0);
            }
            this.getModel().setValue(Key_FBill, (Object)defTargetBill.getEntityNumber());
        }
        this.fillRuleCombo(defTargetBill);
        this.fillOrgCombo(defTargetBill);
    }

    private void fillRuleCombo(ConvertBill bill) {
        ConvertBill currBill = bill;
        if (currBill == null) {
            currBill = this.getCurrConvertBill();
        }
        boolean isPush = false;
        if (this.opParameter.getOpType() == ConvertOpType.Push || this.opParameter.getOpType() == ConvertOpType.SpecPush) {
            isPush = true;
        }
        ArrayList<ComboItem> ruleItems = new ArrayList<ComboItem>();
        String defRuleId = "";
        boolean isDefTargetBill = false;
        if (isPush) {
            ComboItem blankItem = new ComboItem();
            blankItem.setValue("@all");
            blankItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u81ea\u52a8\u5339\u914d\u89c4\u5219", (String)"MftConvertOpFormEdit_0", (String)"mmc-pom-formplugin", (Object[])new Object[0])));
            ruleItems.add(blankItem);
            if (currBill != null) {
                isDefTargetBill = StringUtils.equalsIgnoreCase((CharSequence)currBill.getEntityNumber(), (CharSequence)this.opParameter.getDefTargetBill());
            }
        }
        if (currBill != null) {
            for (ConvertOpRule rule : currBill.getRules()) {
                if (!rule.isVisibled()) continue;
                ComboItem ruleItem = new ComboItem();
                ruleItem.setValue(rule.getRuleId());
                ruleItem.setCaption(new LocaleString(rule.getRuleName()));
                ruleItems.add(ruleItem);
                if (!isDefTargetBill || !StringUtils.equalsIgnoreCase((CharSequence)rule.getRuleId(), (CharSequence)this.opParameter.getDefRuleId())) continue;
                defRuleId = rule.getRuleId();
            }
        }
        ComboEdit billEditor = (ComboEdit)this.getView().getControl(Key_FRule);
        billEditor.setComboItems(ruleItems);
        if (ruleItems.size() == 0) {
            this.getModel().setValue(Key_FRule, (Object)"");
        } else {
            if (StringUtils.isBlank((CharSequence)defRuleId)) {
                defRuleId = ((ComboItem)ruleItems.get(0)).getValue();
            }
            this.getModel().setValue(Key_FRule, (Object)defRuleId);
        }
    }

    private void fillOrgCombo(ConvertBill bill) {
        ConvertBill currBill = bill;
        if (currBill == null) {
            currBill = this.getCurrConvertBill();
        }
        if (currBill == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{Key_FRelationOrg});
            return;
        }
        ConvertOpParameter copParameter = this.getConvertOpParamter();
        ArrayList orgIds = new ArrayList();
        if (copParameter.getOpType() == ConvertOpType.Push) {
            String targetEntityNumber = currBill.getEntityNumber();
            String ruleId = (String)this.getModel().getValue(Key_FRule);
            GetTargetOptionalOrgsArgs args = new GetTargetOptionalOrgsArgs();
            args.setAppId(copParameter.getAppId());
            args.setSourceEntityNumber(copParameter.getEntityNumber());
            args.setTargetEntityNumber(targetEntityNumber);
            for (ConvertOpRule rule : currBill.getRules()) {
                args.getRuleIds().add(rule.getRuleId());
            }
            if (!"@all".equals(ruleId)) {
                args.setRuleId(ruleId);
            }
            args.setSelectedRows((List)copParameter.getSelectedRows());
            GetTargetOptionalOrgsResult orgsResult = ConvertServiceHelper.getTargetOptionalOrgs((GetTargetOptionalOrgsArgs)args);
            if (!orgsResult.isSuccess() || !orgsResult.isHasMainOrg()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{Key_FRelationOrg});
            } else if (!orgsResult.isShowTargetOrgCombo()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{Key_FRelationOrg});
            } else {
                orgIds.addAll(orgsResult.getOrgIds());
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{Key_FRelationOrg});
            return;
        }
        ArrayList<ComboItem> orgItems = new ArrayList<ComboItem>();
        ComboItem blankItem = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u81ea\u52a8\u8ba1\u7b97", (String)"MftConvertOpFormEdit_1", (String)"mmc-pom-formplugin", (Object[])new Object[0])), "0");
        orgItems.add(blankItem);
        if (orgIds.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{Key_FRelationOrg});
        } else {
            Object[] arrOrgIds;
            this.getView().setVisible(Boolean.TRUE, new String[]{Key_FRelationOrg});
            if (orgIds.size() > 10) {
                arrOrgIds = new Object[10];
                for (int i = 0; i < 10; ++i) {
                    arrOrgIds[i] = orgIds.get(i);
                }
            } else {
                arrOrgIds = orgIds.toArray();
            }
            DynamicObjectType orgMainType = EntityMetadataCache.getSubDataEntityType((String)"bos_org", new ArrayList());
            Map orgs = BusinessDataServiceHelper.loadFromCache((Object[])arrOrgIds, (DynamicObjectType)orgMainType);
            for (Map.Entry orgItem : orgs.entrySet()) {
                ComboItem ruleItem = new ComboItem();
                ruleItem.setValue(orgItem.getKey().toString());
                ruleItem.setCaption(new LocaleString(((DynamicObject)orgItem.getValue()).get("name").toString()));
                orgItems.add(ruleItem);
            }
        }
        ComboEdit billEditor = (ComboEdit)this.getView().getControl(Key_FRelationOrg);
        billEditor.setComboItems(orgItems);
        if (orgItems.size() == 0) {
            this.getModel().setValue(Key_FRelationOrg, (Object)"");
        } else {
            this.getModel().setValue(Key_FRelationOrg, (Object)blankItem.getValue());
        }
    }

    private ConvertBill getCurrConvertBill() {
        ConvertBill currBill = null;
        ConvertOpParameter copParameter = this.getConvertOpParamter();
        String fldValue = (String)this.getModel().getValue(Key_FBill);
        if (copParameter == null || StringUtils.isBlank((CharSequence)fldValue)) {
            return null;
        }
        for (ConvertBill convertBill : copParameter.getBills()) {
            if (!StringUtils.equals((CharSequence)fldValue, (CharSequence)convertBill.getEntityNumber())) continue;
            currBill = convertBill;
            break;
        }
        return currBill;
    }

    private ConvertOpParameter getConvertOpParamter() {
        if (this.opParameter == null) {
            String opParamJson = (String)this.getView().getFormShowParameter().getCustomParam("opparam");
            if (StringUtils.isNotBlank((CharSequence)opParamJson)) {
                this.opParameter = (ConvertOpParameter)SerializationUtils.fromJsonString((String)opParamJson, ConvertOpParameter.class);
            } else {
                this.opParameter = new ConvertOpParameter();
                this.opParameter.setOpType(ConvertOpType.Push);
            }
        }
        return this.opParameter;
    }
}

