/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.formplugin.distribplan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class DistribPlanConvertPlugIn
extends AbstractConvertPlugIn {
    private Map<String, String> dimensionRelFieldMap = new HashMap<String, String>(16);

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        String tgtMainType = this.getTgtMainType().toString();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(tgtMainType);
        this.initDefaultRelFieldMap();
        this.dimensionRelFieldMap = this.getDimensionRelFieldMap();
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject dataEntity = entity.getDataEntity();
            this.clearHead(dataEntity);
        }
    }

    public Map<String, String> getDimensionRelFieldMap() {
        return this.dimensionRelFieldMap;
    }

    private void initDefaultRelFieldMap() {
        this.dimensionRelFieldMap = new HashMap<String, String>(16);
        this.dimensionRelFieldMap.put("entryentity.material", "material");
        this.dimensionRelFieldMap.put("entryentity.baseunit", "unit");
        this.dimensionRelFieldMap.put("entryentity.billnumber", "mftno");
        this.dimensionRelFieldMap.put("entryentity.prodmtno", "prodmaterial");
        this.dimensionRelFieldMap.put("entryentity.produnit", "produnit");
        this.dimensionRelFieldMap.put("entryentity.workprocd", "workproc");
        this.dimensionRelFieldMap.put("entryentity.workcenter", "workcenter");
        this.dimensionRelFieldMap.put("entryentity.workstation", "workstation");
        this.dimensionRelFieldMap.put("entryentity.productionorgunit", "reqorg");
        this.dimensionRelFieldMap.put("entryentity.supplyorgunit", "supplyorg");
        this.dimensionRelFieldMap.put("entryentity.instock", "warehouse");
        this.dimensionRelFieldMap.put("entryentity.inposition", "stocklocat");
        this.dimensionRelFieldMap.put("entryentity.projectnumber", "project");
        this.dimensionRelFieldMap.put("entryentity.isbackflush", "backflush");
        this.dimensionRelFieldMap.put("entryentity.outstock", "calloutwarehouse");
        this.dimensionRelFieldMap.put("entryentity.outposition", "calloutstocklocat");
        this.dimensionRelFieldMap.put("entryentity.outstockorg", "calloutorg");
        this.dimensionRelFieldMap.put("entryentity.onorderbillno", "onorderbillno");
        this.dimensionRelFieldMap.put("entryentity.transactiontypeid", "transactiontypeid");
        this.dimensionRelFieldMap.put("entryentity.zhny_storeman", "zhny_headstoreman");
        this.dimensionRelFieldMap.put("entryentity.zhny_is_setsupplier", "zhny_headissetsupplier");
        this.dimensionRelFieldMap.put("entryentity.zhny_entrysupplier", "zhny_headsupplier");
    }

    private void clearHead(DynamicObject dataEntity) {
        DynamicObject dimensionObj;
        ArrayList<String> existField = new ArrayList<String>(16);
        DynamicObject distrtype = dataEntity.getDynamicObject("distrtype");
        if (distrtype != null && (dimensionObj = this.getMergeDimension(distrtype.getLong("id"))) != null) {
            DynamicObjectCollection entryentity = dimensionObj.getDynamicObjectCollection("entryentity");
            List group = entryentity.stream().map(o -> o.getString("attridentif")).collect(Collectors.toList());
            for (String dimension : group) {
                String field = this.dimensionRelFieldMap.get(dimension);
                if (!StringUtils.isNotEmpty((CharSequence)field)) continue;
                existField.add(field);
            }
        }
        Collection<String> allFields = this.dimensionRelFieldMap.values();
        List clearField = allFields.stream().filter(o -> !existField.contains(o)).collect(Collectors.toList());
        DynamicObjectType dynamicObjectType = dataEntity.getDynamicObjectType();
        for (String field : clearField) {
            if (dynamicObjectType.getProperty(field) == null) continue;
            dataEntity.set(field, null);
        }
    }

    private DynamicObject getMergeDimension(long id) {
        DynamicObject distrtype = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"mpdm_distrtype", (String)"mergedimension.id");
        Long mergedimensionId = distrtype.getLong("mergedimension.id");
        DynamicObject mergedimension = null;
        if (mergedimensionId > 0L) {
            mergedimension = BusinessDataServiceHelper.loadSingleFromCache((Object)mergedimensionId, (String)"mpdm_mergedimension");
        }
        return mergedimension;
    }
}

