/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.formplugin.distribplan;

import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.mmc.pom.business.distr.helper.DistrRunHelper;

public class DistributePlanExecPlugin
extends AbstractFormPlugin {
    private static final String SCHEDULING_ORG = "scheduling_org";
    private static final Log log = LogFactory.getLog(DistributePlanExecPlugin.class);
    private static final String POM_DISTRPLAN_EXEC = "pom_distrplan_exec";
    private static final String CACULATE_LOG = "mrp_caculate_log";
    private static final String PLANGRAMENTITY = "pom_planprogram_distr";
    private Set<Object> dataMutexSuccessSet = new HashSet<Object>(16);
    private String mutexEntityId = "pom_mftorder";
    private String mutexOpKey = "distrplan";
    private String mutexIdFieldName = "entryentity.billid";
    private String algoCacheId = null;
    private String schedulingSchemeId = null;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button runitem = (Button)this.getControl("btncalc");
        runitem.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long userId = RequestContext.get().getCurrUserId();
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"04", (String)BizAppServiceHelp.getAppIdByAppNumber((String)"pom"), (String)POM_DISTRPLAN_EXEC, (String)"47150e89000000ac");
        List orgIds = result.getHasPermOrgs();
        long orgid = RequestContext.get().getOrgId();
        if (!orgIds.isEmpty()) {
            this.setOrgByPermission(orgid, orgIds);
        } else if (result.hasAllOrgPerm()) {
            this.getModel().setValue(SCHEDULING_ORG, (Object)RequestContext.get().getOrgId());
        }
    }

    private void autoTrigger() {
        FormShowParameter param = this.getView().getFormShowParameter();
        String autoTrigger = (String)param.getCustomParam("autoTrigger");
        Map runSet = DistrRunHelper.loadRunSet((String)autoTrigger);
        if (runSet != null) {
            this.getModel().setValue(SCHEDULING_ORG, runSet.get(SCHEDULING_ORG));
            this.getModel().setValue("scheduling_scheme", runSet.get("scheduling_scheme"));
            this.getView().invokeOperation("exec");
        }
    }

    public void setOrgByPermission(long orgid, List<Long> orgIds) {
        if (orgIds.contains(orgid)) {
            this.getModel().setValue(SCHEDULING_ORG, (Object)RequestContext.get().getOrgId());
        } else {
            this.getModel().setValue(SCHEDULING_ORG, (Object)orgIds.get(0));
        }
    }

    public void click(EventObject e) {
        super.click(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (SCHEDULING_ORG.equals(key)) {
            this.getModel().setValue("scheduling_scheme", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        String key = op.getOperateKey();
        if ("exec".equals(key)) {
            this.initCalcParams();
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u8ba1\u7b97\u51c6\u5907\u4e2d\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"DistributePlanExecPlugin_5", (String)"mmc-pom-formplugin", (Object[])new Object[0])));
            try {
                this.beforeCalculate(e);
            }
            finally {
                this.getView().hideLoading();
            }
        }
    }

    private void initCalcParams() {
        FormShowParameter param = this.getView().getFormShowParameter();
        this.algoCacheId = (String)param.getCustomParam("algoCacheId");
        String mutexEntityIdTemp = (String)param.getCustomParam("mutexEntityId");
        this.mutexEntityId = StringUtils.isEmpty((CharSequence)mutexEntityIdTemp) ? this.mutexEntityId : mutexEntityIdTemp;
        String mutexOpKeyTemp = (String)param.getCustomParam("mutexOpKey");
        this.mutexOpKey = StringUtils.isEmpty((CharSequence)mutexOpKeyTemp) ? this.mutexOpKey : mutexOpKeyTemp;
        String mutexIdFieldNameTemp = (String)param.getCustomParam("mutexIdFieldName");
        this.mutexIdFieldName = StringUtils.isEmpty((CharSequence)mutexIdFieldNameTemp) ? this.mutexIdFieldName : mutexIdFieldNameTemp;
    }

    private void beforeCalculate(BeforeDoOperationEventArgs e) {
        CachedDataSet cachedDataSet = this.testAlgoCache();
        if (StringUtils.isNotEmpty((CharSequence)this.algoCacheId) && cachedDataSet == null) {
            String msg = ResManager.loadKDString((String)"\u9009\u5355\u6570\u636e\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"DistributePlanExecPlugin_3", (String)"mmc-pom-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            return;
        }
        if (!this.addDataMutex(cachedDataSet)) {
            return;
        }
        try {
            Long logid = (Long)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IMRPCalcRuntimeService", (String)"initRuntime", (Object[])new Object[]{CACULATE_LOG});
            this.writeLog(logid);
            this.execSchedulingScheme(logid);
        }
        catch (Exception exception) {
            this.release();
            throw exception;
        }
    }

    private boolean addDataMutex(CachedDataSet cachedDataSet) {
        Set<Object> orderIdSet = new HashSet(16);
        this.dataMutexSuccessSet = new HashSet<Object>(16);
        StringBuilder errMsg = new StringBuilder();
        DynamicObject schedulingScheme = (DynamicObject)this.getModel().getValue("scheduling_scheme");
        String string = this.schedulingSchemeId = schedulingScheme != null ? schedulingScheme.getPkValue().toString() : "";
        if (!MutexHelper.require((String)PLANGRAMENTITY, (Object)String.valueOf(this.schedulingSchemeId), (String)"globaexec", (boolean)true, (StringBuilder)errMsg)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u5b58\u5728\u6b63\u5728\u8fd0\u884c\u7684\u8ba1\u5212\uff0c\u8bf7\u7b49\u5f85\u8fd0\u7b97\u7ed3\u675f\u6216\u7ec8\u6b62\u8fd0\u7b97\u540e\u518d\u8fdb\u884c\u8ba1\u7b97\u3002", (String)"DistributePlanExecPlugin_1", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (cachedDataSet != null && cachedDataSet.getRowMeta().getField(this.mutexIdFieldName, false) != null) {
            List dataSetList = cachedDataSet.getList(0, cachedDataSet.getRowCount());
            orderIdSet = dataSetList.stream().map(o -> o.getLong(this.mutexIdFieldName)).collect(Collectors.toSet());
            for (Object orderId : orderIdSet) {
                StringBuilder itemMsg = new StringBuilder();
                if (!MutexHelper.require((String)this.mutexEntityId, (Object)String.valueOf(orderId), (String)this.mutexOpKey, (boolean)true, (StringBuilder)itemMsg)) {
                    errMsg.append((CharSequence)itemMsg);
                    continue;
                }
                this.dataMutexSuccessSet.add(orderId);
            }
            if (errMsg.length() > 0) {
                this.getView().showTipNotification(errMsg.toString());
                this.release();
                return false;
            }
        }
        return true;
    }

    private void execSchedulingScheme(long ctxId) {
        DynamicObject org = (DynamicObject)this.getModel().getValue(SCHEDULING_ORG);
        String title = ResManager.loadKDString((String)"\u914d\u9001\u8ba1\u5212", (String)"DistributePlanExecPlugin_2", (String)"mmc-pom-formplugin", (Object[])new Object[0]);
        Long evntid = (Long)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IMRPCalcRuntimeService", (String)"startCalc", (Object[])new Object[]{ctxId, null, org.getLong("id"), org.getString("name"), this.getView().getFormShowParameter().getFormId(), title, CACULATE_LOG});
        this.showLogForm(evntid);
    }

    private DynamicObject writeLog(Long ctxId) {
        this.putAlgoCacheId(ctxId);
        String title = ResManager.loadKDString((String)"\u914d\u9001\u8ba1\u5212", (String)"DistributePlanExecPlugin_2", (String)"mmc-pom-formplugin", (Object[])new Object[0]);
        DynamicObject schedulingScheme = (DynamicObject)this.getModel().getValue("scheduling_scheme");
        DynamicObject caculateLog = BusinessDataServiceHelper.loadSingle((Object)ctxId, (String)CACULATE_LOG);
        DynamicObject org = (DynamicObject)this.getModel().getValue(SCHEDULING_ORG);
        caculateLog.set("createorg", (Object)org);
        caculateLog.set("useorg", (Object)org);
        caculateLog.set("status", (Object)"C");
        caculateLog.set("enable", (Object)"1");
        caculateLog.set("plantype", (Object)title);
        caculateLog.set("plangram", (Object)schedulingScheme.getLong("id"));
        caculateLog.set("programname", (Object)schedulingScheme.getString("name"));
        caculateLog.set("programnumber", (Object)schedulingScheme.getString("number"));
        caculateLog.set("plangramentity", (Object)PLANGRAMENTITY);
        caculateLog.set("plandate", this.getModel().getValue("plandate"));
        caculateLog.set("creator", (Object)RequestContext.get().getCurrUserId());
        caculateLog.set("startdate", (Object)new Date());
        caculateLog.set("operatmode", (Object)title);
        caculateLog.set("operatmodekey", (Object)this.getView().getFormShowParameter().getFormId());
        caculateLog.set("runtype", (Object)"DISTR");
        String number = CodeRuleServiceHelper.getNumber((String)CACULATE_LOG, (DynamicObject)caculateLog, (String)String.valueOf(RequestContext.get().getOrgId()));
        if (StringUtils.isNotEmpty((CharSequence)number)) {
            caculateLog.set("number", (Object)number);
        }
        SaveServiceHelper.update((DynamicObject)caculateLog);
        return caculateLog;
    }

    private void putAlgoCacheId(Long ctxId) {
        FormShowParameter param = this.getView().getFormShowParameter();
        String algoCacheId = (String)param.getCustomParam("algoCacheId");
        if (StringUtils.isNotEmpty((CharSequence)algoCacheId)) {
            DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(CACULATE_LOG);
            cache.put(ctxId.toString(), "algoCacheId", (Object)algoCacheId);
        }
    }

    private CachedDataSet testAlgoCache() {
        CachedDataSet cachedDataSet = null;
        if (StringUtils.isNotEmpty((CharSequence)this.algoCacheId)) {
            try {
                cachedDataSet = Algo.getCacheDataSet((String)this.algoCacheId);
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        return cachedDataSet;
    }

    private void showLogForm(Long id) {
        this.getView().close();
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId("pom_distrcaculate_log");
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setPkId((Object)id);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam("id", (Object)id);
        formShowParameter.setCustomParam("forward", (Object)"distrplan");
        formShowParameter.setCaption(this.getView().getFormShowParameter().getFormName());
        this.getView().showForm((FormShowParameter)formShowParameter);
        ThreadPools.executeOnce((String)"DistributePlanExecPlugin", () -> this.doRelease(id));
    }

    private void doRelease(Long id) {
        String status = this.getCalcStatus(id);
        int i = 0;
        while ("D".equals(status)) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            status = this.getCalcStatus(id);
            if (++i <= 10000) continue;
        }
        this.release();
    }

    private void release() {
        if (this.dataMutexSuccessSet != null) {
            for (Object orderId : this.dataMutexSuccessSet) {
                MutexHelper.release((String)this.mutexEntityId, (String)this.mutexOpKey, (String)String.valueOf(orderId));
            }
            this.dataMutexSuccessSet.clear();
        }
        MutexHelper.release((String)PLANGRAMENTITY, (String)"globaexec", (String)String.valueOf(this.schedulingSchemeId));
    }

    private String getCalcStatus(Long id) {
        String status = "";
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)CACULATE_LOG, (String)"calculatestatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (dynamicObject != null) {
            status = dynamicObject.getString("calculatestatus");
        }
        return status;
    }
}

