/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.formplugin.distribsplit;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.mftorder.helper.WarehouseHelper;
import kd.bd.mpdm.common.utils.DynamicObjDataUtil;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;

public class DistribOrderSplitEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String MATERIAL = "material";
    private static final String UNIT = "unit";
    private static final String REQQTY = "reqqty";
    private static final String SPLITQTY = "splitqty";
    private static final String SUPPLYORG = "supplyorg";
    private static final String WAREHOUSE = "warehouse";
    private static final String STOCKLOCAT = "stocklocat";
    private static final String BTNOK = "btnok";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject distrbPlanObj = this.getDistrbPlanObj();
        if (null == distrbPlanObj) {
            return;
        }
        IDataModel model = this.getModel();
        model.beginInit();
        model.setValue(MATERIAL, (Object)distrbPlanObj.getDynamicObject(MATERIAL));
        model.setValue(UNIT, (Object)distrbPlanObj.getDynamicObject(UNIT));
        model.setValue(REQQTY, (Object)distrbPlanObj.getBigDecimal(REQQTY));
        model.setValue(SUPPLYORG, (Object)distrbPlanObj.getDynamicObject(SUPPLYORG));
        model.endInit();
        model.updateCache();
        this.getView().updateView(REQQTY);
        this.getView().updateView(SUPPLYORG);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK});
        this.addF7Listener(WAREHOUSE, STOCKLOCAT);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        if (WAREHOUSE.equals(fieldKey)) {
            this.warehouseBeforeF7Select(e);
        } else if (STOCKLOCAT.equals(fieldKey)) {
            this.locationBeforeF7Select(e);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BTNOK.equalsIgnoreCase(key)) {
            this.btnOkClick();
        }
    }

    private void addF7Listener(String ... baseDataKeys) {
        IFormView view = this.getView();
        for (String baseDataKey : baseDataKeys) {
            BasedataEdit basedataEdit = (BasedataEdit)view.getControl(baseDataKey);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    private void warehouseBeforeF7Select(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        DynamicObject supplyOrg = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)SUPPLYORG);
        if (null == supplyOrg) {
            return;
        }
        Long[] warehouseids = WarehouseHelper.getAllFinishInitWarehouseIDs((Long)supplyOrg.getLong("id"));
        Set ids = Arrays.stream(warehouseids).filter(x -> null != x).collect(Collectors.toSet());
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        List qFilters = listShowParameter.getListFilterParameter().getQFilters();
        if (CollectionUtils.isNotEmpty(ids)) {
            qFilters.add(new QFilter("id", "in", ids));
        } else {
            qFilters.add(new QFilter("id", "=", (Object)0L));
        }
    }

    private void locationBeforeF7Select(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        DynamicObject warehouse = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)WAREHOUSE);
        if (null == warehouse) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u62c6\u5206\u540e\u4ed3\u5e93\u3002", (String)"DistribOrderSplitEdit_0", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        warehouse = BusinessDataServiceHelper.loadSingle((Object)warehouse.getPkValue(), (String)"bd_warehouse");
        DynamicObjectCollection col = warehouse.getDynamicObjectCollection("entryentity");
        Set locationSet = col.stream().filter(x -> null != x.getDynamicObject("location")).map(x -> x.getDynamicObject("location").getPkValue()).collect(Collectors.toSet());
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        QFilter qfilter = new QFilter("id", "in", locationSet);
        listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
    }

    private void btnOkClick() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        BigDecimal splitQty = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)model, (String)SPLITQTY);
        BigDecimal reqQty = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)model, (String)REQQTY);
        if (splitQty.compareTo(BigDecimal.ZERO) <= 0 || splitQty.compareTo(reqQty) >= 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u62c6\u5206\u6570\u91cf\u5fc5\u987b\u5927\u4e8e\u96f6\uff0c\u5c0f\u4e8e\u9700\u6c42\u6570\u91cf\u3002", (String)"DistribOrderSplitEdit_1", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject distrbPlanObj = this.getDistrbPlanObj();
        if (distrbPlanObj == null) {
            return;
        }
        DynamicObjectType dynamicObjectType = distrbPlanObj.getDynamicObjectType();
        DynamicObject distribPlanObjNew = new DynamicObject(dynamicObjectType);
        this.buildNewObjHeadInfo(distrbPlanObj, dynamicObjectType, distribPlanObjNew);
        this.buildNewObjEntryInfo(distrbPlanObj, distribPlanObjNew);
        DynamicObject[] distrbPlanObjArr = new DynamicObject[]{distrbPlanObj, distribPlanObjNew};
        SaveServiceHelper.save((DynamicObject[])distrbPlanObjArr);
        view.returnDataToParent((Object)Boolean.TRUE);
        view.close();
    }

    private DynamicObject getDistrbPlanObj() {
        Long distrbplanId = (Long)this.getView().getFormShowParameter().getCustomParam("distrbplanId");
        if (null == distrbplanId) {
            return null;
        }
        DynamicObject distrbPlanObj = BusinessDataServiceHelper.loadSingle((Object)distrbplanId, (String)"pom_distribplan");
        return distrbPlanObj;
    }

    private void buildNewObjHeadInfo(DynamicObject distrbPlanObj, DynamicObjectType dynamicObjectType, DynamicObject distribPlanObjNew) {
        IDataModel model = this.getModel();
        DataEntityPropertyCollection properties = dynamicObjectType.getProperties();
        HashSet<String> headExcludeProps = new HashSet<String>(16);
        headExcludeProps.add("id");
        headExcludeProps.add("entryentity");
        this.cloneDynamicObj(distrbPlanObj, distribPlanObjNew, properties, headExcludeProps);
        String billno = CodeRuleServiceHelper.getNumber((String)"pom_distribplan", (DynamicObject)distribPlanObjNew, (String)String.valueOf(RequestContext.get().getOrgId()));
        distribPlanObjNew.set("billno", (Object)billno);
        BigDecimal splitQty = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)model, (String)SPLITQTY);
        distribPlanObjNew.set(REQQTY, (Object)splitQty);
        distribPlanObjNew.set("creator", (Object)RequestContext.get().getUid());
        distribPlanObjNew.set("createtime", (Object)KDDateUtils.now());
        distribPlanObjNew.set(WAREHOUSE, (Object)DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)WAREHOUSE));
        distribPlanObjNew.set(STOCKLOCAT, (Object)DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)STOCKLOCAT));
        distrbPlanObj.set(REQQTY, (Object)distrbPlanObj.getBigDecimal(REQQTY).subtract(splitQty));
    }

    private void cloneDynamicObj(DynamicObject distrbPlanObj, DynamicObject distribPlanObjNew, DataEntityPropertyCollection properties, Set<String> excludeProps) {
        for (IDataEntityProperty property : properties) {
            String propName = property.getName();
            if (excludeProps.contains(propName)) continue;
            distribPlanObjNew.set(propName, distrbPlanObj.get(propName));
        }
    }

    private void buildNewObjEntryInfo(DynamicObject distrbPlanObj, DynamicObject distribPlanObjNew) {
        int lastIndex;
        IDataModel model = this.getModel();
        DynamicObjectCollection entryentity = distrbPlanObj.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection entryentityNew = distribPlanObjNew.getDynamicObjectCollection("entryentity");
        DataEntityPropertyCollection entryProps = entryentity.getDynamicObjectType().getProperties();
        BigDecimal splitQty = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)model, (String)SPLITQTY);
        int seq = 0;
        for (int i = lastIndex = entryentity.size() - 1; i >= 0 && splitQty.compareTo(BigDecimal.ZERO) > 0; --i) {
            DynamicObject entryRow = (DynamicObject)entryentity.get(i);
            DynamicObject newEntryRow = entryentityNew.addNew();
            HashSet<String> entryExcludeProps = new HashSet<String>(16);
            entryExcludeProps.add("id");
            entryExcludeProps.add("entryentity_lk");
            this.cloneDynamicObj(entryRow, newEntryRow, entryProps, entryExcludeProps);
            newEntryRow.set("seq", (Object)(++seq));
            BigDecimal rqty = entryRow.getBigDecimal("rqty");
            if (rqty.compareTo(splitQty) > 0) {
                entryRow.set("rqty", (Object)entryRow.getBigDecimal("rqty").subtract(splitQty));
                newEntryRow.set("rqty", (Object)splitQty);
            } else {
                entryentity.remove(i);
            }
            splitQty = splitQty.subtract(rqty);
        }
    }
}

