/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.formplugin.mftorder;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;

public class ProOrderBillShowViewPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private Map<String, String> childPageIds = new HashMap<String, String>(8);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView fv = this.getView();
        if (fv == null) {
            return;
        }
        FormShowParameter fsp = fv.getFormShowParameter();
        this.childPageIds.clear();
        Map findTargetBills = (Map)fsp.getCustomParam("paramList");
        this.showDataByName(findTargetBills, "im_mdc_mftproorder");
        this.showDataByName(findTargetBills, "im_mdc_mftfeedorder");
        this.showDataByName(findTargetBills, "im_mdc_mftreturnorder");
        this.putPageIds(this.childPageIds);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getView().getControl("tabbills");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    private void showBillList(String entityid, Set<Long> billIds) {
        ListShowParameter showParam = new ListShowParameter();
        showParam.setHasRight(true);
        showParam.setIsolationOrg(false);
        showParam.setBillFormId(entityid);
        showParam.getOpenStyle().setShowType(ShowType.NewTabPage);
        showParam.setShowFilter(false);
        showParam.setShowQuickFilter(false);
        showParam.setCustomParam("isshowtoolbarap", (Object)"yes");
        showParam.getOpenStyle().setTargetKey("tabbills");
        for (Long billId : billIds) {
            showParam.addLinkQueryPkId((Object)billId);
        }
        this.childPageIds.put(entityid, showParam.getPageId());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, entityid);
        showParam.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParam);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String entityNumber = closedCallBackEvent.getActionId();
        String pageId = this.getPageId(entityNumber);
        if (pageId != null && pageId.length() > 0) {
            this.closePage(entityNumber);
        }
    }

    private void showDataByName(Map<String, Object> findTargetBills, String name) {
        Set<Long> prolinkids = new HashSet();
        Object object = findTargetBills.get(name);
        if (object instanceof JSONArray) {
            String jsonStr = JSONObject.toJSONString((Object)object);
            List idlist = JSONObject.parseArray((String)jsonStr, Long.class);
            for (Long id : idlist) {
                prolinkids.add(id);
            }
        } else {
            prolinkids = (Set)findTargetBills.get(name);
        }
        if (prolinkids != null && !prolinkids.isEmpty()) {
            this.showBillList(name, prolinkids);
        }
    }

    private String getPageId(String entityNumber) {
        Map<String, String> pageIds = this.getPageIds();
        return pageIds.get(entityNumber);
    }

    private void closePage(String entityNumber) {
        Map<String, String> pageIds = this.getPageIds();
        if (pageIds.containsKey(entityNumber)) {
            pageIds.remove(entityNumber);
        }
        if (pageIds.isEmpty()) {
            this.getView().close();
        } else {
            this.putPageIds(pageIds);
        }
    }

    private void putPageIds(Map<String, String> childPageIds) {
        this.getPageCache().put("pageids", SerializationUtils.toJsonString(childPageIds));
    }

    private Map<String, String> getPageIds() {
        String cacheValue = this.getPageCache().get("pageids");
        return StringUtils.isBlank((CharSequence)cacheValue) ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)cacheValue, Map.class);
    }

    public void tabSelected(TabSelectEvent var1) {
    }
}

