/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.formplugin.mftorder;

import java.util.EventObject;
import kd.bd.mpdm.formplugin.stockchange.StockChangeTplEdit;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class XManufacturestockEdit
extends StockChangeTplEdit
implements RowClickEventListener {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefaultTrans();
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (StringUtils.equals((CharSequence)"stockentry", (CharSequence)entryGrid.getKey())) {
            DynamicObject entryentity = this.getModel().getEntryRowEntity("stockentry", this.getSelectEntryRowIndex());
            if (entryentity == null) {
                return;
            }
            DynamicObject material = entryentity.getDynamicObject("materialid");
            if (material == null) {
                return;
            }
            Boolean enable = Boolean.FALSE;
            enable = this.isUseAuxpty(material);
            this.getView().setEnable(enable, new String[]{"auxpropertyfield"});
        }
    }

    private Boolean isUseAuxpty(DynamicObject material) {
        Object pkValue = material.getDynamicObject("masterid").getPkValue();
        DynamicObject masterid = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_material", (QFilter[])new QFilter[]{new QFilter("id", "=", pkValue)});
        if (masterid.getBoolean("isuseauxpty")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void setDefaultTrans() {
        DynamicObject dept = (DynamicObject)this.getModel().getValue("org");
        if (dept == null) {
            return;
        }
        QFilter qFilter = new QFilter("isfault", "=", (Object)"1");
        QFilter planFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_transactproduct", (Long)Long.parseLong(dept.getPkValue().toString()));
        qFilter.and(planFilter);
        qFilter.and(new QFilter("pomorom", "=", (Object)"P"));
        qFilter.and(new QFilter("transactiontype", "=", (Object)Long.valueOf("738166303168232448")));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("isstockchange", "=", (Object)"1"));
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"mpdm_transactproduct", (String)"number,name", (QFilter[])new QFilter[]{qFilter});
        if (load != null && load.length == 1) {
            this.getModel().setItemValueByNumber("transactiontypeid", load[0].getString("number"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }
}

