/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.formplugin.mftorder;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.common.mftorder.enums.ManuBillBizStatusEnum;
import kd.bd.mpdm.common.mftorder.enums.ManuBillPlanStatusEnum;
import kd.bd.mpdm.common.mftorder.enums.ManuBillProductTypeEnum;
import kd.bd.mpdm.common.mftorder.utils.MetaDataHelper;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.pom.common.mftorder.consts.ManuBillConsts;
import kd.mmc.pom.common.mftorder.enums.ChangeTypeEnum;
import kd.mmc.pom.common.mftorder.utils.OrderUtils;

public class XMftOrderEdit
extends AbstractBillPlugIn
implements ClickListener,
RowClickEventListener,
HyperLinkClickListener {
    private static final String XMFTORDERX = "xmftorderX";
    private static final String FALSE = "false";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{"srcbillid"});
        this.addClickListeners(new String[]{"srcbillno"});
    }

    public void beforeBindData(EventObject e) {
        OrderUtils.updatePID((DynamicObject)this.getModel().getDataEntity());
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        FormOperate op = (FormOperate)e.getSource();
        if (StringUtils.equals((CharSequence)"draw", (CharSequence)op.getOperateKey())) {
            Object org = this.getModel().getValue("org");
            Object tran = this.getModel().getValue("transactiontype");
            StringBuilder err = new StringBuilder();
            if (org == null) {
                err.append(ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u4e3a\u7a7a\uff0c", (String)"XMftOrderEdit_0", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            }
            if (tran == null) {
                err.append(ResManager.loadKDString((String)"\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b\u4e3a\u7a7a\uff0c", (String)"XMftOrderEdit_1", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            }
            if (err.length() > 0) {
                err.append(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u9009\u5355\u3002", (String)"XMftOrderEdit_2", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
                this.getView().showTipNotification(err.toString());
                e.setCancel(true);
            }
        } else if (StringUtils.equals((CharSequence)"newentry", (CharSequence)op.getOperateKey())) {
            Object org = this.getModel().getValue("org");
            Object tran = this.getModel().getValue("transactiontype");
            StringBuilder err = new StringBuilder();
            if (org == null) {
                err.append(ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u4e3a\u7a7a\uff0c", (String)"XMftOrderEdit_0", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            }
            if (tran == null) {
                err.append(ResManager.loadKDString((String)"\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b\u4e3a\u7a7a\uff0c", (String)"XMftOrderEdit_1", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            }
            if (err.length() > 0) {
                err.append(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u589e\u884c\u3002", (String)"XMftOrderEdit_3", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
                this.getView().showTipNotification(err.toString());
                e.setCancel(true);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("true".equals(this.getPageCache().get(XMFTORDERX))) {
            return;
        }
        this.getPageCache().put(XMFTORDERX, "true");
        int currentIndex = this.getSelectEntryRowIndex();
        if ("transactiontype".equals(key)) {
            DynamicObject newObj = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject oldObj = (DynamicObject)e.getChangeSet()[0].getOldValue();
            String oldtran = "";
            if (newObj == null) {
                this.getPageCache().put(XMFTORDERX, "true");
                this.getModel().setValue("transactiontype", (Object)oldObj);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b\u4e0d\u5141\u8bb8\u6e05\u7a7a\u3002", (String)"XMftOrderEdit_4", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
                this.getPageCache().put(XMFTORDERX, FALSE);
                return;
            }
            String newtran = newObj.getPkValue().toString();
            if (oldObj != null) {
                oldtran = oldObj.getPkValue().toString();
            }
            this.getPageCache().put("newXOrderObj", newtran);
            this.getPageCache().put("oldXOrderObj", oldtran);
            if (oldObj != null && !newtran.equals(this.getPageCache().get("oldXOrderObj"))) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("tranChange", (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5355\u636e\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"XMftOrderEdit_5", (String)"mmc-pom-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
            }
        } else if ("srcbillno".equals(key)) {
            String orderno = (String)this.getModel().getValue("srcbillno", currentIndex);
            if (!StringUtils.isBlank((CharSequence)orderno)) {
                QFilter filter = new QFilter("billno", "=", (Object)orderno);
                List<QFilter> filters = this.getOrderFilter();
                filters.add(filter);
                QFilter[] filterArray = new QFilter[filters.size()];
                DynamicObject order = BusinessDataServiceHelper.loadSingle((String)"pom_mftorder", (String)"", (QFilter[])filters.toArray(filterArray));
                if (order == null) {
                    this.setOrderInfo(null, currentIndex);
                } else {
                    DynamicObject stockdym = BusinessDataServiceHelper.loadSingle((Object)order.getPkValue(), (String)"pom_mftorder");
                    this.setOrderInfo(stockdym, currentIndex);
                }
            } else {
                this.setOrderInfo(null, currentIndex);
            }
        }
        this.getPageCache().put(XMFTORDERX, FALSE);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"tranChange", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                int entryNum = this.getModel().getEntryRowCount("treeentryentity");
                for (int i = entryNum - 1; i >= 0; --i) {
                    this.getModel().deleteEntryRow("treeentryentity", i);
                }
                this.showEntryDetial();
                this.getModel().setValue("transactiontype", (Object)this.getPageCache().get("newXOrderObj"));
            } else {
                this.getPageCache().put(XMFTORDERX, "true");
                this.getModel().setValue("transactiontype", (Object)this.getPageCache().get("oldXOrderObj"));
                this.getPageCache().put(XMFTORDERX, FALSE);
            }
        }
    }

    private void showEntryDetial() {
        this.getModel().setValue("entrymaterial", null);
        this.getModel().setValue("entrybatchno", null);
        this.getModel().setValue("entryauxproperty", null);
        this.getModel().setValue("entryyieldrate", null);
        this.getModel().setValue("entryestscrapqty", null);
        this.getModel().setValue("entryinwardept", null);
        this.getModel().setValue("entrywarehouse", null);
        this.getModel().setValue("entrylocation", null);
        this.getModel().setValue("entryiscontrolqty", null);
        this.getModel().setValue("entryinwarmax", null);
        this.getModel().setValue("entryinwarmin", null);
        this.getModel().setValue("entryrcvinhighlimit", null);
        this.getModel().setValue("entryrcvinlowlimit", null);
        this.getModel().setValue("entryoutputoperation", null);
        this.getModel().setValue("entryrptqty", null);
        this.getModel().setValue("entryreportqty", null);
        this.getModel().setValue("entryworkwasteqty", null);
        this.getModel().setValue("entrymtlcostqty", null);
        this.getModel().setValue("entryqualifiedqty", null);
        this.getModel().setValue("entryunqualifiedqty", null);
        this.getModel().setValue("entryscrapqty", null);
        this.getModel().setValue("entryrepairqty", null);
        this.getModel().setValue("entryreworkqty", null);
        this.getModel().setValue("entrypickingpairs", null);
        this.getModel().setValue("entrystockqty", null);
        this.getModel().setValue("entryquainwaqty", null);
        this.getModel().setValue("entryunquainwaqty", null);
        this.getModel().setValue("entryscrinwaqty", null);
        this.getModel().setValue("entryrepinwaqty", null);
        this.getModel().setValue("entryplansuretime", null);
        this.getModel().setValue("entrytransmittime", null);
        this.getModel().setValue("entrystartworktime", null);
        this.getModel().setValue("entryendworktime", null);
        this.getModel().setValue("entryclosetime", null);
        this.getModel().setValue("entrycompletime", null);
        this.getModel().setValue("entrysourcebilltype", null);
        this.getModel().setValue("entrysourcebillnumber", null);
        this.getModel().setValue("entrysourceentryseq", null);
        this.getModel().setValue("entryunit", null);
        this.getModel().setValue("entryseq", (Object)-1);
        this.getModel().setValue("entrybaseunit", null);
        this.getModel().setValue("entrybaseqty", null);
        this.getModel().setValue("entryauxptyunit", null);
        this.getModel().setValue("entryauxptyqty", null);
        this.lockSomeControls();
    }

    private void lockSomeControls() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"entrybatchno"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"entryauxproperty"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"entryinwardept"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"entrywarehouse"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"entrylocation"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"entryiscontrolqty"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"entryinwarmax"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"entryinwarmin"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"entryoutputoperation"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().clearNoDataRow();
        this.getModel().forceClearNoDataRow();
        int billEntryCount = this.getModel().getEntryRowCount("treeentryentity");
        if (billEntryCount == 0) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"billtype"});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"billtype"});
        }
        this.setEntryEnable();
        this.getView().setEnable(Boolean.FALSE, new String[]{"entrustdept", "remark"});
    }

    private void setEntryEnable() {
        IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
        int billEntryCount = this.getModel().getEntryRowCount("treeentryentity");
        String[] billEntry1 = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"treeentryentity");
        String[] billEntry3 = this.getDifferentFromString(billEntry1, ManuBillConsts.getEntryFields((String)"a"));
        for (int i = 0; i < billEntryCount; ++i) {
            if ("B".equals(this.getModel().getValue("changetype", i))) {
                this.getView().setEnable(Boolean.FALSE, i, billEntry3);
                String taskStatus = (String)this.getModel().getValue("taskstatus", i);
                if (!"B".equals(taskStatus)) continue;
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"planbegintime"});
                continue;
            }
            if (!"C".equals(this.getModel().getValue("changetype", i))) continue;
            this.getView().setEnable(Boolean.FALSE, i, billEntry1);
        }
    }

    private String[] getDifferentFromString(String[] s1, String[] s2) {
        HashSet<String> hs1 = new HashSet<String>(Arrays.asList(s1));
        HashSet<String> hs2 = new HashSet<String>(Arrays.asList(s2));
        hs1.removeAll(hs2);
        return hs1.toArray(new String[0]);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        RowDataEntity[] rows = e.getRowDataEntities();
        if ("treeentryentity".equals(entryName)) {
            for (RowDataEntity row : rows) {
                int rowIndex = row.getRowIndex();
                this.getModel().setValue("changetype", (Object)"A", rowIndex);
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        int row = evt.getRow();
        if ("treeentryentity".equals(entryGrid.getKey())) {
            String changeType = (String)this.getModel().getValue("changetype", row);
            if (ChangeTypeEnum.MODIFY.getValue().equals(changeType) || ChangeTypeEnum.CANCEL.getValue().equals(changeType)) {
                this.getView().setEnable(Boolean.FALSE, ManuBillConsts.getOtherFields());
                this.unlockLoacation(row);
            }
        }
    }

    public void click(EventObject evt) {
        Control sourceField = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)sourceField.getKey(), (CharSequence)"srcbillno")) {
            this.showBillList(sourceField.getKey());
        }
    }

    private void showBillList(String sourcekey) {
        String entityNumber = null;
        if (StringUtils.equalsIgnoreCase((CharSequence)sourcekey, (CharSequence)"srcbillno")) {
            entityNumber = "pom_mftorder";
        }
        if (!StringUtils.isEmpty((CharSequence)entityNumber)) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("billstatus", "=", (Object)"C"));
            qFilters.add(new QFilter("treeentryentity.planstatus", "in", (Object)new Object[]{ManuBillPlanStatusEnum.TRANSMIT.getValue(), ManuBillPlanStatusEnum.PLANSURE.getValue()}));
            qFilters.add(new QFilter("treeentryentity.bizstatus", "=", (Object)ManuBillBizStatusEnum.NORMAL.getValue()));
            qFilters.add(new QFilter("isinitbill", "=", (Object)false));
            DynamicObject tran = (DynamicObject)this.getModel().getValue("transactiontype");
            QFilter transFilter = tran != null ? new QFilter("transactiontype", "=", tran.getPkValue()) : new QFilter("transactiontype", "=", (Object)0L);
            qFilters.add(transFilter);
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            QFilter orgFilter = org != null ? new QFilter("org", "=", org.getPkValue()) : new QFilter("org", "=", (Object)0L);
            qFilters.add(orgFilter);
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)entityNumber, (boolean)false);
            showParameter.getListFilterParameter().setQFilters(qFilters);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, sourcekey);
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionKey = e.getActionId();
        int currentRowIndex = this.getSelectEntryRowIndex();
        if (e.getReturnData() != null) {
            DynamicObject mftorder;
            ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
            Object pk = rows.get(0).getPrimaryKeyValue();
            if (StringUtils.equalsIgnoreCase((CharSequence)"srcbillno", (CharSequence)actionKey) && (mftorder = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"pom_mftorder")) != null) {
                this.getPageCache().put(XMFTORDERX, "true");
                this.getModel().setValue("srcbillid", (Object)rows.get(0).getPrimaryKeyValue().toString(), currentRowIndex);
                this.getModel().setValue("srcbillno", (Object)rows.get(0).getBillNo(), currentRowIndex);
                this.getPageCache().put(XMFTORDERX, FALSE);
            }
        }
    }

    public int getSelectEntryRowIndex() {
        int currentEntryIndex = -1;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            currentEntryIndex = selectRows[0];
        }
        return currentEntryIndex;
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        int rowIndex;
        String operationKey = evt.getOperateKey();
        if ("save".equals(operationKey)) {
            this.setEntryEnable();
        }
        if ((rowIndex = this.getSelectEntryRowIndex()) == -1) {
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)"cancelentry")) {
            this.getModel().setValue("changetype", (Object)"C", rowIndex);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)"insertentry")) {
            String producttype = (String)this.getModel().getValue("producttype", rowIndex);
            if (!ManuBillProductTypeEnum.MAIN.getValue().equals(producttype)) {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"srcbillno"});
            }
        }
    }

    private List<QFilter> getOrderFilter() {
        QFilter planFilter = new QFilter("treeentryentity.planstatus", "in", (Object)new String[]{ManuBillPlanStatusEnum.TRANSMIT.getValue(), ManuBillPlanStatusEnum.PLANSURE.getValue()});
        QFilter bizFilter = new QFilter("treeentryentity.bizstatus", "=", (Object)ManuBillBizStatusEnum.NORMAL.getValue());
        QFilter auditFilter = new QFilter("billstatus", "=", (Object)"C");
        DynamicObject tran = (DynamicObject)this.getModel().getValue("transactiontype");
        QFilter transFilter = tran != null ? new QFilter("transactiontype.id", "=", tran.getPkValue()) : new QFilter("transactiontype.id", "=", (Object)0L);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        QFilter orgFilter = org != null ? new QFilter("org.id", "=", org.getPkValue()) : new QFilter("org.id", "=", (Object)0L);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(planFilter);
        filters.add(bizFilter);
        filters.add(auditFilter);
        filters.add(transFilter);
        filters.add(orgFilter);
        return filters;
    }

    private void setOrderInfo(DynamicObject order, int currentRowIndex) {
        if (order == null) {
            this.getModel().setValue("srcbillid", null, currentRowIndex);
            this.getModel().setValue("srcbillno", null, currentRowIndex);
        } else {
            this.getModel().setValue("srcbillid", (Object)order.getPkValue().toString(), currentRowIndex);
            this.getModel().setValue("srcbillno", order.get("billno"), currentRowIndex);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        Object stockid;
        if (StringUtils.equals((CharSequence)"srcbillno", (CharSequence)arg0.getFieldName()) && (stockid = this.getModel().getValue("srcbillid", arg0.getRowIndex())) != null) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("pom_mftorder");
            showParameter.setPkId(stockid);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void unlockLoacation(int rowindex) {
        DynamicObject warehouse = (DynamicObject)this.getModel().getValue("warehouse");
        if (warehouse == null) {
            return;
        }
        boolean isopenlocation = (warehouse = BusinessDataServiceHelper.loadSingleFromCache((Object)warehouse.getPkValue(), (String)"bd_warehouse")).getBoolean("isopenlocation");
        if (isopenlocation) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"entrylocation"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"entrylocation"});
        }
    }

    public void initImportData(InitImportDataEventArgs e) {
        List sourceDataList = e.getSourceDataList();
        if (null != sourceDataList && sourceDataList.size() > 0) {
            for (Map sourceData : sourceDataList) {
                JSONArray arrEntrys;
                Object sourceDataObj = sourceData.get("treeentryentity");
                if (sourceDataObj instanceof List || (arrEntrys = (JSONArray)sourceDataObj) == null) continue;
                for (int i = 0; i < arrEntrys.size(); ++i) {
                    JSONObject entryObj = arrEntrys.getJSONObject(i);
                    if (entryObj == null) continue;
                    this.autoFilldataFromImport(entryObj, sourceData);
                }
            }
        }
    }

    private void autoFilldataFromImport(JSONObject entryObj, Map<String, Object> sourceData) {
        this.autoFillPlanPrepareTime(entryObj);
    }

    private void autoFillPlanPrepareTime(JSONObject entryObj) {
        Object planpreparetimeobj = entryObj.get((Object)"planpreparetime");
        Object planbegintime = entryObj.get((Object)"planbegintime");
        if (planpreparetimeobj == null && planbegintime != null) {
            entryObj.put("planpreparetime", planbegintime);
        }
    }
}

