/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.formplugin.mrocard;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.pom.common.mro.utils.MROToolUtils;

public class MROSWSBatchEdit
extends AbstractBillPlugIn {
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("batchdraw".equals(e.getOperateKey()) && e.getOperationResult().isSuccess()) {
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            filters.add(this.getOrderQFilter());
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"pom_mroorder", (boolean)false);
            showParameter.getListFilterParameter().setQFilters(filters);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "mroorder");
            showParameter.setCloseCallBack(closeCallBack);
            showParameter.setMultiSelect(true);
            showParameter.setSelectedRows(this.getSelectedPk("pom_mroorder"));
            this.getView().showForm((FormShowParameter)showParameter);
        } else if ("generate".equals(e.getOperateKey()) && e.getOperationResult().isSuccess()) {
            this.getModel().setValue("ordernos", (Object)"");
            this.getModel().setValue("orderids", (Object)"");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("project".equals(e.getProperty().getName())) {
            this.getModel().setValue("ordernos", (Object)"");
            this.getModel().setValue("orderids", (Object)"");
        }
    }

    private QFilter getOrderQFilter() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        QFilter q = new QFilter("org", "=", org.getPkValue());
        q.and(new QFilter("treeentryentity.project", "=", project.getPkValue()));
        q.and(new QFilter("swsnum", "=", (Object)0));
        q.and(new QFilter("issuborder", "=", (Object)false));
        q.and(new QFilter("billstatus", "=", (Object)"C"));
        q.and(new QFilter("treeentryentity.taskstatus", "in", (Object)new String[]{"A", "B", "D"}));
        q.and(new QFilter("treeentryentity.bizstatus", "in", (Object)new String[]{"A", "B"}));
        return q;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionKey = e.getActionId();
        if (e.getReturnData() != null && "mroorder".equals(actionKey)) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
            String billno = this.getRows(rows, "billnos");
            String billids = this.getRows(rows, "id");
            this.getModel().setValue("ordernos", (Object)billno);
            this.getModel().setValue("orderids", (Object)billids);
        }
    }

    private String getRows(ListSelectedRowCollection rows, String name) {
        HashSet<String> billnos = new HashSet<String>(rows.size());
        for (ListSelectedRow row : rows) {
            if ("billnos".equals(name)) {
                billnos.add(row.getBillNo());
                continue;
            }
            billnos.add(row.getPrimaryKeyValue().toString());
        }
        StringBuilder sb = new StringBuilder();
        for (String billno : billnos) {
            sb.append(billno);
            sb.append(";");
        }
        return sb.substring(0, sb.length() - 1);
    }

    private Object[] getSelectedPk(String entityNumber) {
        List billnos = MROToolUtils.getBillnoList((String)((String)this.getModel().getValue("ordernos")));
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("billno", "in", (Object)billnos));
        DynamicObject[] load = BusinessDataServiceHelper.load((String)entityNumber, (String)"id", (QFilter[])filters.toArray(new QFilter[filters.size()]));
        Object[] pks = new Object[load.length];
        for (int i = 0; i < load.length; ++i) {
            pks[i] = load[i].getPkValue();
        }
        return pks;
    }
}

