/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.formplugin.mroorder;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SubEntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mmc.pom.business.mrolockcontrol.MroLockControlBusiness;

public class MROLockControlEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit professionEdit;
        BasedataEdit projectEdit;
        super.registerListener(e);
        BasedataEdit lockInfoEdit = (BasedataEdit)this.getControl("lock");
        if (lockInfoEdit != null) {
            lockInfoEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((projectEdit = (BasedataEdit)this.getControl("project")) != null) {
            projectEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((professionEdit = (BasedataEdit)this.getControl("professional")) != null) {
            professionEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    private String getOrgFiledName() {
        return "org";
    }

    private DynamicObject getAndValidOrg() {
        DynamicObject org = (DynamicObject)this.getModel().getValue(this.getOrgFiledName());
        if (org == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u751f\u4ea7\u7ec4\u7ec7!", (String)"MROLockControlEditPlugin_0", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
        }
        return org;
    }

    private Set<String> getProjectBusinessStatus() {
        return MroLockControlBusiness.getProjectBusinessStatus();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        QFilter filter;
        DynamicObject createOrg;
        ListShowParameter listShowPrams;
        IDataModel model = this.getModel();
        FormShowParameter showParams = e.getFormShowParameter();
        ListShowParameter listShowParameter = listShowPrams = showParams instanceof ListShowParameter ? (ListShowParameter)showParams : null;
        if (listShowPrams == null) {
            return;
        }
        ListFilterParameter listParams = listShowPrams.getListFilterParameter();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
        String fieldName = e.getProperty().getName();
        if ("lock".equals(fieldName)) {
            createOrg = this.getAndValidOrg();
            if (createOrg == null) {
                e.setCancel(true);
                return;
            }
            filter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_lockinfo", (Long)createOrg.getLong("id"));
            qFilterList.add(filter);
        }
        if ("project".equals(fieldName)) {
            createOrg = this.getAndValidOrg();
            if (createOrg == null) {
                e.setCancel(true);
                return;
            }
            filter = new QFilter("prjstate.number", "in", this.getProjectBusinessStatus());
            qFilterList.add(filter);
        }
        if (!qFilterList.isEmpty()) {
            for (int i = 0; i < qFilterList.size(); ++i) {
                listParams.getQFilters().add(qFilterList.get(i));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeDatas;
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        for (ChangeData changeData : changeDatas = e.getChangeSet()) {
            Object oldObject = changeData.getOldValue();
            Object newObject = changeData.getNewValue();
            if (oldObject != null && newObject != null && oldObject.equals(newObject)) continue;
            this.propertyChanged(proName, changeData);
        }
    }

    protected void propertyChanged(String propertyName, Object propertyValue) {
        ChangeData changeData;
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        ChangeData changeData2 = changeData = propertyValue instanceof ChangeData ? (ChangeData)propertyValue : null;
        if (changeData == null) {
            return;
        }
        if ("lock".equals(propertyName)) {
            DynamicObject lockInfo = (DynamicObject)changeData.getNewValue();
            this.lockInfoPropertyChange(model, lockInfo);
        }
    }

    private void lockInfoPropertyChange(IDataModel model, DynamicObject lockInfo) {
        if (lockInfo == null) {
            model.setValue("entcreater", null);
        } else {
            model.setValue("entcreater", (Object)lockInfo.getDynamicObject("creator"));
        }
    }

    private boolean isSubmitStatus() {
        return "B".equals(this.getModel().getValue("billstatus")) || "C".equals(this.getModel().getValue("billstatus"));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        boolean isSamePerson = true;
        String keyop = ((AbstractOperate)e.getSource()).getOperateKey();
        if ("installtag".equals(keyop) || "removetag".equals(keyop) || "addtags".equals(keyop) || "deletetags".equals(keyop) || "deleteentrydel".equals(keyop)) {
            if (!this.isSubmitStatus() && !"deleteentrydel".equals(keyop)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u672a\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u672c\u6b21\u64cd\u4f5c!", (String)"MROLockControlEditPlugin_14", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884cLOCK\u4fe1\u606f\u6570\u636e\uff01", (String)"MROLockControlEditPlugin_9", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            if (("addtags".equals(keyop) || "removetag".equals(keyop)) && selectRows.length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884cLOCK\u4fe1\u606f\u6570\u636e\uff01", (String)"MROLockControlEditPlugin_9", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            SubEntryGrid subEntryGrid = (SubEntryGrid)this.getControl("subentryentity");
            int[] subEntryGridSelectRows = subEntryGrid.getSelectRows();
            if ("deletetags".equals(keyop) && subEntryGridSelectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6807\u8bc6\u4fe1\u606f\u6570\u636e\uff01", (String)"MROLockControlEditPlugin_10", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            for (int i = 0; i < selectRows.length; ++i) {
                int selectRow = selectRows[i];
                String entbizstatus = (String)this.getModel().getValue("entbizstatus", selectRow);
                if ("removetag".equals(keyop) || "addtags".equals(keyop) || "deletetags".equals(keyop)) {
                    if (StringUtils.equals((CharSequence)"B", (CharSequence)entbizstatus)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"LOCK\u4fe1\u606f\u5206\u5f55\u7684\u4e1a\u52a1\u72b6\u6001\u4e3a\u79fb\u9664\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u672c\u6b21\u64cd\u4f5c!", (String)"MROLockControlEditPlugin_11", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    if ("removetag".equals(keyop) && StringUtils.equals((CharSequence)"A", (CharSequence)entbizstatus)) {
                        String tagcdesc = (String)this.getModel().getValue("tagcdesc", selectRow);
                        int installtag = 0;
                        if (StringUtils.isNotBlank((CharSequence)tagcdesc)) {
                            installtag = Integer.parseInt(tagcdesc.substring(0, 1));
                        }
                        if (installtag > 0) {
                            this.getView().showErrorNotification(ResManager.loadKDString((String)"LOCK\u4fe1\u606f\u5206\u5f55\u7684\u672a\u79fb\u9664\u6807\u8bc6\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u672c\u6b21\u64cd\u4f5c!", (String)"MROLockControlEditPlugin_12", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
                            e.setCancel(true);
                            return;
                        }
                        this.getModel().setValue("entbizstatus", (Object)"B", selectRow);
                    }
                } else {
                    if (StringUtils.equals((CharSequence)"A", (CharSequence)entbizstatus)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"LOCK\u4fe1\u606f\u5206\u5f55\u7684\u4e1a\u52a1\u72b6\u6001\u4e3a\u5b89\u88c5\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u672c\u6b21\u64cd\u4f5c!", (String)"MROLockControlEditPlugin_13", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    if ("installtag".equals(keyop) && StringUtils.equals((CharSequence)"B", (CharSequence)entbizstatus)) {
                        this.getModel().setValue("entbizstatus", (Object)"A", selectRow);
                    }
                }
                if (!"deletetags".equals(keyop) && !"deleteentrydel".equals(keyop)) continue;
                for (int j = 0; j < subEntryGridSelectRows.length; ++j) {
                    int subSelectRow = subEntryGridSelectRows[j];
                    DynamicObject currentUser = this.getCurrentUser();
                    DynamicObject person = (DynamicObject)this.getModel().getValue("person", subSelectRow, selectRow);
                    if (null != person) {
                        long pkValue = (Long)person.getPkValue();
                        long id = currentUser.getLong("id");
                        if (id != pkValue) {
                            isSamePerson = false;
                        }
                    }
                    this.getModel().setValue("isremove", (Object)true, subSelectRow, selectRow);
                    this.getModel().setValue("removeperson", (Object)this.getCurrentUser(), subSelectRow, selectRow);
                    this.getModel().setValue("entryremovedate", (Object)new Date(), subSelectRow, selectRow);
                }
            }
        }
        if ("deletetags".equals(keyop)) {
            FormOperate source = (FormOperate)e.getSource();
            RefObject afterConfirm = new RefObject();
            if (!source.getOption().tryGetVariableValue("afterconfirm", afterConfirm) && !isSamePerson) {
                String msgStr = ResManager.loadKDString((String)"\u60a8\u786e\u5b9a\u8981\u79fb\u9664\u4ed6\u4eba\u65b0\u589e\u7684\u6807\u8bc6\u4fe1\u606f\u5417?", (String)"MROLockControlEditPlugin_6", (String)"mmc-pom-formplugin", (Object[])new Object[0]);
                ConfirmCallBackListener listener = new ConfirmCallBackListener("removeOtherPersonTags", (IFormPlugin)this);
                this.getView().showConfirm(msgStr, MessageBoxOptions.YesNo, listener);
                e.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("removeOtherPersonTags".equals(callBackId)) {
            MessageBoxResult result = messageBoxClosedEvent.getResult();
            if (MessageBoxResult.No.equals((Object)result)) {
                return;
            }
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("afterconfirm", "true");
            this.getView().invokeOperation("deletetags", operateOption);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String opKey = e.getOperateKey();
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        if ("save".equals(opKey)) {
            this.getView().updateView();
        }
        if ("deletetags".equals(opKey)) {
            this.getView().updateView();
        }
        if ("installtag".equals(opKey)) {
            this.getView().invokeOperation("addtags");
        }
    }

    public DynamicObject getCurrentUser() {
        long userId = RequestContext.get().getCurrUserId();
        return BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user", (String)"id,number,name");
    }
}

