/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.formplugin.mroorder;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class MROOrderScanEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String PRODUCT_ORG = "productorg";
    private static final String PROJECT = "project";
    private static final String UPDATE_STATUS = "updatestatus";
    private static final String ORDER_NUMBER = "orderno";
    private static final String ORDER = "cardorder";
    private static final String ENTRY_ENTITY = "cardentryentity";
    private static final String BUTTON_OK = "btnok";
    private static final String TRANSMIT = "A";
    private static final String BEGIN_WORK = "B";
    private static final String CANCEL = "C";
    private static final String ERROR = "D";
    private static final String KEEP = "E";
    private static final String HOLD = "F";
    private static final String END_WORK = "G";
    private static final String SWS_ORDER_NO = "swsorderno";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit project = (BasedataEdit)this.getControl(PROJECT);
        project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Button button = (Button)this.getControl(BUTTON_OK);
        button.addClickListener((ClickListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long orgId = RequestContext.get().getOrgId();
        this.getModel().setItemValueByID(PRODUCT_ORG, (Object)orgId);
        this.setFocus();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (ORDER_NUMBER.equals(propertyName) || SWS_ORDER_NO.equals(propertyName)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            String orderNum = "";
            if (null != newValue) {
                orderNum = ((String)newValue).trim();
            }
            if (orderNum.length() > 0) {
                DynamicObject project = (DynamicObject)this.getModel().getValue(PROJECT);
                DynamicObject mroOrder = BusinessDataServiceHelper.loadSingle((String)"pom_mroorder", (String)"treeentryentity.project", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)orderNum)});
                String elseErrorMg = ResManager.loadKDString((String)"\u5f53\u524d\u626b\u63cf\u4e0d\u5c5e\u4e8e\u68c0\u4fee\u5de5\u5355\uff0c\u8bf7\u626b\u63cf\u6b63\u786e\u7684\u68c0\u4fee\u5de5\u5355", (String)"MROOrderScanEdit_12", (String)"mmc-pom-formplugin", (Object[])new Object[0]);
                if (SWS_ORDER_NO.equals(propertyName)) {
                    elseErrorMg = ResManager.loadKDString((String)"\u5f53\u524d\u626b\u63cf\u4e0d\u5c5e\u4e8e\u8865\u5145\u68c0\u4fee\u5de5\u5355\uff0c\u8bf7\u626b\u63cf\u6b63\u786e\u7684\u8865\u5145\u68c0\u4fee\u5de5\u5355\u3002", (String)"MROOrderScanEdit_13", (String)"mmc-pom-formplugin", (Object[])new Object[0]);
                    QFilter swsOrderQfilter = new QFilter("billstatus", "=", (Object)CANCEL);
                    swsOrderQfilter.and(new QFilter("billentry.orderno", "=", (Object)orderNum));
                    boolean isExistsSws = QueryServiceHelper.exists((String)"pom_mrosws", (QFilter[])swsOrderQfilter.toArray());
                    if (!isExistsSws) {
                        this.getView().showTipNotification(elseErrorMg);
                        return;
                    }
                }
                if (mroOrder != null) {
                    DynamicObject orderProject = ((DynamicObject)mroOrder.getDynamicObjectCollection("treeentryentity").get(0)).getDynamicObject(PROJECT);
                    if (project == null) {
                        this.getModel().setValue(PROJECT, (Object)orderProject);
                    } else if (orderProject == null || !project.getPkValue().equals(orderProject.getPkValue())) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u5de5\u5355\u4e0d\u5c5e\u4e8e\u5f53\u524d\u6240\u9009\u9879\u76ee", (String)"MROOrderScanEdit_11", (String)"mmc-pom-formplugin", (Object[])new Object[0]), orderNum));
                        return;
                    }
                } else {
                    this.getView().showTipNotification(elseErrorMg);
                    return;
                }
                DynamicObjectCollection entry = this.getModel().getEntryEntity(ENTRY_ENTITY);
                for (DynamicObject row : entry) {
                    if (!row.getString(ORDER).equals(orderNum)) continue;
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u5de5\u5355\u5df2\u5b58\u5728", (String)"MROOrderScanEdit_14", (String)"mmc-pom-formplugin", (Object[])new Object[0]), orderNum));
                    return;
                }
                int index = this.getModel().createNewEntryRow(ENTRY_ENTITY);
                this.getModel().setValue(ORDER, (Object)orderNum, index);
            }
        } else if ("scantype".equals(propertyName)) {
            this.getModel().setValue(ORDER_NUMBER, (Object)"");
            this.getModel().setValue(SWS_ORDER_NO, (Object)"");
            this.getModel().deleteEntryData(ENTRY_ENTITY);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String scantype = (String)this.getModel().getValue("scantype");
        if (evt.getSource().equals(this.getControl(BUTTON_OK))) {
            DynamicObject organization = (DynamicObject)this.getModel().getValue(PRODUCT_ORG);
            if (organization == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u751f\u4ea7\u7ec4\u7ec7", (String)"MROOrderScanEdit_1", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject project = (DynamicObject)this.getModel().getValue(PROJECT);
            if (project == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u9879\u76ee\u53f7", (String)"MROOrderScanEdit_2", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection entry = (DynamicObjectCollection)this.getModel().getValue(ENTRY_ENTITY);
            if (entry.size() == 0) {
                String errorMg = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u68c0\u4fee\u5de5\u5355", (String)"MROOrderScanEdit_3", (String)"mmc-pom-formplugin", (Object[])new Object[0]);
                if (StringUtils.equals((CharSequence)scantype, (CharSequence)BEGIN_WORK)) {
                    errorMg = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8865\u5145\u68c0\u4fee\u5de5\u5355\u3002", (String)"MROOrderScanEdit_15", (String)"mmc-pom-formplugin", (Object[])new Object[0]);
                }
                this.getView().showTipNotification(errorMg);
                return;
            }
            LinkedHashSet<String> orders = new LinkedHashSet<String>();
            for (DynamicObject order : entry) {
                orders.add(order.getString(ORDER));
            }
            int orderCount = orders.size();
            if (StringUtils.equals((CharSequence)scantype, (CharSequence)TRANSMIT)) {
                QFilter qFilter = new QFilter("billno", "in", orders).and(new QFilter("treeentryentity.project", "=", project.getPkValue())).and(new QFilter("org", "=", organization.getPkValue()));
                DynamicObjectCollection queryOrders = QueryServiceHelper.query((String)"pom_mroorder", (String)"id, billno", (QFilter[])new QFilter[]{qFilter});
                Object[] orderIds = new Object[queryOrders.size()];
                for (int i = 0; i < queryOrders.size(); ++i) {
                    DynamicObject queryOrder = (DynamicObject)queryOrders.get(i);
                    orderIds[i] = queryOrder.getLong("id");
                    orders.remove(queryOrder.getString("billno"));
                }
                String status = (String)this.getModel().getValue(UPDATE_STATUS);
                if (Objects.isNull(status)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u66f4\u65b0\u72b6\u6001", (String)"MROOrderScanEdit_4", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
                    return;
                }
                String operateKey = "";
                switch (status) {
                    case "A": {
                        operateKey = "transmit";
                        break;
                    }
                    case "B": {
                        operateKey = "beginwork";
                        break;
                    }
                    case "C": {
                        operateKey = "cancel";
                        break;
                    }
                    case "D": {
                        operateKey = "error";
                        break;
                    }
                    case "E": {
                        operateKey = "keep";
                        break;
                    }
                    case "F": {
                        operateKey = "hold";
                        break;
                    }
                    case "G": {
                        operateKey = "endwork";
                    }
                }
                OperationResult executeResult = OperationServiceHelper.executeOperate((String)operateKey, (String)"pom_mroorder", (Object[])orderIds, (OperateOption)OperateOption.create());
                int successCount = executeResult.getSuccessPkIds().size();
                String summary = String.format(ResManager.loadKDString((String)"\u5171%1$d\u6761\u5355\u636e\uff0c\u6210\u529f%2$d\u6761\uff0c\u5931\u8d25%3$d\u6761", (String)"MROOrderScanEdit_10", (String)"mmc-pom-formplugin", (Object[])new Object[0]), orderCount, successCount, orderCount - successCount);
                String reason = "";
                if (orderCount - successCount > 0) {
                    reason = this.buildErrorInfo(executeResult, orders);
                }
                ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("OK", (IFormPlugin)this);
                String succeedIds = JSON.toJSONString((Object)executeResult.getSuccessPkIds());
                this.getView().showConfirm(summary, reason, MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener, new HashMap(), succeedIds);
            } else if (StringUtils.equals((CharSequence)scantype, (CharSequence)BEGIN_WORK)) {
                DynamicObject[] sfc_mromanuftech;
                HashSet<DynamicObject[]> mroswsEntrySet = new HashSet<DynamicObject[]>(16);
                HashMap<Long, String> mroswsAndOrderNoMap = new HashMap<Long, String>(16);
                HashSet<String> existOrders = new HashSet<String>(16);
                QFilter swsOrderQfilter = new QFilter("billstatus", "=", (Object)CANCEL);
                swsOrderQfilter.and(new QFilter("billentry.orderno", "in", orders));
                swsOrderQfilter.and(new QFilter("org", "=", organization.getPkValue()));
                swsOrderQfilter.and(new QFilter(PROJECT, "=", project.getPkValue()));
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"querySws", (String)"pom_mrosws", (String)"id,billentry.id,billentry.orderno", (QFilter[])swsOrderQfilter.toArray(), (String)"");){
                    while (dataSet.hasNext()) {
                        Row row = dataSet.next();
                        Long id = row.getLong("id");
                        DynamicObject[] entryId = row.getLong("billentry.id");
                        String orderno = row.getString("billentry.orderno");
                        mroswsAndOrderNoMap.put(id, orderno);
                        mroswsEntrySet.add(entryId);
                        existOrders.add(orderno);
                    }
                }
                QFilter mromanuftechFilter = new QFilter("oprentryentity.oprswsentryid", "in", mroswsEntrySet);
                HashSet<Long> mroManuftechIds = new HashSet<Long>(16);
                HashSet<Long> mroManuftechEntryIds = new HashSet<Long>(16);
                for (DynamicObject mromanuftech : sfc_mromanuftech = BusinessDataServiceHelper.load((String)"sfc_mromanuftech", (String)"oprswsentryid,oprcancelworkhours,manufactureorderid,oprstatus,billno,oprworkhours", (QFilter[])mromanuftechFilter.toArray())) {
                    Long pkValue = (Long)mromanuftech.getPkValue();
                    mroManuftechIds.add(pkValue);
                    DynamicObjectCollection oprentryentity = mromanuftech.getDynamicObjectCollection("oprentryentity");
                    for (DynamicObject oprentry : oprentryentity) {
                        Long entryPkValue = (Long)oprentry.getPkValue();
                        mroManuftechEntryIds.add(entryPkValue);
                    }
                }
                OperateOption option = OperateOption.create();
                option.setVariableValue("ignorewarn", String.valueOf(true));
                option.setVariableValue("ignoreinteraction", String.valueOf(true));
                option.setVariableValue("strictvalidation", String.valueOf(false));
                option.setVariableValue("ignoreValidation", String.valueOf(true));
                option.setVariableValue("WF", "false");
                option.setVariableValue("operateOption", JSON.toJSONString(mroManuftechEntryIds));
                option.setVariableValue("orderBillType", "pom_mroorder");
                option.setVariableValue("selectentryids", StringUtils.join((Object[])mroswsEntrySet.toArray(), (String)","));
                OperationResult executeResult = OperationServiceHelper.executeOperate((String)"donothing_finish", (String)"sfc_mromanuftech", (Object[])mroManuftechIds.toArray(), (OperateOption)option);
                int successCount = executeResult.getSuccessPkIds().size();
                String summary = String.format(ResManager.loadKDString((String)"\u5171%1$d\u6761\u5355\u636e\uff0c\u6210\u529f%2$d\u6761\uff0c\u5931\u8d25%3$d\u6761", (String)"MROOrderScanEdit_10", (String)"mmc-pom-formplugin", (Object[])new Object[0]), orderCount, successCount, orderCount - successCount);
                String reason = "";
                ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("OKSWS", (IFormPlugin)this);
                HashSet<String> successOrderNoSet = new HashSet<String>(16);
                List successSwsPkIds = executeResult.getSuccessPkIds();
                for (Object successPkId : successSwsPkIds) {
                    String successOrderNo = (String)mroswsAndOrderNoMap.get(successPkId);
                    successOrderNoSet.add(successOrderNo);
                }
                ArrayList<Long> successPkIds = new ArrayList<Long>(16);
                if (successOrderNoSet.size() > 0) {
                    QFilter orderQfilter = new QFilter("billno", "in", successOrderNoSet);
                    DynamicObjectCollection mroorders = QueryServiceHelper.query((String)"pom_mroorder", (String)"id, billno", (QFilter[])orderQfilter.toArray());
                    for (DynamicObject mroorder : mroorders) {
                        successPkIds.add(mroorder.getLong("id"));
                    }
                }
                StringJoiner reasonBase = new StringJoiner("\n");
                if (orderCount - mroswsEntrySet.size() > 0) {
                    reasonBase = this.buildErrorInfoSwsProject(orders, existOrders);
                }
                if (orderCount - successCount > 0) {
                    reason = this.buildErrorInfoSws(executeResult, reasonBase).toString();
                }
                String succeedIds = JSON.toJSONString(successPkIds);
                this.getView().showConfirm(summary, reason, MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener, new HashMap(), succeedIds);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        List succeedIds;
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getCallBackId().equals("OK") && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            List succeedIds2 = JSON.parseArray((String)messageBoxClosedEvent.getCustomVaule(), Long.class);
            this.showMroOrderList(succeedIds2);
        } else if (messageBoxClosedEvent.getCallBackId().equals("OKSWS") && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes) && (succeedIds = JSON.parseArray((String)messageBoxClosedEvent.getCustomVaule(), Long.class)).size() > 0) {
            this.showMroOrderList(succeedIds);
        }
    }

    private void showMroOrderList(List<Long> succeedIds) {
        ListShowParameter list = new ListShowParameter();
        list.setBillFormId("pom_mroorder");
        list.getListFilterParameter().setFilter(new QFilter("id", "in", succeedIds));
        list.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)list);
    }

    private StringJoiner buildErrorInfoSwsProject(Set<String> orders, Set<String> existOrders) {
        StringJoiner reason = new StringJoiner("\n");
        reason.add(ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0\uff1a", (String)"MROOrderScanEdit_6", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
        for (String orderno : orders) {
            if (existOrders.contains(orderno)) continue;
            reason.add(String.format(ResManager.loadKDString((String)"%s\u7684\u751f\u4ea7\u7ec4\u7ec7\u6216\u8005\u9879\u76ee\u53f7\u4e0e\u8f93\u5165\u751f\u4ea7\u7ec4\u7ec7\u3001\u9879\u76ee\u53f7\u7684\u4e0d\u4e00\u81f4\u3002", (String)"MROOrderScanEdit_7", (String)"mmc-pom-formplugin", (Object[])new Object[0]), orderno));
        }
        return reason;
    }

    private StringJoiner buildErrorInfoSws(OperationResult result, StringJoiner reason) {
        Map bills = result.getBillNos();
        for (ValidateResult validateError : result.getValidateResult().getValidateErrors()) {
            if (bills.size() == 1) {
                String message = ((OperateErrorInfo)validateError.getAllErrorInfo().get(0)).getMessage();
                String billNo = "";
                for (Map.Entry entry : bills.entrySet()) {
                    billNo = (String)entry.getValue();
                }
                StringBuilder errorInfo = new StringBuilder();
                errorInfo.append(String.format(ResManager.loadKDString((String)"%1$s:%2$s\uff0c\u66f4\u65b0\u72b6\u6001\u4e0d\u6210\u529f\u3002", (String)"MROOrderScanEdit_16", (String)"mmc-pom-formplugin", (Object[])new Object[0]), billNo, message));
                reason.add(errorInfo.toString());
                continue;
            }
            for (OperateErrorInfo operateErrorInfo : validateError.getAllErrorInfo()) {
                String message = operateErrorInfo.getMessage();
                StringBuilder errorInfo = new StringBuilder();
                errorInfo.append(String.format(ResManager.loadKDString((String)"%1$s\uff0c\u66f4\u65b0\u72b6\u6001\u4e0d\u6210\u529f\u3002", (String)"MROOrderScanEdit_17", (String)"mmc-pom-formplugin", (Object[])new Object[0]), message));
                reason.add(errorInfo.toString());
            }
        }
        return reason;
    }

    private String buildErrorInfo(OperationResult result, Collection<String> notExistOrders) {
        StringJoiner reason = new StringJoiner("\n");
        reason.add(ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0\uff1a", (String)"MROOrderScanEdit_6", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
        for (String order : notExistOrders) {
            reason.add(String.format(ResManager.loadKDString((String)"%s\u7684\u751f\u4ea7\u7ec4\u7ec7\u6216\u8005\u9879\u76ee\u53f7\u4e0e\u8f93\u5165\u751f\u4ea7\u7ec4\u7ec7\u3001\u9879\u76ee\u53f7\u7684\u4e0d\u4e00\u81f4\u3002", (String)"MROOrderScanEdit_7", (String)"mmc-pom-formplugin", (Object[])new Object[0]), order));
        }
        Map bills = result.getBillNos();
        for (ValidateResult validateError : result.getValidateResult().getValidateErrors()) {
            if (bills.size() == 1) {
                String message = ((OperateErrorInfo)validateError.getAllErrorInfo().get(0)).getMessage();
                String billNo = "";
                for (Map.Entry entry : bills.entrySet()) {
                    billNo = (String)entry.getValue();
                }
                StringBuilder errorInfo = new StringBuilder();
                message = message.substring(0, message.indexOf("\n") - 1);
                errorInfo.append(String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s\uff0c\u66f4\u65b0\u72b6\u6001\u4e0d\u6210\u529f\u3002", (String)"MROOrderScanEdit_18", (String)"mmc-pom-formplugin", (Object[])new Object[0]), billNo, message));
                reason.add(errorInfo.toString());
                continue;
            }
            for (OperateErrorInfo operateErrorInfo : validateError.getAllErrorInfo()) {
                String message = operateErrorInfo.getMessage();
                message = message.substring(0, message.indexOf("\n") - 1);
                StringBuilder errorInfo = new StringBuilder();
                errorInfo.append(String.format(ResManager.loadKDString((String)"%1$s\uff0c\u66f4\u65b0\u72b6\u6001\u4e0d\u6210\u529f\u3002", (String)"MROOrderScanEdit_17", (String)"mmc-pom-formplugin", (Object[])new Object[0]), message));
                reason.add(errorInfo.toString());
            }
        }
        return reason.toString();
    }

    private void setFocus() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(ORDER_NUMBER, "setFocus", new Object[0]);
    }
}

