/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.formplugin.prodwip.filiter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.pom.formplugin.prodwip.consts.ProdWipConst;
import org.apache.commons.lang3.time.DateUtils;

public class ProdWipFiliterBill
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit textEdit = (TextEdit)this.getControl("prodnomul");
        textEdit.addClickListener((ClickListener)this);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        this.getModel().setItemValueByID("org", formShowParameter.getCustomParam("org"));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initDate();
    }

    private void initDate() {
        Date date = new Date();
        Date begin = DateUtils.setDays((Date)date, (int)1);
        this.getModel().setValue("bctbegin", (Object)begin);
        this.getModel().setValue("bctend", (Object)date);
        this.getModel().setValue("pbtbegin", (Object)begin);
        this.getModel().setValue("pbtend", (Object)date);
        this.getModel().setValue("petbegin", (Object)begin);
        this.getModel().setValue("petend", (Object)date);
    }

    public void beforeClick(BeforeClickEvent e) {
        super.beforeClick(e);
        Control source = (Control)e.getSource();
        String fieldKey = source.getKey();
        if ("prodnomul".equals(fieldKey)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"pom_mftorder", (boolean)true);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fieldKey));
            List filters = listShowParameter.getListFilterParameter().getQFilters();
            filters.add(new QFilter("org.fisproduce", "=", (Object)Boolean.TRUE));
            if (org != null) {
                filters.add(new QFilter("org.id", "=", org.getPkValue()));
            }
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (returnData != null && "prodnomul".equals(actionId)) {
            ListSelectedRowCollection lists = (ListSelectedRowCollection)returnData;
            ArrayList<String> billNos = new ArrayList<String>();
            for (ListSelectedRow list : lists) {
                String billNo = list.getBillNo();
                if (billNos.contains(billNo)) continue;
                billNos.add(billNo);
            }
            StringJoiner sJoinerBillno = new StringJoiner(";");
            billNos.stream().forEach(t -> sJoinerBillno.add((CharSequence)t));
            this.getModel().setValue("prodnomul", (Object)sJoinerBillno.toString());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String field = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet.length < 1 || changeSet[0].getNewValue() == null) {
            return;
        }
        Object newValue = changeSet[0].getNewValue();
        switch (field) {
            case "modulenomul": {
                MulBasedataDynamicObjectCollection mulBase = (MulBasedataDynamicObjectCollection)newValue;
                ArrayList<Long> ids = new ArrayList<Long>();
                for (DynamicObject dynamicObject : mulBase) {
                    DynamicObject baseData = (DynamicObject)dynamicObject.get("fbasedataid");
                    ids.add(baseData.getLong("id"));
                }
                StringJoiner stringJoiner = new StringJoiner(";");
                QFilter fil = new QFilter("id", "in", ids);
                DynamicObjectCollection names = QueryServiceHelper.query((String)"bd_materialmftinfo", (String)"masterid.name", (QFilter[])new QFilter[]{fil});
                names.stream().filter(t -> t.get("masterid.name") != null).forEach(t -> stringJoiner.add(t.getString("masterid.name")));
                this.getModel().setValue("modulenamemul", (Object)stringJoiner.toString());
                break;
            }
        }
    }

    private boolean verifyQuery() {
        IDataModel model = this.getModel();
        StringBuilder sb = new StringBuilder();
        if (model.getValue("bizstatus") == null) {
            sb.append(ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u72b6\u6001\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002 \n", (String)"ProdWipFiliterBill_0", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
        }
        if (model.getValue("planstatus") == null) {
            sb.append(ResManager.loadKDString((String)"\u201c\u8ba1\u5212\u72b6\u6001\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002 \n", (String)"ProdWipFiliterBill_1", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
        }
        if (model.getValue("taskstatus") == null) {
            sb.append(ResManager.loadKDString((String)"\u201c\u4efb\u52a1\u72b6\u6001\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002 \n", (String)"ProdWipFiliterBill_2", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
        }
        if (model.getValue("pickstatus") == null) {
            sb.append(ResManager.loadKDString((String)"\u201c\u9886\u6599\u72b6\u6001\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002 \n", (String)"ProdWipFiliterBill_3", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
        }
        if (model.getValue("pbtbegin") != null && model.getValue("pbtend") != null) {
            Date begintime = (Date)model.getValue("pbtbegin");
            Date endtime = (Date)model.getValue("pbtend");
            if (model.getValue("petbegin") != null || model.getValue("petend") != null) {
                Date finishbegin = (Date)model.getValue("petbegin");
                Date finishend = (Date)model.getValue("petend");
                if (finishbegin.before(begintime)) {
                    sb.append(ResManager.loadKDString((String)"\u6700\u65e9\u8ba1\u5212\u5b8c\u5de5\u65e5\u671f\u5e94\u665a\u4e8e\u7b49\u4e8e\u6700\u65e9\u8ba1\u5212\u5f00\u5de5\u65e5\u671f\u3002\r\n", (String)"ProdWipFiliterBill_4", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
                }
                if (finishend.before(endtime)) {
                    sb.append(ResManager.loadKDString((String)"\u6700\u665a\u8ba1\u5212\u5b8c\u5de5\u65e5\u671f\u5e94\u665a\u4e8e\u7b49\u4e8e\u6700\u665a\u8ba1\u5212\u5f00\u5de5\u65e5\u671f\u3002\r\n", (String)"ProdWipFiliterBill_5", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
                }
            }
        }
        if (sb.length() != 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b8c\u6574\u7684\u67e5\u8be2\u6761\u4ef6\u3002", (String)"ProdWipFiliterBill_6", (String)"mmc-pom-formplugin", (Object[])new Object[0]), sb.toString(), MessageTypes.Default);
            return false;
        }
        return true;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control srcCtrl = (Control)evt.getSource();
        switch (key = srcCtrl.getKey()) {
            case "btnok": {
                if (!this.verifyQuery()) break;
                HashMap<String, Object> resultMap = new HashMap<String, Object>(32);
                for (String baseData : ProdWipConst.resultMapping) {
                    ArrayList result = new ArrayList();
                    DynamicObjectCollection resultMul = (DynamicObjectCollection)this.getModel().getValue(baseData);
                    resultMul.forEach(t -> result.add((Long)t.getDynamicObject("fbasedataid").getPkValue()));
                    resultMap.put(baseData, result);
                }
                for (String date : ProdWipConst.dateMapping) {
                    Object dateResult = this.getModel().getValue(date);
                    resultMap.put(date, dateResult);
                }
                for (String status : ProdWipConst.statusMapping) {
                    String statusResult = (String)this.getModel().getValue(status);
                    String[] statusList = statusResult.substring(1, statusResult.length() - 1).split(",");
                    resultMap.put(status, statusList);
                }
                String billNo = (String)this.getModel().getValue("prodnomul");
                String[] splitBillNo = billNo.split(";");
                if (splitBillNo.length != 0 && !"".equals(splitBillNo[0])) {
                    ArrayList<String> billNos = new ArrayList<String>(splitBillNo.length);
                    billNos.addAll(Arrays.asList(splitBillNo));
                    resultMap.put("prodnomul", billNos);
                }
                this.getView().returnDataToParent(resultMap);
                this.getView().close();
                break;
            }
            case "btncancel": {
                this.getView().returnDataToParent(null);
            }
        }
    }
}

