/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.formplugin.repaire;

import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.utils.AverageAssignUtil;
import kd.bd.mpdm.common.utils.DynamicObjDataUtil;
import kd.bd.mpdm.common.utils.UnitPrecisionUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;

public class ManufstockHsRepaireFormPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String oprKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (!operationResult.isSuccess()) {
            return;
        }
        switch (oprKey) {
            case "excuterepair": {
                this.excuteRepaire();
            }
        }
    }

    private void excuteRepaire() {
        try {
            DynamicObjectCollection colls;
            List billIdSet;
            DynamicObject entityobj = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"entityobj");
            String unitprop = DynamicObjDataUtil.getDataModelStringData((IDataModel)this.getModel(), (String)"unitprop");
            String qtyprop = DynamicObjDataUtil.getDataModelStringData((IDataModel)this.getModel(), (String)"qtyprop");
            String billno = DynamicObjDataUtil.getDataModelStringData((IDataModel)this.getModel(), (String)"billno");
            String entityNumber = entityobj.getString("number");
            String entrykey = DynamicObjDataUtil.getDataModelStringData((IDataModel)this.getModel(), (String)"entrykey");
            QFilter qfilters = QFilter.of((String)"1=1", (Object[])new Object[0]);
            if (StringUtils.isNotBlank((CharSequence)billno)) {
                String[] sbillno = billno.split(",");
                qfilters = new QFilter("billno", "in", (Object)sbillno);
            }
            if ((billIdSet = (colls = QueryServiceHelper.query((String)entityNumber, (String)"id", (QFilter[])qfilters.toArray())).stream().map(p -> p.getLong("id")).collect(Collectors.toList())).isEmpty()) {
                return;
            }
            List assignBillIDLst = AverageAssignUtil.getAssignListByMaxSize(billIdSet, (int)10000);
            for (List billIDLst : assignBillIDLst) {
                DynamicObject[] billObjs;
                for (DynamicObject billObj : billObjs = BusinessDataServiceHelper.load((String)entityNumber, (String)(qtyprop + "," + unitprop), (QFilter[])new QFilter("id", "in", (Object)billIDLst).toArray())) {
                    IDataEntityProperty propEntryKey = (IDataEntityProperty)billObj.getDataEntityType().getProperties().get((Object)entrykey);
                    if (propEntryKey == null) {
                        throw new KDBizException("entrykey is no exist");
                    }
                    DynamicObjectCollection entrys = billObj.getDynamicObjectCollection(entrykey);
                    for (DynamicObject entry : entrys) {
                        IDataEntityProperty propQty = (IDataEntityProperty)entry.getDataEntityType().getProperties().get((Object)unitprop);
                        if (propQty == null) continue;
                        String[] qtykeys = qtyprop.split(",");
                        UnitPrecisionUtils.caleQtyPrecision((DynamicObject)entry, (String)unitprop, (String[])qtykeys);
                    }
                }
                SaveServiceHelper.save((DynamicObject[])billObjs);
            }
        }
        catch (Exception ex) {
            throw new KDBizException("data error:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
        }
    }
}

