/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.formplugin.report;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bd.mpdm.business.mftorder.SerialNumberHelper;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mmc.pom.common.manufacture.utils.MftOrderReportUtils;

public class POMReportMftOrderBillEdit
extends AbstractFormPlugin
implements RowClickEventListener,
BeforeF7SelectListener {
    private Boolean isIgnoreChangeListener = Boolean.FALSE;
    private static final Map<String, String> fieldMaps = new HashMap<String, String>();

    public void itemClick(ItemClickEvent evt) {
        String operationKey;
        super.itemClick(evt);
        switch (operationKey = evt.getItemKey()) {
            case "checksnnumber": 
            case "entersnnumber": 
            case "importsnnumber": {
                SerialNumberHelper.handleSNNumber((AbstractFormPlugin)this, (ItemClickEvent)evt);
                break;
            }
        }
    }

    public static String getFieldName(String key) {
        return fieldMaps.get(key);
    }

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        BasedataEdit userno;
        BasedataEdit represources;
        BasedataEdit repactivity;
        EntryGrid entryActGrid;
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("sumentry");
        if (entryGrid != null) {
            entryGrid.addRowClickListener((RowClickEventListener)this);
        }
        if ((entryActGrid = (EntryGrid)this.getView().getControl("subentryentity")) != null) {
            entryActGrid.addRowClickListener((RowClickEventListener)this);
        }
        if ((repactivity = (BasedataEdit)this.getView().getControl("repactivity")) != null) {
            repactivity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((represources = (BasedataEdit)this.getView().getControl("represources")) != null) {
            represources.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((userno = (BasedataEdit)this.getView().getControl("userno")) != null) {
            userno.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (this.isIgnoreChangeListener.booleanValue()) {
            this.isIgnoreChangeListener = Boolean.FALSE;
            return;
        }
        String propertyName = e.getProperty().getName();
        Object newObj = e.getChangeSet()[0].getNewValue();
        int currentIndex = this.getSelectEntryRowIndex();
        ChangeData changeData = e.getChangeSet()[0];
        if (currentIndex > -1) {
            DynamicObject dataEntity = this.getModel().getEntryRowEntity("sumentry", currentIndex);
            this.entryToOther(dataEntity);
            String entryFieldName = POMReportMftOrderBillEdit.getFieldName(propertyName);
            if (StringUtils.isNotEmpty((CharSequence)entryFieldName) && currentIndex >= 0) {
                this.getModel().setValue(entryFieldName, newObj, currentIndex);
            }
        }
        this.copyEntryToDetail(propertyName, newObj);
        if (null == this.getPageCache().get("isIgnoreSubentryentityChangeListener") || StringUtils.equals((CharSequence)"false", (CharSequence)this.getPageCache().get("isIgnoreSubentryentityChangeListener"))) {
            HashSet set;
            Date startTime;
            Date closeTime;
            if ("repactivity".equals(propertyName)) {
                this.propChangeRepactivity(changeData);
            }
            if ("repbaseqty".equals(propertyName)) {
                this.propChangeRepbaseqty(changeData);
            }
            if ("actstandardformula".equals(propertyName)) {
                this.propChangeRepActStandardformula(changeData);
            }
            if ("profession".equals(propertyName)) {
                DynamicObjectCollection sumentry = this.getModel().getEntryEntity("childreportentity");
                for (int i = 0; i < sumentry.size(); ++i) {
                    this.getModel().setValue("userno", null, i);
                }
            }
            if ("starttime".equals(propertyName) && (closeTime = (Date)this.getModel().getValue("closetime", e.getChangeSet()[0].getRowIndex())) != null && newObj != null) {
                this.getModel().setValue("actconsumedhours", (Object)this.calDate((Date)newObj, closeTime), e.getChangeSet()[0].getRowIndex());
            }
            if ("closetime".equals(propertyName) && (startTime = (Date)this.getModel().getValue("starttime", e.getChangeSet()[0].getRowIndex())) != null && newObj != null) {
                this.getModel().setValue("actconsumedhours", (Object)this.calDate(startTime, (Date)newObj), e.getChangeSet()[0].getRowIndex());
            }
            if ("actconsumedhours".equals(propertyName)) {
                this.calHours(e);
                this.calTime(this.getModel().getEntryEntity("subentryentity"));
            }
            if ("opactivity".equals(propertyName)) {
                this.calHours(e);
                this.calTime(this.getModel().getEntryEntity("subentryentity"));
            }
            if ("dailyexptype".equals(propertyName)) {
                DynamicObject dailyexptype = (DynamicObject)newObj;
                if (null != dailyexptype) {
                    if ("A".equals(dailyexptype.getString("type"))) {
                        this.getModel().setValue("tasktype", (Object)"B", e.getChangeSet()[0].getRowIndex());
                    } else if ("B".equals(dailyexptype.getString("type"))) {
                        this.getModel().setValue("tasktype", (Object)"C", e.getChangeSet()[0].getRowIndex());
                    }
                } else {
                    this.getModel().setValue("tasktype", null, e.getChangeSet()[0].getRowIndex());
                }
            }
            if ((set = Sets.newHashSet((Object[])new String[]{"completqty", "qualifyqty", "concesionqty", "workwasteqty", "scrapqty", "scrappedqty", "repairqty", "reworkqty"})).contains(propertyName)) {
                this.properChangeCalRepActualQty();
            }
        }
    }

    private void properChangeCalRepActualQty() {
        DynamicObjectCollection subentryentitys = this.getModel().getEntryEntity("subentryentity");
        if (subentryentitys != null) {
            for (DynamicObject subentryentity : subentryentitys) {
                BigDecimal repactualqty = this.calRepactualqty(subentryentity);
                this.getModel().setValue("repactualqty", (Object)repactualqty, subentryentity.getInt("seq") - 1);
            }
        }
    }

    private BigDecimal calDate(Date startTime, Date closeTime) {
        Duration between = Duration.between(startTime.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime(), closeTime.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
        BigDecimal seconds = new BigDecimal(between.getSeconds() + "");
        BigDecimal hours = seconds.divide(new BigDecimal("3600"), 2, 4);
        return hours;
    }

    private void calHours(PropertyChangedArgs e) {
        DynamicObjectCollection entity = this.getModel().getEntryEntity("childreportentity");
        BigDecimal reduce1 = entity.stream().filter(x -> "A".equals(x.getString("opactivity"))).map(x -> x.getBigDecimal("actconsumedhours")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal reduce2 = entity.stream().filter(x -> "B".equals(x.getString("opactivity"))).map(x -> x.getBigDecimal("actconsumedhours")).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.getModel().setValue("totalconsumedhours", (Object)reduce1, e.getChangeSet()[0].getParentRowIndex());
        this.getModel().setValue("totalinspectionhours", (Object)reduce2, e.getChangeSet()[0].getParentRowIndex());
    }

    private void calTime(DynamicObjectCollection entryEntity) {
        BigDecimal decimal = new BigDecimal("1");
        DynamicObjectCollection entity = this.getModel().getEntryEntity("childreportentity");
        BigDecimal reduce1 = entity.stream().filter(x -> "A".equals(x.getString("opactivity"))).map(x -> x.getBigDecimal("actconsumedhours")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal reduce2 = entity.stream().filter(x -> "B".equals(x.getString("opactivity"))).map(x -> x.getBigDecimal("actconsumedhours")).reduce(BigDecimal.ZERO, BigDecimal::add);
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject repActivity = ((DynamicObject)entryEntity.get(i)).getDynamicObject("repactivity");
            if (repActivity == null || repActivity.getDynamicObject("unit") == null) continue;
            DynamicObject unit = repActivity.getDynamicObject("unit");
            if ("minute".equals(unit.getString("number"))) {
                decimal = new BigDecimal("60");
            } else if ("second".equals(unit.getString("number"))) {
                decimal = new BigDecimal("3600");
            }
            this.getModel().setValue("actchours", (Object)reduce1.multiply(decimal), i);
            this.getModel().setValue("actihours", (Object)reduce2.multiply(decimal), i);
        }
    }

    private void propChangeRepactivity(ChangeData changeData) {
        int rowIndex = changeData.getRowIndex();
        Object newValue = changeData.getNewValue();
        DynamicObject repactivity = (DynamicObject)newValue;
        this.getModel().setValue("repactivity", (Object)repactivity, rowIndex);
        if (null != repactivity) {
            repactivity = BusinessDataServiceHelper.loadSingleFromCache((Object)repactivity.getPkValue(), (String)"mpdm_processactivity", (String)"baseqty");
            BigDecimal repbaseqty = repactivity.getBigDecimal("baseqty");
            this.getModel().setValue("repbaseqty", (Object)repbaseqty, rowIndex);
        }
        DynamicObject subentryentity = this.getModel().getEntryRowEntity("subentryentity", rowIndex);
        BigDecimal repactualqty = this.calRepactualqty(subentryentity);
        this.getModel().setValue("repactualqty", (Object)repactualqty, rowIndex);
    }

    private void propChangeRepbaseqty(ChangeData changeData) {
        int rowIndex = changeData.getRowIndex();
        Object newValue = changeData.getNewValue();
        BigDecimal repbaseqty = (BigDecimal)newValue;
        this.getModel().setValue("repbaseqty", (Object)repbaseqty, rowIndex);
        DynamicObject subentryentity = this.getModel().getEntryRowEntity("subentryentity", rowIndex);
        BigDecimal repactualqty = this.calRepactualqty(subentryentity);
        this.getModel().setValue("repactualqty", (Object)repactualqty, rowIndex);
    }

    private void propChangeRepActStandardformula(ChangeData changeData) {
        int rowIndex = changeData.getRowIndex();
        this.getModel().setValue("actstandardformula", changeData.getNewValue(), rowIndex);
        DynamicObject subentryentity = this.getModel().getEntryRowEntity("subentryentity", rowIndex);
        BigDecimal repactualqty = this.calRepactualqty(subentryentity);
        this.getModel().setValue("repactualqty", (Object)repactualqty, rowIndex);
    }

    private void copyEntryToDetail(String filed, Object newObj) {
        switch (filed) {
            case "repairbsqty": {
                this.getModel().setValue("entryrepairbsqty", newObj);
                break;
            }
            case "concesionbsqty": {
                this.getModel().setValue("entryconcesionbsqty", newObj);
                break;
            }
        }
    }

    public int getSelectEntryRowIndex() {
        int currentEntryIndex = -1;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("sumentry");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            currentEntryIndex = selectRows[0];
        }
        return currentEntryIndex;
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (StringUtils.equals((CharSequence)"sumentry", (CharSequence)entryGrid.getKey())) {
            DynamicObject entryentity = this.getModel().getEntryRowEntity("sumentry", evt.getRow());
            this.showEntryDetial(entryentity);
        }
    }

    private void showEntryDetial(DynamicObject entryentity) {
        this.isIgnoreChangeListener = Boolean.TRUE;
        if (entryentity != null) {
            IDataModel model = this.getModel();
            model.setValue("entryqualifywareqty", entryentity.get("qualifywareqty"));
            model.setValue("entryunqualifywareqty", entryentity.get("unqualifywareqty"));
            model.setValue("entryscrappedwareqty", entryentity.get("scrappedwareqty"));
            model.setValue("entrypushdownwareqty", entryentity.get("pushdownwareqty"));
            this.entryToOther(entryentity);
            if (null == entryentity.get("begintime")) {
                model.setValue("entrybegintime", (Object)this.getTodayStartTime());
            } else {
                model.setValue("entrybegintime", entryentity.get("begintime"));
            }
            if (null == entryentity.get("endtime")) {
                model.setValue("entryendtime", (Object)this.getTodayStartTime());
            } else {
                model.setValue("entryendtime", entryentity.get("endtime"));
            }
        }
        this.isIgnoreChangeListener = Boolean.FALSE;
    }

    private void entryToOther(DynamicObject entryentity) {
        IDataModel model = this.getModel();
        model.setValue("entrybaseunit", entryentity.get("baseunit"));
        model.setValue("entrycplbsqty", entryentity.get("completbsqty"));
        model.setValue("entryqualifybsqty", entryentity.get("qualifybsqty"));
        model.setValue("entrywstbsqty", entryentity.get("workwastebsqty"));
        model.setValue("entryscrapbsqty", entryentity.get("scrapbsqty"));
        model.setValue("entrysrpbsqty", entryentity.get("scrappedbsqty"));
        model.setValue("entryreworkbsqty", entryentity.get("reworkbsqty"));
        model.setValue("entryconcesionbsqty", entryentity.get("concesionbsqty"));
        model.setValue("entryrepairbsqty", entryentity.get("repairbsqty"));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key = e.getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"previousentry") || StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"nextentry")) {
            DynamicObject entryentity = this.getModel().getEntryRowEntity("sumentry", this.getSelectEntryRowIndex());
            this.showEntryDetial(entryentity);
        } else if (StringUtils.equals((CharSequence)"newentryact", (CharSequence)key) || StringUtils.equals((CharSequence)"insertentryact", (CharSequence)key)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("sumentry");
            EntryGrid entryActGrid = (EntryGrid)this.getView().getControl("subentryentity");
            if (entryGrid.getSelectRows().length == 0) {
                return;
            }
            int rowIndex = entryGrid.getSelectRows()[0];
            int rowIndexAct = entryActGrid.getSelectRows()[0];
            DynamicObject entrySum = this.getModel().getEntryRowEntity("sumentry", rowIndex);
            Long mftentryid = entrySum.getLong("mftentryid");
            String selectPro = "treeentryentity.processroute,treeentryentity.id,treeentryentity.planbegintime,treeentryentity.planendtime,treeentryentity.routereplace";
            QFilter qf = new QFilter("treeentryentity.id", "=", (Object)mftentryid);
            Date planbegintime = null;
            Date planendtime = null;
            try (DataSet mftOrderEntryDataSets = QueryServiceHelper.queryDataSet((String)"mmc-POMReportMftOrderBillEdit", (String)"pom_mftorder", (String)selectPro, (QFilter[])qf.toArray(), null);){
                while (mftOrderEntryDataSets.hasNext()) {
                    Row mftOrderEntryDataSet = mftOrderEntryDataSets.next();
                    planbegintime = mftOrderEntryDataSet.getDate("treeentryentity.planbegintime");
                    planendtime = mftOrderEntryDataSet.getDate("treeentryentity.planendtime");
                }
            }
            if (null != planbegintime && planendtime != null) {
                this.getModel().setValue("repactualbegintime", (Object)planbegintime, rowIndexAct);
                this.getModel().setValue("repactualfinishtime", (Object)planendtime, rowIndexAct);
            }
        } else if ("deleteentryuser".equals(key)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("childreportentity");
            BigDecimal reduce1 = entryEntity.stream().filter(x -> "A".equals(x.getString("opactivity"))).map(x -> x.getBigDecimal("actconsumedhours")).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal reduce2 = entryEntity.stream().filter(x -> "B".equals(x.getString("opactivity"))).map(x -> x.getBigDecimal("actconsumedhours")).reduce(BigDecimal.ZERO, BigDecimal::add);
            DynamicObject parent = (DynamicObject)entryEntity.getParent();
            parent.set("totalconsumedhours", (Object)reduce1);
            parent.set("totalinspectionhours", (Object)reduce2);
            this.calTime(this.getModel().getEntryEntity("subentryentity"));
            this.getView().updateView("sumentry");
        }
    }

    private BigDecimal calRepactualqty(DynamicObject subentryentity) {
        Object processactivityPk;
        int rowIndex = this.getSelectEntryRowIndex() > 0 ? this.getSelectEntryRowIndex() : 0;
        DynamicObject sumEntryRow = (DynamicObject)this.getModel().getEntryEntity("sumentry").get(rowIndex);
        BigDecimal repactualqty = new BigDecimal(0);
        DynamicObject processactivity = subentryentity.getDynamicObject("repactivity");
        if (null != processactivity && null != (processactivityPk = processactivity.getPkValue())) {
            processactivity = BusinessDataServiceHelper.loadSingleFromCache((Object)processactivityPk, (String)"mpdm_processactivity");
            int seq = subentryentity.getInt("seq");
            try {
                repactualqty = MftOrderReportUtils.runFormula((DynamicObject)subentryentity, (DynamicObject)processactivity);
            }
            catch (Exception e) {
                if (sumEntryRow.containsProperty("processseq") && sumEntryRow.containsProperty("oprno")) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u6d3b\u52a8\u5206\u5f55\u7b2c%s\u884c\u6d3b\u52a8\u516c\u5f0f\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u8bed\u6cd5\u662f\u5426\u6b63\u786e\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"POMReportMftOrderBillEdit_0", (String)"mmc-pom-formplugin", (Object[])new Object[0]), seq, sumEntryRow.get("processseq"), sumEntryRow.get("oprno")));
                }
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6d3b\u52a8\u5217\u8868\u7b2c%s\u884c\u6d3b\u52a8\u516c\u5f0f\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u8bed\u6cd5\u662f\u5426\u6b63\u786e\u3002", (String)"POMReportMftOrderBillEdit_2", (String)"mmc-pom-formplugin", (Object[])new Object[0]), seq));
            }
        }
        return repactualqty;
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String entityName = e.getEntryProp().getName();
        if ("childreportentity".equals(entityName)) {
            this.getModel().setValue("repworkunit", this.getModel().getValue("workunit", e.getParentRow()), e.getRowDataEntities()[0].getRowIndex());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("sumentry");
        int rowcount = this.getModel().getEntryRowCount("sumentry");
        if (entryGrid != null && rowcount > 0) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"docbilltype"});
            entryGrid.selectRows(0, true);
            DynamicObject entryentity = this.getModel().getEntryRowEntity("sumentry", 0);
            this.showEntryDetial(entryentity);
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"docbilltype"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.isMroOrderReport().booleanValue()) {
            this.getModel().setValue("staffreport", (Object)"hours");
        }
    }

    private Boolean isMroOrderReport() {
        ListShowParameter formShowParameter;
        String billType;
        if (null != this.getView().getFormShowParameter().getParentFormId() && !this.getView().getFormShowParameter().getParentFormId().equals("im_mdc_backflushform") && this.getView().getParentView() != null && this.getView().getParentView().getFormShowParameter() instanceof ListShowParameter && (billType = (String)(formShowParameter = (ListShowParameter)this.getView().getParentView().getFormShowParameter()).getCustomParam("billtype")) != null && !"orderreport".equals(billType)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (StringUtils.equals((CharSequence)billStatus, (CharSequence)"A")) {
            e.setCheckDataChange(true);
        } else {
            e.setCheckDataChange(false);
        }
    }

    private Date getTodayStartTime() {
        Calendar todayStart = Calendar.getInstance();
        todayStart.set(11, 0);
        todayStart.set(12, 0);
        todayStart.set(13, 0);
        return todayStart.getTime();
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Control con = (Control)evt.getSource();
        String source = con.getKey();
        if ("repactivity".equals(source)) {
            this.filterRepactivity(evt);
        }
        if ("represources".equals(source)) {
            this.filterRepresources(evt);
        }
        if ("userno".equals(source) && this.isMroOrderReport().booleanValue()) {
            this.filterUserno(evt);
        }
    }

    private void filterUserno(BeforeF7SelectEvent evt) {
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        listShowParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
        listShowParameter.setMultiSelect(false);
        DynamicObjectCollection sumentry = this.getModel().getEntryEntity("sumentry");
        if (sumentry.size() <= 0 || null == ((DynamicObject)sumentry.get(0)).getDynamicObject("profession")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u884c\u4e1a\u4fe1\u606f\u3002", (String)"POMReportMftOrderBillEdit_1", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        Long professionId = ((DynamicObject)sumentry.get(0)).getDynamicObject("profession").getLong("id");
        if (null != professionId) {
            QFilter qfilter = new QFilter("professiona", "=", (Object)professionId);
            listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
        }
    }

    private void filterRepactivity(BeforeF7SelectEvent evt) {
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        listShowParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
        listShowParameter.setMultiSelect(false);
        DynamicObject mftOrderReportBill = this.getModel().getDataEntity();
        DynamicObject mftOrg = (DynamicObject)mftOrderReportBill.get("org");
        if (null == mftOrg) {
            return;
        }
        Long mftOrgId = mftOrg.getLong("masterid");
        if (null != mftOrgId) {
            QFilter qfilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_processactivity", (Long)mftOrgId);
            listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
        }
    }

    private void filterRepresources(BeforeF7SelectEvent evt) {
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        listShowParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
        listShowParameter.setMultiSelect(false);
        DynamicObject mftOrderReportBill = this.getModel().getDataEntity();
        DynamicObject mftOrg = (DynamicObject)mftOrderReportBill.get("org");
        if (null == mftOrg) {
            return;
        }
        QFilter qfilter = new QFilter("enable", "=", (Object)"1");
        qfilter.and(new QFilter("status", "=", (Object)"C"));
        Long mftOrgId = mftOrg.getLong("masterid");
        if (null != mftOrgId) {
            QFilter resourceOrgQFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_resources", (Long)mftOrgId);
            qfilter.and(resourceOrgQFilter);
        }
        listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
    }

    static {
        fieldMaps.put("entrybegintime", "begintime");
        fieldMaps.put("entryendtime", "endtime");
        fieldMaps.put("entryqualifywareqty", "qualifywareqty");
        fieldMaps.put("entryunqualifywareqty", "unqualifywareqty");
        fieldMaps.put("entryscrappedwareqty", "scrappedwareqty");
    }
}

