/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.formplugin.rpt;

import java.util.Date;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class MftOrderReqoutRptQueryPlugin
extends AbstractReportListDataPlugin {
    static String orderSelects = "billstatus,treeentryentity.id as forderentryid";
    static String stockSelects = "org,mftdeptorgid,productid,unitid,orderno,orderid,orderentryid,stockentry.standqty,stockentry.demandqty,stockentry.actissueqty,stockentry.rejectedqty,stockentry.feedingqty,stockentry.allotqty,stockentry.materialid,stockentry.materialunitid";
    static String finalSelects = "org,mftdeptorgid,productid,unitid,orderno,stockentry.materialid,stockentry.materialunitid,stockentry.standqty,stockentry.demandqty,stockentry.actissueqty,stockentry.rejectedqty,stockentry.feedingqty,orderentryid,stockentry.allotqty,billstatus,orderid,stockentry.demandqty - stockentry.actissueqty + stockentry.rejectedqty - stockentry.feedingqty as reqoutdiffqty";
    private FilterInfo filterInfo;

    public DataSet query(ReportQueryParam param, Object arg1) throws Throwable {
        this.filterInfo = param.getFilter();
        DataSet dataSet = this.getDataSet();
        return dataSet.select(finalSelects.split(","));
    }

    private DataSet getDataSet() {
        DynamicObject producte;
        QFilter q = this.getOrderFilter();
        DynamicObjectCollection querys = QueryServiceHelper.query((String)"pom_mftorder", (String)orderSelects, (QFilter[])new QFilter[]{q});
        HashSet<Object> orderEntrySet = new HashSet<Object>();
        for (DynamicObject query : querys) {
            orderEntrySet.add(query.get("forderentryid"));
        }
        QFilter qs = new QFilter("orderentryid", "in", orderEntrySet);
        DynamicObject productb = this.filterInfo.getDynamicObject("materielstart");
        if (productb != null) {
            qs.and("stockentry.materialid", ">=", productb.getPkValue());
        }
        if ((producte = this.filterInfo.getDynamicObject("materielend")) != null) {
            qs.and("stockentry.materialid", "<=", producte.getPkValue());
        }
        DataSet orderDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pom_mftorder", (String)orderSelects, (QFilter[])new QFilter[]{q}, null);
        DataSet stockDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pom_mftstock", (String)stockSelects, (QFilter[])new QFilter[]{qs}, null);
        return orderDataSet.join(stockDataSet, JoinType.INNER).on("forderentryid", "orderentryid").select(finalSelects.split(",")).finish();
    }

    private QFilter getOrderFilter() {
        DynamicObject producte;
        DynamicObject productb;
        String orderNoe;
        String orderNob;
        DynamicObject org = this.filterInfo.getDynamicObject("orgfield");
        QFilter q = new QFilter("org", "=", org.getPkValue());
        DynamicObjectCollection tran = this.filterInfo.getDynamicObjectCollection("transactiontypeid");
        if (tran != null) {
            HashSet<Object> set = new HashSet<Object>();
            for (DynamicObject info : tran) {
                set.add(info.getPkValue());
            }
            q.and("transactiontype", "in", set);
        }
        Date bsdate = this.filterInfo.getDate("planbegintimestart");
        q.and("treeentryentity.planbegintime", ">=", (Object)bsdate);
        Date bedate = this.filterInfo.getDate("planbegintimeend");
        q.and("treeentryentity.planbegintime", "<=", (Object)bedate);
        Date ebdate = this.filterInfo.getDate("planendtimestart");
        q.and("treeentryentity.planendtime", ">=", (Object)ebdate);
        Date eedate = this.filterInfo.getDate("planendtimeend");
        q.and("treeentryentity.planendtime", "<=", (Object)eedate);
        DynamicObject dept = this.filterInfo.getDynamicObject("mftdeptorgidfield");
        if (dept != null) {
            q.and("treeentryentity.producedept", "=", dept.getPkValue());
        }
        if ((orderNob = this.filterInfo.getString("ordernostart")) != null && !"".equals(orderNob)) {
            q.and("billno", ">=", (Object)orderNob);
        }
        if ((orderNoe = this.filterInfo.getString("ordernoend")) != null && !"".equals(orderNoe)) {
            q.and("billno", "<=", (Object)orderNoe);
        }
        if ((productb = this.filterInfo.getDynamicObject("productidstart")) != null) {
            q.and("treeentryentity.material", ">=", productb.getPkValue());
        }
        if ((producte = this.filterInfo.getDynamicObject("productidend")) != null) {
            q.and("treeentryentity.material", "<=", producte.getPkValue());
        }
        String billstatus = this.filterInfo.getString("billstatusfield");
        q.and("billstatus", "in", (Object)billstatus.split(","));
        String bizstatus = this.filterInfo.getString("bizstatusfield");
        q.and("treeentryentity.bizstatus", "in", (Object)bizstatus.split(","));
        String planstatus = this.filterInfo.getString("planstatusfield");
        q.and("treeentryentity.planstatus", "in", (Object)planstatus.split(","));
        String taskstatus = this.filterInfo.getString("taskstatusfield");
        q.and("treeentryentity.taskstatus", "in", (Object)taskstatus.split(","));
        String pickstatus = this.filterInfo.getString("pickstatusfield");
        q.and("treeentryentity.pickstatus", "in", (Object)pickstatus.split(","));
        return q;
    }
}

