/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.formplugin.stock;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.enums.TriggerEventType;
import kd.bd.mpdm.common.query.helper.MaterialQueryHelper;
import kd.bd.mpdm.common.query.helper.WarehouseQueryHelper;
import kd.bd.mpdm.common.utils.DyObjUtils;
import kd.bd.mpdm.formplugin.batchmaintain.AbstractBatchMaintainTpl;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.validate.BillStatus;
import kd.bos.metadata.form.ControlAp;
import kd.bos.orm.query.QFilter;

public class MftStockBatchMaintainPlugin
extends AbstractBatchMaintainTpl {
    private static final String[] visibleField = new String[]{"supplymode", "supplierid", "supplyorgid", "warehouseid", "location", "isstockallot", "outorgunitid", "outwarehouseid", "outlocation", "issuemode", "isbulkmaterial", "isbackflush", "backflushtime", "iskeypart", "overissuecontrl", "considerminbatch", "demanddate", "processseq", "oprno", "childremarks", "issinhighlimit", "extraratioqty", "issinlowlimit", "lackraitioqty", "considerminbatch"};
    private static final String[] unVisibleField = new String[]{"baseunitid", "baseqty"};
    private static final String[] unLockField = new String[]{"oprno", "XX"};
    private static final String[] linkedHead = new String[]{"billno", "transactiontypeid", "productid", "productname", "baseunitid", "baseqty", "orderentryid"};
    private static final String allVisible = "init,new,edit,view,submit,audit";
    private static final int LIMIT = 2000;
    private static final String[] entryfields = new String[]{"qtynumerator", "qtydenominator", "fixscrap", "scraprate", "ecostcenter"};
    private static final String[] entryLockfields = new String[]{"materialid", "bomreversion", "qtytype", "iscannegative", "wastagerateformula", "isbomextend"};

    public String getTargetEntityName() {
        return "pom_mftstock";
    }

    public String getTargetEntryName() {
        return "stockentry";
    }

    public String getBatchMaintainEntityName() {
        return "pom_stockbatchmaintain";
    }

    protected void modifyControlAp(ControlAp controlAp) {
        if (Arrays.asList(visibleField).contains(controlAp.getKey())) {
            controlAp.setVisible(allVisible);
        } else if (Arrays.asList(unVisibleField).contains(controlAp.getKey())) {
            controlAp.setVisible("");
        }
        if (Arrays.asList(unLockField).contains(controlAp.getKey())) {
            controlAp.setLock("");
        }
    }

    protected Set<String> getLinkedHeadField() {
        return new HashSet<String>(Arrays.asList(linkedHead));
    }

    protected List<QFilter> genQFilter(Long orgId) {
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>(2);
        qfilters.add(new QFilter("billstatus", "=", (Object)BillStatus.A));
        qfilters.add(new QFilter("org", "=", (Object)orgId));
        qfilters.add(new QFilter("stockentry.parentid", "=", (Object)0));
        return qfilters;
    }

    protected void processSelectDate(DynamicObject[] dynamicObjects, Set<Long> selectedEntryId) {
        if (!Objects.isNull(dynamicObjects)) {
            HashSet<Long> replaceBind = new HashSet<Long>(16);
            for (DynamicObject dynamicObject : dynamicObjects) {
                DynamicObjectCollection cols = dynamicObject.getDynamicObjectCollection(this.getTargetEntryName());
                if (Objects.isNull(cols)) continue;
                Map pkObj = cols.stream().collect(Collectors.toMap(o -> o.getLong("id"), Function.identity()));
                for (Long entryId : selectedEntryId) {
                    DynamicObject replacePlan;
                    DynamicObject entry = (DynamicObject)pkObj.get(entryId);
                    if (entry == null || (replacePlan = entry.getDynamicObject("replaceplan")) == null) continue;
                    for (Map.Entry entryMap : pkObj.entrySet()) {
                        DynamicObject stockReplace = ((DynamicObject)entryMap.getValue()).getDynamicObject("replaceplan");
                        if (stockReplace == null || !replacePlan.getPkValue().equals(stockReplace.getPkValue())) continue;
                        replaceBind.add(entryMap.getKey());
                    }
                }
            }
            selectedEntryId.addAll(replaceBind);
        }
    }

    protected void afterAddRow(DynamicObject dynamicObject, int focusRow) {
        Arrays.asList(linkedHead).forEach(headField -> {
            if (this.getModel().getProperty(headField) != null) {
                dynamicObject.set(headField, this.getModel().getValue(headField, focusRow));
            }
        });
        dynamicObject.set("processseq", (Object)"1");
        dynamicObject.set("oprno", (Object)"10");
    }

    protected void runSingleRule(int colRow, DynamicObject col, TriggerEventType eventType) {
        HashMap<String, Boolean> viewLockInfo = new HashMap<String, Boolean>();
        if (eventType == TriggerEventType.LOAD || eventType == TriggerEventType.ADD) {
            if (!col.getBoolean("isjumplevel")) {
                this.setControlState(viewLockInfo, true);
            } else {
                this.setControlState(viewLockInfo, false);
            }
        }
        if (eventType == TriggerEventType.LOAD || eventType == TriggerEventType.PROCHANGE || eventType == TriggerEventType.ADD) {
            DynamicObject materielinv = col.getDynamicObject("materielinv");
            boolean enablelot = false;
            if (materielinv != null) {
                enablelot = materielinv.getBoolean("enablelot");
            }
            this.setEnable(viewLockInfo, materielinv != null && enablelot, "batchno");
            DynamicObject transactiontypeid = col.getDynamicObject("transactiontypeid");
            if (transactiontypeid != null) {
                this.setEnable(viewLockInfo, "D".equals(transactiontypeid.getString("producttype")), "rework");
                this.setEnable(viewLockInfo, transactiontypeid.getBoolean("isconsiderloss"), "wastagerateformula");
                this.setEnable(viewLockInfo, transactiontypeid.getBoolean("isconsiderloss"), "fixscrap");
                this.setEnable(viewLockInfo, transactiontypeid.getBoolean("isconsiderloss"), "scraprate");
            }
            this.lockMaterialField(viewLockInfo, col, colRow);
            this.lockUseratioField(viewLockInfo, col, colRow);
            this.setEnable(viewLockInfo, "B".equals(col.getString("overissuecontrl")), "issinhighlimit", "extraratioqty", "issinlowlimit", "lackraitioqty");
            this.lockLocationField(viewLockInfo, col, colRow);
            this.lockOutLocationField(viewLockInfo, col, colRow);
            this.lockFlushtimeField(viewLockInfo, col, colRow);
            this.setAuxpropLock(viewLockInfo, col, colRow);
            this.setIssueModeLock(viewLockInfo, col, colRow);
        }
        this.fireSetEnable(viewLockInfo, colRow);
    }

    protected void runRule(TriggerEventType eventType) {
        super.runRule(eventType);
        if (eventType == TriggerEventType.LOAD) {
            this.lockJumpLevelRowData();
        }
    }

    private void lockJumpLevelRowData() {
        DynamicObject stockEntry;
        int i;
        DynamicObjectCollection stockDymcol = (DynamicObjectCollection)this.getModel().getValue("entryentity");
        int size = stockDymcol.size();
        HashMap<Long, Integer> seqMap = new HashMap<Long, Integer>(size);
        boolean needLoop = false;
        HashSet<Integer> updateSeqSet = new HashSet<Integer>(16);
        DataEntityPropertyCollection treeEntryProperties = stockDymcol.getDynamicObjectType().getProperties();
        IDataEntityProperty property = (IDataEntityProperty)treeEntryProperties.get((Object)"parentseq");
        for (i = 0; i < size; ++i) {
            stockEntry = (DynamicObject)stockDymcol.get(i);
            if (stockEntry.getBoolean("isjumplevel")) {
                this.getView().setEnable(Boolean.FALSE, i, entryLockfields);
                this.getView().setEnable(Boolean.FALSE, i, entryfields);
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"batchno"});
            }
            stockEntry.set("parentseq", (Object)0);
            Long stockId = (Long)stockEntry.getPkValue();
            Long parentStockId = stockEntry.getLong("pstockentryid");
            int seq = stockEntry.getInt("seq");
            seqMap.put(stockId, seq);
            if (parentStockId == null || parentStockId.equals(0L)) continue;
            if (seqMap.containsKey(parentStockId)) {
                this.getModel().setValue("parentseq", seqMap.get(parentStockId), i);
                updateSeqSet.add(i);
                if (property == null) continue;
                stockEntry.getDataEntityState().setBizChanged(property.getOrdinal(), false);
                continue;
            }
            needLoop = true;
        }
        if (needLoop) {
            for (i = 0; i < size; ++i) {
                stockEntry = (DynamicObject)stockDymcol.get(i);
                Long parentStockId = stockEntry.getLong("pstockentryid");
                if (parentStockId == null || parentStockId.equals(0L) || !updateSeqSet.add(i)) continue;
                this.getModel().setValue("parentseq", seqMap.get(parentStockId), i);
                if (property == null) continue;
                stockEntry.getDataEntityState().setBizChanged(property.getOrdinal(), false);
            }
        }
    }

    private void setControlState(Map<String, Boolean> viewLockInfo, boolean flag) {
        this.setEnable(viewLockInfo, flag, "bomversion", "childauxpropertyid", "supplymode", "supplierid", "supplyorgid", "warehouseid", "location", "outorgunitid", "outwarehouseid", "outlocation", "issuemode", "isbackflush", "backflushtime", "iskeypart", "considerminbatch", "overissuecontrl", "issinhighlimit", "extraratioqty", "issinlowlimit", "lackraitioqty", "leadtime", "demanddate", "setuplocation", "childremarks", "rejectedqty", "feedingqty", "scrapqty", "wipqty", "useqty", "cansendqty", "isstockallot", "isbulkmaterial");
    }

    private void setEnable(Map<String, Boolean> viewLockInfo, boolean enable, String ... field) {
        if (field != null) {
            Arrays.asList(field).forEach(key -> viewLockInfo.put((String)key, enable));
        }
    }

    private void fireSetEnable(Map<String, Boolean> viewLockInfo, int changeRow) {
        if (viewLockInfo != null && viewLockInfo.size() > 0) {
            ArrayList trueList = new ArrayList(viewLockInfo.size());
            ArrayList falseList = new ArrayList(viewLockInfo.size());
            viewLockInfo.forEach((key, enable) -> {
                if (enable.booleanValue()) {
                    trueList.add(key);
                } else {
                    falseList.add(key);
                }
            });
            this.getView().setEnable(Boolean.valueOf(true), changeRow, trueList.toArray(new String[1]));
            this.getView().setEnable(Boolean.valueOf(false), changeRow, falseList.toArray(new String[1]));
        }
    }

    private void lockMaterialField(Map<String, Boolean> viewLockInfo, DynamicObject col, int changeRow) {
        DynamicObject replacePlan = col.getDynamicObject("replaceplan");
        boolean isBomExtend = col.getBoolean("isbomextend");
        boolean enable = replacePlan == null && !isBomExtend;
        this.setEnable(viewLockInfo, enable, "materialid");
        this.setEnable(viewLockInfo, enable, "qtytype");
        this.setEnable(viewLockInfo, enable, "bomreversion");
        this.setEnable(viewLockInfo, enable, "entryconfiguredcode");
    }

    private void lockUseratioField(Map<String, Boolean> viewLockInfo, DynamicObject col, int changeRow) {
        DynamicObject replacePlan = col.getDynamicObject("replaceplan");
        String pid = col.getString("pid");
        boolean enable = replacePlan != null && !"0".equals(pid);
        this.setEnable(viewLockInfo, enable, "useratio");
    }

    private void lockLocationField(Map<String, Boolean> viewLockInfo, DynamicObject col, int changeRow) {
        DynamicObject newObj = col.getDynamicObject("warehouseid");
        Long dyObjId = DyObjUtils.getDyObjId((Object)newObj);
        if (!DyObjUtils.isEmptyId((Long)dyObjId)) {
            long warehouseId = dyObjId;
            DynamicObject warehouse = WarehouseQueryHelper.getDataCacheByID((Object)warehouseId);
            boolean isopenlocation = warehouse.getBoolean("isopenlocation");
            if (isopenlocation && !col.getBoolean("isjumplevel")) {
                this.setEnable(viewLockInfo, Boolean.TRUE, "location");
            } else {
                this.setEnable(viewLockInfo, Boolean.FALSE, "location");
            }
        } else {
            this.setEnable(viewLockInfo, Boolean.FALSE, "location");
        }
    }

    private void lockOutLocationField(Map<String, Boolean> viewLockInfo, DynamicObject col, int changeRow) {
        DynamicObject newObj = col.getDynamicObject("outwarehouseid");
        if (newObj != null) {
            long warehouseId = (Long)newObj.getPkValue();
            DynamicObject warehouse = WarehouseQueryHelper.getDataCacheByID((Object)warehouseId);
            boolean isopenlocation = warehouse.getBoolean("isopenlocation");
            if (isopenlocation && !col.getBoolean("isjumplevel")) {
                this.setEnable(viewLockInfo, Boolean.TRUE, "outlocation");
            } else {
                this.setEnable(viewLockInfo, Boolean.FALSE, "outlocation");
            }
        } else {
            this.setEnable(viewLockInfo, Boolean.FALSE, "outlocation");
        }
    }

    private void lockFlushtimeField(Map<String, Boolean> viewLockInfo, DynamicObject col, int changeRow) {
        DynamicObject trandym = col.getDynamicObject("transactiontypeid");
        if (trandym != null && StringUtils.equals((CharSequence)"mpdm_transactout", (CharSequence)trandym.getDataEntityType().getName())) {
            this.setEnable(viewLockInfo, Boolean.FALSE, "backflushtime");
        } else if ("B".equals(col.get("isbackflush"))) {
            this.setEnable(viewLockInfo, Boolean.TRUE, "backflushtime");
        } else {
            this.setEnable(viewLockInfo, Boolean.FALSE, "backflushtime");
        }
    }

    private void setAuxpropLock(Map<String, Boolean> viewLockInfo, DynamicObject col, int changeRow) {
        DynamicObject materialMft = col.getDynamicObject("materialid");
        if (col.getBoolean("isjumplevel")) {
            return;
        }
        Boolean isbomextend = col.getBoolean("isbomextend");
        if (materialMft != null && !isbomextend.booleanValue()) {
            DynamicObject mateMft = materialMft;
            DynamicObject material = mateMft.getDynamicObject("masterid");
            material = MaterialQueryHelper.getDataCacheByID((Object)material.getPkValue());
            this.getView().setEnable(Boolean.TRUE, changeRow, new String[]{"isstockallot"});
            if (material != null) {
                boolean isuseauxpty = material.getBoolean("isuseauxpty");
                if (isuseauxpty) {
                    this.setEnable(viewLockInfo, Boolean.TRUE, "childauxpropertyid");
                } else {
                    this.setEnable(viewLockInfo, Boolean.FALSE, "childauxpropertyid");
                }
            }
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"childauxpropertyid"});
            if (!StringUtils.equals((CharSequence)"om_mftstock", (CharSequence)this.getTargetEntityName())) {
                this.setEnable(viewLockInfo, Boolean.FALSE, "isstockallot");
            }
        }
        this.isstockallotChange(viewLockInfo, col, changeRow);
        this.lockLimitQty(viewLockInfo, col, changeRow);
    }

    private void setIssueModeLock(Map<String, Boolean> viewLockInfo, DynamicObject col, int changeRow) {
        if (col.getBoolean("isbulkmaterial")) {
            this.setEnable(viewLockInfo, Boolean.FALSE, "issuemode");
        } else {
            this.setEnable(viewLockInfo, Boolean.TRUE, "issuemode");
        }
    }

    private void lockLimitQty(Map<String, Boolean> viewLockInfo, DynamicObject col, int changeRow) {
        if (col.getBoolean("iscannegative")) {
            col.set("issuemode", (Object)"C");
            col.set("isbackflush", (Object)"A");
            this.setEnable(viewLockInfo, Boolean.FALSE, "overissuecontrl");
            this.setEnable(viewLockInfo, Boolean.FALSE, "issuemode");
            this.setEnable(viewLockInfo, Boolean.FALSE, "isbackflush");
        } else {
            this.setEnable(viewLockInfo, Boolean.TRUE, "overissuecontrl");
            this.setEnable(viewLockInfo, Boolean.TRUE, "issuemode");
            this.setEnable(viewLockInfo, Boolean.TRUE, "isbackflush");
        }
    }

    private void isstockallotChange(Map<String, Boolean> viewLockInfo, DynamicObject col, int changeRow) {
        Boolean isstockallot = col.getBoolean("isstockallot");
        Boolean isbomextend = col.getBoolean("isbomextend");
        if (isstockallot.booleanValue()) {
            this.setEnable(viewLockInfo, Boolean.TRUE, "outorgunitid");
            this.setEnable(viewLockInfo, Boolean.TRUE, "outwarehouseid");
        } else {
            this.setEnable(viewLockInfo, Boolean.FALSE, "outorgunitid");
            this.setEnable(viewLockInfo, Boolean.FALSE, "outwarehouseid");
            this.setEnable(viewLockInfo, Boolean.FALSE, "outlocation");
        }
    }
}

