/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.formplugin.stock;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bd.mpdm.business.helper.MaterialInvInfoHelper;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bd.mpdm.common.query.helper.MaterialMftQueryHelper;
import kd.bd.mpdm.common.query.helper.MaterialPlanQueryHelper;
import kd.bd.mpdm.common.query.helper.MaterialQueryHelper;
import kd.bd.mpdm.common.query.helper.WarehouseQueryHelper;
import kd.bd.mpdm.common.stockchange.utils.EntityNameUtils;
import kd.bd.mpdm.common.utils.DyObjUtils;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.FieldEdit;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.mmc.pom.business.utils.MftStockReturnData;
import kd.mmc.pom.common.utils.PomBigDecimaUtil;

public class MftStockInitEdit
extends AbstractBillPlugIn {
    private static final String[] HEADFIELDS = new String[]{"actissueqtyfield", "rejectedqtyfield", "feedingqtyfield"};

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("stockentry");
        if (entryGrid.getSelectRows().length == 0) {
            return;
        }
        ChangeData cd = e.getChangeSet()[0];
        int rowIndex = cd.getRowIndex();
        if (this.isHeadField(propertyName) && (rowIndex = entryGrid.getSelectRows()[0]) == -1) {
            return;
        }
        Object isinitbill = this.getModel().getValue("isinitbill");
        if (isinitbill != null && Boolean.parseBoolean(isinitbill.toString())) {
            this.intiBillPropertyChanged(e);
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        IDataModel model = this.getModel();
        String entityKey = model.getDataEntityType().getName();
        if (!"om_mftstock".equals(entityKey) && !"pom_mftstock".equals(entityKey)) {
            return;
        }
        StringBuilder err = new StringBuilder();
        DynamicObject dataEntity = model.getDataEntity(true);
        boolean isinitbill = dataEntity.getBoolean("isinitbill");
        if (!isinitbill) {
            err.append(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5bfc\u5165\u201c\u521d\u59cb\u5316\u201d\u4e3a\u201c\u5426\u201d\u7684\u5355\u636e\u3002", (String)"MftStockInitEdit_0", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            ArrayList<String> errors = new ArrayList<String>(2);
            errors.add(err.toString());
            e.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), errors);
            return;
        }
        OrgRelationParam orgRelationParam = new OrgRelationParam();
        orgRelationParam.setOrgId(dataEntity.getDynamicObject("org").getLong("id"));
        orgRelationParam.setFromViewType("04");
        orgRelationParam.setIncludeSelf(true);
        orgRelationParam.setDirectViewType("toorg");
        orgRelationParam.setToViewType("05");
        orgRelationParam.setNumber("Production_TO_Inventory_S");
        List bizRelationOrgIds = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)orgRelationParam);
        DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection("stockentry");
        for (int i = 0; i < entryColl.size(); ++i) {
            DynamicObject orderEntry;
            DynamicObject entry = (DynamicObject)entryColl.get(i);
            int index = i;
            entry.set("seq", (Object)(i + 1));
            Object materialObj = entry.get("materialid");
            Object isbackflushObj = entry.get("isbackflush");
            Object warehouseidObj = entry.get("warehouseid");
            Object locationObj = entry.get("location");
            Object supplymodeObj = entry.get("supplymode");
            Object supplyorgidObj = entry.get("supplyorgid");
            Object supplieridObj = entry.get("supplierid");
            Object isstockallotObj = entry.get("isstockallot");
            Object outorgunitidObj = entry.get("outorgunitid");
            Object qtynumeratorObj = entry.get("qtynumerator");
            Object qtydenominatorObj = entry.get("qtydenominator");
            Object fixscrapObj = entry.get("fixscrap");
            Object wastagerateformulaObj = entry.get("wastagerateformula");
            Object scraprateObj = entry.get("scraprate");
            Object overissuecontrlObj = entry.get("overissuecontrl");
            Object qtytypeObj = entry.get("qtytype");
            Object iscannegativeObj = entry.get("iscannegative");
            Object outwarehouseidObj = entry.get("outwarehouseid");
            Object batchnoObj = entry.get("batchno");
            BigDecimal unissueqty = entry.getBigDecimal("unissueqty");
            BigDecimal actissueqty = entry.getBigDecimal("actissueqty");
            BigDecimal rejectedqty = entry.getBigDecimal("rejectedqty");
            BigDecimal feedingqty = entry.getBigDecimal("feedingqty");
            BigDecimal allotqty = entry.getBigDecimal("allotqty");
            boolean isbulkmaterial = entry.getBoolean("isbulkmaterial");
            entry.set("outqty", (Object)actissueqty);
            String sourceType = entry.getString("sourcetype");
            if ("B".equals(sourceType)) {
                if (materialObj == null) continue;
                this.change4material(materialObj, "materialunitid", true, index, index);
                this.change4material(materialObj, index, index);
                this.setDefault(index, index, materialObj);
                this.setAuxpropLock(materialObj, index, index);
                MPDMMftGenStocksUtils.change4qtyRes((String)"qtynumerator", (BigDecimal)((BigDecimal)this.getModel().getValue("qtynumerator", index)), (IDataModel)this.getModel(), (int)index, (int)index, (IFormView)this.getView());
            }
            if (isbackflushObj != null) {
                entry.set("isbackflush", isbackflushObj);
                MPDMMftGenStocksUtils.setbackflush((Object)isbackflushObj, (int)index, (IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)true);
            }
            if (StringUtils.isNotBlank((Object)supplymodeObj)) {
                entry.set("supplymode", supplymodeObj);
                this.setSupplyorgfield("", index);
            }
            if (supplyorgidObj != null) {
                if (bizRelationOrgIds.contains(((DynamicObject)supplyorgidObj).getLong("id"))) {
                    entry.set("supplyorgid", supplyorgidObj);
                    this.setMaterialInvInfo(index);
                    this.setSupplyorgfield("", index);
                } else {
                    err.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u7684\u201c\u4f9b\u8d27\u7ec4\u7ec7\u201d\uff0c\u4e0d\u5728\u53ef\u9009\u8303\u56f4\u4e4b\u5185\u3002", (String)"MftStockInitEdit_1", (String)"mmc-pom-formplugin", (Object[])new Object[0]), index + 1));
                }
            }
            if (isstockallotObj != null) {
                entry.set("isstockallot", isstockallotObj);
                this.isstockallotChange(index, index);
            }
            if (overissuecontrlObj != null) {
                entry.set("overissuecontrl", overissuecontrlObj);
                String overfield = overissuecontrlObj.toString();
                if ("B".equals(overfield)) {
                    MPDMMftGenStocksUtils.calHighQty((int)index, (IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)true);
                    MPDMMftGenStocksUtils.calLowQty((int)index, (IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)true);
                } else if ("A".equals(overfield)) {
                    this.clearLimitQty(index, index, "overissuecontrlfield");
                }
                MPDMMftGenStocksUtils.aculCanSendQty((int)index, (IDataModel)this.getModel(), (boolean)true);
            }
            if (qtytypeObj != null) {
                entry.set("qtytype", qtytypeObj);
                this.getModel().setValue("qtydenominator", (Object)BigDecimal.ONE, index);
                this.getModel().setValue("qtynumerator", (Object)BigDecimal.ZERO, index);
                this.getModel().setValue("standqty", (Object)BigDecimal.ZERO, index);
                this.getModel().setValue("demandqty", (Object)BigDecimal.ZERO, index);
                this.getModel().setValue("unissueqty", (Object)BigDecimal.ZERO, index);
            }
            if (((Boolean)iscannegativeObj).booleanValue()) {
                this.clearLimitQty(index, index, "iscannegative");
            }
            if (isbulkmaterial) {
                entry.set("isbulkmaterial", (Object)isbulkmaterial);
                entry.set("issuemode", (Object)"C");
            } else {
                entry.set("isbulkmaterial", (Object)isbulkmaterial);
            }
            if (warehouseidObj != null) {
                entry.set("warehouseid", warehouseidObj);
            }
            if (locationObj != null) {
                entry.set("location", locationObj);
            }
            if (supplieridObj != null) {
                entry.set("supplierid", supplieridObj);
                this.setSupplyorgfield("mustinput", index);
            }
            if (outorgunitidObj != null) {
                entry.set("outorgunitid", outorgunitidObj);
            }
            if (qtynumeratorObj instanceof BigDecimal) {
                entry.set("qtynumerator", qtynumeratorObj);
                MPDMMftGenStocksUtils.change4qtyRes((String)"qtynumerator", (BigDecimal)((BigDecimal)qtynumeratorObj), (IDataModel)this.getModel(), (int)index, (int)index, (IFormView)this.getView());
            }
            if (qtydenominatorObj instanceof BigDecimal) {
                entry.set("qtydenominator", qtydenominatorObj);
                MPDMMftGenStocksUtils.change4qtyRes((String)"qtydenominator", (BigDecimal)((BigDecimal)qtydenominatorObj), (IDataModel)this.getModel(), (int)index, (int)index, (IFormView)this.getView());
            }
            if (fixscrapObj instanceof BigDecimal) {
                entry.set("fixscrap", fixscrapObj);
                MPDMMftGenStocksUtils.change4qtyRes((String)"fixscrap", (BigDecimal)((BigDecimal)fixscrapObj), (IDataModel)this.getModel(), (int)index, (int)index, (IFormView)this.getView());
            }
            if (wastagerateformulaObj != null) {
                entry.set("wastagerateformula", wastagerateformulaObj);
                MPDMMftGenStocksUtils.change4qtyRes((String)"wastagerateformula", (BigDecimal)BigDecimal.ONE, (IDataModel)this.getModel(), (int)index, (int)index, (IFormView)this.getView());
            }
            if (scraprateObj instanceof BigDecimal) {
                entry.set("scraprate", scraprateObj);
                MPDMMftGenStocksUtils.change4qtyRes((String)"scraprate", (BigDecimal)((BigDecimal)scraprateObj), (IDataModel)this.getModel(), (int)index, (int)index, (IFormView)this.getView());
            }
            if (batchnoObj != null) {
                entry.set("batchno", batchnoObj);
            }
            if (outwarehouseidObj != null) {
                entry.set("outwarehouseid", outwarehouseidObj);
            }
            if (BigDecimal.ZERO.compareTo(actissueqty) < 0) {
                entry.set("actissueqty", (Object)actissueqty);
            }
            if (BigDecimal.ZERO.compareTo(rejectedqty) < 0) {
                entry.set("rejectedqty", (Object)rejectedqty);
            }
            if (BigDecimal.ZERO.compareTo(feedingqty) < 0) {
                entry.set("feedingqty", (Object)feedingqty);
            }
            if (BigDecimal.ZERO.compareTo(allotqty) < 0) {
                entry.set("allotqty", (Object)allotqty);
            }
            entry.set("unissueqty", MPDMMftGenStocksUtils.aculUnSendQty((DynamicObject)entry));
            entry.set("cansendqty", MPDMMftGenStocksUtils.aculCanSendQty((DynamicObject)entry));
            String ordername = "";
            String modelName = model.getDataEntityType().getName();
            if (EntityNameUtils.getAllStockChangeName().contains(modelName)) {
                orderEntry = (DynamicObject)model.getValue("entryorderentryid", index);
                ordername = EntityNameUtils.getEntityName((int)3, (int)0, (String)modelName);
            } else {
                orderEntry = (DynamicObject)model.getValue("orderentryid");
                ordername = EntityNameUtils.getEntityName((int)1, (int)0, (String)modelName);
            }
            if (orderEntry == null) continue;
            DynamicObject transactiontype = (DynamicObject)model.getValue("transactiontypeid");
            entry.set("useqty", (Object)MPDMMftGenStocksUtils.aculUseQty((DynamicObject)entry, (Object)orderEntry.getPkValue(), (DynamicObject)transactiontype, (String)ordername));
            BigDecimal wipqty = MPDMMftGenStocksUtils.aculWIPQty((DynamicObject)entry);
            entry.set("wipqty", (Object)wipqty);
        }
        int rowcount = model.getEntryRowCount("stockentry");
        MftStockReturnData returnData = new MftStockReturnData(rowcount, model).invoke(model);
        StringBuilder checkerr = returnData.getErr();
        err.append((CharSequence)checkerr);
        if (err.length() > 0) {
            e.setCancel(true);
            ArrayList<String> errors = new ArrayList<String>(2);
            errors.add(err.toString());
            e.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), errors);
        }
    }

    private void clearLimitQty(int changeIndex, int currentSelectIndex, String key) {
        Object demandqty = this.getModel().getValue("demandqty", changeIndex);
        this.getModel().setValue("issinhighlimit", (Object)BigDecimal.ZERO, changeIndex);
        this.getModel().setValue("extraratioqty", demandqty, changeIndex);
        this.getModel().setValue("issinlowlimit", (Object)BigDecimal.ZERO, changeIndex);
        this.getModel().setValue("lackraitioqty", demandqty, changeIndex);
        this.getModel().setValue("overissuecontrl", (Object)"A", changeIndex);
        boolean isShow = false;
        if (changeIndex == currentSelectIndex) {
            isShow = true;
            this.getModel().setValue("issinhighlimitfield", (Object)BigDecimal.ZERO);
            this.getModel().setValue("extraratioqtyfield", demandqty);
            this.getModel().setValue("issinlowlimitfield", (Object)BigDecimal.ZERO);
            this.getModel().setValue("lackraitioqtyfield", demandqty);
        }
        this.getModel().setValue("overissuecontrlfield", (Object)"A");
        this.lockLimitQty(changeIndex, currentSelectIndex);
        if (key.equals("iscannegative")) {
            if (((Boolean)this.getModel().getValue("iscannegative", changeIndex)).booleanValue()) {
                this.getModel().setValue("actissueqty", this.getModel().getValue("demandqty", changeIndex), changeIndex);
                if (changeIndex == currentSelectIndex) {
                    this.getModel().setValue("actissueqtyfield", this.getModel().getValue("demandqty", changeIndex));
                }
            } else {
                this.getModel().setValue("actissueqty", (Object)BigDecimal.ZERO, changeIndex);
                if (changeIndex == currentSelectIndex) {
                    this.getModel().setValue("actissueqtyfield", (Object)BigDecimal.ZERO);
                }
            }
        }
        MPDMMftGenStocksUtils.aculCanSendQty((int)changeIndex, (IDataModel)this.getModel(), (boolean)isShow);
        DynamicObject stockEntry = this.getModel().getEntryRowEntity("stockentry", changeIndex);
        DynamicObject orderEntry = EntityNameUtils.getAllStockChangeName().contains(this.getModel().getDataEntityType().getName()) ? (DynamicObject)this.getModel().getValue("entryorderentryid", changeIndex) : (DynamicObject)this.getModel().getValue("orderentryid");
        if (orderEntry == null) {
            return;
        }
        DynamicObject transactiontype = (DynamicObject)this.getModel().getValue("transactiontypeid");
        this.getModel().setValue("unissueqty", MPDMMftGenStocksUtils.aculUnSendQty((DynamicObject)stockEntry), changeIndex);
        String modelName = this.getModel().getDataEntityType().getName();
        String ordername = "";
        ordername = EntityNameUtils.getAllStockChangeName().contains(modelName) ? EntityNameUtils.getEntityName((int)3, (int)0, (String)modelName) : EntityNameUtils.getEntityName((int)1, (int)0, (String)modelName);
        stockEntry.set("useqty", (Object)MPDMMftGenStocksUtils.aculUseQty((DynamicObject)stockEntry, (Object)orderEntry.getPkValue(), (DynamicObject)transactiontype, (String)ordername));
        this.getModel().setValue("useqty", stockEntry.get("useqty"), changeIndex);
        if (changeIndex == currentSelectIndex) {
            this.getModel().setValue("useqtyfield", stockEntry.get("useqty"));
        }
        stockEntry.set("wipqty", (Object)MPDMMftGenStocksUtils.aculWIPQty((DynamicObject)stockEntry));
        this.getModel().setValue("wipqty", stockEntry.get("wipqty"), changeIndex);
        if (changeIndex == currentSelectIndex) {
            this.getModel().setValue("wipqtyfield", stockEntry.get("wipqty"));
        }
    }

    private void isstockallotChange(int changeIndex, int currentSelectIndex) {
        Boolean isstockallot = (Boolean)this.getModel().getValue("isstockallot", changeIndex);
        Boolean isbomextend = (Boolean)this.getModel().getValue("isbomextend", changeIndex);
        if (changeIndex == currentSelectIndex) {
            if (isstockallot.booleanValue()) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"outorgunitfield"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"outwarehousefield"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"outorgunitfield"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"outwarehousefield"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"outlocationfield"});
            }
        }
        if (ObjectUtils.isEmpty((Object)isstockallot) || ObjectUtils.isEmpty((Object)isbomextend)) {
            return;
        }
        if (!isbomextend.booleanValue() && !isstockallot.booleanValue()) {
            this.getModel().setValue("outorgunitid", null, changeIndex);
            this.getModel().setValue("outwarehouseid", null, changeIndex);
            this.getModel().setValue("outlocation", null, changeIndex);
            if (changeIndex == currentSelectIndex) {
                this.getModel().setValue("outorgunitfield", null);
                this.getModel().setValue("outwarehousefield", null);
                this.getModel().setValue("outlocationfield", null);
            }
        }
    }

    private void setMaterialInvInfo(int changeIndex) {
        DynamicObject mtfOrg = (DynamicObject)this.getModel().getValue("supplyorgid", changeIndex);
        DynamicObject materialMft = (DynamicObject)this.getModel().getValue("materialid", changeIndex);
        if (materialMft != null) {
            this.getModel().setValue("materielinv", (Object)MaterialInvInfoHelper.getMaterialInvInfo((DynamicObject)mtfOrg, (DynamicObject)materialMft.getDynamicObject("masterid")), changeIndex);
        }
    }

    private void setSupplyorgfield(String string, int currentSelectIndex) {
        int currentIndex = this.getSelectEntryRowIndex();
        String supplyfield = (String)this.getModel().getValue("supplymode", currentSelectIndex);
        FieldEdit s = (FieldEdit)this.getView().getControl("supplierfield");
        DynamicObject sypplyorgfield = (DynamicObject)this.getModel().getValue("supplyorgid", currentSelectIndex);
        if ("bos_org".equals(supplyfield)) {
            if (currentIndex != -1) {
                s.setMustInput(true);
            }
            if (!"mustinput".equals(string) && sypplyorgfield != null) {
                ArrayList<Object> array = new ArrayList<Object>();
                Long orgId = (Long)sypplyorgfield.getPkValue();
                List ownerArray = MPDMMftGenStocksUtils.getOwners((Long)orgId);
                array.addAll(ownerArray);
                if (((Boolean)sypplyorgfield.get("fisaccounting")).booleanValue()) {
                    array.add(sypplyorgfield.getPkValue());
                }
                if (!array.isEmpty()) {
                    if (currentIndex != -1) {
                        this.getModel().setValue("supplierfield", array.get(0));
                    }
                    this.getModel().setValue("supplierid", array.get(0), currentSelectIndex);
                } else {
                    if (currentIndex != -1) {
                        this.getModel().setValue("supplierfield", null);
                    }
                    this.getModel().setValue("supplierid", null, currentSelectIndex);
                }
            }
        } else if (currentIndex != -1) {
            s.setMustInput(false);
        }
    }

    private int getSelectEntryRowIndex() {
        int currentEntryIndex = -1;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("stockentry");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            currentEntryIndex = selectRows[0];
        }
        return currentEntryIndex;
    }

    private void setAuxpropLock(Object materialMft, int changeIndex, int currentSelectIndex) {
        if (this.isJumpLevel(changeIndex)) {
            return;
        }
        Boolean isbomextend = (Boolean)this.getModel().getValue("isbomextend", changeIndex);
        if (changeIndex == currentSelectIndex) {
            if (materialMft != null && !isbomextend.booleanValue()) {
                DynamicObject mateMft = (DynamicObject)materialMft;
                DynamicObject material = mateMft.getDynamicObject("masterid");
                material = MaterialQueryHelper.getDataCacheByID((Object)material.getPkValue());
                this.getView().setEnable(Boolean.TRUE, new String[]{"isstockallotfield"});
                if (material != null) {
                    boolean isuseauxpty = material.getBoolean("isuseauxpty");
                    if (isuseauxpty) {
                        this.getView().setEnable(Boolean.TRUE, new String[]{"auxpropertyfield"});
                    } else {
                        this.getView().setEnable(Boolean.FALSE, new String[]{"auxpropertyfield"});
                    }
                }
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"auxpropertyfield"});
                if (!StringUtils.equals((CharSequence)"om_mftstock", (CharSequence)this.getModel().getDataEntityType().getName())) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"isstockallotfield"});
                }
            }
            BigDecimal canqty = (BigDecimal)this.getModel().getValue("cansendqty", changeIndex);
            if (canqty.compareTo(BigDecimal.ZERO) < 0) {
                this.getModel().setValue("cansendqtyfield", (Object)0);
            }
        }
        this.isstockallotChange(changeIndex, currentSelectIndex);
        this.lockLimitQty(changeIndex, currentSelectIndex);
    }

    private void lockLimitQty(int changeIndex, int currentSelectIndex) {
        if (((Boolean)this.getModel().getValue("iscannegative", changeIndex)).booleanValue()) {
            this.getModel().setValue("issuemode", (Object)"C", changeIndex);
            this.getModel().setValue("isbackflush", (Object)"A", changeIndex);
            if (changeIndex == currentSelectIndex) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"overissuecontrlfield"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"issuemodefield"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"backflushfield"});
                this.getModel().setValue("issuemodefield", (Object)"C");
                this.getModel().setValue("backflushfield", (Object)"A");
            }
        } else if (changeIndex == currentSelectIndex) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"overissuecontrlfield"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"issuemodefield"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"backflushfield"});
        }
    }

    public boolean isJumpLevel(int rowIndex) {
        if (rowIndex == -1) {
            return false;
        }
        return (Boolean)this.getModel().getValue("isjumplevel", rowIndex);
    }

    private void change4material(Object newObj, int changeIndex, int currentSelectIndex) {
        this.getModel().setValue("entryconfiguredcode", null, changeIndex);
        if (newObj == null) {
            this.getModel().setValue("isbackflush", (Object)"A", changeIndex);
            this.getModel().setValue("iskeypart", (Object)Boolean.FALSE, changeIndex);
            this.getModel().setValue("overissuecontrl", (Object)"B", changeIndex);
            this.getModel().setValue("issinhighlimit", (Object)BigDecimal.ZERO, changeIndex);
            this.getModel().setValue("extraratioqty", (Object)BigDecimal.ZERO, changeIndex);
            this.getModel().setValue("issinlowlimit", (Object)BigDecimal.ZERO, changeIndex);
            this.getModel().setValue("lackraitioqty", (Object)BigDecimal.ZERO, changeIndex);
            if (changeIndex == currentSelectIndex) {
                this.getModel().setValue("materielfield", null);
                this.getModel().setValue("backflushfield", (Object)Boolean.FALSE);
                this.getModel().setValue("iskeypartfield", (Object)Boolean.FALSE);
                this.getModel().setValue("overissuecontrlfield", (Object)"B");
                this.getModel().setValue("issinhighlimitfield", (Object)BigDecimal.ZERO);
                this.getModel().setValue("extraratioqtyfield", (Object)BigDecimal.ZERO);
                this.getModel().setValue("issinlowlimitfield", (Object)BigDecimal.ZERO);
                this.getModel().setValue("lackraitioqtyfield", (Object)BigDecimal.ZERO);
            }
        } else {
            String changetype = "A";
            if (StringUtils.equals((CharSequence)changetype, (CharSequence)"A")) {
                String isquotacontrol;
                DynamicObject mtfmaterial = (DynamicObject)newObj;
                this.getModel().setValue("isbackflush", mtfmaterial.get("isbackflush"), changeIndex);
                this.getModel().setValue("iskeypart", mtfmaterial.get("iskeypart"), changeIndex);
                BigDecimal issinhighlimit = mtfmaterial.get("issinhighlimit") == null ? BigDecimal.ZERO : mtfmaterial.getBigDecimal("issinhighlimit");
                this.getModel().setValue("issinhighlimit", (Object)issinhighlimit, changeIndex);
                BigDecimal demandQty = (BigDecimal)this.getModel().getValue("demandqty");
                BigDecimal extraratioqty = demandQty.multiply(BigDecimal.ONE.add(issinhighlimit.divide(BigDecimal.valueOf(100L), 4, 4)));
                this.getModel().setValue("extraratioqty", (Object)extraratioqty, changeIndex);
                BigDecimal issinlowlimit = mtfmaterial.get("issinlowlimit") == null ? BigDecimal.ZERO : mtfmaterial.getBigDecimal("issinlowlimit");
                this.getModel().setValue("issinlowlimit", (Object)issinlowlimit, changeIndex);
                BigDecimal lackraitioqty = demandQty.multiply(BigDecimal.ONE.subtract(issinlowlimit.divide(BigDecimal.valueOf(100L), 4, 4)));
                this.getModel().setValue("lackraitioqty", (Object)lackraitioqty, changeIndex);
                if (changeIndex == currentSelectIndex) {
                    this.getModel().setValue("materielfield", (Object)mtfmaterial);
                    this.getModel().setValue("backflushfield", mtfmaterial.get("isbackflush"));
                    this.getModel().setValue("iskeypartfield", mtfmaterial.get("iskeypart"));
                    this.getModel().setValue("issinhighlimitfield", (Object)issinhighlimit);
                    this.getModel().setValue("extraratioqtyfield", (Object)extraratioqty);
                    this.getModel().setValue("issinlowlimitfield", (Object)issinlowlimit);
                    this.getModel().setValue("lackraitioqtyfield", (Object)lackraitioqty);
                }
                String string = isquotacontrol = mtfmaterial.get("isquotacontrol") == null ? "" : mtfmaterial.getString("isquotacontrol");
                if (StringUtils.equals((CharSequence)isquotacontrol, (CharSequence)"true")) {
                    this.getModel().setValue("overissuecontrl", (Object)"B", changeIndex);
                    if (changeIndex == currentSelectIndex) {
                        this.getModel().setValue("overissuecontrlfield", (Object)"B");
                    }
                } else {
                    this.getModel().setValue("overissuecontrl", (Object)"A", changeIndex);
                    if (changeIndex == currentSelectIndex) {
                        this.getModel().setValue("overissuecontrlfield", (Object)"A");
                    }
                }
            }
        }
    }

    private void intiBillPropertyChanged(PropertyChangedArgs e) {
        String name;
        IDataEntityProperty property = e.getProperty();
        switch (name = property.getName()) {
            case "actissueqtyfield": 
            case "rejectedqtyfield": 
            case "feedingqtyfield": {
                this.calculateQty();
                break;
            }
        }
    }

    private void calculateQty() {
        if ("true".equals(this.getPageCache().get("isIgnoreChangeMftstock"))) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("stockentry");
        if (entryGrid.getSelectRows().length == 0) {
            return;
        }
        int entryIndex = entryGrid.getSelectRows()[0];
        if (entryIndex == -1) {
            return;
        }
        this.getPageCache().put("isIgnoreChangeMftstock", "true");
        BigDecimal extraratioqtyfield = PomBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("extraratioqtyfield"));
        BigDecimal demandqtyfield = PomBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("demandqtyfield"));
        BigDecimal actissueqtyfield = PomBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("actissueqtyfield"));
        BigDecimal rejectedqtyfield = PomBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("rejectedqtyfield"));
        BigDecimal feedingqtyfield = PomBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("feedingqtyfield"));
        BigDecimal unissueQty = demandqtyfield.subtract(actissueqtyfield).add(rejectedqtyfield).subtract(feedingqtyfield);
        BigDecimal cansendqty = extraratioqtyfield.subtract(actissueqtyfield).add(rejectedqtyfield).subtract(feedingqtyfield);
        this.getModel().setValue("cansendqtyfield", (Object)cansendqty);
        this.getModel().setValue("outqty", (Object)actissueqtyfield, entryIndex);
        this.getModel().setValue("unissueqty", (Object)unissueQty, entryIndex);
        this.getModel().setValue("actissueqty", (Object)actissueqtyfield, entryIndex);
        this.getModel().setValue("rejectedqty", (Object)rejectedqtyfield, entryIndex);
        this.getModel().setValue("feedingqty", (Object)feedingqtyfield, entryIndex);
        this.getModel().setValue("cansendqty", (Object)cansendqty, entryIndex);
        DynamicObject orderEntry = (DynamicObject)this.getModel().getValue("orderentryid");
        if (orderEntry != null) {
            DynamicObject entry = this.getModel().getEntryRowEntity("stockentry", entryIndex);
            DynamicObject transactiontype = (DynamicObject)this.getModel().getValue("transactiontypeid");
            BigDecimal useQty = MPDMMftGenStocksUtils.aculUseQty((DynamicObject)entry, (Object)orderEntry.getPkValue(), (DynamicObject)transactiontype, (String)"om_mftorder");
            this.getModel().setValue("useqtyfield", (Object)useQty);
            this.getModel().setValue("useqty", (Object)useQty, entryIndex);
            BigDecimal wipqty = MPDMMftGenStocksUtils.aculWIPQty((DynamicObject)entry);
            this.getModel().setValue("wipqtyfield", (Object)wipqty);
            this.getModel().setValue("wipqty", (Object)wipqty, entryIndex);
        }
        this.getPageCache().put("isIgnoreChangeMftstock", "false");
    }

    private void setDefault(int changeIndex, int currentSelectIndex, Object newObj) {
        if (newObj != null) {
            DynamicObject material = (DynamicObject)newObj;
            DynamicObject materialinfo = MaterialMftQueryHelper.getDataCacheByID((Object)material.getPkValue());
            DynamicObject masterid = materialinfo.getDynamicObject("masterid");
            this.getModel().setValue("materielmasterid", (Object)masterid, changeIndex);
            QFilter filter = new QFilter("masterid", "=", masterid.getPkValue());
            filter.and(new QFilter("status", "=", (Object)"C"));
            filter.and(new QFilter("enable", "=", (Object)"1"));
            DynamicObject mtfOrg = (DynamicObject)this.getModel().getValue("org");
            if (mtfOrg == null) {
                return;
            }
            DynamicObject loadSingle = MaterialPlanQueryHelper.getDataCacheByMaterialID((Long)masterid.getLong("id"), (Long)mtfOrg.getLong("id"), null);
            String wastagerateformula = "B";
            DynamicObject tran = (DynamicObject)this.getModel().getValue("transactiontypeid");
            boolean s = false;
            if (tran != null) {
                s = tran.getBoolean("isconsiderloss");
            }
            if (loadSingle != null) {
                wastagerateformula = loadSingle.getString("wastagerateformula");
            } else if (!s) {
                wastagerateformula = "";
            }
            this.getModel().setValue("wastagerateformula", (Object)wastagerateformula, changeIndex);
            this.getModel().setValue("supplyorgid", materialinfo.get("supplyorgunitid"), changeIndex);
            this.setMaterialInvInfo(changeIndex);
            this.getPageCache().put("isIgnoreChangeMftstock", "true");
            this.getModel().setValue("isbulkmaterial", materialinfo.get("isbulkmaterial"), changeIndex);
            this.getModel().setValue("isstockallot", materialinfo.get("isstockallot"), changeIndex);
            this.getModel().setValue("outorgunitid", materialinfo.get("outstorageunit"), changeIndex);
            this.getModel().setValue("outwarehouseid", materialinfo.get("outwarehouse"), changeIndex);
            this.getModel().setValue("outlocation", materialinfo.get("outwarelocation"), changeIndex);
            String modestring = MPDMMftGenStocksUtils.getIssuemode((Object)materialinfo.get("issuemode"));
            this.getModel().setValue("issuemode", (Object)modestring, changeIndex);
            this.getModel().setValue("batchno", null, changeIndex);
            this.getModel().setValue("lot", null, changeIndex);
            this.getModel().setValue("isbackflush", materialinfo.get("isbackflush"), changeIndex);
            this.getModel().setValue("warehouseid", materialinfo.get("warehouse"), changeIndex);
            this.getModel().setValue("location", materialinfo.get("location"), changeIndex);
            String entityName = this.getModel().getDataEntityType().getName();
            if (StringUtils.equals((CharSequence)entityName, (CharSequence)"pom_mftstock") || StringUtils.equals((CharSequence)entityName, (CharSequence)"pom_xmftstock")) {
                MPDMMftGenStocksUtils.setStockEntryWarehouse((DynamicObject)mtfOrg, (String)entityName, (IDataModel)this.getModel(), (int)changeIndex);
            }
            DynamicObject product = (DynamicObject)this.getModel().getValue("productid");
            if (EntityNameUtils.getAllStockChangeName().contains(this.getModel().getDataEntityType().getName())) {
                product = (DynamicObject)this.getModel().getValue("productno", changeIndex);
            }
            this.getModel().setValue("rework", (Object)"false", changeIndex);
            if (material != null && product != null && material.getPkValue().equals(product.getPkValue())) {
                this.getModel().setValue("rework", (Object)"true", changeIndex);
            }
            MPDMMftGenStocksUtils.setbackflush((Object)materialinfo.get("isbackflush"), (int)changeIndex, (IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)true);
            this.setSupplyorgfield("", changeIndex);
            if (changeIndex == currentSelectIndex) {
                this.getModel().setValue("supplyorgfield", materialinfo.get("supplyorgunitid"));
                this.getModel().setValue("isbulkmaterialfield", materialinfo.get("isbulkmaterial"));
                this.getModel().setValue("isstockallotfield", materialinfo.get("isstockallot"));
                this.getModel().setValue("warehousefield", this.getModel().getValue("warehouseid", changeIndex));
                this.lockLocationField(this.getModel().getValue("warehouseid", changeIndex), changeIndex);
                this.getModel().setValue("locationfield", this.getModel().getValue("location", changeIndex));
                this.getModel().setValue("outorgunitfield", materialinfo.get("outstorageunit"));
                this.getModel().setValue("outwarehousefield", materialinfo.get("outwarehouse"));
                this.lockOutLocationField(materialinfo.get("outwarehouse"), changeIndex);
                this.getModel().setValue("outlocationfield", materialinfo.get("outwarelocation"));
                this.getModel().setValue("issuemodefield", (Object)modestring);
                this.getModel().setValue("backflushfield", materialinfo.get("isbackflush"));
            }
        }
    }

    private void lockOutLocationField(Object newObj, int changeIndex) {
        if (newObj != null) {
            long warehouseId = (Long)((DynamicObject)newObj).getPkValue();
            DynamicObject warehouse = WarehouseQueryHelper.getDataCacheByID((Object)warehouseId);
            boolean isopenlocation = warehouse.getBoolean("isopenlocation");
            if (isopenlocation && !this.isJumpLevel(changeIndex)) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"outlocationfield"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"outlocationfield"});
            }
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"outlocationfield"});
        }
    }

    private void lockLocationField(Object newObj, int changeIndex) {
        Long dyObjId = DyObjUtils.getDyObjId((Object)newObj);
        if (!DyObjUtils.isEmptyId((Long)dyObjId)) {
            long warehouseId = dyObjId;
            DynamicObject warehouse = WarehouseQueryHelper.getDataCacheByID((Object)warehouseId);
            boolean isopenlocation = warehouse.getBoolean("isopenlocation");
            if (isopenlocation && !this.isJumpLevel(changeIndex)) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"locationfield"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"locationfield"});
            }
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"locationfield"});
        }
    }

    private void change4material(Object newObj, String destObject, boolean isEntry, int changeIndex, int currentSelectIndex) {
        if (newObj == null) {
            if (isEntry) {
                this.getModel().setValue(destObject, null, changeIndex);
                this.getModel().setValue("materialunitidfield", null);
                this.getModel().setValue("batchno", null, changeIndex);
                this.getModel().setValue("lot", null, changeIndex);
                if (changeIndex == currentSelectIndex) {
                    this.getModel().setValue("batchnofield", null);
                }
            } else {
                this.getModel().setValue(destObject, null);
            }
        } else {
            DynamicObject mateMft = (DynamicObject)newObj;
            DynamicObject material = mateMft.getDynamicObject("masterid");
            DynamicObject baseunit = (material = MaterialQueryHelper.getDataCacheByID((Object)material.getPkValue())).getDynamicObject("baseunit");
            if (baseunit != null && isEntry) {
                this.getModel().setValue(destObject, null, changeIndex);
                this.getModel().setValue(destObject, (Object)baseunit, changeIndex);
                if (changeIndex == currentSelectIndex) {
                    this.getModel().setValue("materialunitidfield", null);
                    this.getModel().setValue("materialunitidfield", baseunit.get("id"));
                }
            }
        }
    }

    private boolean isHeadField(String fieldname) {
        List<String> headfields = Arrays.asList(HEADFIELDS);
        return headfields.contains(fieldname);
    }
}

