/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.formplugin.stock;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.mftorder.utils.CreateStockByBomUtils;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bd.mpdm.common.query.mservice.helper.MsBomQueryHelper;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class StockBOMQueryPlugin
extends AbstractFormPlugin
implements SearchEnterListener {
    private static String[] strName = new String[]{"level", "materialmftinfo", "material", "bomreversion", "configuredcode", "baseunit", "qtynumerator", "qtydenominator", "qtytype", "standqty", "auxproperty"};
    private static String entry = "stockbomentry";
    private static String ExpendResult = "expendResult";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String bomIdStr = (String)formShowParameter.getCustomParam("bomIdStr");
        BigDecimal qty = (BigDecimal)formShowParameter.getCustomParam("qty");
        Long bomID = Long.parseLong(bomIdStr);
        Long routeId = 0L;
        Date expendbomtime = new Date();
        if (StringUtils.isNotBlank((CharSequence)bomIdStr) && BigDecimal.ZERO.compareTo(qty) <= 0) {
            JSONArray filterArray = new JSONArray(16);
            JSONObject bomFilterJson = CreateStockByBomUtils.getBomFilterJsonType((Long)bomID, (BigDecimal)qty, (Date)expendbomtime, (String)"A", (Long)routeId);
            filterArray.add((Object)bomFilterJson);
            String reskey = CreateStockByBomUtils.getBomFilterStrType((Long)bomID, (BigDecimal)qty, (Date)expendbomtime, (String)"A", (Long)routeId);
            String result = CreateStockByBomUtils.getQueryDataRes((String)filterArray.toString());
            if (result.indexOf("true") >= 0) {
                this.getPageCache().put(ExpendResult, reskey);
                this.fillEntry(null, null);
            }
        }
    }

    private void fillEntry(String filterValue, List<String> fieldNames) {
        String resKey = this.getPageCache().get(ExpendResult);
        if (StringUtils.isEmpty((CharSequence)resKey)) {
            return;
        }
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("mmc-fmm-bomsearch");
        String res = (String)cache.get(resKey);
        if (StringUtils.isEmpty((CharSequence)res)) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        BigDecimal qty = (BigDecimal)formShowParameter.getCustomParam("qty");
        BigDecimal useratio = (BigDecimal)formShowParameter.getCustomParam("useratio");
        JSONArray resArray = JSONArray.parseArray((String)res);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (String str : strName) {
            vs.addField(str, new Object[0]);
        }
        HashSet<Long> bomEntryIdSet = new HashSet<Long>(resArray.size());
        HashSet<Object> materialid = new HashSet<Object>(resArray.size());
        if (resArray != null) {
            for (int i = 0; i < resArray.size(); ++i) {
                JSONObject resJson = (JSONObject)resArray.get(i);
                bomEntryIdSet.add(resJson.getLong("entry_Id"));
                materialid.add(resJson.get((Object)"entrymaterialId"));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)filterValue) && !CollectionUtils.isEmpty(fieldNames)) {
            this.setFastFilter(filterValue, fieldNames, resArray, materialid);
        }
        Map bomEntryMap = MsBomQueryHelper.getBomEntryFromCache(bomEntryIdSet);
        for (int i = 0; i < resArray.size(); ++i) {
            JSONObject resJson = (JSONObject)resArray.get(i);
            DynamicObject bomEntry = (DynamicObject)bomEntryMap.get(resJson.getLong("entry_Id"));
            DynamicObject entryunit = bomEntry.getDynamicObject("entryunit");
            String qtytype = resJson.get((Object)"entryqtytype") == null ? "A" : resJson.getString("entryqtytype");
            BigDecimal numerator = resJson.getBigDecimal("entryqtynumerator");
            BigDecimal denominator = resJson.getBigDecimal("entryqtydenominator");
            BigDecimal standQty = MPDMMftGenStocksUtils.calculateStandQty((DynamicObject)entryunit, (String)qtytype, (BigDecimal)useratio, (BigDecimal)qty, (BigDecimal)numerator, (BigDecimal)denominator);
            vs.addRow(new Object[]{resJson.getString("level"), resJson.get((Object)"entrymaterialInfo"), resJson.get((Object)"entrymaterialId"), resJson.get((Object)"bomVer"), resJson.get((Object)"configCode"), resJson.get((Object)"entryunit"), numerator, denominator, qtytype, standQty, resJson.get((Object)"entryauxproperty")});
        }
        model.beginInit();
        model.deleteEntryData(entry);
        model.batchCreateNewEntryRow(entry, vs);
        model.endInit();
        this.getView().updateView(entry);
    }

    private void setFastFilter(String filterValue, List<String> fieldNames, JSONArray resArray, Set<Object> materialid) {
        QFilter filter = new QFilter("id", "in", materialid);
        for (int i = 0; i < fieldNames.size(); ++i) {
            String filterField = fieldNames.get(i);
            if (i == 0) {
                filter.and(new QFilter(filterField, "ftlike", (Object)filterValue));
                continue;
            }
            filter.or(new QFilter(filterField, "ftlike", (Object)filterValue));
        }
        Map material = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"id,maseterid", (QFilter[])filter.toArray());
        if (material == null || material.size() < 1) {
            resArray.clear();
        } else {
            Set materialids = material.keySet();
            JSONArray clone = (JSONArray)resArray.clone();
            resArray.clear();
            for (int i = 0; i < clone.size(); ++i) {
                JSONObject resJson = (JSONObject)clone.get(i);
                Object entrymaterialId = resJson.get((Object)"entrymaterialId");
                if (!materialids.contains(entrymaterialId)) continue;
                resArray.add((Object)resJson);
            }
        }
    }

    public void search(SearchEnterEvent e) {
        Search source = (Search)e.getSource();
        String value = e.getText();
        List fieldNames = e.getFieldNames();
        this.fillEntry(value, fieldNames);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)"btnok", (CharSequence)control.getKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entry);
            int[] selects = entryGrid.getSelectRows();
            if (selects.length > 0) {
                ArrayList<DynamicObject> returnList = new ArrayList<DynamicObject>(selects.length);
                for (int i = 0; i < selects.length; ++i) {
                    DynamicObject entryObject = this.getModel().getEntryRowEntity(entry, entryGrid.getSelectRows()[i]);
                    if (null == entry) continue;
                    returnList.add(entryObject);
                }
                this.getView().returnDataToParent(returnList);
                this.getView().close();
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8fd4\u56de\u6570\u636e\u884c\u3002", (String)"StockBOMQueryPlugin_0", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
        }
    }
}

