/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.formplugin.stock;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.mmc.pom.business.orderrestructure.OrderRestructureService;

public class StockBOMSelectPlugin
extends AbstractBillPlugIn {
    private String BOMSetect = "bomselect";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)this.BOMSetect, (CharSequence)operateKey)) {
            DynamicObject bom;
            BigDecimal qty = (BigDecimal)this.getModel().getValue("qty");
            if (qty.compareTo(BigDecimal.ZERO) <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u91cf\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"StockBOMSelectPlugin_0", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if (null == (bom = (DynamicObject)this.getModel().getValue("bomid"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355bom\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"StockBOMSelectPlugin_1", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        IBillModel model = (IBillModel)this.getModel();
        DynamicObject bom = (DynamicObject)model.getValue("bomid");
        String bomIdStr = "";
        if (bom != null) {
            bomIdStr = bom.getString("id");
        }
        BigDecimal qty = (BigDecimal)model.getValue("qty");
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        if (StringUtils.equals((CharSequence)this.BOMSetect, (CharSequence)key)) {
            boolean isSuccess = e.getOperationResult().isSuccess();
            if (!isSuccess) {
                return;
            }
            int currentRow = model.getEntryCurrentRowIndex("stockentry");
            BigDecimal useratio = ((BigDecimal)model.getValue("useratio", currentRow)).divide(new BigDecimal("100"), 4, 4);
            String formId = "pom_bomquery";
            FormShowParameter showParameter = OrderRestructureService.importBom((String)"BOM", (IFormPlugin)this, (String)key, (String)formId);
            showParameter.getCustomParams().put("bomIdStr", bomIdStr);
            showParameter.getCustomParams().put("qty", qty);
            showParameter.getCustomParams().put("useratio", useratio);
            this.getView().showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        IBillModel model = (IBillModel)this.getModel();
        String actionId = e.getActionId();
        Object returnDataObj = e.getReturnData();
        if (this.BOMSetect.equals(actionId)) {
            if (returnDataObj instanceof List) {
                List returnDatas = (List)returnDataObj;
                for (int i = 0; i < returnDatas.size(); ++i) {
                    DynamicObject returnData = (DynamicObject)returnDatas.get(i);
                    int currentRow = model.getEntryCurrentRowIndex("stockentry");
                    Object material = this.getModel().getValue("materialid", currentRow);
                    if (i == 0 && material == null) {
                        model.setValue("materialid", returnData.get("materialmftinfo"), currentRow);
                        model.setValue("isbomextend", (Object)false, currentRow);
                        model.setValue("qtynumerator", returnData.get("qtynumerator"), currentRow);
                        model.setValue("qtydenominator", returnData.get("qtydenominator"), currentRow);
                        continue;
                    }
                    int newEntryRow = model.createNewEntryRow("stockentry");
                    model.setValue("materialid", returnData.get("materialmftinfo"), newEntryRow);
                    model.setValue("isbomextend", (Object)false, newEntryRow);
                    model.setValue("qtynumerator", returnData.get("qtynumerator"), newEntryRow);
                    model.setValue("qtydenominator", returnData.get("qtydenominator"), newEntryRow);
                }
            }
            this.getView().updateView();
        }
    }
}

