/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.prop.opplugin.botp;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.manuftech.ManuftechUtil;
import kd.bd.mpdm.common.poromanuftech.utils.PropManuftechCreateBillUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropMftOrderToPropManFtechOp
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(PropMftOrderToPropManFtechOp.class);

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntitySet targetExtDataEntitySet = e.getTargetExtDataEntitySet();
        String tgtMainType = this.getTgtMainType().toString();
        ExtendedDataEntity[] entities = targetExtDataEntitySet.FindByEntityKey(tgtMainType);
        HashSet<Long> orgIds = new HashSet<Long>(entities.length);
        HashSet<Object> sets = new HashSet<Object>(entities.length);
        HashSet<Object> proGrammeIds = new HashSet<Object>(entities.length);
        HashMap entryMap = new HashMap(16);
        for (ExtendedDataEntity extendedDataEntity : entities) {
            if (extendedDataEntity.getDataEntity().getDynamicObject("mftentryseq") != null) {
                sets.add(extendedDataEntity.getDataEntity().getDynamicObject("mftentryseq").getPkValue());
                if (extendedDataEntity.getDataEntity().getDynamicObject("programme") != null) {
                    proGrammeIds.add(extendedDataEntity.getDataEntity().getDynamicObject("programme").getPkValue());
                }
            }
            if (extendedDataEntity.getDataEntity().getDynamicObject("org") == null) continue;
            orgIds.add(extendedDataEntity.getDataEntity().getDynamicObject("org").getLong("id"));
        }
        PropManuftechCreateBillUtil.getOrderEntityMap((String)this.getSrcMainType().getName(), sets, entryMap);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"fmm_programe");
        DynamicObject[] programmes = BusinessDataServiceHelper.load((Object[])proGrammeIds.toArray(), (DynamicObjectType)dataEntityType);
        HashMap<Object, DynamicObject> objectDynamicObjectMap = new HashMap<Object, DynamicObject>(16);
        for (DynamicObject dynamicObject : programmes) {
            objectDynamicObjectMap.put(dynamicObject.getPkValue(), dynamicObject);
        }
        for (ExtendedDataEntity extendedDataEntity : entities) {
            DynamicObject entity = extendedDataEntity.getDataEntity();
            PropMftOrderToPropManFtechOp.putHeadData(entity);
            DynamicObject orderEntryObj = (DynamicObject)entryMap.get(entity.getDynamicObject("mftentryseq").getPkValue());
            if (orderEntryObj.getDynamicObject("programme") == null || !"D".equals(entity.getString("transactiontype.stockmaterials"))) continue;
            entity.getDynamicObjectCollection("proentryentity").removeAll((Collection)entity.getDynamicObjectCollection("proentryentity"));
            PropMftOrderToPropManFtechOp.createProEntryData(entity, orderEntryObj, objectDynamicObjectMap);
            PropMftOrderToPropManFtechOp.createOprEntryData(entity, orderEntryObj, objectDynamicObjectMap);
            PropManuftechCreateBillUtil.setPorValue((DynamicObject)entity, (String)"processreference");
            orgIds.addAll(entity.getDynamicObjectCollection("oprentryentity").stream().filter(x -> x.getDynamicObject("oprorg") != null).map(x -> x.getDynamicObject("oprorg").getLong("id")).collect(Collectors.toSet()));
        }
        Map map = ManuftechUtil.getAccountingOrgIdByMftOrgId(orgIds);
        Map orgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", map.values())});
        for (ExtendedDataEntity dataEntity : entities) {
            DynamicObject entity = dataEntity.getDataEntity();
            DynamicObject orderEntryObj = (DynamicObject)entryMap.get(entity.getDynamicObject("mftentryseq").getPkValue());
            if (entity.getDynamicObject("org") != null) {
                entity.set("accountingorg", orgMap.get(map.get(entity.getDynamicObject("org").getLong("id"))));
            }
            if (orderEntryObj.getDynamicObject("programme") == null) continue;
            PropManuftechCreateBillUtil.setOprEntryAccountingOrgValue((DynamicObject)entity, (Map)map, (Map)orgMap);
        }
    }

    private static void createProEntryData(DynamicObject orderTechnicsObj, DynamicObject orderEntryObj, Map<Object, DynamicObject> proGrammeMap) {
        DynamicObject proGrammeObj = orderTechnicsObj.getDynamicObject("programme");
        proGrammeObj = proGrammeMap.get(proGrammeObj.getPkValue());
        proGrammeObj.getDynamicObjectCollection("entryentity").sort((arg0, arg1) -> {
            int result = -1;
            if (arg0.getInt("processno") > arg1.getInt("processno")) {
                result = 1;
            }
            return result;
        });
        for (int i = 0; i < 1; ++i) {
            DynamicObject entryObj = (DynamicObject)proGrammeObj.getDynamicObjectCollection("entryentity").get(i);
            DynamicObject newEntryObj = orderTechnicsObj.getDynamicObjectCollection("proentryentity").addNew();
            PropManuftechCreateBillUtil.setProEntryEntityValue((DynamicObject)entryObj, (DynamicObject)orderEntryObj, (DynamicObject)newEntryObj);
            newEntryObj.set("seq", (Object)(i + 1));
        }
    }

    private static void createOprEntryData(DynamicObject orderTechnicsObj, DynamicObject orderEntryObj, Map<Object, DynamicObject> proGrammeMap) {
        DynamicObject proGrammeObj = orderTechnicsObj.getDynamicObject("programme");
        proGrammeObj = proGrammeMap.get(proGrammeObj.getPkValue());
        proGrammeObj.getDynamicObjectCollection("entryentity").sort((arg0, arg1) -> {
            int result = -1;
            if (arg0.getInt("processno") > arg1.getInt("processno")) {
                result = 1;
            }
            return result;
        });
        int seq = 0;
        for (int i = 0; i < proGrammeObj.getDynamicObjectCollection("entryentity").size(); ++i) {
            DynamicObject entryObj = (DynamicObject)proGrammeObj.getDynamicObjectCollection("entryentity").get(i);
            Date validDate = entryObj.getDate("validate");
            Date invalidDate = entryObj.getDate("invalidate");
            Date expendTime = orderEntryObj.getDate("expendbomtime");
            if (invalidDate != null && validDate != null && (!invalidDate.after(expendTime) || !validDate.before(expendTime))) continue;
            DynamicObject newEntryObj = orderTechnicsObj.getDynamicObjectCollection("oprentryentity").addNew();
            PropManuftechCreateBillUtil.setOprEntryEntityValue((DynamicObject)entryObj, (DynamicObject)orderEntryObj, (DynamicObject)newEntryObj, (DynamicObject)orderTechnicsObj);
            newEntryObj.set("oprproductionqty", (Object)orderTechnicsObj.getBigDecimal("qty"));
            newEntryObj.set("seq", (Object)(++seq));
            PropManuftechCreateBillUtil.setActSubEntryEntityValue((DynamicObject)entryObj, (DynamicObject)orderEntryObj, (DynamicObject)newEntryObj);
        }
    }

    private static void putHeadData(DynamicObject obj) {
        if (!CodeRuleServiceHelper.isExist((String)obj.getDataEntityType().getName(), (DynamicObject)obj, (String)obj.getDynamicObject("org").getPkValue().toString())) {
            obj.set("billno", (Object)UUID.randomUUID().toString().substring(0, 30));
        } else {
            obj.set("billno", (Object)CodeRuleServiceHelper.getNumber((String)obj.getDataEntityType().getName(), (DynamicObject)obj, (String)obj.getDynamicObject("org").getPkValue().toString()));
        }
    }
}

