/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.prop.opplugin.mftstock;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bd.mpdm.common.mftorder.utils.PomDyObjUtil;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class MftStockPropSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("isinitbill");
        e.getFieldKeys().add("orderid");
        e.getFieldKeys().add("transactiontypeid");
        e.getFieldKeys().add("stockentry.useqty");
        e.getFieldKeys().add("stockentry.wipqty");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        super.beforeExecuteOperationTransaction(e);
        String name = this.billEntityType.getName();
        if (!"prop_mftstock".equals(name)) {
            return;
        }
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            boolean isinitbill = dataEntity.getBoolean("isinitbill");
            if (!isinitbill) continue;
            DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection("stockentry");
            for (DynamicObject entry : entryColl) {
                boolean isCanNegative = entry.getBoolean("iscannegative");
                if (!isCanNegative) {
                    Long orderentryid = PomDyObjUtil.getDyObjId((Object)dataEntity.get("orderentryid"));
                    DynamicObject transactiontype = dataEntity.getDynamicObject("transactiontypeid");
                    BigDecimal useQty = MPDMMftGenStocksUtils.aculUseQty((DynamicObject)entry, (Object)orderentryid, (DynamicObject)transactiontype, (String)"prop_mftorder");
                    entry.set("useqty", (Object)useQty);
                }
                BigDecimal wipqty = MPDMMftGenStocksUtils.aculWIPQty((DynamicObject)entry);
                entry.set("wipqty", (Object)wipqty);
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String name = this.billEntityType.getName();
        if (!"prop_mftstock".equals(name)) {
            return;
        }
        DynamicObject[] objs = e.getDataEntities();
        ArrayList<Long> updateOrder = new ArrayList<Long>(16);
        for (DynamicObject obj : objs) {
            boolean isinitbill = obj.getBoolean("isinitbill");
            if (!isinitbill) continue;
            String orderidStr = obj.getString("orderid");
            updateOrder.add(Long.valueOf(orderidStr));
        }
        if (updateOrder != null && updateOrder.size() > 0) {
            OperationServiceHelper.executeOperate((String)"calmaterial", (String)"prop_mftorder", (Object[])updateOrder.toArray(), (OperateOption)OperateOption.create());
        }
    }
}

