/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.prop.opplugin.processreport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.mmc.prop.business.manuftech.PushMftManuInBillUtils;
import org.apache.commons.collections4.CollectionUtils;

public class ProcessReportAfterOp
extends AbstractOperationServicePlugIn {
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operateKey = this.getOption().getVariableValue("operatekey");
        DynamicObject[] bills = e.getDataEntities();
        HashSet<Long> orderEntryIds = new HashSet<Long>(16);
        for (int i = 0; i < bills.length; ++i) {
            DynamicObjectCollection dynamicObjectCollection = bills[i].getDynamicObjectCollection("sumentry");
            for (DynamicObject object : dynamicObjectCollection) {
                if (object.getDynamicObject("manufactureentryid") == null) continue;
                orderEntryIds.add(object.getDynamicObject("manufactureentryid").getLong("id"));
            }
        }
        ArrayList<Long> ids = new ArrayList<Long>(orderEntryIds);
        switch (operateKey) {
            case "audit": {
                this.culUseQty(ids);
                this.autoPushMftManuInBill(bills);
                break;
            }
            case "unaudit": {
                this.culUseQty(ids);
                break;
            }
        }
        e.setDataEntities(bills);
    }

    private void culUseQty(List<Long> ids) {
        try {
            DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"IMftOrderService", (String)"batchCulUseQtyByOrderEntryId", (Object[])new Object[]{ids, "prop_mftorder"});
        }
        catch (Exception ex) {
            throw new KDException((Throwable)ex, new ErrorCode("MmcServiceOrderCloseOpAction", ex.getMessage() != null ? ex.getMessage() : ex.toString()), new Object[0]);
        }
    }

    public void autoPushMftManuInBill(DynamicObject[] bills) {
        List isAutoWarehouse = Arrays.stream(bills).filter(x -> x.getDynamicObject("transactiontype") != null).filter(x -> x.getDynamicObject("transactiontype").getBoolean("isautowarehouse")).collect(Collectors.toList());
        PushArgs pushArgs = PushMftManuInBillUtils.buildPushArgs((String)"prop_processreportbill");
        ArrayList<ListSelectedRow> needPushRows = new ArrayList<ListSelectedRow>();
        for (DynamicObject dynamicObject : isAutoWarehouse) {
            DynamicObjectCollection sumEntry = dynamicObject.getDynamicObjectCollection("sumentry");
            for (DynamicObject entry : sumEntry) {
                if (!entry.getBoolean("warehousepoint")) continue;
                DynamicObjectCollection dynamicObjectCollection = entry.getDynamicObjectCollection("subentryentity1");
                for (DynamicObject object : dynamicObjectCollection) {
                    ListSelectedRow srcBill = new ListSelectedRow(dynamicObject.getPkValue());
                    srcBill.setEntryEntityKey("subentryentity1");
                    srcBill.setEntryPrimaryKeyValue(object.getPkValue());
                    needPushRows.add(srcBill);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(needPushRows)) {
            pushArgs.setSelectedRows(needPushRows);
            ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
            if (!pushResult.isSuccess()) {
                return;
            }
            PushMftManuInBillUtils.saveMftManuInBill((ConvertOperationResult)pushResult);
        }
    }
}

