/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.prop.opplugin.processreport;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.business.manuftech.OprUnitHelper;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.UnitConvertHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.mmc.prop.common.utils.PropGetOpentryUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ProcessReportBeginOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(ProcessReportBeginOp.class);

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("manufactureid");
        e.getFieldKeys().add("oprentry.id");
        e.getFieldKeys().add("oprentry");
        e.getFieldKeys().add("manufactureentryid");
        e.getFieldKeys().add("mroorderentryid");
        e.getFieldKeys().add("matertype");
        e.getFieldKeys().add("bookdate");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operateKey = this.getOption().getVariableValue("operatekey");
        DynamicObject[] bills = e.getDataEntities();
        HashSet<Long> orderIds = new HashSet<Long>(16);
        HashSet<Long> oprEntryIds = new HashSet<Long>(16);
        HashSet<Long> orderEntryIds = new HashSet<Long>(16);
        for (DynamicObject reportbill : bills) {
            DynamicObjectCollection sumentitys = reportbill.getDynamicObjectCollection("sumentry");
            for (DynamicObject obj : sumentitys) {
                DynamicObjectCollection dynamicObjectCollection = obj.getDynamicObjectCollection("otherproductentity");
                orderIds.addAll(dynamicObjectCollection.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getString("srcorderentryid2"))).map(x -> x.getLong("srcorderentryid2")).collect(Collectors.toSet()));
                orderIds.add(obj.getLong("manufactureid"));
                oprEntryIds.add(PropGetOpentryUtils.getOprentryId((DynamicObject)obj));
                if (obj.getDynamicObject("manufactureentryid") == null) continue;
                orderEntryIds.add(obj.getDynamicObject("manufactureentryid").getLong("id"));
            }
        }
        String orderEntity = "";
        String fetchEntity = "";
        if (CollectionUtils.isNotEmpty(orderEntryIds)) {
            orderEntity = "prop_mftorder";
            fetchEntity = "prop_manftech";
        }
        DynamicObject[] manftechByEntryIds = this.getManftechByEntryIds(oprEntryIds, fetchEntity);
        switch (operateKey) {
            case "submit": 
            case "audit": {
                Map<Long, Map<String, Object>> orderByEntryId = this.getOrderById(orderIds, orderEntity);
                this.audit(bills, manftechByEntryIds, orderByEntryId, fetchEntity);
                SaveServiceHelper.save((DynamicObject[])manftechByEntryIds);
                break;
            }
            case "unaudit": {
                this.unAudit(bills, manftechByEntryIds, fetchEntity);
                SaveServiceHelper.save((DynamicObject[])manftechByEntryIds);
            }
        }
        e.setDataEntities(bills);
    }

    private void audit(DynamicObject[] bills, DynamicObject[] manftechByEntryIds, Map<Long, Map<String, Object>> orderByEntryId, String fetchEntity) {
        for (DynamicObject reportbill : bills) {
            DynamicObjectCollection sumentitys = reportbill.getDynamicObjectCollection("sumentry");
            for (DynamicObject obj : sumentitys) {
                if (!reportbill.getBoolean("ischargeoff")) {
                    this.rewriteRep(obj, true, manftechByEntryIds, fetchEntity);
                }
                obj.getDynamicObjectCollection("subentryentity1").clear();
                if (!obj.getBoolean("warehousepoint")) continue;
                for (int j = 0; j < manftechByEntryIds.length; ++j) {
                    DynamicObjectCollection manftechentrys = manftechByEntryIds[j].getDynamicObjectCollection("oprentryentity");
                    for (DynamicObject manftechentry : manftechentrys) {
                        if (!manftechentry.getPkValue().toString().equals(PropGetOpentryUtils.getOprentryIdStr((DynamicObject)obj))) continue;
                        this.rewriteInstorage(reportbill, obj, orderByEntryId, OprUnitHelper.getManftechMap((DynamicObject)manftechByEntryIds[j], (DynamicObject)manftechentry));
                    }
                }
            }
        }
    }

    private void unAudit(DynamicObject[] bills, DynamicObject[] manftechByEntryIds, String fetchEntity) {
        for (DynamicObject reportbill : bills) {
            DynamicObjectCollection sumentitys = reportbill.getDynamicObjectCollection("sumentry");
            for (DynamicObject obj : sumentitys) {
                if (!reportbill.getBoolean("ischargeoff")) {
                    this.rewriteRep(obj, false, manftechByEntryIds, fetchEntity);
                }
                obj.getDynamicObjectCollection("subentryentity1").clear();
            }
        }
    }

    private void rewriteInstorage(DynamicObject reportbill, DynamicObject obj, Map<Long, Map<String, Object>> orderByEntryId, Map<String, Object> oprEntry) {
        DynamicObjectCollection subinstorages = obj.getDynamicObjectCollection("subentryentity1");
        Map<String, Object> orderData = orderByEntryId.get(obj.getDynamicObject("manufactureentryid").getLong("id"));
        DynamicObject dynamicObject = subinstorages.addNew();
        dynamicObject.set("seq", (Object)1);
        dynamicObject.set("manufacturenun3", obj.get("manufacturenun"));
        dynamicObject.set("manufacturerow3", obj.get("manufacturerow"));
        dynamicObject.set("manufactureentryid3", obj.getDynamicObject("manufactureentryid").getPkValue());
        dynamicObject.set("matertype3", obj.get("matertype"));
        dynamicObject.set("material3", obj.get("material"));
        dynamicObject.set("unitfield3", (Object)obj.getDynamicObject("baseunit"));
        Long unitId = (Long)orderData.get("treeentryentity.unit");
        dynamicObject.set("produceunit3", (Object)unitId);
        dynamicObject.set("auxproperty3", obj.get("auxproperty"));
        if (obj.get("material") != null) {
            long material = obj.getDynamicObject("material").getDynamicObject("masterid").getLong("id");
            long id = dynamicObject.getDynamicObject("unitfield3").getLong("id");
            dynamicObject.set("qualifyqty3", (Object)OprUnitHelper.getBaseQty(oprEntry, (BigDecimal)obj.getBigDecimal("qualifyqty").add(obj.getBigDecimal("receiveqty"))));
            dynamicObject.set("scrapqty3", (Object)OprUnitHelper.getBaseQty(oprEntry, (BigDecimal)obj.getBigDecimal("junkqty")));
            dynamicObject.set("badqualifyqty3", (Object)OprUnitHelper.getBaseQty(oprEntry, (BigDecimal)obj.getBigDecimal("repairqty").add(obj.getBigDecimal("checkreworkqty"))));
            dynamicObject.set("conformityqty3", (Object)UnitConvertHelper.calculateNewQty((BigDecimal)dynamicObject.getBigDecimal("qualifyqty3"), (Long)unitId, (Long)id, (Long)material, (StringBuilder)new StringBuilder()));
            dynamicObject.set("discardqty3", (Object)UnitConvertHelper.calculateNewQty((BigDecimal)dynamicObject.getBigDecimal("scrapqty3"), (Long)unitId, (Long)id, (Long)material, (StringBuilder)new StringBuilder()));
            dynamicObject.set("badconformityqty3", (Object)UnitConvertHelper.calculateNewQty((BigDecimal)dynamicObject.getBigDecimal("badqualifyqty3"), (Long)unitId, (Long)id, (Long)material, (StringBuilder)new StringBuilder()));
        }
        dynamicObject.set("inwarehouseorg3", orderData.get("treeentryentity.inwardept"));
        dynamicObject.set("ownertype3", (Object)"bos_org");
        dynamicObject.set("warehouse3", orderData.get("treeentryentity.warehouse"));
        if (((Boolean)orderData.get("treeentryentity.inwardept.fisaccounting")).booleanValue()) {
            dynamicObject.set("inwarconsigner3", orderData.get("treeentryentity.inwardept"));
        } else {
            List list = OrgUnitServiceHelper.getFromOrgs((String)"05", (Long)((Long)orderData.get("treeentryentity.inwardept")), (String)"10");
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                dynamicObject.set("inwarconsigner3", list.get(0));
            }
        }
        dynamicObject.set("batchno3", obj.get("batchno"));
        DynamicObjectCollection dynamicObjectCollection = obj.getDynamicObjectCollection("otherproductentity");
        for (int j = 0; j < dynamicObjectCollection.size(); ++j) {
            dynamicObject = subinstorages.addNew();
            DynamicObject otherent = (DynamicObject)dynamicObjectCollection.get(j);
            dynamicObject.set("seq", (Object)(otherent.getInt("seq") + 1));
            dynamicObject.set("manufacturenun3", obj.get("manufacturenun"));
            dynamicObject.set("matertype3", otherent.get("outputtype2"));
            dynamicObject.set("material3", otherent.get("material2"));
            if (otherent.getDynamicObject("material2") != null) {
                dynamicObject.set("produceunit3", (Object)otherent.getDynamicObject("produceunit2"));
                dynamicObject.set("unitfield3", (Object)otherent.getDynamicObject("material2").getDynamicObject("masterid").getDynamicObject("baseunit"));
                dynamicObject.set("conformityqty3", (Object)otherent.getBigDecimal("qualifyqty2").add(otherent.getBigDecimal("receiveqty2")));
                dynamicObject.set("discardqty3", (Object)otherent.getBigDecimal("junkqty2"));
                dynamicObject.set("badconformityqty3", (Object)otherent.getBigDecimal("repairqty2").add(otherent.getBigDecimal("reworkqty2")));
                long material = otherent.getDynamicObject("material2").getDynamicObject("masterid").getLong("id");
                long id = otherent.getDynamicObject("produceunit2").getLong("id");
                dynamicObject.set("qualifyqty3", (Object)UnitConvertHelper.calculateNewQty((BigDecimal)dynamicObject.getBigDecimal("conformityqty3"), (Long)dynamicObject.getDynamicObject("unitfield3").getLong("id"), (Long)id, (Long)material, (StringBuilder)new StringBuilder()));
                dynamicObject.set("scrapqty3", (Object)UnitConvertHelper.calculateNewQty((BigDecimal)dynamicObject.getBigDecimal("discardqty3"), (Long)dynamicObject.getDynamicObject("unitfield3").getLong("id"), (Long)id, (Long)material, (StringBuilder)new StringBuilder()));
                dynamicObject.set("badqualifyqty3", (Object)UnitConvertHelper.calculateNewQty((BigDecimal)dynamicObject.getBigDecimal("badconformityqty3"), (Long)dynamicObject.getDynamicObject("unitfield3").getLong("id"), (Long)id, (Long)material, (StringBuilder)new StringBuilder()));
            }
            dynamicObject.set("inwarehouseorg3", otherent.get("inwarehouseorg2"));
            dynamicObject.set("batchno3", otherent.get("batchno2"));
            dynamicObject.set("ownertype3", otherent.get("ownertype2"));
            dynamicObject.set("inwarconsigner3", otherent.get("inwarconsigner2"));
            dynamicObject.set("warehouse3", otherent.get("warehouse2"));
            dynamicObject.set("position3", otherent.get("position2"));
            dynamicObject.set("manufactureentryid3", otherent.get("srcorderentryid2"));
            Map<String, Object> map = orderByEntryId.get(otherent.getLong("srcorderentryid2"));
            dynamicObject.set("auxproperty3", map.get("treeentryentity.auxproperty"));
            dynamicObject.set("manufacturerow3", map.get("treeentryentity.seq"));
        }
    }

    private void rewriteRep(DynamicObject reportbill, boolean isaudit, DynamicObject[] manftechByEntryIds, String fetchEntity) {
        DynamicObjectCollection repsubentryentitys = reportbill.getDynamicObjectCollection("repsubentryentity");
        Long oprentryid = PropGetOpentryUtils.getOprentryId((DynamicObject)reportbill);
        if (manftechByEntryIds == null || manftechByEntryIds.length == 0) {
            return;
        }
        for (int j = 0; j < manftechByEntryIds.length; ++j) {
            DynamicObjectCollection manftechentrys = manftechByEntryIds[j].getDynamicObjectCollection("oprentryentity");
            for (DynamicObject manftechentry : manftechentrys) {
                if (!manftechentry.getPkValue().toString().equals(oprentryid.toString())) continue;
                DynamicObjectCollection repentitys = manftechentry.getDynamicObjectCollection("repsubentryentity");
                for (int k = 0; k < repsubentryentitys.size(); ++k) {
                    DynamicObject repentry = (DynamicObject)repsubentryentitys.get(k);
                    if (isaudit) {
                        DynamicObject rep = repentitys.addNew();
                        rep.set("repactivity", repentry.get("repactivity"));
                        rep.set("repbaseqty", repentry.get("repbaseqty"));
                        rep.set("repactualqty", repentry.get("repactualqty"));
                        rep.set("repactualbegintime", repentry.get("repactualbegintime"));
                        rep.set("repactualfinishtime", repentry.get("repactualfinishtime"));
                        rep.set("represources", repentry.get("represources"));
                        rep.set("srcentryid", (Object)repentry.getPkValue().toString());
                        rep.set("seq", repentry.get("seq"));
                        continue;
                    }
                    for (int i = 0; i < repentitys.size(); ++i) {
                        if (!repentry.getPkValue().toString().equals(((DynamicObject)repentitys.get(i)).getString("srcentryid"))) continue;
                        repentitys.remove(i);
                        --i;
                    }
                }
            }
        }
    }

    private DynamicObject[] getManftechByEntryIds(Set<Long> oprEntryId, String entity) {
        return BusinessDataServiceHelper.load((String)entity, (String)this.selectProperties(entity), (QFilter[])new QFilter[]{new QFilter("oprentryentity.id", "in", oprEntryId)});
    }

    private String selectProperties(String entity) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("id,");
        strBuilder.append("qty").append(',');
        strBuilder.append("baseunit").append(',');
        strBuilder.append("material").append(',');
        strBuilder.append("processroute").append(',');
        strBuilder.append("planstarttime").append(',');
        strBuilder.append("planfinishtime").append(',');
        strBuilder.append("baseqty").append(',');
        strBuilder.append("mftentryseq").append(',');
        strBuilder.append("billno").append(',');
        strBuilder.append("billstatus").append(',');
        strBuilder.append("modifytime").append(',');
        strBuilder.append("modifier").append(',');
        strBuilder.append("manufactureorderseq").append(',');
        strBuilder.append("proentryentity").append('.').append("processseqqty").append(',');
        strBuilder.append("proentryentity").append('.').append("processseq").append(',');
        strBuilder.append("proentryentity").append('.').append("processplanbegintime").append(',');
        strBuilder.append("proentryentity").append('.').append("processplanendtime").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprplanbegintime").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprno").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprplanfinishtime").append(',');
        strBuilder.append("oprentryentity").append('.').append("headqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("headunit").append(',');
        strBuilder.append("oprentryentity").append('.').append("operationqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprunit").append(',');
        strBuilder.append("oprentryentity").append('.').append("operationunit").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprstandardqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprproductionqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprstatus").append(',');
        strBuilder.append("oprentryentity").append('.').append("oproperation").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprtotalqualifiedqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprparent").append(',');
        strBuilder.append("repsubentryentity").append('.').append("repactivity").append(',');
        strBuilder.append("repsubentryentity").append('.').append("repbaseqty").append(',');
        strBuilder.append("repsubentryentity").append('.').append("repactualqty").append(',');
        strBuilder.append("repsubentryentity").append('.').append("repactualbegintime").append(',');
        strBuilder.append("repsubentryentity").append('.').append("repactualfinishtime").append(',');
        strBuilder.append("repsubentryentity").append('.').append("srcentryid").append(',');
        strBuilder.append("repsubentryentity").append('.').append("represources").append(',');
        strBuilder.append("repsubentryentity").append('.').append("seq").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprinvalid");
        return strBuilder.toString();
    }

    private Map<Long, Map<String, Object>> getOrderById(Set<Long> orderIds, String entity) {
        HashMap<Long, Map<String, Object>> result = new HashMap<Long, Map<String, Object>>(128);
        QFilter filter = new QFilter("id", "in", orderIds);
        String selectFields = "id,billno,billstatus,treeentryentity.id,treeentryentity.seq,treeentryentity.inwardept,treeentryentity.inwardept.fisinventory,treeentryentity.inwardept.fisaccounting,treeentryentity.unit,treeentryentity.warehouse,treeentryentity.location,treeentryentity.auxproperty";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getOrderById", (String)entity, (String)selectFields, (QFilter[])new QFilter[]{filter}, (String)"");){
            while (dataSet.hasNext()) {
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                Row next = dataSet.next();
                map.put("id", next.getLong("id"));
                map.put("billno", next.getString("billno"));
                map.put("billstatus", next.getString("billstatus"));
                map.put("treeentryentity.id", next.getLong("treeentryentity.id"));
                map.put("treeentryentity.seq", next.getInteger("treeentryentity.seq"));
                map.put("treeentryentity.inwardept", next.getLong("treeentryentity.inwardept"));
                map.put("treeentryentity.inwardept.fisaccounting", next.getBoolean("treeentryentity.inwardept.fisaccounting"));
                map.put("treeentryentity.unit", next.getLong("treeentryentity.unit"));
                map.put("treeentryentity.warehouse", next.getLong("treeentryentity.warehouse"));
                map.put("treeentryentity.auxproperty", next.get("treeentryentity.auxproperty"));
                result.put(next.getLong("treeentryentity.id"), map);
            }
        }
        return result;
    }
}

