/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.prop.opplugin.processreport.validator;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ProcessReportAuditValidator
extends AbstractValidator {
    public void validate() {
        String operateKey;
        switch (operateKey = this.getOperateKey()) {
            case "audit": {
                this.transactionTypeCheck();
            }
        }
    }

    private void transactionTypeCheck() {
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        HashSet<Long> entryIDs = new HashSet<Long>();
        HashSet<Long> orderF7Ids = new HashSet<Long>();
        HashMap<Long, Integer> mapping = new HashMap<Long, Integer>();
        for (int i1 = 0; i1 < dataEntities.length; ++i1) {
            DynamicObject dataEntity;
            String billstatus;
            if (dataEntities[i1] == null || !"B".equals(billstatus = (dataEntity = dataEntities[i1].getDataEntity()).getString("billstatus"))) continue;
            DynamicObjectCollection sumentrys = dataEntity.getDynamicObjectCollection("sumentry");
            for (int i2 = 0; i2 < sumentrys.size(); ++i2) {
                DynamicObject dynamicObject = (DynamicObject)sumentrys.get(i2);
                if (dynamicObject == null) continue;
                Long entryid = (Long)dynamicObject.getPkValue();
                DynamicObject manufactureentryid = dynamicObject.getDynamicObject("manufactureentryid");
                if (manufactureentryid != null) {
                    orderF7Ids.add((Long)manufactureentryid.getPkValue());
                }
                entryIDs.add(entryid);
                mapping.put(entryid, i1);
            }
        }
        QFilter billnoFiliter = new QFilter("sumentry.id", "in", entryIDs);
        try (DataSet processReports = QueryServiceHelper.queryDataSet((String)"query_prop_processreportbill", (String)"prop_processreportbill", (String)this.getSelectProperties("prop_processreportbill"), (QFilter[])new QFilter[]{billnoFiliter}, null);){
            DataSet result = null;
            QFilter qFilter = new QFilter("treeentryentity.id", "in", orderF7Ids);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"query_prop_mftorder", (String)"prop_mftorder", (String)this.getSelectProperties("prop_mftorder"), (QFilter[])new QFilter[]{qFilter}, (String)"");){
                HashSet<Long> transactiontypeIds = new HashSet<Long>();
                DataSet copyDS = ds.copy();
                while (copyDS.hasNext()) {
                    Row next = copyDS.next();
                    transactiontypeIds.add(next.getLong("transactiontype"));
                }
                QFilter qfilter1 = new QFilter("id", "in", transactiontypeIds);
                try (DataSet transactiontypeIdRows = QueryServiceHelper.queryDataSet((String)"query_transactiontype", (String)"mpdm_transactproduct", (String)this.getSelectProperties("mpdm_omtransactproduct"), (QFilter[])new QFilter[]{qfilter1}, (String)"");){
                    DataSet dataSet = ds.join(transactiontypeIdRows).select(new String[]{"billno", "baseqty", "isprocedure", "isreportpick", "reportcontrol", "reportcontrolrang", "entryId"}).on("transactiontype", "id").finish();
                    result = processReports.join(dataSet).select(new String[]{"entryid", "oprentryid", "manufactureentryid", "completqty", "baseqty", "isprocedure", "isreportpick", "reportcontrol", "reportcontrolrang", "masterid", "opra", "processseq", "oprno", "totalcompletqty"}).on("manufactureentryid", "entryId").finish();
                }
                DataSet res = result.where("isprocedure=true").where("isreportpick=true");
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"query_prop_mftstock", (String)"prop_mftstock", (String)this.getSelectProperties("prop_mftstock"), (QFilter[])new QFilter[]{new QFilter("orderentryid.id", "in", orderF7Ids)}, (String)"");){
                    DataSet stock = res.join(dataSet).select(new String[]{"entryid", "oprentryid", "manufactureentryid", "completqty", "baseqty", "isprocedure", "isreportpick", "reportcontrol", "reportcontrolrang", "masterid", "stockMasterId", "isbackflush", "issuemode", "isbulkmaterial", "iskeypart", "overissuecontrl", "lackraitioqty", "qtytype", "actissueqty", "rejectedqty", "feedingqty", "fixscrap", "demandqty", "totalcompletqty"}).on("manufactureentryid", "orderentryid").on("opra", "stockworkprocedureid").on("processseq", "stockprocessseq").on("oprno", "stockoprno").finish();
                    DataSet copy = stock.copy();
                    HashSet<Long> oprentryids = new HashSet<Long>(16);
                    while (copy.hasNext()) {
                        Row next = copy.next();
                        Long oprentryid = next.getLong("oprentryid");
                        oprentryids.add(oprentryid);
                    }
                    try (DataSet mfttechnicsDataSet = QueryServiceHelper.queryDataSet((String)"query_prop_manftech", (String)"prop_manftech", (String)this.getSelectProperties("prop_manftech"), (QFilter[])new QFilter[]{new QFilter("oprentryentity.id", "in", oprentryids)}, (String)"");){
                        DataSet select = mfttechnicsDataSet.select(new String[]{"mfttechnics", "oprtotalreportqty", "headqty", "headunit", "operationqty", "oprunit", "precisionaccount"});
                        DataSet result1 = stock.join(select).select(new String[]{"entryid", "completqty", "baseqty", "isprocedure", "isreportpick", "reportcontrol", "reportcontrolrang", "masterid", "stockMasterId", "isbackflush", "issuemode", "isbulkmaterial", "precisionaccount", "iskeypart", "overissuecontrl", "lackraitioqty", "qtytype", "actissueqty", "rejectedqty", "feedingqty", "fixscrap", "demandqty", "oprtotalreportqty", "headqty", "headunit", "operationqty", "oprunit", "totalcompletqty"}).on("oprentryid", "mfttechnics").finish();
                        DataSet copyResult = result1.copy();
                        HashSet masterids = new HashSet();
                        HashSet stockMasterIds = new HashSet();
                        copyResult.forEach(t -> {
                            stockMasterIds.add(t.getLong("stockMasterId"));
                            masterids.add(t.getLong("masterid"));
                        });
                        try (DataSet materials = QueryServiceHelper.queryDataSet((String)"queryMaterial", (String)"bd_material", (String)this.getSelectProperties("masterid"), (QFilter[])new QFilter[]{new QFilter("id", "in", masterids)}, (String)"");){
                            DataSet on = result1.join(materials).select(new String[]{"entryid", "completqty", "baseqty", "isprocedure", "isreportpick", "reportcontrol", "reportcontrolrang", "number", "name", "stockMasterId", "isbackflush", "issuemode", "isbulkmaterial", "precisionaccount", "iskeypart", "overissuecontrl", "lackraitioqty", "qtytype", "actissueqty", "rejectedqty", "feedingqty", "fixscrap", "demandqty", "oprtotalreportqty", "headqty", "headunit", "operationqty", "oprunit", "totalcompletqty"}).on("masterid", "id").finish();
                            try (DataSet stockMaterials = QueryServiceHelper.queryDataSet((String)"queryStockMaterial", (String)"bd_material", (String)this.getSelectProperties("stockMasterId"), (QFilter[])new QFilter[]{new QFilter("id", "in", stockMasterIds)}, (String)"");){
                                DataSet result2 = on.join(stockMaterials).select(new String[]{"entryid", "completqty", "baseqty", "isprocedure", "isreportpick", "reportcontrol", "reportcontrolrang", "number", "name", "materialnumber", "materialname", "isbackflush", "issuemode", "isbulkmaterial", "precisionaccount", "iskeypart", "overissuecontrl", "lackraitioqty", "qtytype", "actissueqty", "rejectedqty", "feedingqty", "fixscrap", "demandqty", "oprtotalreportqty", "headqty", "headunit", "operationqty", "oprunit", "totalcompletqty"}).on("stockMasterId", "id").finish();
                                while (result2.hasNext()) {
                                    Row next = result2.next();
                                    String reportcontrolrang = next.getString("reportcontrolrang");
                                    String isbackflush = next.getString("isbackflush");
                                    Boolean isbulkmaterial = next.getBoolean("isbulkmaterial");
                                    String issuemode = next.getString("issuemode");
                                    Boolean iskeypart = next.getBoolean("iskeypart");
                                    switch (reportcontrolrang) {
                                        case "A": {
                                            if (!"A".equals(isbackflush) || isbulkmaterial.booleanValue() || "C".equals(issuemode)) break;
                                            this.verifyFullySuse(next, mapping);
                                            break;
                                        }
                                        case "B": {
                                            if (!iskeypart.booleanValue() || isbulkmaterial.booleanValue() || "C".equals(issuemode)) break;
                                            this.verifyFullySuse(next, mapping);
                                            break;
                                        }
                                        case "C": {
                                            if (isbulkmaterial.booleanValue() || "C".equals(issuemode)) break;
                                            this.verifyFullySuse(next, mapping);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void verifyFullySuse(Row row, Map<Long, Integer> mapping) {
        BigDecimal actissueqty = row.getBigDecimal("actissueqty");
        BigDecimal rejectedqty = row.getBigDecimal("rejectedqty");
        BigDecimal feedingqty = row.getBigDecimal("feedingqty");
        BigDecimal oprtotalreportqty = row.getBigDecimal("oprtotalreportqty");
        BigDecimal completqty = row.getBigDecimal("completqty");
        BigDecimal headqty = row.getBigDecimal("headqty");
        Integer headunit = row.getInteger("headunit");
        Integer precisionaccount = row.getInteger("precisionaccount");
        BigDecimal operationqty = row.getBigDecimal("operationqty");
        Integer oprunit = row.getInteger("oprunit");
        BigDecimal demandqty = row.getBigDecimal("demandqty");
        BigDecimal fixscrap = row.getBigDecimal("fixscrap");
        BigDecimal baseqty = row.getBigDecimal("baseqty");
        String qtytype = row.getString("qtytype");
        String overissuecontrl = row.getString("overissuecontrl");
        BigDecimal lackraitioqty = row.getBigDecimal("lackraitioqty");
        String reportcontrol = row.getString("reportcontrol");
        BigDecimal totalcompletqty = oprtotalreportqty.add(completqty);
        Long entryid = row.getLong("entryid");
        BigDecimal a = actissueqty.subtract(rejectedqty).add(feedingqty);
        BigDecimal divided = demandqty.subtract(fixscrap).multiply(oprtotalreportqty.add(completqty)).multiply(headqty);
        BigDecimal divide = baseqty.multiply(operationqty);
        BigDecimal c = divided.divide(divide, (int)headunit, precisionaccount);
        BigDecimal b = null;
        block5 : switch (qtytype) {
            case "B": {
                b = demandqty;
                break;
            }
            case "A": 
            case "C": {
                switch (overissuecontrl) {
                    case "A": {
                        b = c;
                        break block5;
                    }
                    case "B": {
                        b = c.compareTo(lackraitioqty) < 0 ? c : lackraitioqty;
                    }
                }
            }
        }
        if (a == null) {
            a = BigDecimal.ZERO;
        }
        if (b == null) {
            b = BigDecimal.ZERO;
        }
        if (a.compareTo(b) < 0) {
            Integer i = mapping.get(entryid);
            String materialnumber = row.getString("materialnumber");
            String materialname = row.getString("materialname");
            String number = row.getString("number");
            String name = row.getString("name");
            String message = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u5168\u9886\u6599\u7684\u7269\u6599\uff1a\u5de5\u5e8f\u6c47\u62a5\u4ea7\u54c1\u7f16\u7801[%1$s] \u4ea7\u54c1\u540d\u79f0[%2$s] \u7d2f\u8ba1\u6c47\u62a5\u6570\u91cf[%3$s]\uff0c\u7269\u6599\u7f16\u7801[%4$s] \u7269\u6599\u540d\u79f0[%5$s]\u5e94\u9886\u7528[%6$s]\uff0c\u5b9e\u9645\u9886\u7528[%7$s]\u3002", (String)"ProcessReportAuditValidator_0", (String)"mmc-prop-opplugin", (Object[])new Object[0]), number, name, totalcompletqty.setScale(oprunit).toPlainString(), materialnumber, materialname, b.setScale(headunit).toPlainString(), a.setScale(headunit).toPlainString());
            boolean processreportaudit = this.getOption().containsVariable("processreportaudit");
            if (!processreportaudit) {
                reportcontrol = "B";
            }
            switch (reportcontrol) {
                case "A": {
                    this.addWarningMessage(this.dataEntities[i], message);
                    break;
                }
                case "B": {
                    this.addErrorMessage(this.dataEntities[i], message);
                }
            }
        }
    }

    private String getSelectProperties(String billType) {
        StringJoiner stringJoiner = new StringJoiner(",");
        switch (billType) {
            case "pom_mftorder": 
            case "prop_mftorder": {
                stringJoiner.add("transactiontype");
                stringJoiner.add("treeentryentity.id as entryId");
                stringJoiner.add("treeentryentity.baseqty AS baseqty");
                stringJoiner.add("billno");
                break;
            }
            case "mpdm_omtransactproduct": {
                stringJoiner.add("id");
                stringJoiner.add("isprocedure");
                stringJoiner.add("isreportpick");
                stringJoiner.add("reportcontrol");
                stringJoiner.add("reportcontrolrang");
                break;
            }
            case "pom_mftstock": 
            case "prop_mftstock": {
                stringJoiner.add("orderentryid.id as orderentryid");
                stringJoiner.add("stockentry.materialid.masterid as stockMasterId");
                stringJoiner.add("stockentry.isbackflush as isbackflush");
                stringJoiner.add("stockentry.issuemode as issuemode");
                stringJoiner.add("stockentry.isbulkmaterial as isbulkmaterial");
                stringJoiner.add("stockentry.iskeypart as iskeypart");
                stringJoiner.add("stockentry.overissuecontrl as overissuecontrl");
                stringJoiner.add("stockentry.lackraitioqty as lackraitioqty");
                stringJoiner.add("stockentry.qtytype as qtytype");
                stringJoiner.add("stockentry.workprocedureid as stockworkprocedureid");
                stringJoiner.add("stockentry.processseq as stockprocessseq");
                stringJoiner.add("stockentry.oprno as stockoprno");
                stringJoiner.add("stockentry.actissueqty as actissueqty");
                stringJoiner.add("stockentry.rejectedqty as rejectedqty");
                stringJoiner.add("stockentry.feedingqty as feedingqty");
                stringJoiner.add("stockentry.fixscrap as fixscrap");
                stringJoiner.add("stockentry.demandqty as demandqty");
                break;
            }
            case "sfc_processreportbill": 
            case "prop_processreportbill": {
                stringJoiner.add("sumentry.id AS entryid");
                stringJoiner.add("sumentry.oprentry AS oprentryid");
                stringJoiner.add("sumentry.completqty AS completqty");
                stringJoiner.add("sumentry.manufacturenun AS manufacturenun");
                stringJoiner.add("sumentry.manufactureentryid.id AS manufactureentryid");
                stringJoiner.add("sumentry.material.masterid AS masterid");
                stringJoiner.add("sumentry.opra as opra");
                stringJoiner.add("sumentry.processseq as processseq");
                stringJoiner.add("sumentry.oprno as oprno");
                stringJoiner.add("sumentry.totalcompletqty as totalcompletqty");
                break;
            }
            case "sfc_manftech": 
            case "prop_manftech": {
                stringJoiner.add("oprentryentity.id as mfttechnics");
                stringJoiner.add("oprentryentity.oprtotalreportqty as oprtotalreportqty");
                stringJoiner.add("oprentryentity.headqty as headqty");
                stringJoiner.add("oprentryentity.headunit.precision as headunit");
                stringJoiner.add("oprentryentity.headunit.precisionaccount as precisionaccount");
                stringJoiner.add("oprentryentity.operationqty as operationqty");
                stringJoiner.add("oprentryentity.oprunit.precision as oprunit");
                break;
            }
            case "masterid": {
                stringJoiner.add("id");
                stringJoiner.add("number");
                stringJoiner.add("name");
                break;
            }
            case "stockMasterId": {
                stringJoiner.add("id");
                stringJoiner.add("number As materialnumber");
                stringJoiner.add("name As materialname");
            }
        }
        return stringJoiner.toString();
    }
}

