/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.prop.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.manuftech.utils.SFCCustFormulaFuntions;
import kd.bd.mpdm.common.mftorder.enums.PrecisionAccountEnum;
import kd.bd.mpdm.common.query.helper.TransactionTypeQueryHelper;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.formula.platform.api.IFormulaFunctions;
import kd.bos.formula.platform.engine.FormulaEngine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class PropMftOrderReportHelper {
    private static Log logger = LogFactory.getLog(PropMftOrderReportHelper.class);

    public static Map<String, List<String>> checkCompleteMaterialRequisition(DynamicObject mftReptBillRow) {
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>(16);
        ArrayList<String> warnResult = new ArrayList<String>(10);
        ArrayList<String> strongControlResult = new ArrayList<String>(10);
        ArrayList<String> errorMsgResult = new ArrayList<String>(10);
        if (null != mftReptBillRow && null != mftReptBillRow.getDynamicObject("material")) {
            DynamicObject material = mftReptBillRow.getDynamicObject("material");
            Long mftEntryId = mftReptBillRow.getLong("mftentryid");
            if (mftEntryId != null && !mftEntryId.equals(0L)) {
                Map<String, Object> orderEntryMap = PropMftOrderReportHelper.getOrderEntryInfo(mftEntryId);
                DynamicObject transactiontype = (DynamicObject)orderEntryMap.get("transactiontype");
                boolean isreportpick = transactiontype.getBoolean("isreportpick");
                if (!isreportpick) {
                    resultMap.put("warnResult", warnResult);
                    resultMap.put("strongControlResult", strongControlResult);
                    resultMap.put("errorMsgResult", errorMsgResult);
                    return resultMap;
                }
                String matertype = mftReptBillRow.getString("matertype");
                if (StringUtils.equals((CharSequence)"C", (CharSequence)matertype)) {
                    String reportcontrolrang = transactiontype.getString("reportcontrolrang");
                    QFilter qf = new QFilter("orderentryid", "=", (Object)mftEntryId);
                    DynamicObject mftStockDyn = BusinessDataServiceHelper.loadSingle((String)"prop_mftstock", (String)"stockentry,stockentry.materialid,stockentry.isbackflush,stockentry.iskeypart,stockentry.issuemode,stockentry.isbulkmaterial,stockentry.lackraitioqty,stockentry.overissuecontrl,stockentry.actissueqty,stockentry.rejectedqty,stockentry.feedingqty,stockentry.demandqty,stockentry.fixscrap,stockentry.qtytype", (QFilter[])new QFilter[]{qf});
                    DynamicObjectCollection mftStockEntrys = mftStockDyn.getDynamicObjectCollection("stockentry");
                    for (DynamicObject mftStockEntry : mftStockEntrys) {
                        if (PropMftOrderReportHelper.isContinue(reportcontrolrang, mftStockEntry)) continue;
                        BigDecimal pickedQty = PropMftOrderReportHelper.calculatePickedQty(mftStockEntry);
                        BigDecimal requireQty = PropMftOrderReportHelper.calculateRequireQty(mftStockEntry, orderEntryMap, mftReptBillRow, errorMsgResult);
                        BigDecimal sumQty = PropMftOrderReportHelper.calculateSumQty(orderEntryMap, mftReptBillRow);
                        if (pickedQty.compareTo(requireQty) >= 0) continue;
                        DynamicObject mftStockMaterial = mftStockEntry.getDynamicObject("materialid");
                        String materialCode = PropMftOrderReportHelper.getMaterialNumber(mftStockMaterial);
                        String materialName = PropMftOrderReportHelper.getMaterialName(mftStockMaterial);
                        String productCode = PropMftOrderReportHelper.getMaterialNumber(material);
                        String productName = PropMftOrderReportHelper.getMaterialName(material);
                        String tipMessage = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u5168\u9886\u6599\u7684\u7269\u6599\uff1a\u5de5\u5355\u6c47\u62a5\u4ea7\u54c1\u7f16\u7801[%1$s] \u4ea7\u54c1\u540d\u79f0[%2$s] \u7d2f\u8ba1\u6c47\u62a5\u6570\u91cf[%3$s]\uff0c\u7269\u6599\u7f16\u7801[%4$s] \u7269\u6599\u540d\u79f0[%5$s]\u5e94\u9886\u7528[%6$s]\uff0c\u5b9e\u9645\u9886\u7528[%7$s]\u3002", (String)"PropMftOrderReportUtils_6", (String)"mmc-prop-common", (Object[])new Object[0]) + "\n", productCode, productName, sumQty.stripTrailingZeros().toPlainString(), materialCode, materialName, requireQty.stripTrailingZeros().toPlainString(), pickedQty.stripTrailingZeros().toPlainString());
                        String controlType = transactiontype.getString("reportcontrol");
                        if (StringUtils.equals((CharSequence)"A", (CharSequence)controlType)) {
                            warnResult.add(tipMessage);
                            continue;
                        }
                        if (!StringUtils.equals((CharSequence)"B", (CharSequence)controlType)) continue;
                        strongControlResult.add(tipMessage);
                    }
                }
            }
        }
        resultMap.put("warnResult", warnResult);
        resultMap.put("strongControlResult", strongControlResult);
        resultMap.put("errorMsgResult", errorMsgResult);
        return resultMap;
    }

    private static BigDecimal calculatePickedQty(DynamicObject mftStockDyn) {
        BigDecimal actissueqty = mftStockDyn.getBigDecimal("actissueqty");
        BigDecimal rejectedqty = mftStockDyn.getBigDecimal("rejectedqty");
        BigDecimal feedingqty = mftStockDyn.getBigDecimal("feedingqty");
        return actissueqty.subtract(rejectedqty).add(feedingqty);
    }

    private static BigDecimal calculateSumQty(Map<String, Object> orderEntryMap, DynamicObject mftOrderRPTEntry) {
        BigDecimal reportqty = (BigDecimal)orderEntryMap.get("reportqty");
        BigDecimal rptCompletqty = mftOrderRPTEntry.getBigDecimal("completqty");
        return reportqty.add(rptCompletqty);
    }

    private static BigDecimal calculateRequireQty(DynamicObject stockentry, Map<String, Object> orderEntryMap, DynamicObject mftOrderRPTEntry, List<String> errorMsgResult) {
        BigDecimal requireQty = BigDecimal.ZERO;
        BigDecimal qty = (BigDecimal)orderEntryMap.get("qty");
        int precision = 2;
        int precisionAccount = 4;
        DynamicObject unit = (DynamicObject)orderEntryMap.get("unit");
        if (null != unit) {
            precision = unit.getInt("precision");
            precisionAccount = PrecisionAccountEnum.getEnumByVal((int)Integer.parseInt(unit.getString("precisionaccount")));
        }
        if (qty.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal demandqty = stockentry.getBigDecimal("demandqty");
            String qtytype = stockentry.getString("qtytype");
            if (StringUtils.equals((CharSequence)"B", (CharSequence)qtytype)) {
                requireQty = demandqty;
            } else if (StringUtils.equals((CharSequence)"A", (CharSequence)qtytype)) {
                BigDecimal tempQty = BigDecimal.ZERO;
                BigDecimal reportqty = (BigDecimal)orderEntryMap.get("reportqty");
                BigDecimal rptCompletqty = mftOrderRPTEntry.getBigDecimal("completqty");
                BigDecimal fixscrap = stockentry.getBigDecimal("fixscrap");
                tempQty = tempQty.add(reportqty).add(rptCompletqty).multiply(demandqty.subtract(fixscrap)).divide(qty, precision, precisionAccount);
                String overissuecontrl = stockentry.getString("overissuecontrl");
                requireQty = StringUtils.equals((CharSequence)"A", (CharSequence)overissuecontrl) ? tempQty : (tempQty.compareTo(stockentry.getBigDecimal("lackraitioqty")) < 0 ? tempQty : stockentry.getBigDecimal("lackraitioqty"));
            }
        }
        return requireQty;
    }

    public static BigDecimal runFormula(DynamicObject repentry, DynamicObject processactivity) throws Exception {
        String formulaStr;
        BigDecimal ret = new BigDecimal(0);
        DynamicObject actstandardformula = repentry.getDynamicObject("actstandardformula");
        if (null != actstandardformula && (actstandardformula = BusinessDataServiceHelper.loadSingleFromCache((Object)actstandardformula.getPkValue(), (String)"mpdm_processformula")) != null && StringUtils.isNotBlank((CharSequence)(formulaStr = actstandardformula.getString("formula")))) {
            HashMap<String, DynamicObject> varValues = new HashMap<String, DynamicObject>();
            DynamicObjectCollection repentrys = new DynamicObjectCollection();
            DynamicObject sumentry = (DynamicObject)OrmUtils.clone((IDataEntityBase)((DynamicObject)repentry.getParent()), (boolean)false, (boolean)true);
            repentrys.add((Object)((DynamicObject)OrmUtils.clone((IDataEntityBase)repentry, (boolean)false, (boolean)true)));
            sumentry.set("subentryentity", (Object)repentrys);
            DynamicObject cloneProcessReport = (DynamicObject)OrmUtils.clone((IDataEntityBase)((IDataEntityBase)((DynamicObject)repentry.getParent()).getParent()), (boolean)false, (boolean)true);
            DynamicObjectCollection dynamicObjectCollection = cloneProcessReport.getDynamicObjectCollection("sumentry");
            dynamicObjectCollection.clear();
            dynamicObjectCollection.add((Object)sumentry);
            varValues.put("prop_mftorderreport", cloneProcessReport);
            varValues.put("mpdm_processactivity", processactivity);
            try {
                FormulaEngine.registerFunctions((IFormulaFunctions)new SFCCustFormulaFuntions());
                logger.info(String.format("\u6d41\u7a0b\u5de5\u5355\u6c47\u62a5\u5355\u8c03\u7528\u6d3b\u52a8\u516c\u5f0f\u5f00\u59cb\uff0c\u53c2\u6570formulaStr\uff1a%s;\u53c2\u6570\uff1avarValues\uff1a%s;", formulaStr, varValues));
                Object result = FormulaEngine.runFormula((String)formulaStr, varValues);
                String resultStr = null == result ? "null" : result.toString();
                logger.info(String.format("\u6d41\u7a0b\u5de5\u5355\u6c47\u62a5\u5355\u8c03\u7528\u6d3b\u52a8\u516c\u5f0f\u7ed3\u675f\uff0c\u8fd4\u56de\u7ed3\u679cresult\uff1a%s;", resultStr));
                if (result instanceof BigDecimal) {
                    ret = (BigDecimal)result;
                } else if (result instanceof Integer) {
                    ret = new BigDecimal(Integer.parseInt(result.toString()));
                } else if (result instanceof ArrayList) {
                    ArrayList list = (ArrayList)result;
                    ret = (BigDecimal)list.get(0);
                } else {
                    String retStr = String.valueOf(result);
                    ret = new BigDecimal(retStr);
                }
            }
            catch (Exception exp) {
                String errInfo = String.format(ResManager.loadKDString((String)"\u516c\u5f0f\u8ba1\u7b97\u65f6\u51fa\u73b0\u5f02\u5e38 - \u53c2\u65701:%1$s,\u53c2\u65702:%2$s", (String)"PropMftOrderReportUtils_5", (String)"mmc-prop-common", (Object[])new Object[0]), formulaStr, ((Object)varValues).toString());
                logger.info(errInfo, (Object)exp);
                throw new Exception(errInfo, exp);
            }
        }
        return ret;
    }

    private static Map<String, Object> getOrderEntryInfo(Long mftEntryId) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
        QFilter qfilter = new QFilter("treeentryentity.id", "=", (Object)mftEntryId);
        DynamicObject dy = null;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-PropMftOrderReportUtils-getTransactionType", (String)"prop_mftorder", (String)"transactiontype,treeentryentity.reportqty reportqty,treeentryentity.qty qty ,treeentryentity.unit unit", (QFilter[])new QFilter[]{qfilter}, (String)"");){
            while (ds.hasNext()) {
                Row dsRow = ds.next();
                Long transactiontype = dsRow.getLong("transactiontype");
                dy = TransactionTypeQueryHelper.getDataCacheByID((Object)transactiontype);
                dataMap.put("transactiontype", dy);
                dataMap.put("qty", dsRow.getBigDecimal("qty"));
                dataMap.put("reportqty", dsRow.getBigDecimal("reportqty"));
                dataMap.put("unit", BusinessDataServiceHelper.loadSingleFromCache((Object)dsRow.getLong("unit"), (String)"bd_measureunits"));
            }
        }
        return dataMap;
    }

    private static String getMaterialNumber(DynamicObject mateialmftInfo) {
        DynamicObject material = mateialmftInfo.getDynamicObject("masterid");
        return material.getString("number");
    }

    private static String getMaterialName(DynamicObject mateialmftInfo) {
        DynamicObject material = mateialmftInfo.getDynamicObject("masterid");
        return material.getString("name");
    }

    public static Set<String> convertLongToStringSet(Set<Long> idSet) {
        HashSet<String> idStringSet = new HashSet<String>(idSet.size());
        for (Long id : idSet) {
            idStringSet.add(String.valueOf(id));
        }
        return idStringSet;
    }

    private static boolean isContinue(String reportcontrolrang, DynamicObject mftStockEntry) {
        boolean isContinue;
        String isbackflush = mftStockEntry.getString("isbackflush");
        boolean isbulkmaterial = mftStockEntry.getBoolean("isbulkmaterial");
        String issuemode = mftStockEntry.getString("issuemode");
        boolean iskeypart = mftStockEntry.getBoolean("iskeypart");
        boolean bl = isContinue = StringUtils.equals((CharSequence)"A", (CharSequence)reportcontrolrang) && (!StringUtils.equals((CharSequence)"A", (CharSequence)isbackflush) || isbulkmaterial || StringUtils.equals((CharSequence)"C", (CharSequence)issuemode));
        if (!isContinue) {
            boolean bl2 = isContinue = StringUtils.equals((CharSequence)"B", (CharSequence)reportcontrolrang) && (!iskeypart || isbulkmaterial || StringUtils.equals((CharSequence)"C", (CharSequence)issuemode));
            if (!isContinue) {
                isContinue = StringUtils.equals((CharSequence)"C", (CharSequence)reportcontrolrang) && (isbulkmaterial || StringUtils.equals((CharSequence)"C", (CharSequence)issuemode));
            }
        }
        return isContinue;
    }
}

