/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.prop.formplugin.mftorder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.botp.runtime.ConvertOpParameter;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.prop.common.mftorder.utils.MftOrderToProorderUtil;

public class MftOrderList
extends AbstractListPlugin {
    private static final String BILLLISTAP = "billlistap";

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("pushpick".equals(itemKey) || "pushreturn".equals(itemKey) || "pushapply".equals(itemKey)) {
            this.pushPick(itemKey);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String key = e.getOperateKey();
        if ("viewmftprooder".equals(key)) {
            this.viewMFTPROODER();
        }
    }

    private void viewMFTPROODER() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection selects = billList.getSelectedRows();
        ArrayList<Object> idList = new ArrayList<Object>(selects.size());
        for (int i = 0; i < selects.size(); ++i) {
            ListSelectedRow row = selects.get(i);
            Object entryPk = row.getEntryPrimaryKeyValue();
            if (entryPk == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u5355\u636e\u5206\u5f55\u7684\u4e3b\u952e\uff0c\u8bf7\u68c0\u67e5\u5217\u8868\u6570\u636e\u663e\u793a\u7684\u51c6\u786e\u6027\u3002", (String)"MftOrderList_19", (String)"mmc-prop-formplugin", (Object[])new Object[0]));
            }
            idList.add(entryPk);
        }
        ArrayList<Long> stockids = new ArrayList<Long>();
        QFilter qFilterStock = new QFilter("orderentryid", "in", idList);
        DynamicObject[] stock = BusinessDataServiceHelper.load((String)"prop_mftstock", (String)"id", (QFilter[])qFilterStock.toArray());
        if (stock != null && stock.length > 0) {
            for (DynamicObject dynamicObject : stock) {
                stockids.add(dynamicObject.getLong("id"));
            }
            if (stockids.size() > 0) {
                QFilter qmftProorder = new QFilter("billentry.mainbillid", "in", stockids);
                DynamicObjectCollection query = QueryServiceHelper.query((String)"im_mdc_mftproorder", (String)"id,billtype.billformid", (QFilter[])qmftProorder.toArray());
                HashSet<Long> prolinkids = new HashSet<Long>();
                HashSet returnlinkids = new HashSet();
                for (DynamicObject dym : query) {
                    String billformid = dym.getString("billtype.billformid");
                    if (!"im_mdc_mftproorder".equals(billformid)) continue;
                    prolinkids.add(dym.getLong("id"));
                }
                HashMap<String, HashSet<Long>> findTargetBills = new HashMap<String, HashSet<Long>>();
                if (prolinkids.isEmpty() && returnlinkids.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4e0b\u6e38\u9886\u6599\u5355\u3002", (String)"MftOrderList_15", (String)"mmc-prop-formplugin", (Object[])new Object[0]));
                    return;
                }
                findTargetBills.put("im_mdc_propproorder", prolinkids);
                HashMap<String, String> para = new HashMap<String, String>();
                para.put("formId", "prop_proorder");
                FormShowParameter fsParameter = FormShowParameter.createFormShowParameter(para);
                fsParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                fsParameter.setCustomParam("paramList", findTargetBills);
                this.getView().showForm(fsParameter);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u751f\u4ea7\u7ec4\u4ef6\u6e05\u5355\u3002", (String)"MftOrderList_16", (String)"mmc-prop-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    private void pushPick(String type) {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection selects = billList.getSelectedRows();
        IFormView view = this.getView();
        StringBuilder thisErrormsg = new StringBuilder();
        if (null == selects || selects.size() == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e", (String)"MftOrderList_1", (String)"mmc-prop-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selects.size() >= 1) {
            for (ListSelectedRow row : selects) {
                String pkid = row.getPrimaryKeyValue().toString();
                Object entryPk = row.getEntryPrimaryKeyValue();
                if (entryPk == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u5355\u636e\u5206\u5f55\u7684\u4e3b\u952e\uff0c\u8bf7\u68c0\u67e5\u5217\u8868\u6570\u636e\u663e\u793a\u7684\u51c6\u786e\u6027\u3002", (String)"MftOrderList_19", (String)"mmc-prop-formplugin", (Object[])new Object[0]));
                }
                DynamicObject manubill = BusinessDataServiceHelper.loadSingle((Object)pkid, (String)"prop_mftorder");
                DynamicObjectCollection entryCol = manubill.getDynamicObjectCollection("treeentryentity");
                StringBuilder tErrormsg = new StringBuilder();
                for (int j = 0; j < entryCol.size(); ++j) {
                    DynamicObject entry = (DynamicObject)entryCol.get(j);
                    if (!entry.getPkValue().toString().equals(entryPk.toString())) continue;
                    String producttype = entry.getString("producttype");
                    String planstatus = entry.getString("planstatus");
                    String bizstatus = entry.getString("bizstatus");
                    if (!"C".equals(producttype)) {
                        tErrormsg.append(ResManager.loadKDString((String)"\u4ea7\u54c1\u7c7b\u578b\u4e0d\u4e3a\u4e3b\u4ea7\u54c1", (String)"MftOrderList_2", (String)"mmc-prop-formplugin", (Object[])new Object[0]));
                    }
                    if (!"A".equals(bizstatus)) {
                        tErrormsg.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\u4e0d\u4e3a\u6b63\u5e38", (String)"MftOrderList_3", (String)"mmc-prop-formplugin", (Object[])new Object[0]));
                    }
                    if (!"C".equals(planstatus)) {
                        tErrormsg.append(ResManager.loadKDString((String)"\u8ba1\u5212\u72b6\u6001\u4e0d\u4e3a\u4e0b\u8fbe", (String)"MftOrderList_4", (String)"mmc-prop-formplugin", (Object[])new Object[0]));
                    }
                    if (tErrormsg.length() <= 0) continue;
                    tErrormsg.insert(0, String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u751f\u4ea7\u5de5\u5355\uff1a%1$s \u7b2c%2$s\u884c\uff0c", (String)"MftOrderList_17", (String)"mmc-prop-formplugin", (Object[])new Object[0]), row.getBillNo(), entry.get("seq")));
                    tErrormsg.append("\u3002\n");
                    thisErrormsg.append((CharSequence)tErrormsg);
                }
            }
        }
        if (thisErrormsg.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6d41\u7a0b\u751f\u4ea7\u5de5\u5355\u9886\u6599\u5931\u8d25\u3002", (String)"MftOrderList_8", (String)"mmc-prop-formplugin", (Object[])new Object[0]), thisErrormsg.toString(), null);
            return;
        }
        ConvertOpParameter opParameter = MftOrderToProorderUtil.buildParameter((IFormView)view, null, (String)type);
        if (opParameter.getSelectedRows().size() == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6d41\u7a0b\u751f\u4ea7\u5de5\u5355\u5173\u8054\u7684\u6d41\u7a0b\u7528\u6599\u6e05\u5355\u4e0d\u5b58\u5728\u9700\u8981\u4e0b\u63a8\u7684\u6570\u636e\u3002", (String)"MftOrderList_9", (String)"mmc-prop-formplugin", (Object[])new Object[0]));
            return;
        }
        String opParameterJson = SerializationUtils.toJsonString((Object)opParameter);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getCustomParams().put("opparam", opParameterJson);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u4e0b\u63a8", (String)"MftOrderList_10", (String)"mmc-prop-formplugin", (Object[])new Object[0]));
        showParameter.setFormId("prop_botp_convertop");
        this.getView().showForm(showParameter);
    }
}

