/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.prop.formplugin.processreport;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.manuftech.bean.ManuFetchEntryBean;
import kd.bd.mpdm.common.manuftech.bean.ManuFetchEntryBeanUtils;
import kd.bd.mpdm.common.manuftech.utils.ChangeEntryStartOrCompletionTimeUtil;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterCalcWriteValueEventArgs;
import kd.bos.entity.botp.plugin.args.AfterCloseRowEventArgs;
import kd.bos.entity.botp.plugin.args.AfterCommitAmountEventArgs;
import kd.bos.entity.botp.plugin.args.AfterExcessCheckEventArgs;
import kd.bos.entity.botp.plugin.args.AfterReadSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeCloseRowEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeCreateArticulationRowEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeExcessCheckEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeExecWriteBackRuleEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeReadSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeSaveSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeTrackEventArgs;
import kd.bos.entity.botp.plugin.args.FinishWriteBackEventArgs;
import kd.bos.entity.botp.plugin.args.PreparePropertysEventArgs;
import kd.bos.entity.botp.plugin.args.RollbackSaveEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.UnitConvertHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.prop.common.mftorder.utils.QueryOrderUtil;
import kd.mmc.prop.common.utils.PropGetOpentryUtils;
import org.apache.commons.collections4.CollectionUtils;

public class PropProcessReportBackWrite
extends AbstractWriteBackPlugIn {
    private static final Log logger = LogFactory.getLog(PropProcessReportBackWrite.class);
    private Map<String, DynamicObject> tarMap = new HashMap<String, DynamicObject>();

    public LinkSetItemElement getCurrLinkSetItem() {
        return super.getCurrLinkSetItem();
    }

    public String getOpType() {
        return super.getOpType();
    }

    public BillEntityType getTargetSubMainType() {
        return super.getTargetSubMainType();
    }

    public void setContext(BillEntityType targetSubMainType, String opType, LinkSetItemElement linkSetItem) {
        super.setContext(targetSubMainType, opType, linkSetItem);
    }

    public void preparePropertys(PreparePropertysEventArgs e) {
        super.preparePropertys(e);
        e.getFieldKeys().add("manufactureentryid");
        e.getFieldKeys().add("oprentry");
        e.getFieldKeys().add("oprentry.id");
        e.getFieldKeys().add("completqty2");
        e.getFieldKeys().add("srcorderid2");
        e.getFieldKeys().add("srcorderentryid2");
        e.getFieldKeys().add("ischargeoff");
        e.getFieldKeys().add("reportdate");
        e.getFieldKeys().add("repactualbegintime");
        e.getFieldKeys().add("repactualfinishtime");
        e.getFieldKeys().add("warehousepoint");
    }

    public void beforeTrack(BeforeTrackEventArgs e) {
        super.beforeTrack(e);
    }

    public void beforeCreateArticulationRow(BeforeCreateArticulationRowEventArgs e) {
        super.beforeCreateArticulationRow(e);
    }

    public void beforeExecWriteBackRule(BeforeExecWriteBackRuleEventArgs e) {
        super.beforeExecWriteBackRule(e);
    }

    public void afterCalcWriteValue(AfterCalcWriteValueEventArgs e) {
        super.afterCalcWriteValue(e);
    }

    public void beforeReadSourceBill(BeforeReadSourceBillEventArgs e) {
        super.beforeReadSourceBill(e);
    }

    public void afterReadSourceBill(AfterReadSourceBillEventArgs e) {
        super.afterReadSourceBill(e);
    }

    public void afterCommitAmount(AfterCommitAmountEventArgs e) {
        super.afterCommitAmount(e);
        DynamicObject activeRow = e.getTargetActiveRow();
        String opType = this.getOpType();
        if (!"delete".equalsIgnoreCase(opType)) {
            if (activeRow != null) {
                DynamicObject parent = (DynamicObject)activeRow.getParent();
                this.tarMap.put(parent.getString("id"), parent);
            }
        } else {
            Long billId = e.getTargetRowId().getBillId();
            QFilter billqf = new QFilter("id", "in", (Object)billId);
            String selectColumn = "id,reportdate,manufactureentryid,oprentry,mroorderentryid,oprentryid,completbaseqty,ischargeoff,srcorderid2,warehousepoint,srcorderentryid2,completqty2,qualifyqty2,receiveqty2,workwasteqty2,scrapqty2,junkqty2,repairqty2,reworkqty2,repactualbegintime,repactualfinishtime";
            this.tarMap.put(billId.toString(), BusinessDataServiceHelper.loadSingle((String)"prop_processreportbill", (String)selectColumn, (QFilter[])new QFilter[]{billqf}));
        }
    }

    public void beforeExcessCheck(BeforeExcessCheckEventArgs e) {
        super.beforeExcessCheck(e);
    }

    public void afterExcessCheck(AfterExcessCheckEventArgs e) {
        super.afterExcessCheck(e);
    }

    public void beforeCloseRow(BeforeCloseRowEventArgs e) {
        super.beforeCloseRow(e);
    }

    public void afterCloseRow(AfterCloseRowEventArgs e) {
        super.afterCloseRow(e);
    }

    public void beforeSaveSourceBill(BeforeSaveSourceBillEventArgs e) {
        super.beforeSaveSourceBill(e);
    }

    public void afterSaveSourceBill(AfterSaveSourceBillEventArgs e) {
        DynamicObject[] mroOrders;
        Map column;
        Map column1;
        super.afterSaveSourceBill(e);
        HashSet orderEntryIds = new HashSet(16);
        HashSet oprEntryIds = new HashSet(16);
        HashSet mroOrderEntryIds = new HashSet(16);
        ArrayList list = new ArrayList(10);
        this.tarMap.forEach((k, v) -> {
            DynamicObjectCollection sumentitys = v.getDynamicObjectCollection("sumentry");
            for (DynamicObject obj : sumentitys) {
                if (obj.getDynamicObject("manufactureentryid") != null) {
                    orderEntryIds.add(obj.getDynamicObject("manufactureentryid").getLong("id"));
                }
                oprEntryIds.add(PropGetOpentryUtils.getOprentryId((DynamicObject)obj));
                if (obj.getDynamicObject("oprentry") == null) continue;
                DynamicObjectCollection dynamicObjectCollection = obj.getDynamicObjectCollection("repsubentryentity");
                Optional<DynamicObject> min = dynamicObjectCollection.stream().filter(x -> x.getDate("repactualbegintime") != null).min(Comparator.comparing(x -> x.getDate("repactualbegintime")));
                Optional<DynamicObject> max = dynamicObjectCollection.stream().filter(x -> x.getDate("repactualfinishtime") != null).max(Comparator.comparing(x -> x.getDate("repactualfinishtime")));
                list.add(ManuFetchEntryBeanUtils.buildBean((Long)PropGetOpentryUtils.getOprentryId((DynamicObject)obj), min, max, (Date)v.getDate("reportdate")));
            }
        });
        Map<Long, List<ManuFetchEntryBean>> map = list.stream().collect(Collectors.groupingBy(ManuFetchEntryBean::getOprEntry));
        HashMap dateMap = new HashMap(16);
        map.forEach((k, v) -> {
            ManuFetchEntryBean max = v.stream().max(Comparator.comparing(ManuFetchEntryBean::getMax)).orElseGet(() -> new ManuFetchEntryBean());
            ManuFetchEntryBean min = v.stream().min(Comparator.comparing(ManuFetchEntryBean::getMin)).orElseGet(() -> new ManuFetchEntryBean());
            ManuFetchEntryBean bean = new ManuFetchEntryBean();
            bean.setOprEntry(k);
            bean.setMin(min.getMin());
            bean.setMax(max.getMax());
            dateMap.put(k, bean);
        });
        String selectProperties = QueryOrderUtil.selectProperties((String)"prop_manftech");
        StringBuilder stringBuilder = new StringBuilder(selectProperties);
        stringBuilder.append(',');
        stringBuilder.append("oprentryentity").append('.').append("pushreportbaseqty").append(',');
        stringBuilder.append("modifier").append(',');
        stringBuilder.append("modifytime");
        DynamicObject[] mftOrders = CollectionUtils.isNotEmpty(orderEntryIds) ? BusinessDataServiceHelper.load((String)"prop_mftorder", (String)"unit,baseunit,materielmasterid,qualifiedqty,rptqty,workwasteqty,reworkqty,mtlcostqty,acceptqty,scrapqty,repairqty,reportqty,unreportqty,qty", (QFilter[])new QFilter[]{new QFilter("treeentryentity.id", "in", orderEntryIds)}) : new DynamicObject[]{};
        DynamicObject[] manftechs = BusinessDataServiceHelper.load((String)"prop_manftech", (String)stringBuilder.toString(), (QFilter[])new QFilter[]{new QFilter("oprentryentity.id", "in", oprEntryIds)});
        HashMap<Long, DynamicObject> oprDynamicObjectMap = new HashMap<Long, DynamicObject>(16);
        for (int i = 0; i < manftechs.length; ++i) {
            DynamicObjectCollection collection = manftechs[i].getDynamicObjectCollection("oprentryentity");
            for (DynamicObject object : collection) {
                oprDynamicObjectMap.put(object.getLong("id"), object);
            }
        }
        HashBasedTable param = HashBasedTable.create();
        this.tarMap.forEach((arg_0, arg_1) -> this.lambda$afterSaveSourceBill$8(mftOrders, oprDynamicObjectMap, manftechs, dateMap, (Table)param, arg_0, arg_1));
        SaveServiceHelper.save((DynamicObject[])mftOrders);
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ignorewarn", String.valueOf(true));
        operateOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        operateOption.setVariableValue("strictvalidation", String.valueOf(true));
        operateOption.setVariableValue("ignoreValidation", String.valueOf(true));
        operateOption.setVariableValue("WF", "false");
        operateOption.setVariableValue("orderBillType", "prop_mftorder");
        Map column2 = param.column((Object)"row_start");
        if (CollectionUtils.isNotEmpty(column2.keySet())) {
            DynamicObject object;
            operateOption.setVariableValue("operateOption", JSON.toJSONString(column2.keySet()));
            object = OperationServiceHelper.executeOperate((String)"donothing_start", (String)"prop_manftech", (DynamicObject[])manftechs, (OperateOption)operateOption);
        }
        if (CollectionUtils.isNotEmpty((column1 = param.column((Object)"row_finish")).keySet())) {
            operateOption.setVariableValue("operateOption", JSON.toJSONString(column1.keySet()));
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"donothing_finish", (String)"prop_manftech", (DynamicObject[])manftechs, (OperateOption)operateOption);
        }
        if (CollectionUtils.isNotEmpty((column = param.column((Object)"row_unstart")).keySet())) {
            operateOption.setVariableValue("operateOption", JSON.toJSONString(column.keySet()));
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"donothing_unstart", (String)"prop_manftech", (DynamicObject[])manftechs, (OperateOption)operateOption);
        }
        DynamicObject[] dynamicObjectArray = mroOrders = CollectionUtils.isNotEmpty(mroOrderEntryIds) ? BusinessDataServiceHelper.load((String)"pom_mroorder", (String)"planhours,actualhours", (QFilter[])new QFilter[]{new QFilter("treeentryentity.id", "in", mroOrderEntryIds)}) : new DynamicObject[]{};
        if (mroOrders.length > 0) {
            this.tarMap.forEach((k, v) -> {
                DynamicObjectCollection sumentitys = v.getDynamicObjectCollection("sumentry");
                for (DynamicObject obj : sumentitys) {
                    DynamicObject mroorderentryid = obj.getDynamicObject("mroorderentryid");
                    if (mroorderentryid == null) continue;
                    for (DynamicObject object : mroOrders) {
                        DynamicObjectCollection ooderEntrys = object.getDynamicObjectCollection("treeentryentity");
                        for (DynamicObject orderEntry : ooderEntrys) {
                            if (!orderEntry.getPkValue().toString().equals(mroorderentryid.getPkValue().toString())) continue;
                            String option = this.getOpType();
                            if (v.getBoolean("ischargeoff") && "audit".equalsIgnoreCase(option)) {
                                option = "unaudit";
                            }
                            if ("audit".equalsIgnoreCase(option)) {
                                orderEntry.set("actualhours", (Object)orderEntry.getBigDecimal("actualhours").add(obj.getBigDecimal("totalconsumedhours")));
                                continue;
                            }
                            if (!"unaudit".equalsIgnoreCase(option)) continue;
                            orderEntry.set("actualhours", (Object)orderEntry.getBigDecimal("actualhours").subtract(obj.getBigDecimal("totalconsumedhours")));
                        }
                    }
                }
            });
            SaveServiceHelper.save((DynamicObject[])mroOrders);
        }
    }

    public void finishWriteBack(FinishWriteBackEventArgs e) {
        super.finishWriteBack(e);
    }

    public void rollbackSave(RollbackSaveEventArgs e) {
        super.rollbackSave(e);
    }

    private void rewriteOrtherProductInfo(DynamicObject otherentry, String option, DynamicObject[] mftOrders) {
        String srcorderid = otherentry.getString("srcorderid2");
        String srcorderentryid = otherentry.getString("srcorderentryid2");
        if (srcorderid != null && srcorderentryid != null && !srcorderid.trim().isEmpty()) {
            for (int i = 0; i < mftOrders.length; ++i) {
                DynamicObjectCollection orderentrys = mftOrders[i].getDynamicObjectCollection("treeentryentity");
                for (DynamicObject ordentry : orderentrys) {
                    if (!ordentry.getPkValue().toString().equals(srcorderentryid)) continue;
                    if ("audit".equals(option)) {
                        ordentry.set("qualifiedqty", (Object)ordentry.getBigDecimal("qualifiedqty").add(otherentry.getBigDecimal("qualifyqty2")));
                        ordentry.set("workwasteqty", (Object)ordentry.getBigDecimal("workwasteqty").add(otherentry.getBigDecimal("workwasteqty2")));
                        ordentry.set("mtlcostqty", (Object)ordentry.getBigDecimal("mtlcostqty").add(otherentry.getBigDecimal("scrapqty2")));
                        ordentry.set("acceptqty", (Object)ordentry.getBigDecimal("acceptqty").add(otherentry.getBigDecimal("receiveqty2")));
                        ordentry.set("scrapqty", (Object)ordentry.getBigDecimal("scrapqty").add(otherentry.getBigDecimal("junkqty2")));
                        ordentry.set("repairqty", (Object)ordentry.getBigDecimal("repairqty").add(otherentry.getBigDecimal("repairqty2")));
                        ordentry.set("reworkqty", (Object)ordentry.getBigDecimal("reworkqty").add(otherentry.getBigDecimal("reworkqty2")));
                        ordentry.set("reportqty", (Object)ordentry.getBigDecimal("reportqty").add(otherentry.getBigDecimal("completqty2")));
                        this.updateUnReportQty(ordentry);
                        continue;
                    }
                    if ("unaudit".equals(option)) {
                        ordentry.set("qualifiedqty", (Object)ordentry.getBigDecimal("qualifiedqty").subtract(otherentry.getBigDecimal("qualifyqty2")));
                        ordentry.set("workwasteqty", (Object)ordentry.getBigDecimal("workwasteqty").subtract(otherentry.getBigDecimal("workwasteqty2")));
                        ordentry.set("mtlcostqty", (Object)ordentry.getBigDecimal("mtlcostqty").subtract(otherentry.getBigDecimal("scrapqty2")));
                        ordentry.set("acceptqty", (Object)ordentry.getBigDecimal("acceptqty").subtract(otherentry.getBigDecimal("receiveqty2")));
                        ordentry.set("scrapqty", (Object)ordentry.getBigDecimal("scrapqty").subtract(otherentry.getBigDecimal("junkqty2")));
                        ordentry.set("repairqty", (Object)ordentry.getBigDecimal("repairqty").subtract(otherentry.getBigDecimal("repairqty2")));
                        ordentry.set("reworkqty", (Object)ordentry.getBigDecimal("reworkqty").subtract(otherentry.getBigDecimal("reworkqty2")));
                        ordentry.set("reportqty", (Object)ordentry.getBigDecimal("reportqty").subtract(otherentry.getBigDecimal("completqty2")));
                        this.updateUnReportQty(ordentry);
                        continue;
                    }
                    if ("save".equals(option) || "draft".equals(option)) {
                        ordentry.set("rptqty", (Object)ordentry.getBigDecimal("rptqty").add(otherentry.getBigDecimal("completqty2")));
                        continue;
                    }
                    if (!"delete".equals(option)) continue;
                    ordentry.set("rptqty", (Object)ordentry.getBigDecimal("rptqty").subtract(otherentry.getBigDecimal("completqty2")));
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])mftOrders);
    }

    private void rewriteroductInfo(DynamicObject object, String option, DynamicObject[] mftOrders, DynamicObject oprDynamicObject) {
        for (int i = 0; i < mftOrders.length; ++i) {
            DynamicObjectCollection orderentrys = mftOrders[i].getDynamicObjectCollection("treeentryentity");
            for (DynamicObject dynamicObject : orderentrys) {
                if (!Objects.equals(dynamicObject.getPkValue(), object.getDynamicObject("manufactureentryid").getPkValue())) continue;
                DynamicObject unit = dynamicObject.getDynamicObject("unit");
                DynamicObject baseUnit = dynamicObject.getDynamicObject("baseunit");
                DynamicObject materielmaster = dynamicObject.getDynamicObject("materielmasterid");
                if ("save".equals(option) || "draft".equals(option)) {
                    dynamicObject.set("rptqty", (Object)this.getQtyByBaseQty(oprDynamicObject.getBigDecimal("pushreportbaseqty"), unit, baseUnit, materielmaster));
                    continue;
                }
                if ("delete".equals(option)) {
                    dynamicObject.set("rptqty", (Object)this.getQtyByBaseQty(oprDynamicObject.getBigDecimal("pushreportbaseqty"), unit, baseUnit, materielmaster));
                    continue;
                }
                if ("audit".equals(option)) {
                    dynamicObject.set("qualifiedqty", (Object)dynamicObject.getBigDecimal("qualifiedqty").add(this.getQtyByBaseQty(object.getBigDecimal("qualifybaseqty"), unit, baseUnit, materielmaster)));
                    dynamicObject.set("workwasteqty", (Object)dynamicObject.getBigDecimal("workwasteqty").add(this.getQtyByBaseQty(object.getBigDecimal("workwastebaseqty"), unit, baseUnit, materielmaster)));
                    dynamicObject.set("mtlcostqty", (Object)dynamicObject.getBigDecimal("mtlcostqty").add(this.getQtyByBaseQty(object.getBigDecimal("scrapbaseqty"), unit, baseUnit, materielmaster)));
                    dynamicObject.set("acceptqty", (Object)dynamicObject.getBigDecimal("acceptqty").add(this.getQtyByBaseQty(object.getBigDecimal("receivebaseqty"), unit, baseUnit, materielmaster)));
                    dynamicObject.set("scrapqty", (Object)dynamicObject.getBigDecimal("scrapqty").add(this.getQtyByBaseQty(object.getBigDecimal("junkbaseqty"), unit, baseUnit, materielmaster)));
                    dynamicObject.set("repairqty", (Object)dynamicObject.getBigDecimal("repairqty").add(this.getQtyByBaseQty(object.getBigDecimal("repairbaseqty"), unit, baseUnit, materielmaster)));
                    dynamicObject.set("reworkqty", (Object)dynamicObject.getBigDecimal("reworkqty").add(this.getQtyByBaseQty(object.getBigDecimal("checkreworkbaseqty"), unit, baseUnit, materielmaster)));
                    dynamicObject.set("reportqty", (Object)dynamicObject.getBigDecimal("reportqty").add(this.getQtyByBaseQty(object.getBigDecimal("completbaseqty"), unit, baseUnit, materielmaster)));
                    this.updateUnReportQty(dynamicObject);
                    continue;
                }
                if (!"unaudit".equals(option)) continue;
                dynamicObject.set("qualifiedqty", (Object)dynamicObject.getBigDecimal("qualifiedqty").subtract(this.getQtyByBaseQty(object.getBigDecimal("qualifybaseqty"), unit, baseUnit, materielmaster)));
                dynamicObject.set("workwasteqty", (Object)dynamicObject.getBigDecimal("workwasteqty").subtract(this.getQtyByBaseQty(object.getBigDecimal("workwastebaseqty"), unit, baseUnit, materielmaster)));
                dynamicObject.set("mtlcostqty", (Object)dynamicObject.getBigDecimal("mtlcostqty").subtract(this.getQtyByBaseQty(object.getBigDecimal("scrapbaseqty"), unit, baseUnit, materielmaster)));
                dynamicObject.set("acceptqty", (Object)dynamicObject.getBigDecimal("acceptqty").subtract(this.getQtyByBaseQty(object.getBigDecimal("receivebaseqty"), unit, baseUnit, materielmaster)));
                dynamicObject.set("scrapqty", (Object)dynamicObject.getBigDecimal("scrapqty").subtract(this.getQtyByBaseQty(object.getBigDecimal("junkbaseqty"), unit, baseUnit, materielmaster)));
                dynamicObject.set("repairqty", (Object)dynamicObject.getBigDecimal("repairqty").subtract(this.getQtyByBaseQty(object.getBigDecimal("repairbaseqty"), unit, baseUnit, materielmaster)));
                dynamicObject.set("reworkqty", (Object)dynamicObject.getBigDecimal("reworkqty").subtract(this.getQtyByBaseQty(object.getBigDecimal("checkreworkbaseqty"), unit, baseUnit, materielmaster)));
                dynamicObject.set("reportqty", (Object)dynamicObject.getBigDecimal("reportqty").subtract(this.getQtyByBaseQty(object.getBigDecimal("completbaseqty"), unit, baseUnit, materielmaster)));
                this.updateUnReportQty(dynamicObject);
            }
        }
    }

    private void updateUnReportQty(DynamicObject dynamicObject) {
        BigDecimal reportqty = dynamicObject.getBigDecimal("reportqty");
        BigDecimal qty = dynamicObject.getBigDecimal("qty");
        BigDecimal repairqty = dynamicObject.getBigDecimal("repairqty");
        BigDecimal unreportqty = qty.subtract(reportqty).add(repairqty);
        if (BigDecimal.ZERO.compareTo(unreportqty) > 0) {
            dynamicObject.set("unreportqty", (Object)BigDecimal.ZERO);
        } else {
            dynamicObject.set("unreportqty", (Object)unreportqty);
        }
    }

    private BigDecimal getQtyByBaseQty(BigDecimal baseQty, DynamicObject unit, DynamicObject baseUnit, DynamicObject materielmaster) {
        return UnitConvertHelper.calculateNewQty((BigDecimal)baseQty, (Long)(unit == null ? null : Long.valueOf(unit.getLong("id"))), (Long)(baseUnit == null ? null : Long.valueOf(baseUnit.getLong("id"))), (Long)(materielmaster == null ? null : Long.valueOf(materielmaster.getLong("id"))), (StringBuilder)new StringBuilder());
    }

    private /* synthetic */ void lambda$afterSaveSourceBill$8(DynamicObject[] mftOrders, Map oprDynamicObjectMap, DynamicObject[] manftechs, Map dateMap, Table param, String k, DynamicObject v) {
        DynamicObjectCollection sumentitys = v.getDynamicObjectCollection("sumentry");
        for (DynamicObject obj : sumentitys) {
            if (obj.getBoolean("warehousepoint")) {
                this.rewriteroductInfo(obj, this.getOpType().toLowerCase(), mftOrders, (DynamicObject)oprDynamicObjectMap.get(PropGetOpentryUtils.getOprentryId((DynamicObject)obj)));
            }
            DynamicObjectCollection otherProductEntity = obj.getDynamicObjectCollection("otherproductentity");
            for (DynamicObject otherEntry : otherProductEntity) {
                this.rewriteOrtherProductInfo(otherEntry, this.getOpType().toLowerCase(), mftOrders);
            }
            Long entryPkvalue = PropGetOpentryUtils.getOprentryId((DynamicObject)obj);
            if (entryPkvalue == null) continue;
            for (DynamicObject object : manftechs) {
                DynamicObjectCollection manftechEntrys = object.getDynamicObjectCollection("oprentryentity");
                for (DynamicObject manftechentry : manftechEntrys) {
                    if (!manftechentry.getPkValue().toString().equals(entryPkvalue.toString())) continue;
                    String option = this.getOpType();
                    if (v.getBoolean("ischargeoff") && "audit".equalsIgnoreCase(option)) {
                        option = "unaudit";
                    }
                    ManuFetchEntryBean manuFetchEntryBean = (ManuFetchEntryBean)dateMap.get(entryPkvalue);
                    if ("audit".equalsIgnoreCase(option)) {
                        if (StringUtils.equals((CharSequence)"10070", (CharSequence)obj.getString("confirmoprstatus"))) {
                            if (manftechentry.getBigDecimal("floorqty").compareTo(manftechentry.getBigDecimal("oprtotalqualifiedqty").add(manftechentry.getBigDecimal("oprtotalreceiveqty"))) <= 0) {
                                if ("E".equals(manftechentry.getString("oprstatus"))) {
                                    param.put((Object)entryPkvalue, (Object)"row_finish", (Object)"F");
                                }
                                if ("D".equals(manftechentry.getString("oprstatus"))) {
                                    param.put((Object)entryPkvalue, (Object)"row_start", (Object)"E");
                                    param.put((Object)entryPkvalue, (Object)"row_finish", (Object)"F");
                                }
                                ChangeEntryStartOrCompletionTimeUtil.changeEntryStartOrCompletionTimeToFinish((DynamicObject)manftechentry, (Date)manuFetchEntryBean.getMin(), (Date)manuFetchEntryBean.getMax());
                                continue;
                            }
                            if ("D".equals(manftechentry.getString("oprstatus"))) {
                                param.put((Object)entryPkvalue, (Object)"row_start", (Object)"E");
                            }
                            ChangeEntryStartOrCompletionTimeUtil.changeEntryStartOrCompletionTimeToStart((DynamicObject)manftechentry, (Date)manuFetchEntryBean.getMin());
                            continue;
                        }
                        if (!StringUtils.equals((CharSequence)"10080", (CharSequence)obj.getString("confirmoprstatus"))) continue;
                        if ("E".equals(manftechentry.getString("oprstatus"))) {
                            param.put((Object)entryPkvalue, (Object)"row_finish", (Object)"F");
                        }
                        if ("D".equals(manftechentry.getString("oprstatus"))) {
                            param.put((Object)entryPkvalue, (Object)"row_start", (Object)"E");
                        }
                        ChangeEntryStartOrCompletionTimeUtil.changeEntryStartOrCompletionTimeToFinish((DynamicObject)manftechentry, (Date)manuFetchEntryBean.getMin(), (Date)manuFetchEntryBean.getMax());
                        continue;
                    }
                    if (!"unaudit".equalsIgnoreCase(option) || manftechentry.getBigDecimal("floorqty").compareTo(manftechentry.getBigDecimal("oprtotalqualifiedqty").add(manftechentry.getBigDecimal("oprtotalreceiveqty"))) <= 0 || !"F".equals(manftechentry.getString("oprstatus"))) continue;
                    param.put((Object)entryPkvalue, (Object)"row_unstart", (Object)"E");
                }
            }
        }
    }
}

