/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.prop.common.mftorder.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.botp.ConvertBill;
import kd.bos.entity.botp.ConvertOpType;
import kd.bos.entity.botp.ConvertRuleCache;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.ConvertOpParameter;
import kd.bos.entity.botp.runtime.ConvertOpRule;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class MftOrderToProorderUtil {
    public static ConvertOpParameter buildParameter(IFormView iListView, IBillView iBillView, String type) {
        ConvertOpParameter opParameter = new ConvertOpParameter();
        opParameter.setOpType(ConvertOpType.Push);
        opParameter.setAppId("prop");
        opParameter.setEntityNumber("prop_mftstock");
        List<Object> bills = MftOrderToProorderUtil.loadTargetBills(iListView, iBillView, type);
        if (StringUtils.equals((CharSequence)"pushreturn", (CharSequence)type)) {
            bills = bills.stream().filter(var -> "im_mdc_mftreturnorder".equals(var.getEntityNumber())).collect(Collectors.toList());
        } else if (StringUtils.equals((CharSequence)"pushpick", (CharSequence)type)) {
            bills = bills.stream().filter(var -> "im_mdc_mftproorder".equals(var.getEntityNumber())).collect(Collectors.toList());
        } else if (StringUtils.equals((CharSequence)"pushapply", (CharSequence)type)) {
            bills = bills.stream().filter(var -> "im_mdc_mftomreqapplybill".equals(var.getEntityNumber())).collect(Collectors.toList());
        }
        if (bills != null) {
            opParameter.getBills().addAll(bills);
        }
        if (null != iListView) {
            IListView listView = (IListView)iListView;
            opParameter.setSelectedRows(MftOrderToProorderUtil.getListSelectRow(listView.getSelectedRows(), type));
        } else {
            IBillModel billModel = (IBillModel)iBillView.getModel();
            opParameter.setSelectedRows(MftOrderToProorderUtil.getEditSelectRow(iBillView, billModel, type));
        }
        opParameter.setDefTargetBill("");
        opParameter.setDefRuleId("");
        opParameter.setHasRight(false);
        return opParameter;
    }

    private static ListSelectedRowCollection getListSelectRow(ListSelectedRowCollection selects, String type) {
        ListSelectedRowCollection resultSelect = new ListSelectedRowCollection();
        for (int i = 0; i < selects.size(); ++i) {
            ListSelectedRow row = selects.get(i);
            String pkid = row.getPrimaryKeyValue().toString();
            Object entryPk = row.getEntryPrimaryKeyValue();
            ListSelectedRowCollection resultsimple = MftOrderToProorderUtil.getStockSelectedRows(pkid, entryPk, type);
            resultSelect.addAll((Collection)resultsimple);
        }
        return resultSelect;
    }

    public static ListSelectedRowCollection getStockSelectedRows(String pkid, Object entryid, String type) {
        DynamicObject stock = null;
        String selectProperties = "id,billstatus,stockentry.id,stockentry.wipqty";
        if (StringUtils.equals((CharSequence)"pushpick", (CharSequence)type) || StringUtils.equals((CharSequence)"pushreturn", (CharSequence)type) || StringUtils.equals((CharSequence)"pushapply", (CharSequence)type)) {
            stock = MftOrderToProorderUtil.getOrderStockBySelectProperties(pkid, entryid, "prop_mftstock", selectProperties);
        }
        ListSelectedRowCollection selectedRows = new ListSelectedRowCollection();
        if (null != stock && StringUtils.equals((CharSequence)"C", (CharSequence)stock.getString("billstatus"))) {
            DynamicObjectCollection stockentrys = stock.getDynamicObjectCollection("stockentry");
            for (int j = 0; j < stockentrys.size(); ++j) {
                ListSelectedRow row;
                DynamicObject dynamicObject = (DynamicObject)stockentrys.get(j);
                BigDecimal wipQty = dynamicObject.getBigDecimal("wipqty");
                if (StringUtils.equals((CharSequence)"pushpick", (CharSequence)type) || StringUtils.equals((CharSequence)"pushapply", (CharSequence)type)) {
                    row = new ListSelectedRow(stock.getPkValue());
                    row.setEntryEntityKey("stockentry");
                    row.setEntryPrimaryKeyValue(dynamicObject.getPkValue());
                    selectedRows.add((Object)row);
                    continue;
                }
                if (!StringUtils.equals((CharSequence)"pushreturn", (CharSequence)type) || wipQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                row = new ListSelectedRow(stock.getPkValue());
                row.setEntryEntityKey("stockentry");
                row.setEntryPrimaryKeyValue(dynamicObject.getPkValue());
                selectedRows.add((Object)row);
            }
        }
        return selectedRows;
    }

    private static ListSelectedRowCollection getEditSelectRow(IBillView iBillView, IBillModel billModel, String type) {
        ListSelectedRowCollection resultSelect = new ListSelectedRowCollection();
        EntryGrid entryGrid = (EntryGrid)iBillView.getControl("treeentryentity");
        DynamicObject dataEntity = billModel.getDataEntity();
        String pkid = dataEntity.getPkValue().toString();
        for (int i = 0; i < entryGrid.getSelectRows().length; ++i) {
            DynamicObject entry = billModel.getEntryRowEntity("treeentryentity", entryGrid.getSelectRows()[i]);
            Object pkValue = entry.getPkValue();
            String producttype = entry.getString("producttype");
            if (!"C".equals(producttype)) continue;
            ListSelectedRowCollection resultsimple = MftOrderToProorderUtil.getStockSelectedRows(pkid, pkValue, type);
            resultSelect.addAll((Collection)resultsimple);
        }
        return resultSelect;
    }

    private static DynamicObject getOrderStockBySelectProperties(Object orderid, Object orderEntryid, String entityType, String selectProperties) {
        QFilter filter1 = new QFilter("orderid", "=", (Object)(orderid != null ? orderid.toString() : "0"));
        QFilter filter2 = new QFilter("orderentryid", "=", (Object)(orderEntryid != null ? Long.parseLong(orderEntryid.toString()) : 0L));
        return BusinessDataServiceHelper.loadSingle((String)entityType, (String)selectProperties, (QFilter[])new QFilter[]{filter1, filter2});
    }

    private static List<ConvertBill> loadTargetBills(IFormView iListView, IBillView iBillView, String type) {
        ArrayList<ConvertBill> list = new ArrayList<ConvertBill>(10);
        String sourceEntityNumber = "prop_mftstock";
        List bills = ConvertMetaServiceHelper.loadConvertBills((String)sourceEntityNumber, (ConvertOpType)ConvertOpType.Push);
        Set<Long> srcBillTypeIds = MftOrderToProorderUtil.getSrcBillTypeIds(iListView, iBillView);
        for (ConvertBill bill : bills) {
            List<ConvertOpRule> opRules = MftOrderToProorderUtil.filterRules(bill, srcBillTypeIds, sourceEntityNumber);
            if (opRules.isEmpty()) continue;
            bill.getRules().addAll(opRules);
            list.add(bill);
        }
        return list;
    }

    private static Set<Long> getSrcBillTypeIds(IFormView iListView, IBillView iBillView) {
        HashSet<Long> billTypeIds = new HashSet<Long>();
        if (null != iListView) {
            IListView listView = (IListView)iListView;
            for (ListSelectedRow row : listView.getSelectedRows()) {
                if (row.getBillTypeID() == null || Long.compare(0L, row.getBillTypeID()) == 0) continue;
                billTypeIds.add(row.getBillTypeID());
            }
        } else {
            DynamicObject billTypeObj;
            String billTypeKey = ((BillEntityType)iBillView.getModel().getDataEntityType()).getBillType();
            if (StringUtils.isNotBlank((CharSequence)billTypeKey) && (billTypeObj = (DynamicObject)iBillView.getModel().getValue(billTypeKey)) != null) {
                billTypeIds.add((Long)billTypeObj.getPkValue());
            }
        }
        return billTypeIds;
    }

    private static List<ConvertOpRule> filterRules(ConvertBill bill, Set<Long> srcBillTypeIds, String sourceEntityNumber) {
        ArrayList<ConvertOpRule> opRules = new ArrayList<ConvertOpRule>(10);
        List<ConvertRuleElement> rules = MftOrderToProorderUtil.loadRules(sourceEntityNumber, bill.getEntityNumber());
        if (rules.isEmpty()) {
            return opRules;
        }
        for (ConvertRuleElement rule : rules) {
            if (!rule.isEnabled()) continue;
            ConvertOpRule opRule = new ConvertOpRule(rule.getId(), rule.getName().toString());
            opRule.setVisibled(rule.isVisibled());
            opRules.add(opRule);
        }
        return opRules;
    }

    private static List<ConvertRuleElement> loadRules(String sourceEntityNumber, String targetEntityNumber) {
        List rules = ConvertRuleCache.loadRules((String)sourceEntityNumber, (String)targetEntityNumber);
        ArrayList<ConvertRuleElement> enableRules = new ArrayList<ConvertRuleElement>();
        for (ConvertRuleElement rule : rules) {
            if (!rule.isEnabled()) continue;
            enableRules.add(rule);
        }
        return enableRules;
    }
}

