/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.mastermodel.formplugin;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.mastermodel.utils.FormUtil;

public class MasterCombCfgEditPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEnable();
    }

    private void setEnable() {
        IFormView view = this.getView();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Boolean isPreset = dataEntity.getBoolean("ispreset");
        if (isPreset.booleanValue()) {
            view.setEnable(Boolean.FALSE, new String[]{"flexpanelap"});
        } else {
            view.setEnable(Boolean.TRUE, new String[]{"flexpanelap"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtil.addF7Listener(this, "masterfilemeta");
        this.addClickListeners(new String[]{"masterfield", "additionalfield"});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        QFilter filter = null;
        switch (key) {
            case "masterfilemeta": {
                filter = MasterCombCfgEditPlugin.getMasterfileMetaFilter();
                ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(filter);
            }
        }
    }

    private static QFilter getMasterfileMetaFilter() {
        QFilter filter = new QFilter("number", "in", MasterCombCfgEditPlugin.getAllMetaInheritFrom("msbd_masterfile"));
        return filter;
    }

    private static Set<String> getAllMetaInheritFrom(String source) {
        HashSet<String> allNumbers = new HashSet<String>();
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select t2.fnumber from t_meta_formdesign t1", new Object[0]).append(" join t_meta_formdesign t2 on t1.fentityid = t2.fparentid where ", new Object[0]).append(" t1.fnumber = ? ", new Object[]{source});
        try (DataSet formDataset = DB.queryDataSet((String)MasterCombCfgEditPlugin.class.getName(), (DBRoute)DBRoute.meta, (SqlBuilder)sqlBuilder);){
            for (Row row : formDataset) {
                String number = row.getString("fnumber");
                allNumbers.add(number);
                allNumbers.addAll(MasterCombCfgEditPlugin.getAllMetaInheritFrom(number));
            }
        }
        return allNumbers;
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "masterfield": {
                this.clickMasterField();
                break;
            }
            case "additionalfield": {
                this.clickAdditionalField();
            }
        }
    }

    private void clickMasterField() {
        IDataModel model = this.getModel();
        DynamicObject masterMetaObj = (DynamicObject)model.getValue("masterfilemeta");
        if (masterMetaObj == null) {
            String message = ResManager.loadKDString((String)"\u4e3b\u6863\u7c7b\u578b\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u4e3b\u6863\u7c7b\u578b\u3002", (String)"MasterCombCfgEditPlugin_0", (String)"mpscmm-msbd-mastermodel", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return;
        }
        String masterMeta = masterMetaObj.getString("id");
        this.showSelectFieldForm(masterMeta, "masterfield");
    }

    private void clickAdditionalField() {
        IDataModel model = this.getModel();
        DynamicObject additionalMetaObj = (DynamicObject)model.getValue("masteraddition");
        if (additionalMetaObj == null) {
            String message = ResManager.loadKDString((String)"\u4e3b\u6863\u9644\u52a0\u4fe1\u606f\u7c7b\u578b\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u4e3b\u6863\u9644\u52a0\u4fe1\u606f\u7c7b\u578b\u3002", (String)"MasterCombCfgEditPlugin_1", (String)"mpscmm-msbd-mastermodel", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return;
        }
        String additionalMeta = additionalMetaObj.getString("id");
        this.showSelectFieldForm(additionalMeta, "additionalfield");
    }

    private void showSelectFieldForm(String source, String sourceCtrlKey) {
        MainEntityType sourceType = EntityMetadataCache.getDataEntityType((String)source);
        PropTreeBuildOption ops = new PropTreeBuildOption();
        ops.setIncludeBDPropPK(false);
        ops.setIncludeBDRefProp(false);
        ops.setIncludeChildEntity(false);
        ops.setIncludeParentEntity(false);
        ops.setIncludePKField(true);
        TreeNode metaNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)sourceType, (PropTreeBuildOption)ops);
        Iterator iterator = metaNode.getChildren().iterator();
        while (iterator.hasNext()) {
            TreeNode child = (TreeNode)iterator.next();
            if ("billhead".equals(child.getId())) continue;
            iterator.remove();
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)metaNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId = e.getActionId()) {
            case "masterfield": 
            case "additionalfield": {
                this.chooseFieldCallBack(actionId, (String)returnData);
            }
        }
    }

    private void chooseFieldCallBack(String actionId, String returnCol) {
        if (StringUtils.isBlank((String)returnCol)) {
            return;
        }
        IDataModel model = this.getModel();
        String source = null;
        switch (actionId) {
            case "masterfield": {
                source = ((DynamicObject)model.getValue("masterfilemeta")).getString("id");
                break;
            }
            case "additionalfield": {
                source = ((DynamicObject)model.getValue("masteraddition")).getString("id");
            }
        }
        if (returnCol.equals(source) || returnCol.equals("billhead")) {
            return;
        }
        model.beginInit();
        model.setValue(actionId, (Object)returnCol);
        model.endInit();
        this.getView().updateView();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        ChangeData[] changeSet = e.getChangeSet();
        IDataModel model = this.getModel();
        switch (key = e.getProperty().getName()) {
            case "masterfilemeta": 
            case "masteraddition": {
                this.changeMeta(model, changeSet, key);
            }
        }
    }

    private void changeMeta(IDataModel model, ChangeData[] changeSet, String key) {
        model.beginInit();
        block8: for (ChangeData changeData : changeSet) {
            int index = changeData.getRowIndex();
            switch (key) {
                case "masterfilemeta": {
                    model.setValue("masterfield", null, index);
                    continue block8;
                }
                case "masteraddition": {
                    model.setValue("additionalfield", null, index);
                }
            }
        }
        model.endInit();
        this.getView().updateView();
    }
}

