/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.mastermodel.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class MasterfileTplEditPlugin
extends AbstractBasePlugIn
implements TabSelectListener,
HyperLinkClickListener {
    private static final String KEY_ADDITIONALMETAS = "additionalMetas";
    private static final String KEY_COMPMETA = "compMeta";
    private static final String KEY_COMPTITLE = "compTitle";
    private static final String VAL_NOTCOMBDATA = "NOTCOMBDATA";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        EntryGrid entryentity = (EntryGrid)this.getView().getControl("entryentity");
        entryentity.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView view = (IFormView)e.getSource();
        List<Map<String, String>> additionalMetas = MasterfileTplEditPlugin.getMasterCombCfg(view.getModel().getDataEntityType().getName());
        this.getPageCache().put(KEY_ADDITIONALMETAS, SerializationUtils.toJsonString(additionalMetas));
        for (int i = 0; i < 8; ++i) {
            String targetPage = "tabpageap" + i;
            if (i < additionalMetas.size()) {
                Map<String, String> additionalMeta = additionalMetas.get(i);
                String compTitle = additionalMeta.get(KEY_COMPTITLE);
                TabPage tabpage = (TabPage)view.getControl(targetPage);
                if (tabpage == null) continue;
                tabpage.setText(new LocaleString(compTitle));
                continue;
            }
            view.setVisible(Boolean.FALSE, new String[]{targetPage});
        }
    }

    private static List<Map<String, String>> getMasterCombCfg(String formid) {
        Map cfgs = BusinessDataServiceHelper.loadFromCache((String)"msbd_mastercombcfg", (QFilter[])new QFilter("masterfilemeta", "=", (Object)formid).and("enable", "=", (Object)Boolean.TRUE).toArray());
        ArrayList<Map<String, String>> additionalMetas = new ArrayList<Map<String, String>>(cfgs.size());
        for (DynamicObject cfg : cfgs.values()) {
            DynamicObject masteraddition = cfg.getDynamicObject("masteraddition");
            HashMap<String, String> additionalMeta = new HashMap<String, String>(4);
            additionalMeta.put(KEY_COMPMETA, masteraddition.getString("id"));
            additionalMeta.put(KEY_COMPTITLE, masteraddition.getString("name"));
            additionalMeta.put("masterfield", cfg.getString("masterfield"));
            additionalMeta.put("additionalfield", cfg.getString("additionalfield"));
            additionalMetas.add(additionalMeta);
        }
        return additionalMetas;
    }

    public void tabSelected(TabSelectEvent evt) {
        IDataModel model = this.getModel();
        String curSelTabKey = evt.getTabKey();
        if (curSelTabKey.startsWith("tabpageap")) {
            Object masterfieldVal;
            String pageId = this.getPageCache().get(curSelTabKey);
            if (pageId != null && this.getView().getView(pageId) != null || VAL_NOTCOMBDATA.equals(pageId)) {
                return;
            }
            Integer tabSeq = Integer.valueOf(curSelTabKey.replaceFirst("tabpageap", ""));
            String additionalMetasJson = this.getPageCache().get(KEY_ADDITIONALMETAS);
            List additionalMetas = (List)SerializationUtils.fromJsonString((String)additionalMetasJson, List.class);
            Map additionalMeta = (Map)additionalMetas.get(tabSeq);
            String compMeta = (String)additionalMeta.get(KEY_COMPMETA);
            String masterfield = (String)additionalMeta.get("masterfield");
            String additionalfield = (String)additionalMeta.get("additionalfield");
            List additionalIds = QueryServiceHelper.queryPrimaryKeys((String)compMeta, (QFilter[])new QFilter(additionalfield, "=", masterfieldVal = this.getModelValue(model.getDataEntity().get(masterfield))).toArray(), null, (int)1);
            if (additionalIds.size() > 0) {
                Object additionalId = additionalIds.get(0);
                String openPageId = this.openInfoPage(compMeta, curSelTabKey, additionalId);
                this.getPageCache().put(curSelTabKey, openPageId);
            } else {
                this.getPageCache().put(curSelTabKey, VAL_NOTCOMBDATA);
            }
        }
    }

    private Object getModelValue(Object masterfieldVal) {
        if (masterfieldVal instanceof DynamicObject) {
            return ((DynamicObject)masterfieldVal).getPkValue();
        }
        return masterfieldVal;
    }

    private String openInfoPage(String entityNumber, String curSelTabKey, Object dataId) {
        IFormView view = this.getView();
        BaseShowParameter lsp = new BaseShowParameter();
        if (StringUtils.isNotBlank((Object)dataId)) {
            lsp.setPkId(dataId);
        }
        lsp.setFormId(entityNumber);
        lsp.getOpenStyle().setTargetKey(curSelTabKey);
        lsp.getOpenStyle().setShowType(ShowType.InContainer);
        lsp.setParentFormId(view.getFormShowParameter().getFormId());
        lsp.setStatus(OperationStatus.VIEW);
        view.showForm((FormShowParameter)lsp);
        return lsp.getPageId();
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String key = e.getFieldName();
        int index = e.getRowIndex();
        switch (key) {
            case "billno_t": {
                this.showBill(index);
            }
        }
    }

    private void showBill(int index) {
        IDataModel model = this.getModel();
        DynamicObject billtype = (DynamicObject)model.getValue("billtype_t", index);
        Long billid = (Long)model.getValue("billid_t", index);
        if (StringUtils.isNotBlank((Object)billtype) && !billid.equals(0L)) {
            BillShowParameter bsp = new BillShowParameter();
            bsp.setFormId(billtype.getString("number"));
            bsp.setPkId((Object)billid);
            bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            bsp.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)bsp);
        }
    }
}

