/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.quotamodel.business.algorithm;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.quotamodel.business.algorithm.AbstractQuotaStrategy;
import kd.mpscmm.msbd.quotamodel.business.helper.QuotaAlgorithmHelper;
import kd.mpscmm.msbd.quotamodel.common.pojo.QuotaRateDTO;
import kd.mpscmm.msbd.quotamodel.common.pojo.QuotaRecordDetailInfo;

public class DynamicQuotaStrategy
extends AbstractQuotaStrategy {
    private static final Log log = LogFactory.getLog(DynamicQuotaStrategy.class);

    @Override
    public QuotaRecordDetailInfo algorithm(QuotaRecordDetailInfo calRecordDetailInfo, Boolean isResultAdjust, DataSet sourcelistDS) {
        BigDecimal baseRemainQty = calRecordDetailInfo.getUnprocessBaseQty();
        BigDecimal sumbasequotaQty = BigDecimal.ZERO;
        Long calRuleID = calRecordDetailInfo.getQuotaCalRuleID();
        Map<String, String> quotaFldMap = calRecordDetailInfo.getQuotaTgtFieldMap();
        Map<Integer, List<Map<String, Object>>> quotaDefMap = calRecordDetailInfo.getQuotaQueryResultInfos();
        HashMap<Integer, List<Map<String, Object>>> quotaCalResultInfos = new HashMap<Integer, List<Map<String, Object>>>(16);
        if (quotaDefMap != null) {
            log.info("Quota,defMap\uff0c\u5373QuotaQueryResultInfos\uff1a" + quotaDefMap.toString());
            Map<String, BigDecimal> allSupplierQtyMap = QuotaAlgorithmHelper.getHistoryBillBaseQty(calRuleID, calRecordDetailInfo);
            log.info("Quota,historyData\uff1a{}", allSupplierQtyMap);
            Map<String, BigDecimal> supplierBaseQty = calRecordDetailInfo.getSupplierBaseQty();
            if (supplierBaseQty != null && supplierBaseQty.size() > 0) {
                allSupplierQtyMap = this.mergeCurrentAllotQty(allSupplierQtyMap, supplierBaseQty);
            } else {
                Map<String, BigDecimal> currentBatchSupplierQty = calRecordDetailInfo.getCurrentBatchQuotaQty();
                if (currentBatchSupplierQty != null) {
                    allSupplierQtyMap = this.mergeCurrentAllotQty(allSupplierQtyMap, currentBatchSupplierQty);
                    log.info("Quota,currentBatchQty\uff1a{}", currentBatchSupplierQty);
                }
            }
            List<QuotaRateDTO> sortRateDTO = QuotaAlgorithmHelper.getHistoryRate(allSupplierQtyMap, quotaDefMap, calRecordDetailInfo.getQuotaResultKey());
            StringBuilder qrStr = new StringBuilder();
            for (QuotaRateDTO qrdto : sortRateDTO) {
                qrStr.append(qrdto.getPriority());
                qrStr.append(" : ");
                qrStr.append(qrdto.getRsltKey());
                qrStr.append(" : ");
                qrStr.append(qrdto.getSurplusRate());
                qrStr.append(" ; ");
            }
            String rateStr = qrStr == null ? "" : qrStr.toString();
            log.info("Quota,datakey={},DynamicQuotaStrategy\uff0csortRateDTO\uff1apriority : rsltKey : surplusRate = {}", (Object)calRecordDetailInfo.getDataKey(), (Object)rateStr);
            if (sortRateDTO.size() > 0) {
                block1: for (int i = 0; i < sortRateDTO.size() && baseRemainQty.compareTo(BigDecimal.ZERO) > 0; ++i) {
                    String rsltKey = sortRateDTO.get(i).getRsltKey();
                    int priority = sortRateDTO.get(i).getPriority();
                    List<Map<String, Object>> quotaDefLst = quotaDefMap.get(priority);
                    for (int j = 0; j < quotaDefLst.size(); ++j) {
                        StringBuilder defsb = new StringBuilder();
                        Set<String> QuotaRsltKey = calRecordDetailInfo.getQuotaResultKey();
                        for (String keyStr : QuotaRsltKey) {
                            if ("validdate".equalsIgnoreCase(keyStr) || "invaliddate".equalsIgnoreCase(keyStr)) continue;
                            if ("".equals(defsb.toString())) {
                                defsb.append(quotaDefLst.get(j).get(keyStr));
                                continue;
                            }
                            defsb.append("$$").append(quotaDefLst.get(j).get(keyStr));
                        }
                        String defStr = defsb.toString();
                        if (rsltKey == null || defStr == null || !defStr.equals(rsltKey)) continue;
                        Map<String, Object> quotaCalResultMap = quotaDefLst.get(j);
                        quotaCalResultMap.put("quotaedBaseQty", baseRemainQty);
                        BigDecimal srcAdjustBaseQty = new BigDecimal(0);
                        BigDecimal maxBaseQty = new BigDecimal(0);
                        BigDecimal minBaseQty = new BigDecimal(0);
                        BigDecimal packageBatchQty = new BigDecimal(0);
                        if (isResultAdjust.booleanValue()) {
                            Long supplierId = (Long)quotaDefLst.get(j).get("supplier");
                            Long orgId = (Long)quotaDefLst.get(j).get(quotaFldMap.get("org"));
                            Long materialId = (Long)quotaDefLst.get(j).get("material");
                            Map<String, BigDecimal> sourceListRst = QuotaAlgorithmHelper.getQuotaedQtyBySourceList(supplierId, orgId, materialId, baseRemainQty, calRecordDetailInfo.getQuotaDate(), materialId, sourcelistDS);
                            srcAdjustBaseQty = sourceListRst.get("srcAdjustBaseQty");
                            maxBaseQty = sourceListRst.get("maxBaseQty");
                            minBaseQty = sourceListRst.get("minBaseQty");
                            packageBatchQty = sourceListRst.get("packageBaseQty");
                        } else {
                            srcAdjustBaseQty = baseRemainQty;
                        }
                        StringBuilder qtyStr = new StringBuilder();
                        qtyStr.append(quotaDefLst.get(j).get("supplier"));
                        qtyStr.append(" : ");
                        qtyStr.append(baseRemainQty);
                        qtyStr.append(" : ");
                        qtyStr.append(srcAdjustBaseQty);
                        qtyStr.append(" \uff1b ");
                        log.info("Quota,DynamicQuotaStrategyResult,rsltKey : quotaedBaseQty : srcAdjustBaseQty = {} ", (Object)qtyStr.toString());
                        if (srcAdjustBaseQty != null && srcAdjustBaseQty.compareTo(BigDecimal.ZERO) <= 0) continue block1;
                        if (srcAdjustBaseQty != null) {
                            baseRemainQty = baseRemainQty.subtract(srcAdjustBaseQty);
                            sumbasequotaQty = sumbasequotaQty.add(srcAdjustBaseQty);
                        }
                        quotaCalResultMap.put("srcAdjustBaseQty", srcAdjustBaseQty);
                        quotaCalResultMap.put("maxBaseQty", maxBaseQty);
                        quotaCalResultMap.put("minBaseQty", minBaseQty);
                        quotaCalResultMap.put("packageBaseQty", packageBatchQty);
                        if (calRecordDetailInfo.getCurrentBatchQuotaQty() == null) {
                            HashMap<String, BigDecimal> quotaedQtyMap = new HashMap<String, BigDecimal>(16);
                            quotaedQtyMap.put(rsltKey, srcAdjustBaseQty);
                            calRecordDetailInfo.setCurrentBatchQuotaQty(quotaedQtyMap);
                        } else if (calRecordDetailInfo.getCurrentBatchQuotaQty().get(rsltKey) != null) {
                            BigDecimal currentBatchQuotaQty = calRecordDetailInfo.getCurrentBatchQuotaQty().get(rsltKey).add(srcAdjustBaseQty);
                            calRecordDetailInfo.getCurrentBatchQuotaQty().put(rsltKey, currentBatchQuotaQty);
                        } else {
                            calRecordDetailInfo.getCurrentBatchQuotaQty().put(rsltKey, srcAdjustBaseQty);
                        }
                        if (quotaCalResultInfos.get(priority) == null) {
                            ArrayList<Map<String, Object>> quotaCalResultLst = new ArrayList<Map<String, Object>>(16);
                            quotaCalResultLst.add(quotaCalResultMap);
                            quotaCalResultInfos.put(priority, quotaCalResultLst);
                            continue block1;
                        }
                        ((List)quotaCalResultInfos.get(priority)).add(quotaCalResultMap);
                        continue block1;
                    }
                }
            }
        } else {
            log.info("Quota,defmap\uff0c\u5373QuotaQueryResultInfos\u4e3a\u7a7a\uff01");
        }
        calRecordDetailInfo.setQuotaCalculateResultInfos(quotaCalResultInfos);
        return calRecordDetailInfo;
    }

    private Map<String, BigDecimal> mergeCurrentAllotQty(Map<String, BigDecimal> allSupplierAndQtyMap, Map<String, BigDecimal> currentBatchQuotaQty) {
        if (allSupplierAndQtyMap == null) {
            return currentBatchQuotaQty;
        }
        if (allSupplierAndQtyMap == null || allSupplierAndQtyMap.isEmpty()) {
            allSupplierAndQtyMap = new HashMap<String, BigDecimal>(10);
            allSupplierAndQtyMap.putAll(currentBatchQuotaQty);
        } else {
            for (Map.Entry<String, BigDecimal> entry : currentBatchQuotaQty.entrySet()) {
                BigDecimal allotQtyDB = allSupplierAndQtyMap.get(entry.getKey());
                BigDecimal currentAllotQty = currentBatchQuotaQty.get(entry.getKey());
                if (allotQtyDB == null) {
                    allSupplierAndQtyMap.put(entry.getKey(), currentAllotQty);
                    continue;
                }
                allSupplierAndQtyMap.put(entry.getKey(), allotQtyDB.add(currentAllotQty));
            }
        }
        return allSupplierAndQtyMap;
    }
}

