/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.quotamodel.business.algorithm;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.business.helper.BillQuantityHelper;
import kd.mpscmm.msbd.quotamodel.business.algorithm.AbstractQuotaStrategy;
import kd.mpscmm.msbd.quotamodel.business.helper.QuotaAlgorithmHelper;
import kd.mpscmm.msbd.quotamodel.common.pojo.QuotaRecordDetailInfo;

public class FixedQuotaStrategy
extends AbstractQuotaStrategy {
    private static final Log log = LogFactory.getLog(FixedQuotaStrategy.class);

    @Override
    public QuotaRecordDetailInfo algorithm(QuotaRecordDetailInfo calRecordDetailInfo, Boolean isResultAdjust, DataSet sourcelistDS) {
        BigDecimal baseRemainQty = calRecordDetailInfo.getUnprocessBaseQty();
        Long baseUnitID = calRecordDetailInfo.getBaseUnitID();
        DynamicObject baseUnit = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_measureunits", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)baseUnitID)});
        BigDecimal sumbasequotaQty = BigDecimal.ZERO;
        Map<String, String> quotaTgtFieldMap = calRecordDetailInfo.getQuotaTgtFieldMap();
        Map<Integer, List<Map<String, Object>>> quotaQryRsltMap = calRecordDetailInfo.getQuotaQueryResultInfos();
        HashMap<Integer, List<Map<String, Object>>> quotaCalResultInfos = new HashMap<Integer, List<Map<String, Object>>>(16);
        for (int m = 1; m < 999; ++m) {
            List<Map<String, Object>> quotaDefLst = quotaQryRsltMap.get(m);
            if (quotaDefLst == null) continue;
            baseRemainQty = baseRemainQty.subtract(sumbasequotaQty);
            sumbasequotaQty = BigDecimal.ZERO;
            if (baseRemainQty.compareTo(BigDecimal.ZERO) <= 0) break;
            ArrayList<Map<String, Object>> quotaCalResultLst = new ArrayList<Map<String, Object>>(16);
            for (int i = 0; i < quotaDefLst.size(); ++i) {
                Map<String, Object> rowObj = quotaDefLst.get(i);
                BigDecimal allotBaseQty = BigDecimal.ZERO;
                allotBaseQty = i == quotaDefLst.size() - 1 ? baseRemainQty.subtract(sumbasequotaQty) : baseRemainQty.multiply((BigDecimal)rowObj.get("quotarate")).divide(new BigDecimal(100), BillQuantityHelper.getPrecision((DynamicObject)baseUnit), BillQuantityHelper.getPrecisionType((DynamicObject)baseUnit));
                Map<String, Object> quotaCalResultMap = rowObj;
                quotaCalResultMap.put("quotaedBaseQty", allotBaseQty);
                BigDecimal srcAdjustBaseQty = new BigDecimal(0);
                BigDecimal maxBaseQty = new BigDecimal(0);
                BigDecimal minBaseQty = new BigDecimal(0);
                BigDecimal packageBatchQty = new BigDecimal(0);
                if (isResultAdjust.booleanValue()) {
                    Long supplierId = (Long)rowObj.get("supplier");
                    Long orgId = (Long)rowObj.get(quotaTgtFieldMap.get("org"));
                    Long materialId = (Long)rowObj.get("material");
                    Map<String, BigDecimal> sourceListRst = QuotaAlgorithmHelper.getQuotaedQtyBySourceList(supplierId, orgId, materialId, allotBaseQty, calRecordDetailInfo.getQuotaDate(), materialId, sourcelistDS);
                    srcAdjustBaseQty = sourceListRst.get("srcAdjustBaseQty");
                    maxBaseQty = sourceListRst.get("maxBaseQty");
                    minBaseQty = sourceListRst.get("minBaseQty");
                    packageBatchQty = sourceListRst.get("packageBaseQty");
                } else {
                    srcAdjustBaseQty = allotBaseQty;
                }
                StringBuilder qtyStr = new StringBuilder();
                qtyStr.append(quotaDefLst.get(i).get("supplier"));
                qtyStr.append(" : ");
                qtyStr.append(baseRemainQty);
                qtyStr.append(" : ");
                qtyStr.append(srcAdjustBaseQty);
                qtyStr.append(" \uff1b ");
                log.info("Quota,FixedQuotaStrategyResult\uff0crsltKey : quotaedBaseQty : srcAdjustBaseQty = {} ", (Object)qtyStr.toString());
                if (srcAdjustBaseQty != null && srcAdjustBaseQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                if (srcAdjustBaseQty != null) {
                    sumbasequotaQty = sumbasequotaQty.add(srcAdjustBaseQty);
                }
                quotaCalResultMap.put("srcAdjustBaseQty", srcAdjustBaseQty);
                quotaCalResultMap.put("maxBaseQty", maxBaseQty);
                quotaCalResultMap.put("minBaseQty", minBaseQty);
                quotaCalResultMap.put("packageBaseQty", packageBatchQty);
                quotaCalResultLst.add(quotaCalResultMap);
            }
            quotaCalResultInfos.put(m, quotaCalResultLst);
        }
        calRecordDetailInfo.setQuotaCalculateResultInfos(quotaCalResultInfos);
        return calRecordDetailInfo;
    }
}

