/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.quotamodel.business.helper;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.business.helper.FieldMapHelper;
import kd.mpscmm.msbd.common.enums.BillStatusEnum;
import kd.mpscmm.msbd.common.enums.EnableStatusEnum;
import kd.mpscmm.msbd.quotamodel.business.helper.QuotaSchemeHelper;
import kd.mpscmm.msbd.quotamodel.common.pojo.QuotaRateDTO;
import kd.mpscmm.msbd.quotamodel.common.pojo.QuotaRecordDetailInfo;

public class QuotaAlgorithmHelper {
    private static final Log log = LogFactory.getLog(QuotaAlgorithmHelper.class);
    private static final BigDecimal ZERO = BigDecimal.ZERO;
    private static final int ONE = 1;
    private static final int zero = 0;

    public static Map<String, BigDecimal> getQuotaedQtyBySourceList(Long supplierId, Long orgId, Long materialId, BigDecimal baseUnitQty, Date bizDate, Long materialMasterId, DataSet sourcelistDS) throws KDBizException {
        HashMap<String, BigDecimal> sourceListProcessMap = new HashMap<String, BigDecimal>(16);
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        qFilter.and(new QFilter("supplier", "=", (Object)supplierId));
        qFilter.and(new QFilter("entryentity.material.masterid.id", "=", (Object)materialMasterId));
        qFilter.and(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
        qFilter.and(new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        qFilter.and(new QFilter("entryentity.frozenstatus", "=", (Object)"A"));
        DataSet srclst = null;
        if (sourcelistDS == null) {
            ArrayList selectlistFields = new ArrayList();
            Collections.addAll(selectlistFields, "id", "entryentity.id", "org", "supplier", "enable", "status", "entryentity.material", "entryentity.material.masterid.id", "entryentity.purchaseunit", "entryentity.expirydate");
            Collections.addAll(selectlistFields, "entryentity.maxbillqty", "entryentity.minbillqty", "entryentity.packingbaseqty", "entryentity.effectdate");
            Collections.addAll(selectlistFields, "entryentity.maxbillbaseqty", "entryentity.minbillbaseqty");
            String selectFields = selectlistFields.stream().collect(Collectors.joining(","));
            srclst = QueryServiceHelper.queryDataSet((String)"getSourceList", (String)"pm_sourcelist", (String)selectFields, (QFilter[])qFilter.toArray(), null, (int)1);
        } else {
            srclst = sourcelistDS.copy().filter(qFilter.toString());
            HashMap<String, Date> dateMap = new HashMap<String, Date>(16);
            dateMap.put("var", bizDate);
            srclst = srclst.filter("entryentity.effectdate<=var", dateMap);
            srclst = srclst.filter("entryentity.expirydate>=var", dateMap);
        }
        BigDecimal quotaQty = ZERO;
        if (srclst == null || srclst.isEmpty()) {
            quotaQty = baseUnitQty;
            sourceListProcessMap.put("srcAdjustBaseQty", quotaQty);
            sourceListProcessMap.put("maxBaseQty", ZERO);
            sourceListProcessMap.put("minBaseQty", ZERO);
            sourceListProcessMap.put("packageBaseQty", ZERO);
            if (srclst != null) {
                srclst.close();
            }
            return sourceListProcessMap;
        }
        for (Row row : srclst) {
            BigDecimal maxbillbaseqty = row.getBigDecimal("entryentity.maxbillbaseqty");
            BigDecimal minbillbaseqty = row.getBigDecimal("entryentity.minbillbaseqty");
            BigDecimal packingBaseQty = row.getBigDecimal("entryentity.packingbaseqty");
            if (ZERO.compareTo(maxbillbaseqty) == 0) {
                quotaQty = ZERO.compareTo(packingBaseQty) == 0 ? baseUnitQty : baseUnitQty.divide(packingBaseQty, 0, 0).multiply(packingBaseQty);
            }
            if (baseUnitQty.compareTo(maxbillbaseqty) >= 0 && maxbillbaseqty.compareTo(ZERO) > 0) {
                quotaQty = maxbillbaseqty;
            }
            if (baseUnitQty.compareTo(minbillbaseqty) > 0 && baseUnitQty.compareTo(maxbillbaseqty) < 0) {
                quotaQty = ZERO.compareTo(packingBaseQty) == 0 ? baseUnitQty : baseUnitQty.divide(packingBaseQty, 0, 0).multiply(packingBaseQty);
            }
            if (baseUnitQty.compareTo(minbillbaseqty) <= 0) {
                quotaQty = minbillbaseqty;
            }
            sourceListProcessMap.put("srcAdjustBaseQty", quotaQty);
            sourceListProcessMap.put("maxBaseQty", maxbillbaseqty);
            sourceListProcessMap.put("minBaseQty", minbillbaseqty);
            sourceListProcessMap.put("packageBaseQty", packingBaseQty);
        }
        srclst.close();
        return sourceListProcessMap;
    }

    public static Map<String, BigDecimal> getHistoryBillBaseQty(Long calRuleID, QuotaRecordDetailInfo calRecordDetailInfo) {
        Map<Integer, List<Map<String, Object>>> quotaDefMap = calRecordDetailInfo.getQuotaQueryResultInfos();
        DynamicObject calRule = BusinessDataServiceHelper.loadSingleFromCache((String)"msbd_quotacalrule", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)calRuleID)});
        if (calRule == null) {
            return null;
        }
        List<Object> quotaDefLstForDate = new ArrayList(16);
        for (int m = 1; m < 999 && (quotaDefLstForDate = quotaDefMap.get(m)) == null; ++m) {
        }
        HashMap<String, Date> dateMap = new HashMap<String, Date>(16);
        if (calRule.getBoolean("period")) {
            Date startDate = new Date(((Timestamp)((Map)quotaDefLstForDate.get(0)).get("validdate")).getTime());
            Date endDate = new Date(((Timestamp)((Map)quotaDefLstForDate.get(0)).get("invaliddate")).getTime());
            dateMap.put("startDate", startDate);
            dateMap.put("endDate", endDate);
        }
        Set<String> QuotaRsltKey = calRecordDetailInfo.getQuotaResultKey();
        DataSet allHistoryData = null;
        DynamicObjectCollection calRuleEntrys = calRule.getDynamicObjectCollection("entryentity");
        if (calRuleEntrys == null || calRuleEntrys.size() == 0) {
            return null;
        }
        for (DynamicObject calRuleEntry : calRuleEntrys) {
            Map billTgtColMap;
            String srcEntity = calRuleEntry.getDynamicObject("datasource") != null ? calRuleEntry.getDynamicObject("datasource").getString("number") : "";
            if (srcEntity == null || srcEntity.equals("")) continue;
            QFilter qfLst = QFilter.of((String)"1=1", (Object[])new Object[0]);
            FilterBuilder fb = QuotaSchemeHelper.convertStringToQFilter(calRuleEntry.getString("datarangejson_tag"), srcEntity);
            if (fb != null) {
                qfLst.and(fb.getQFilter());
            }
            if (calRuleEntry.getDynamicObject("datamapping") == null || (billTgtColMap = FieldMapHelper.getFieldMapById((Long)((Long)calRuleEntry.getDynamicObject("datamapping").getPkValue()), (String)"target")) == null || billTgtColMap.size() == 0) continue;
            String billBaseQtyProp = (String)billTgtColMap.get("baseqty");
            StringBuilder sb = new StringBuilder();
            int k = 0;
            for (Map.Entry str : billTgtColMap.entrySet()) {
                if (((String)str.getValue()).equalsIgnoreCase(billBaseQtyProp)) {
                    sb.append((String)str.getValue()).append(" as baseqty ");
                } else {
                    sb.append((String)str.getValue()).append(" as ").append((String)str.getKey());
                }
                if (k < billTgtColMap.size() - 1) {
                    sb.append(",");
                }
                ++k;
            }
            String selectCols = sb.toString();
            if (selectCols == null || selectCols.equals("")) continue;
            if (calRule.getBoolean("period")) {
                String srcDate = (String)billTgtColMap.get("date");
                if (dateMap.get("startDate") != null) {
                    qfLst.and(new QFilter(srcDate, ">=", dateMap.get("startDate")));
                }
                if (dateMap.get("endDate") != null) {
                    qfLst.and(new QFilter(srcDate, "<=", dateMap.get("endDate")));
                }
            }
            Set<String> matchKey = calRecordDetailInfo.getMatchKey();
            boolean isExistMatchKey = true;
            for (String mKey : matchKey) {
                if (mKey.equalsIgnoreCase("validdate") || mKey.equalsIgnoreCase("invaliddate") || mKey.equalsIgnoreCase("baseqty")) continue;
                if (billTgtColMap.get(mKey) == null) {
                    isExistMatchKey = false;
                    log.info("Quota,\u53c2\u8003\u6570\u636e\u6620\u5c04\uff1a" + calRuleEntry.getDynamicObject("datamapping").getPkValue() + "\u4e2d\u5339\u914d\u5b57\u6bb5" + mKey + "\u672a\u5728\u53c2\u8003\u5355\u636e\u4e2d\u4f5c\u6620\u5c04\uff01");
                    break;
                }
                QFilter matchQF = new QFilter((String)billTgtColMap.get(mKey), "=", calRecordDetailInfo.getMatchValues().get(mKey));
                qfLst.and(matchQF);
            }
            if (!isExistMatchKey) continue;
            QFilter quotaRsltQF = null;
            boolean isExistRsltKey = true;
            for (int x = 1; x < 999 && isExistRsltKey; ++x) {
                List<Map<String, Object>> quotaDefLst = quotaDefMap.get(x);
                if (quotaDefLst == null) continue;
                for (int m = 0; m < quotaDefLst.size() && isExistRsltKey; ++m) {
                    QFilter rsltQF = null;
                    for (String rsltKey : QuotaRsltKey) {
                        if (rsltKey.equalsIgnoreCase("validdate") || rsltKey.equalsIgnoreCase("invaliddate")) continue;
                        if (billTgtColMap.get(rsltKey) == null) {
                            isExistRsltKey = false;
                            log.info("Quota,\u53c2\u8003\u6570\u636e\u6620\u5c04\uff1a" + calRuleEntry.getDynamicObject("datamapping").getPkValue() + "\u4e2d\u7ed3\u679c\u5b57\u6bb5" + rsltKey + "\u672a\u5728\u53c2\u8003\u5355\u636e\u4e2d\u4f5c\u6620\u5c04\uff01");
                            break;
                        }
                        if (rsltQF == null) {
                            rsltQF = new QFilter((String)billTgtColMap.get(rsltKey), "=", quotaDefLst.get(m).get(rsltKey));
                            continue;
                        }
                        rsltQF.and(new QFilter((String)billTgtColMap.get(rsltKey), "=", quotaDefLst.get(m).get(rsltKey)));
                    }
                    if (quotaRsltQF == null) {
                        quotaRsltQF = rsltQF;
                        continue;
                    }
                    quotaRsltQF.or(rsltQF);
                }
            }
            if (!isExistRsltKey) continue;
            QFilter[] qf = new QFilter[]{qfLst.and(quotaRsltQF)};
            DataSet rowDataSet = QueryServiceHelper.queryDataSet((String)"DynamicQuotaStrategy", (String)srcEntity, (String)selectCols, (QFilter[])qf, null);
            if (rowDataSet == null || rowDataSet.isEmpty()) {
                log.info("Quota,\u53c2\u8003\u5355\u636e\u67e5\u8be2\uff0c\u5355\u636e\u5b9e\u4f53\uff1a{}\uff1b\u67e5\u8be2\u5b57\u6bb5\uff1a{}\uff1b\u67e5\u8be2\u6761\u4ef6\uff1a{}\uff1b\u914d\u989d\u7ed3\u679c\u6761\u4ef6\uff1a{}", new Object[]{srcEntity, selectCols, qf});
                continue;
            }
            if (allHistoryData == null || allHistoryData.isEmpty()) {
                allHistoryData = rowDataSet;
                continue;
            }
            allHistoryData = allHistoryData.union(rowDataSet);
        }
        if (allHistoryData == null) {
            return null;
        }
        if (allHistoryData.isEmpty()) {
            allHistoryData.close();
            return null;
        }
        HashMap<String, BigDecimal> allSupplierQtyMap = new HashMap<String, BigDecimal>(16);
        String[] grpbyStr = new String[QuotaRsltKey.size()];
        int n = 0;
        for (String rsltKey : QuotaRsltKey) {
            if (rsltKey.equalsIgnoreCase("validdate") || rsltKey.equalsIgnoreCase("invaliddate")) continue;
            grpbyStr[n] = rsltKey;
            ++n;
        }
        DataSet allresult = allHistoryData.groupBy(grpbyStr).sum("baseqty").finish();
        for (Row row : allresult) {
            BigDecimal oneSupplierBaseqty = row.getBigDecimal("baseqty");
            StringBuilder currQtyKeysb = new StringBuilder();
            for (String rsltKey : QuotaRsltKey) {
                if (rsltKey.equalsIgnoreCase("validdate") || rsltKey.equalsIgnoreCase("invaliddate")) continue;
                if ("".equals(currQtyKeysb.toString())) {
                    currQtyKeysb.append(row.getString(rsltKey));
                    continue;
                }
                currQtyKeysb.append("$$").append(row.getString(rsltKey));
            }
            String currQtyKey = currQtyKeysb.toString();
            if (currQtyKey == null || "".equals(currQtyKey)) continue;
            allSupplierQtyMap.put(currQtyKey, oneSupplierBaseqty);
        }
        allHistoryData.close();
        allresult.close();
        return allSupplierQtyMap;
    }

    public static List<QuotaRateDTO> getHistoryRate(Map<String, BigDecimal> allSupplierQtyMap, Map<Integer, List<Map<String, Object>>> quotaDefMap, Set<String> QuotaRsltKey) {
        if (quotaDefMap == null || quotaDefMap.size() == 0) {
            return null;
        }
        if (QuotaRsltKey == null || QuotaRsltKey.size() == 0) {
            return null;
        }
        BigDecimal allBillBaseQty = BigDecimal.ZERO;
        if (allSupplierQtyMap != null && allSupplierQtyMap.size() > 0) {
            for (BigDecimal oneSupQty : allSupplierQtyMap.values()) {
                allBillBaseQty = allBillBaseQty.add(oneSupQty);
            }
        }
        BigDecimal historyRate = ZERO;
        BigDecimal supplierQty = ZERO;
        ArrayList<QuotaRateDTO> rateDTO = new ArrayList<QuotaRateDTO>(16);
        for (int m = 1; m < 999; ++m) {
            List<Map<String, Object>> quotaDefLst = quotaDefMap.get(m);
            if (quotaDefLst == null) continue;
            for (int i = 0; i < quotaDefLst.size(); ++i) {
                BigDecimal targetRate = (BigDecimal)quotaDefLst.get(i).get("quotarate");
                StringBuilder currQtyKeysb = new StringBuilder();
                for (String rsltKey : QuotaRsltKey) {
                    if (rsltKey.equalsIgnoreCase("validdate") || rsltKey.equalsIgnoreCase("invaliddate")) continue;
                    if ("".equals(currQtyKeysb.toString())) {
                        currQtyKeysb.append(quotaDefLst.get(i).get(rsltKey));
                        continue;
                    }
                    currQtyKeysb.append("$$").append(quotaDefLst.get(i).get(rsltKey));
                }
                String currQtyKey = currQtyKeysb.toString();
                if (currQtyKey == null) continue;
                if (allSupplierQtyMap != null && allSupplierQtyMap.size() > 0) {
                    supplierQty = allSupplierQtyMap.get(currQtyKey);
                }
                historyRate = ZERO.compareTo(allBillBaseQty) == 0 || supplierQty == null ? ZERO : supplierQty.divide(allBillBaseQty, 2, 4).multiply(BigDecimal.valueOf(100L));
                BigDecimal surplusRate = targetRate != null ? targetRate.subtract(historyRate) : ZERO.subtract(historyRate);
                QuotaRateDTO acceptQuotaRate = QuotaRateDTO.acceptQuotaRate(m, currQtyKey, surplusRate);
                rateDTO.add(acceptQuotaRate);
            }
        }
        List<QuotaRateDTO> sortRateDTO = QuotaRateDTO.sortDynamicQuota(rateDTO);
        return sortRateDTO;
    }
}

