/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.quotamodel.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.mpscmm.msbd.quotamodel.common.pojo.TreeNodeParams;
import org.apache.commons.lang3.StringUtils;

public class AttributeTreePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener {
    private static final String BT_cancel = "cancel";
    private static final String BT_ok = "ok";
    private static final String C_tree = "tree";
    private static final String C_search = "search";
    private static final String AP_filter = "filterap";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.bindTree();
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "ok": {
                this.clickOK(evt);
                break;
            }
            case "cancel": {
                this.clickCancel(evt);
                break;
            }
        }
    }

    private void clickCancel(EventObject evt) {
        this.getView().close();
    }

    private void clickOK(EventObject evt) {
        List<String> ids = this.getSelectedNodeId();
        JSONArray returnInfo = this.getReturnInfo(ids);
        this.getView().returnDataToParent((Object)returnInfo.toJSONString());
        this.getView().close();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BT_cancel, BT_ok});
        Search search = (Search)this.getControl(C_search);
        search.addEnterListener((SearchEnterListener)this);
        TreeView tree = (TreeView)this.getControl(C_tree);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void search(SearchEnterEvent e) {
        String searchText = e.getText();
        TreeNode rootNode = this.getTree();
        List treeNodes = null;
        IPageCache pageCache = this.getPageCache();
        String pageId = this.getView().getPageId();
        String searchNodesCacheKey = pageId + "_searchNodes";
        String matchNodesCacheKey = pageId + "_matchNodes";
        String oldSearchTextCacheKey = pageId + "_oldSearchText";
        String searchIndexCacheKey = pageId + "_searchIndex";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        if (oldSearchText != null && !oldSearchText.equals(searchText) || StringUtils.isBlank((CharSequence)matchNodesCache)) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, 16);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        } else {
            String searchNodesCache = pageCache.get(searchNodesCacheKey);
            treeNodes = StringUtils.isBlank((CharSequence)searchNodesCache) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
        }
        if (treeNodes.isEmpty()) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, 16);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
            this.getView().showTipNotification(AttributeTreePlugin.getMsgColsTreeSelectCompleteNoSel());
        } else {
            TreeView treeView = (TreeView)this.getView().getControl(C_tree);
            if (StringUtils.isNotEmpty((CharSequence)pageCache.get(searchIndexCacheKey))) {
                int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                if (indexCache < treeNodes.size()) {
                    treeView.treeNodeClick(((TreeNode)treeNodes.get(indexCache)).getParentid(), ((TreeNode)treeNodes.get(indexCache)).getId());
                    treeView.showNode(((TreeNode)treeNodes.get(indexCache)).getParentid());
                    treeView.focusNode((TreeNode)treeNodes.get(indexCache));
                    pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
                } else {
                    this.getView().showTipNotification(AttributeTreePlugin.getMsgColsTreeSelectComplete());
                    pageCache.put(searchIndexCacheKey, String.valueOf(0));
                }
            } else {
                treeView.treeNodeClick(((TreeNode)treeNodes.get(0)).getParentid(), ((TreeNode)treeNodes.get(0)).getId());
                treeView.showNode(((TreeNode)treeNodes.get(0)).getParentid());
                treeView.focusNode((TreeNode)treeNodes.get(0));
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
        }
    }

    private void bindTree() {
        TreeNodeParams params = this.getParams();
        TreeNode rootNode = this.getTree();
        TreeView tree = (TreeView)this.getView().getControl(C_tree);
        tree.addNode(rootNode);
        boolean isMulti = params.isMulti();
        tree.setMulti(isMulti);
        Set<String> selectedNodes = params.getSelectedNodes();
        for (String selectedNode : selectedNodes) {
            TreeNode treeNode = rootNode.getTreeNode(selectedNode);
            if (treeNode == null) continue;
            tree.checkNode(treeNode);
        }
        this.getView().setEnable(Boolean.valueOf(!isMulti), new String[]{AP_filter});
        this.getView().setVisible(Boolean.valueOf(!isMulti), new String[]{AP_filter});
    }

    private TreeNodeParams getParams() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        return (TreeNodeParams)SerializationUtils.fromJsonString((String)((String)customParams.get("selectParams")), TreeNodeParams.class);
    }

    private TreeNode getTree() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)((String)customParams.get("treeNodes")), TreeNode.class);
        if (rootNode == null) {
            return new TreeNode("", "0", AttributeTreePlugin.getMsgColsTreeSelectNotObj());
        }
        return rootNode;
    }

    private List<String> getSelectedNodeId() {
        TreeView tree = (TreeView)this.getControl(C_tree);
        TreeView.TreeState treeState = tree.getTreeState();
        if (this.getParams().isMulti()) {
            return treeState.getCheckedNodeIds();
        }
        ArrayList<String> ids = new ArrayList<String>();
        String nodeId = treeState.getFocusNodeId();
        ids.add(nodeId);
        return ids;
    }

    private JSONArray getReturnInfo(List<String> ids) {
        TreeNodeParams params = this.getParams();
        JSONArray infos = new JSONArray();
        if (ids == null) {
            return infos;
        }
        TreeNode tree = this.getTree();
        TreeNode node = null;
        for (String id : ids) {
            if ("0".equals(id)) continue;
            node = tree.getTreeNode(id, 6);
            List children = node.getChildren();
            if (node == null || children != null && children.size() != 0) continue;
            String text = node.getText();
            if (params.isDisplayFullText()) {
                text = this.getNodeFullText(tree, node);
            }
            JSONObject info = new JSONObject(2);
            info.put("id", (Object)node.getId());
            info.put("text", (Object)text);
            infos.add((Object)info);
        }
        return infos;
    }

    private String getNodeFullText(TreeNode root, TreeNode curNode) {
        if (curNode != null) {
            String curNodeText = curNode.getText();
            String parentId = curNode.getParentid();
            TreeNode parentNode = root.getTreeNode(parentId);
            if ("0".equals(parentId)) {
                return curNodeText;
            }
            String parentNodeText = this.getNodeFullText(root, parentNode);
            return parentNodeText + "." + curNodeText;
        }
        return null;
    }

    private static String getMsgColsTreeSelectNotObj() {
        return ResManager.loadKDString((String)"\u6ca1\u6709\u6307\u5b9a\u5b9e\u4f53\u5bf9\u8c61\u3002", (String)"AttributeTreePlugin_0", (String)"mpscmm-msbd-quotamodel", (Object[])new Object[0]);
    }

    private static String getMsgColsTreeSelectCompleteNoSel() {
        return ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22,\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"AttributeTreePlugin_1", (String)"mpscmm-msbd-quotamodel", (Object[])new Object[0]);
    }

    private static String getMsgColsTreeSelectComplete() {
        return ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\u3002", (String)"AttributeTreePlugin_2", (String)"mpscmm-msbd-quotamodel", (Object[])new Object[0]);
    }
}

