/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.quotamodel.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.quotamodel.business.helper.PageShowHelper;
import kd.mpscmm.msbd.quotamodel.common.pojo.FilterParams;

public class QuotaCalRulePlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
ClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit datarange = (TextEdit)this.getControl("datarange");
        datarange.addClickListener((ClickListener)this);
        BasedataEdit dataSource = (BasedataEdit)this.getControl("datasource");
        dataSource.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit datamapping = (BasedataEdit)this.getControl("datamapping");
        datamapping.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject entry : entryentity) {
            String datarangejson;
            DynamicObject datasource = entry.getDynamicObject("datasource");
            if (datasource == null || !StringUtils.isNotEmpty((String)(datarangejson = entry.getString("datarangejson_tag")))) continue;
            FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)datarangejson, FilterCondition.class);
            MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)((String)datasource.getPkValue()));
            FilterBuilder filterBuilder = new FilterBuilder(mainType, condition);
            filterBuilder.buildFilter();
            entry.set("datarange", (Object)filterBuilder.getFilterStringDesc());
        }
        this.getView().updateView("entryentity");
        this.getView().getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String newValue;
        String name = e.getProperty().getName();
        IDataModel model = this.getModel();
        ChangeData changeData = e.getChangeSet()[0];
        Object newObj = changeData.getNewValue();
        Object oldObj = changeData.getOldValue();
        if ("datasource".equals(name)) {
            int index = model.getEntryCurrentRowIndex("entryentity");
            DynamicObject newValue2 = (DynamicObject)newObj;
            if (newValue2 != null) {
                QFilter enable;
                QFilter targetBill;
                String number = newValue2.getString("number");
                QFilter sourceBill = new QFilter("sourcebill.number", "=", (Object)number);
                DynamicObject[] mappings = BusinessDataServiceHelper.load((String)"sbs_billfieldmapping", (String)"id", (QFilter[])new QFilter[]{sourceBill, targetBill = new QFilter("targetobj.number", "=", (Object)"msbd_refermodel"), enable = new QFilter("isenable", "=", (Object)Boolean.TRUE)});
                if (mappings != null && mappings.length > 0) {
                    model.setValue("datamapping", (Object)mappings[0], index);
                } else {
                    model.setValue("quotamapping", null, index);
                }
            } else {
                model.setValue("datamapping", null, index);
            }
            model.setValue("datarange", null, index);
            model.setValue("datarangejson", null, index);
            model.setValue("datarangejson_tag", null, index);
        }
        if ("algorithm".equals(name)) {
            boolean isref;
            DynamicObject algorithm_old = (DynamicObject)oldObj;
            DynamicObject algorithm_new = (DynamicObject)newObj;
            if (algorithm_old != null && (isref = algorithm_old.getBoolean("isref")) && (algorithm_new == null || !algorithm_new.getBoolean("isref"))) {
                String msg = ResManager.loadKDString((String)"\u914d\u989d\u7b97\u6cd5\u5207\u6362\u5c06\u6e05\u7a7a\u53c2\u8003\u6570\u636e\u8bbe\u7f6e\uff0c\u662f\u5426\u786e\u8ba4\u4fee\u6539?", (String)"QuotaCalRulePlugin_0", (String)"mpscmm-msbd-quotamodel", (Object[])new Object[0]);
                MessageBoxOptions options = MessageBoxOptions.YesNo;
                ConfirmCallBackListener callBack = new ConfirmCallBackListener("changeQuotaAlgorithm", (IFormPlugin)this);
                this.getView().showConfirm(msg, options, ConfirmTypes.Default, callBack);
                this.getView().getPageCache().put("algorithm", algorithm_old == null ? null : algorithm_old.getPkValue().toString());
            }
        }
        if ("datarange".equals(name) && StringUtils.isEmpty((String)(newValue = (String)newObj))) {
            this.getModel().setValue("datarangejson", null);
            this.getModel().setValue("datarangejson_tag", null);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("datarange".equals(key)) {
            int index = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject dataSource = (DynamicObject)this.getModel().getValue("datasource", index);
            if (dataSource != null) {
                String entityNumber = dataSource.getString("number");
                if (StringUtils.isNotEmpty((String)entityNumber)) {
                    String filterJson = (String)this.getModel().getValue("datarangejson_tag", index);
                    FilterParams filterParams = new FilterParams(filterJson, (String)this.getModel().getValue("datarange", index));
                    PageShowHelper.showDataFilterPage(this.getView(), entityNumber, filterParams, new CloseCallBack((IFormPlugin)this, "datarange"), ResManager.loadKDString((String)"\u53c2\u8003\u6570\u636e\u8303\u56f4", (String)"QuotaCalRulePlugin_1", (String)"mpscmm-msbd-quotamodel", (Object[])new Object[0]));
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53c2\u8003\u6570\u636e\u6765\u6e90\u3002", (String)"QuotaCalRulePlugin_2", (String)"mpscmm-msbd-quotamodel", (Object[])new Object[0]));
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("datasource".equals(name)) {
            HashSet<String> entitys = new HashSet<String>();
            Map referQuotaMapping = BusinessDataServiceHelper.loadFromCache((String)"sbs_billfieldmapping", (QFilter[])new QFilter[]{new QFilter("targetobj.number", "=", (Object)"msbd_refermodel")});
            for (DynamicObject value : referQuotaMapping.values()) {
                String number = value.getString("sourcebill.number");
                if (!StringUtils.isNotEmpty((String)number)) continue;
                entitys.add(number);
            }
            beforeF7SelectEvent.addCustomQFilter(new QFilter("number", "in", entitys));
        }
        if ("datamapping".equals(name)) {
            int row = beforeF7SelectEvent.getRow();
            DynamicObject dataSource = (DynamicObject)this.getModel().getValue("datasource", row);
            if (dataSource != null) {
                String entityNumber = dataSource.getString("number");
                QFilter targetobj = new QFilter("targetobj", "=", (Object)"msbd_refermodel");
                QFilter sourcebill = new QFilter("sourcebill", "=", (Object)entityNumber);
                QFilter enable = new QFilter("isenable", "=", (Object)true);
                beforeF7SelectEvent.addCustomQFilter(targetobj.and(sourcebill).and(enable));
            } else {
                beforeF7SelectEvent.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53c2\u8003\u6570\u636e\u6765\u6e90\u3002", (String)"QuotaCalRulePlugin_2", (String)"mpscmm-msbd-quotamodel", (Object[])new Object[0]));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        HashMap returnMap;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("datarange".equals(actionId) && (returnMap = (HashMap)evt.getReturnData()) != null) {
            String filterJson = (String)returnMap.get("filterJson");
            String filterDesc = (String)returnMap.get("filterDesc");
            IDataModel model = this.getModel();
            int index = model.getEntryCurrentRowIndex("entryentity");
            model.setValue("datarange", (Object)filterDesc, index);
            model.setValue("datarangejson_tag", (Object)filterJson, index);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if ("changeQuotaAlgorithm".equals(callBackId)) {
            MessageBoxResult result = evt.getResult();
            IDataModel model = this.getModel();
            if (MessageBoxResult.Yes.equals((Object)result)) {
                model.deleteEntryData("entryentity");
                model.setValue("period", (Object)true);
            } else {
                String algorithm = this.getView().getPageCache().get("algorithm");
                if (StringUtils.isNotEmpty((String)algorithm)) {
                    DynamicObject algorithmObj = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(algorithm), (String)"msbd_quotaalgorithm");
                    model.beginInit();
                    model.setValue("algorithm", (Object)algorithmObj);
                    model.endInit();
                }
            }
            this.getView().updateView();
        }
    }
}

