/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.opvalidate.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.mpscmm.msbd.business.helper.SysParamHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class AmountPlanValidator
extends AbstractValidator {
    private static final String APP_ID = "appid";
    private static final String VIEW_TYPE = "viewtype";
    private static final String ENTRY_ID = "entrynum";
    private static final String ENTRY_AMOUNT = "amount";
    private static final String CHANGETYPE = "changetype";
    private static final String TOTALALLAMOUNT = "totalallamount";
    private static final String FAMOUNTPLANCHECK = "famountplancheck";
    private static final String PLANTYPE = "plantype";

    public Set<String> preparePropertys() {
        Map validation;
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>();
        }
        if ((validation = this.getValidation()) == null || validation.isEmpty()) {
            return preparePropertys;
        }
        String entryNum = String.valueOf(validation.get(ENTRY_ID));
        String amountKey = String.valueOf(validation.get(ENTRY_AMOUNT));
        String changeTypeKey = String.valueOf(validation.get(CHANGETYPE));
        String totalAllAmountKey = String.valueOf(validation.get(TOTALALLAMOUNT));
        preparePropertys.add("org");
        preparePropertys.add(entryNum);
        preparePropertys.add(amountKey);
        preparePropertys.add(changeTypeKey);
        preparePropertys.add(totalAllAmountKey);
        return preparePropertys;
    }

    public void validate() {
        Map map = this.getValidation();
        if (map == null || map.isEmpty()) {
            return;
        }
        String appId = String.valueOf(map.get(APP_ID));
        String viewType = String.valueOf(map.get(VIEW_TYPE));
        String entryNumKey = String.valueOf(map.get(ENTRY_ID));
        String amountKey = String.valueOf(map.get(ENTRY_AMOUNT));
        String changeTypeKey = String.valueOf(map.get(CHANGETYPE));
        String totalAllAmountKey = String.valueOf(map.get(TOTALALLAMOUNT));
        String planType = String.valueOf(map.get(PLANTYPE));
        Map<Long, Boolean> appParam = this.batchGetAppParam(this.dataEntities, appId, viewType);
        if (appParam == null || appParam.isEmpty()) {
            return;
        }
        for (ExtendedDataEntity extend : this.dataEntities) {
            DynamicObjectCollection entrys;
            Boolean isCheckAmountPlan;
            DynamicObject entity = extend.getDataEntity();
            DynamicObject org = entity.getDynamicObject("org");
            if (org == null || (isCheckAmountPlan = appParam.get((Long)org.getPkValue())) == null || !isCheckAmountPlan.booleanValue() || (entrys = entity.getDynamicObjectCollection(entryNumKey)) == null || entrys.size() == 0) continue;
            BigDecimal totalAllAmount = entity.getBigDecimal(totalAllAmountKey);
            BigDecimal totalPlanAmount = BigDecimal.ZERO;
            int count = 0;
            for (DynamicObject entry : entrys) {
                String changeType = entry.getString(changeTypeKey);
                if (changeType != null && "C".equals(changeType)) {
                    ++count;
                    continue;
                }
                BigDecimal planAmount = entry.getBigDecimal(amountKey);
                totalPlanAmount = totalPlanAmount.add(planAmount == null ? BigDecimal.ZERO : planAmount);
            }
            if (totalAllAmount == null || totalPlanAmount.compareTo(totalAllAmount) == 0 || count == entrys.size()) continue;
            if ("salconm".equals(planType)) {
                this.addMessage(extend, ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212\u7684\u6536\u6b3e\u91d1\u989d\u5408\u8ba1\u4e0e\u5355\u636e\u7684\u603b\u4ef7\u7a0e\u5408\u8ba1\u4e00\u81f4\u624d\u80fd\u901a\u8fc7\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"AmountPlanValidator_1", (String)"mpscmm-msbd-common", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if ("purconm".equals(planType)) {
                this.addMessage(extend, ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u7684\u4ed8\u6b3e\u91d1\u989d\u5408\u8ba1\u4e0e\u5355\u636e\u7684\u603b\u4ef7\u7a0e\u5408\u8ba1\u4e00\u81f4\u624d\u80fd\u901a\u8fc7\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"AmountPlanValidator_0", (String)"mpscmm-msbd-common", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if ("sales".equals(planType)) {
                this.addMessage(extend, ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212\u7684\u6536\u6b3e\u91d1\u989d\u5408\u8ba1\u4e0e\u5355\u636e\u7684\u603b\u4ef7\u7a0e\u5408\u8ba1\u4e00\u81f4\u624d\u80fd\u901a\u8fc7\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"AmountPlanValidator_1", (String)"mpscmm-msbd-common", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (!"purchase".equals(planType)) continue;
            this.addMessage(extend, ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u7684\u4ed8\u6b3e\u91d1\u989d\u5408\u8ba1\u4e0e\u5355\u636e\u7684\u603b\u4ef7\u7a0e\u5408\u8ba1\u4e00\u81f4\u624d\u80fd\u901a\u8fc7\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"AmountPlanValidator_0", (String)"mpscmm-msbd-common", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }

    private Map<Long, Boolean> batchGetAppParam(ExtendedDataEntity[] dataEntities, String appId, String viewType) {
        HashSet<Long> orgIdSet = new HashSet<Long>(10);
        for (ExtendedDataEntity data : dataEntities) {
            DynamicObject bill = data.getDataEntity();
            DynamicObject org = (DynamicObject)bill.get("org");
            if (org == null) continue;
            orgIdSet.add((Long)org.getPkValue());
        }
        ArrayList orgList = new ArrayList(orgIdSet);
        Map parameterMap = SysParamHelper.batchGetSysParam((String)appId, (String)viewType, orgList, (String)FAMOUNTPLANCHECK);
        HashMap<Long, Boolean> orgAndControlPlanFlag = new HashMap<Long, Boolean>(16);
        for (Map.Entry entry : parameterMap.entrySet()) {
            orgAndControlPlanFlag.put(Long.parseLong((String)entry.getKey()), (Boolean)entry.getValue());
        }
        return orgAndControlPlanFlag;
    }
}

