/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.opvalidate.validator;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.business.helper.BillAmountHelper;
import kd.mpscmm.msbd.business.helper.CurrencyHelper;
import kd.mpscmm.msbd.common.enums.ExchangeTypeEnum;
import kd.mpscmm.msbd.common.enums.StatusEnum;
import kd.mpscmm.msbd.common.pojo.BillAmountInfo;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.common.utils.MethodParameterUtil;

public class BillAmountValidator
extends AbstractValidator {
    public static String PARA_ORGFUNCTION = "orgfunction";
    public static String PARA_ISCHECKPRICEERROR = "ischeckpriceerror";
    public static String PARA_ISCHECKNOTAXERROR = "ischecknotaxerror";
    public static String PARA_ISCHECKHASTAXERROR = "ischeckhastaxerror";
    public static String PARA_ISCHECKCURRENCYERROR = "ischeckcurrencyerror";
    public static String PARA_ISCHECKTOTALERROR = "ischecktotalerror";
    public static String PARA_ISCHECKAMOUNTDIRECTION = "ischeckamountdirection";

    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>(32);
        }
        String customparameter = (String)this.getValidation().get("customparameter");
        String BILLNO = MethodParameterUtil.getProperytMappingValue((Object)customparameter, (String)"billno");
        preparePropertys.add(BILLNO);
        preparePropertys.add("billstatus");
        preparePropertys.add("istax");
        preparePropertys.add("currency");
        preparePropertys.add("settlecurrency");
        preparePropertys.add("exratetable");
        preparePropertys.add("exchangerate");
        preparePropertys.add("exratedate");
        preparePropertys.add("biztime");
        preparePropertys.add("qty");
        preparePropertys.add("price");
        preparePropertys.add("priceandtax");
        preparePropertys.add("taxrate");
        preparePropertys.add("discounttype");
        preparePropertys.add("discountrate");
        preparePropertys.add("exchangetype");
        preparePropertys.add("indirectexrate");
        preparePropertys.add("amount");
        preparePropertys.add("taxamount");
        preparePropertys.add("discountamount");
        preparePropertys.add("amountandtax");
        preparePropertys.add("curamount");
        preparePropertys.add("curtaxamount");
        preparePropertys.add("curamountandtax");
        preparePropertys.add("totalamount");
        preparePropertys.add("totaltaxamount");
        preparePropertys.add("totalallamount");
        return preparePropertys;
    }

    public void validate() {
        if (this.getDataEntities() == null || this.getDataEntities().length == 0) {
            return;
        }
        String customparameter = (String)this.getValidation().get("customparameter");
        String BILLENTRY = MethodParameterUtil.getProperytMappingValue((Object)customparameter, (String)"billentry");
        String MATERIAL = MethodParameterUtil.getProperytMappingValue((Object)customparameter, (String)"material");
        String BILLNO = MethodParameterUtil.getProperytMappingValue((Object)customparameter, (String)"billno");
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObjectCollection entrys;
            Map exRateMap;
            String tipMsg;
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObject org = bill.getDynamicObject("org");
            String billStatus = bill.getString("billstatus");
            Date bizTime = bill.getDate("biztime");
            if ("sm_salorder".equals(bill.getDataEntityType().getName()) || "sm_salesagency".equals(bill.getDataEntityType().getName()) || "sm_returnapply".equals(bill.getDataEntityType().getName())) {
                bizTime = bill.getDate("bizdate");
            }
            String bizTimeName = "";
            bizTimeName = "sm_salesagency".equals(bill.getDataEntityType().getName()) ? ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f", (String)"BillAmountValidator_12", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8ba2\u5355\u65e5\u671f", (String)"BillAmountValidator_13", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]);
            DynamicObject currency = bill.getDynamicObject("currency");
            DynamicObject settleCurrency = bill.getDynamicObject("settlecurrency");
            DynamicObject exRateTable = bill.getDynamicObject("exratetable");
            BigDecimal exchangeRate = bill.getBigDecimal("exchangerate");
            Date exRateTime = bill.getDate("exratedate");
            String exchangeType = bill.getString("exchangetype");
            BigDecimal totalAmount = BigDecimal.ZERO;
            BigDecimal totalTaxAmount = BigDecimal.ZERO;
            BigDecimal totalAllAmount = BigDecimal.ZERO;
            int settleAmtPrecision = settleCurrency == null ? 10 : settleCurrency.getInt("amtprecision");
            Map map = CurrencyHelper.getCurrencyAndExRateTable((Long)((Long)org.getPkValue()));
            if (currency != null && !currency.getPkValue().equals(map.get("baseCurrencyID"))) {
                tipMsg = "";
                if ("pur".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ORGFUNCTION))) {
                    tipMsg = String.format(ResManager.loadKDString((String)"%1$s\uff0c\u672c\u4f4d\u5e01\u201c%2$s\u201d\u4e0d\u662f\u91c7\u8d2d\u7ec4\u7ec7\u7684\u672c\u4f4d\u5e01\u3002", (String)"BillAmountValidator_0", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), bill.get(BILLNO), currency.getString("name"));
                } else if ("sal".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ORGFUNCTION))) {
                    tipMsg = String.format(ResManager.loadKDString((String)"%1$s\uff0c\u672c\u4f4d\u5e01\u201c%2$s\u201d\u4e0d\u662f\u9500\u552e\u7ec4\u7ec7\u7684\u672c\u4f4d\u5e01\u3002", (String)"BillAmountValidator_1", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), bill.get(BILLNO), currency.getString("name"));
                } else if ((org = BusinessDataServiceHelper.loadSingleFromCache((Object)org.getPkValue(), (String)"bos_org", (String)"id,fispurchase,fissale")) != null && org.getBoolean("fispurchase")) {
                    tipMsg = String.format(ResManager.loadKDString((String)"%1$s\uff0c\u672c\u4f4d\u5e01\u201c%2$s\u201d\u4e0d\u662f\u91c7\u8d2d\u7ec4\u7ec7\u7684\u672c\u4f4d\u5e01\u3002", (String)"BillAmountValidator_0", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), bill.get(BILLNO), currency.getString("name"));
                } else if (org != null && org.getBoolean("fissale")) {
                    tipMsg = String.format(ResManager.loadKDString((String)"%1$s\uff0c\u672c\u4f4d\u5e01\u201c%2$s\u201d\u4e0d\u662f\u9500\u552e\u7ec4\u7ec7\u7684\u672c\u4f4d\u5e01\u3002", (String)"BillAmountValidator_1", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), bill.get(BILLNO), currency.getString("name"));
                }
                this.addMessage(dataEntity, tipMsg, ErrorLevel.Error);
            }
            if (currency != null && exRateTable != null && exchangeType != null && settleCurrency != null && !exchangeType.equals((exRateMap = CurrencyHelper.getExChangeRateMap((Long)((Long)settleCurrency.getPkValue()), (Long)((Long)currency.getPkValue()), (Long)((Long)exRateTable.getPkValue()), (Date)exRateTime)).get("exchangetype"))) {
                String tipMsg2 = String.format(ResManager.loadKDString((String)"%1$s\uff0c\u6362\u7b97\u65b9\u5f0f\u201c%2$s\u201d\u4e0e\u7cfb\u7edf\u5f53\u524d\u8bbe\u7f6e\u4e0d\u4e00\u81f4\u3002", (String)"BillAmountValidator_2", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), bill.get(BILLNO), exchangeType);
                this.addMessage(dataEntity, tipMsg2, ErrorLevel.Error);
            }
            if (currency != null && settleCurrency != null && currency.getPkValue().equals(settleCurrency.getPkValue()) && exchangeRate.compareTo(BigDecimal.ONE) != 0) {
                tipMsg = String.format(ResManager.loadKDString((String)"%1$s\uff0c\u201c\u7ed3\u7b97\u5e01\u522b\u201d\u4e0e\u201c\u672c\u4f4d\u5e01\u201d\u76f8\u540c\uff0c\u6c47\u7387\u5fc5\u987b\u4e3a1\u3002", (String)"BillAmountValidator_3", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), bill.get(BILLNO));
                this.addMessage(dataEntity, tipMsg, ErrorLevel.Error);
            }
            if ((entrys = bill.getDynamicObjectCollection(BILLENTRY)) != null && entrys.size() > 0) {
                for (int i = 0; i < entrys.size(); ++i) {
                    DynamicObject billentry = (DynamicObject)entrys.get(i);
                    DynamicObject material = billentry.getDynamicObject(MATERIAL);
                    if (CommonUtils.isNull((Object)material)) {
                        String tipMsg3 = String.format(ResManager.loadKDString((String)"%1$s\uff0c\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%2$s\u884c\uff1a\u201c\u7269\u6599\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BillAmountValidator_4", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), bill.get(BILLNO), i + 1);
                        this.addMessage(dataEntity, tipMsg3, ErrorLevel.Error);
                        continue;
                    }
                    DynamicObject materialmasterid = null;
                    materialmasterid = "bd_material".equals(material.getDataEntityType().getName()) ? material : material.getDynamicObject("masterid");
                    DynamicObject taxrateid = billentry.getDynamicObject("taxrateid");
                    if (bizTime != null && taxrateid != null) {
                        Date activedate = taxrateid.getDate("activedate");
                        Date expdate = taxrateid.getDate("expdate");
                        if (activedate != null && activedate.compareTo(bizTime) > 0 || expdate != null && expdate.compareTo(bizTime) < 0) {
                            String tipMsg4 = String.format(ResManager.loadKDString((String)"%1$s\uff0c\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%2$s\u884c\uff1a\u201c%3$s\u201d\u672a\u5728\u7a0e\u7387\u201c%4$s\u201d\u7684\u6709\u6548\u65e5\u671f\u8303\u56f4\u5185\u3002", (String)"BillAmountValidator_5", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), bill.get(BILLNO), i + 1, bizTimeName, taxrateid.getString("number"));
                            this.addMessage(dataEntity, tipMsg4, ErrorLevel.Error);
                        }
                    }
                    BigDecimal qty = billentry.getBigDecimal("qty");
                    BigDecimal taxAmount = billentry.getBigDecimal("taxAmount");
                    BigDecimal discountAmount = billentry.getBigDecimal("discountAmount");
                    BigDecimal amount = billentry.getBigDecimal("amount");
                    BigDecimal amountAndTax = billentry.getBigDecimal("amountAndTax");
                    BillAmountInfo amountInfo = new BillAmountInfo();
                    amountInfo.setInputamount(false);
                    amountInfo.setTax(bill.getBoolean("istax"));
                    amountInfo.setQty(qty);
                    amountInfo.setPrice(billentry.getBigDecimal("price"));
                    amountInfo.setPriceAndTax(billentry.getBigDecimal("priceandtax"));
                    amountInfo.setTaxRate(billentry.getBigDecimal("taxrate"));
                    amountInfo.setDiscountType(billentry.getString("discounttype"));
                    amountInfo.setDiscountRate(billentry.getBigDecimal("discountrate"));
                    amountInfo.setExChangeRate(bill.getBigDecimal("exchangerate"));
                    amountInfo.setSettleAmtPrecision(settleAmtPrecision);
                    int currencyAmtPrecision = currency == null ? 10 : currency.getInt("amtprecision");
                    amountInfo.setCurrencyAmtPrecision(currencyAmtPrecision);
                    amountInfo.setIndirectExRate(ExchangeTypeEnum.isIndirectRate((Object)exchangeType));
                    amountInfo.setAmount(amount);
                    amountInfo.setTaxAmount(taxAmount);
                    amountInfo.setDiscountAmount(discountAmount);
                    amountInfo.setAmountAndTax(amountAndTax);
                    Map result = BillAmountHelper.calAmount((BillAmountInfo)amountInfo);
                    if (!(!"true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKPRICEERROR)) || BigDecimalUtil.equals((BigDecimal)billentry.getBigDecimal("price"), (BigDecimal)((BigDecimal)result.get(amountInfo.getProperytMappingName("PRICE")))) && BigDecimalUtil.equals((BigDecimal)billentry.getBigDecimal("priceandtax"), (BigDecimal)((BigDecimal)result.get(amountInfo.getProperytMappingName("PRICEANDTAX")))))) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff0c\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%2$s\u884c\uff1a\u7269\u6599\u201c%3$s(%4$s)\u201d\uff0c\u201c\u5355\u4ef7\u201d\u548c\u201c\u542b\u7a0e\u5355\u4ef7\u201d\u8ba1\u7b97\u4e0d\u6b63\u786e\u3002", (String)"BillAmountValidator_6", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), bill.get(BILLNO), i + 1, materialmasterid.get("name"), materialmasterid.get("number")), ErrorLevel.Error);
                    }
                    if (!(BigDecimalUtil.equals((BigDecimal)billentry.getBigDecimal("amount"), (BigDecimal)((BigDecimal)result.get(amountInfo.getProperytMappingName("AMOUNT")))) && BigDecimalUtil.equals((BigDecimal)billentry.getBigDecimal("taxamount"), (BigDecimal)((BigDecimal)result.get(amountInfo.getProperytMappingName("TAXAMOUNT")))) && BigDecimalUtil.equals((BigDecimal)billentry.getBigDecimal("amountandtax"), (BigDecimal)((BigDecimal)result.get(amountInfo.getProperytMappingName("AMOUNTANDTAX")))))) {
                        if ("true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKHASTAXERROR))) {
                            if (Boolean.TRUE.equals(bill.getBoolean("istax"))) {
                                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff0c\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%2$s\u884c\uff1a\u7269\u6599\u201c%3$s(%4$s)\u201d\uff0c\u542b\u7a0e\u65f6\u201c\u91d1\u989d\u201d\u548c\u201c\u4ef7\u7a0e\u5408\u8ba1\u201d\u8ba1\u7b97\u4e0d\u6b63\u786e\u3002", (String)"BillAmountValidator_7", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), bill.get(BILLNO), i + 1, materialmasterid.get("name"), materialmasterid.get("number")), ErrorLevel.Error);
                            }
                        } else if ("true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKNOTAXERROR))) {
                            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff0c\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%2$s\u884c\uff1a\u7269\u6599\u201c%3$s(%4$s)\u201d\uff0c\u4e0d\u542b\u7a0e\u65f6\u201c\u91d1\u989d\u201d\u548c\u201c\u4ef7\u7a0e\u5408\u8ba1\u201d\u8ba1\u7b97\u4e0d\u6b63\u786e\u3002", (String)"BillAmountValidator_8", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), bill.get(BILLNO), i + 1, materialmasterid.get("name"), materialmasterid.get("number")), ErrorLevel.Error);
                        }
                    }
                    if (!(!"true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKCURRENCYERROR)) || BigDecimalUtil.equals((BigDecimal)billentry.getBigDecimal("curamount"), (BigDecimal)((BigDecimal)result.get(amountInfo.getProperytMappingName("CURAMOUNT")))) && BigDecimalUtil.equals((BigDecimal)billentry.getBigDecimal("curtaxamount"), (BigDecimal)((BigDecimal)result.get(amountInfo.getProperytMappingName("CURTAXAMOUNT")))) && BigDecimalUtil.equals((BigDecimal)billentry.getBigDecimal("curamountandtax"), (BigDecimal)((BigDecimal)result.get(amountInfo.getProperytMappingName("CURAMOUNTANDTAX")))))) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff0c\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%2$s\u884c\uff1a\u7269\u6599\u201c%3$s(%4$s)\u201d\uff0c\u201c\u91d1\u989d\u201d\u548c\u201c\u4ef7\u7a0e\u5408\u8ba1\u201d\u7684\u672c\u4f4d\u5e01\u8ba1\u7b97\u4e0d\u6b63\u786e\u3002", (String)"BillAmountValidator_9", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), bill.get(BILLNO), i + 1, materialmasterid.get("name"), materialmasterid.get("number")), ErrorLevel.Error);
                    }
                    if (billentry.getBigDecimal("amount") != null) {
                        totalAmount = totalAmount.add(billentry.getBigDecimal("amount"));
                    }
                    if (billentry.getBigDecimal("taxamount") != null) {
                        totalTaxAmount = totalTaxAmount.add(billentry.getBigDecimal("taxamount"));
                    }
                    if (billentry.getBigDecimal("amountandtax") != null) {
                        totalAllAmount = totalAllAmount.add(billentry.getBigDecimal("amountandtax"));
                    }
                    if (!StatusEnum.AUDIT.getValue().equals(billStatus) && !StatusEnum.SUBMIT.getValue().equals(billStatus) || !"true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKAMOUNTDIRECTION)) || qty == null || taxAmount == null || discountAmount == null || amount == null || amountAndTax == null || qty.compareTo(BigDecimal.ZERO) >= 0 && taxAmount.compareTo(BigDecimal.ZERO) >= 0 && discountAmount.compareTo(BigDecimal.ZERO) >= 0 && amount.compareTo(BigDecimal.ZERO) >= 0 && amountAndTax.compareTo(BigDecimal.ZERO) >= 0 || qty.compareTo(BigDecimal.ZERO) <= 0 && taxAmount.compareTo(BigDecimal.ZERO) <= 0 && discountAmount.compareTo(BigDecimal.ZERO) <= 0 && amount.compareTo(BigDecimal.ZERO) <= 0 && amountAndTax.compareTo(BigDecimal.ZERO) <= 0) continue;
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff0c\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%2$s\u884c\uff1a\u201c\u6570\u91cf\u201d\u3001\u201c\u91d1\u989d\u201d\u3001\u201c\u7a0e\u989d\u201d\u3001\u201c\u6298\u6263\u989d\u201d\u3001\u201c\u4ef7\u7a0e\u5408\u8ba1\u201d\u7684\u65b9\u5411\u9700\u4e00\u81f4\u3002", (String)"BillAmountValidator_10", (String)"mpscmm-mspur", (Object[])new Object[0]), bill.get(BILLNO), i + 1), ErrorLevel.Error);
                }
            }
            if (!"true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKTOTALERROR))) continue;
            totalAmount = totalAmount.setScale(settleAmtPrecision, RoundingMode.HALF_UP);
            totalTaxAmount = totalTaxAmount.setScale(settleAmtPrecision, RoundingMode.HALF_UP);
            totalAllAmount = totalAllAmount.setScale(settleAmtPrecision, RoundingMode.HALF_UP);
            if (BigDecimalUtil.equals((BigDecimal)bill.getBigDecimal("totalamount"), (BigDecimal)totalAmount) && BigDecimalUtil.equals((BigDecimal)bill.getBigDecimal("totaltaxamount"), (BigDecimal)totalTaxAmount) && BigDecimalUtil.equals((BigDecimal)bill.getBigDecimal("totalallamount"), (BigDecimal)totalAllAmount)) continue;
            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff0c\u5355\u636e\u5934\u7684\u91d1\u989d\u6216\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u6b63\u786e\u3002", (String)"BillAmountValidator_11", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), bill.get(BILLNO)), ErrorLevel.Error);
        }
    }
}

