/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.opvalidate.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.mpscmm.msbd.common.enums.BillStatusEnum;
import kd.mpscmm.msbd.common.enums.BizCancelStatusEnum;
import kd.mpscmm.msbd.common.enums.BizCloseStatusEnum;
import kd.mpscmm.msbd.common.enums.ChangeStatusEnum;
import kd.mpscmm.msbd.common.enums.RowCloseStatusEnum;
import kd.mpscmm.msbd.common.enums.RowTerminateStatusEnum;
import kd.mpscmm.msbd.common.enums.StatusEnum;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.common.utils.MetadataUtils;

public class BizStatusValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>();
        }
        preparePropertys.add("billstatus");
        preparePropertys.add("cancelstatus");
        preparePropertys.add("canceler");
        preparePropertys.add("canceldate");
        preparePropertys.add("changestatus");
        preparePropertys.add("changer");
        preparePropertys.add("changedate");
        preparePropertys.add("closestatus");
        preparePropertys.add("closer");
        preparePropertys.add("closedate");
        preparePropertys.add("rowclosestatus");
        preparePropertys.add("rowterminatestatus");
        return preparePropertys;
    }

    public void validate() {
        if (this.getDataEntities() == null || this.getDataEntities().length == 0) {
            return;
        }
        switch (this.getOperateKey()) {
            case "save": {
                for (ExtendedDataEntity data : this.dataEntities) {
                    DynamicObject bill = data.getDataEntity();
                    String billstatus = bill.getString("billstatus");
                    if (!StatusEnum.AUDIT.getValue().equals(billstatus)) continue;
                    if (MetadataUtils.checkProperty((DynamicObject)bill, (String)"closestatus")) {
                        String closeStatus = bill.getString("closestatus");
                        DynamicObject closer = bill.getDynamicObject("closer");
                        Date closedate = bill.getDate("closedate");
                        if (BizCloseStatusEnum.UNCLOSE.getValue().equals(closeStatus)) {
                            if (closer != null) {
                                this.addMessage(data, ResManager.loadKDString((String)"\u5173\u95ed\u72b6\u6001\u4e3a\u6b63\u5e38\uff0c\u5173\u95ed\u4eba\u5e94\u4e3a\u7a7a\u3002", (String)"BizStatusValidator_16", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), ErrorLevel.Error);
                            }
                            if (closedate != null) {
                                this.addMessage(data, ResManager.loadKDString((String)"\u5173\u95ed\u72b6\u6001\u4e3a\u6b63\u5e38\uff0c\u5173\u95ed\u65e5\u671f\u5e94\u4e3a\u7a7a\u3002", (String)"BizStatusValidator_17", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), ErrorLevel.Error);
                            }
                        }
                        if (BizCloseStatusEnum.CLOSE.getValue().equals(closeStatus)) {
                            if (closer == null) {
                                this.addMessage(data, ResManager.loadKDString((String)"\u5173\u95ed\u72b6\u6001\u4e3a\u5df2\u5173\u95ed\uff0c\u5173\u95ed\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizStatusValidator_18", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), ErrorLevel.Error);
                            }
                            if (closedate == null) {
                                this.addMessage(data, ResManager.loadKDString((String)"\u5173\u95ed\u72b6\u6001\u4e3a\u5df2\u5173\u95ed\uff0c\u5173\u95ed\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizStatusValidator_19", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), ErrorLevel.Error);
                            }
                        }
                    }
                    if (MetadataUtils.checkProperty((DynamicObject)bill, (String)"cancelstatus")) {
                        String cancelstatus = bill.getString("cancelstatus");
                        DynamicObject canceler = bill.getDynamicObject("canceler");
                        Date canceldate = bill.getDate("canceldate");
                        if (BizCancelStatusEnum.UNCANCEL.getValue().equals(cancelstatus)) {
                            if (canceler != null) {
                                this.addMessage(data, ResManager.loadKDString((String)"\u4f5c\u5e9f\u72b6\u6001\u4e3a\u672a\u4f5c\u5e9f\uff0c\u4f5c\u5e9f\u4eba\u5e94\u4e3a\u7a7a\u3002", (String)"BizStatusValidator_20", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), ErrorLevel.Error);
                            }
                            if (canceldate != null) {
                                this.addMessage(data, ResManager.loadKDString((String)"\u4f5c\u5e9f\u72b6\u6001\u4e3a\u672a\u4f5c\u5e9f\uff0c\u4f5c\u5e9f\u65e5\u671f\u5e94\u4e3a\u7a7a\u3002", (String)"BizStatusValidator_21", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), ErrorLevel.Error);
                            }
                        }
                        if (BizCancelStatusEnum.CANCEL.getValue().equals(cancelstatus)) {
                            if (canceler == null) {
                                this.addMessage(data, ResManager.loadKDString((String)"\u4f5c\u5e9f\u72b6\u6001\u4e3a\u5df2\u4f5c\u5e9f\uff0c\u4f5c\u5e9f\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizStatusValidator_22", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), ErrorLevel.Error);
                            }
                            if (canceldate == null) {
                                this.addMessage(data, ResManager.loadKDString((String)"\u4f5c\u5e9f\u72b6\u6001\u4e3a\u5df2\u4f5c\u5e9f\uff0c\u4f5c\u5e9f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizStatusValidator_23", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), ErrorLevel.Error);
                            }
                        }
                    }
                    if (MetadataUtils.checkProperty((DynamicObject)bill, (String)"changestatus")) {
                        String changestatus = bill.getString("changestatus");
                        DynamicObject changer = bill.getDynamicObject("changer");
                        Date changedate = bill.getDate("changedate");
                        if (ChangeStatusEnum.UNCHANGE.getValue().equals(changestatus)) {
                            if (changer != null) {
                                this.addMessage(data, ResManager.loadKDString((String)"\u53d8\u66f4\u72b6\u6001\u4e3a\u6b63\u5e38\uff0c\u53d8\u66f4\u4eba\u5e94\u4e3a\u7a7a\u3002", (String)"BizStatusValidator_24", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), ErrorLevel.Error);
                            }
                            if (changedate != null) {
                                this.addMessage(data, ResManager.loadKDString((String)"\u53d8\u66f4\u72b6\u6001\u4e3a\u6b63\u5e38\uff0c\u53d8\u66f4\u65e5\u671f\u5e94\u4e3a\u7a7a\u3002", (String)"BizStatusValidator_25", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), ErrorLevel.Error);
                            }
                        }
                        if (ChangeStatusEnum.CHANGED.getValue().equals(changestatus)) {
                            if (changer == null) {
                                this.addMessage(data, ResManager.loadKDString((String)"\u53d8\u66f4\u72b6\u6001\u4e3a\u5df2\u53d8\u66f4\uff0c\u53d8\u66f4\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizStatusValidator_26", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), ErrorLevel.Error);
                            }
                            if (changedate == null) {
                                this.addMessage(data, ResManager.loadKDString((String)"\u53d8\u66f4\u72b6\u6001\u4e3a\u5df2\u53d8\u66f4\uff0c\u53d8\u66f4\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizStatusValidator_27", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), ErrorLevel.Error);
                            }
                        }
                    }
                    if (bill.get("auditor") == null) {
                        this.addMessage(data, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\uff0c\u5ba1\u6838\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizStatusValidator_28", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), ErrorLevel.Error);
                    }
                    if (bill.get("auditdate") != null) continue;
                    this.addMessage(data, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\uff0c\u5ba1\u6838\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizStatusValidator_29", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), ErrorLevel.Error);
                }
                break;
            }
            case "submit": {
                for (ExtendedDataEntity data : this.dataEntities) {
                    DynamicObject bill = data.getDataEntity();
                    if (bill.getDynamicObjectType().getProperty("cancelstatus") == null) continue;
                    String cancelStatus = bill.getString("cancelstatus");
                    if (!BizCancelStatusEnum.CANCEL.getValue().equals(cancelStatus)) continue;
                    this.addMessage(data, ResManager.loadKDString((String)"\u53ea\u6709\u672a\u4f5c\u5e9f\u7684\u6570\u636e\u624d\u80fd\u63d0\u4ea4\u3002", (String)"BizStatusValidator_1", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), ErrorLevel.Error);
                }
                break;
            }
            case "unsubmit": {
                break;
            }
            case "audit": {
                break;
            }
            case "unaudit": {
                for (ExtendedDataEntity data : this.dataEntities) {
                    DynamicObject bill = data.getDataEntity();
                    String closeStatus = bill.getString("closestatus");
                    if (!BizCloseStatusEnum.CLOSE.getValue().equals(closeStatus)) continue;
                    this.addMessage(data, ResManager.loadKDString((String)"\u5173\u95ed\u72b6\u6001\u5fc5\u987b\u4e3a\u6b63\u5e38\u624d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"BizStatusValidator_2", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), ErrorLevel.Error);
                }
                break;
            }
            case "bizclose": {
                for (ExtendedDataEntity data : this.dataEntities) {
                    DynamicObject bill = data.getDataEntity();
                    String billStatus = bill.getString("billstatus");
                    String closeStatus = bill.getString("closestatus");
                    if (BizCloseStatusEnum.CLOSE.getValue().equals(closeStatus)) {
                        this.addMessage(data, ResManager.loadKDString((String)"\u5173\u95ed\u72b6\u6001\u5fc5\u987b\u4e3a\u6b63\u5e38\u624d\u80fd\u5173\u95ed\u3002", (String)"BizStatusValidator_3", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), ErrorLevel.Error);
                        continue;
                    }
                    if (BillStatusEnum.AUDIT.getValue().equals(billStatus)) continue;
                    this.addMessage(data, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u5ba1\u6838\u624d\u80fd\u5173\u95ed\u3002", (String)"BizStatusValidator_4", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), ErrorLevel.Error);
                }
                break;
            }
            case "bizunclose": {
                for (ExtendedDataEntity data : this.dataEntities) {
                    DynamicObject bill = data.getDataEntity();
                    String closeStatus = bill.getString("closestatus");
                    if (!BizCloseStatusEnum.UNCLOSE.getValue().equals(closeStatus)) continue;
                    this.addMessage(data, ResManager.loadKDString((String)"\u5173\u95ed\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u5173\u95ed\u624d\u80fd\u53cd\u5173\u95ed\u3002", (String)"BizStatusValidator_5", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), ErrorLevel.Error);
                }
                break;
            }
            case "rowterminate": {
                String option = this.getOption().getVariableValue("bos_listselectedrowcollection");
                ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)SerializationUtils.fromJsonString((String)option, ListSelectedRowCollection.class);
                ArrayList<Object> selRowList = new ArrayList<Object>(Arrays.asList(selectedRows.getEntryPrimaryKeyValues()));
                if (CommonUtils.isNull(selRowList)) break;
                for (ExtendedDataEntity data : this.dataEntities) {
                    DynamicObject bill = data.getDataEntity();
                    String closeStatus = bill.getString("closestatus");
                    if (BizCloseStatusEnum.CLOSE.getValue().equals(closeStatus)) {
                        this.addMessage(data, ResManager.loadKDString((String)"\u5df2\u5173\u95ed\u7684\u5355\u636e\u65e0\u6cd5\u6267\u884c\u884c\u7ec8\u6b62\u64cd\u4f5c\u3002", (String)"BizStatusValidator_7", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), ErrorLevel.Error);
                        continue;
                    }
                    for (ListSelectedRow selectedRow : selectedRows) {
                        String entryEntityKey = selectedRow.getEntryEntityKey();
                        Object entryEntityId = selectedRow.getEntryPrimaryKeyValue();
                        int i = 0;
                        for (DynamicObject entry : bill.getDynamicObjectCollection(entryEntityKey)) {
                            String tip;
                            ++i;
                            if (!(entryEntityId instanceof Long) || !(entry.getPkValue() instanceof Long) || !entryEntityId.equals(entry.getPkValue())) continue;
                            String rowCloseStatus = entry.getString("rowclosestatus");
                            String rowTerminateStatus = entry.getString("rowterminatestatus");
                            if (RowTerminateStatusEnum.ROWTERMINATE.getValue().equals(rowTerminateStatus)) {
                                tip = String.format(ResManager.loadKDString((String)"\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff1a\u7ec8\u6b62\u72b6\u6001\u5fc5\u987b\u662f\u6b63\u5e38\u624d\u80fd\u7ec8\u6b62\u3002", (String)"BizStatusValidator_8", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), i);
                                this.addMessage(data, tip, ErrorLevel.Error);
                                continue;
                            }
                            if (!RowCloseStatusEnum.ROWCLOSE.getValue().equals(rowCloseStatus)) continue;
                            tip = String.format(ResManager.loadKDString((String)"\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff1a\u5173\u95ed\u72b6\u6001\u5fc5\u987b\u662f\u6b63\u5e38\u624d\u80fd\u7ec8\u6b62\u3002", (String)"BizStatusValidator_9", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), i);
                            this.addMessage(data, tip, ErrorLevel.Error);
                        }
                    }
                }
                break;
            }
            case "rowunterminate": {
                String option = this.getOption().getVariableValue("bos_listselectedrowcollection");
                ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)SerializationUtils.fromJsonString((String)option, ListSelectedRowCollection.class);
                ArrayList<Object> selRowList = new ArrayList<Object>(Arrays.asList(selectedRows.getEntryPrimaryKeyValues()));
                if (CommonUtils.isNull(selRowList)) break;
                for (ExtendedDataEntity data : this.dataEntities) {
                    DynamicObject bill = data.getDataEntity();
                    String closeStatus = bill.getString("closestatus");
                    if (BizCloseStatusEnum.CLOSE.getValue().equals(closeStatus)) {
                        this.addMessage(data, ResManager.loadKDString((String)"\u5df2\u5173\u95ed\u7684\u5355\u636e\u65e0\u6cd5\u6267\u884c\u884c\u53cd\u7ec8\u6b62\u64cd\u4f5c\u3002", (String)"BizStatusValidator_10", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), ErrorLevel.Error);
                        continue;
                    }
                    for (ListSelectedRow selectedRow : selectedRows) {
                        String entryEntityKey = selectedRow.getEntryEntityKey();
                        Object entryEntityId = selectedRow.getEntryPrimaryKeyValue();
                        int i = 0;
                        for (DynamicObject entry : bill.getDynamicObjectCollection(entryEntityKey)) {
                            String tip;
                            ++i;
                            if (!(entryEntityId instanceof Long) || !(entry.getPkValue() instanceof Long) || !entryEntityId.equals(entry.getPkValue())) continue;
                            String rowCloseStatus = entry.getString("rowclosestatus");
                            String rowTerminateStatus = entry.getString("rowterminatestatus");
                            if (RowTerminateStatusEnum.UNROWTERMINATE.getValue().equals(rowTerminateStatus)) {
                                tip = String.format(ResManager.loadKDString((String)"\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff1a\u7ec8\u6b62\u72b6\u6001\u5fc5\u987b\u662f\u7ec8\u6b62\u624d\u80fd\u53cd\u7ec8\u6b62\u3002", (String)"BizStatusValidator_11", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), i);
                                this.addMessage(data, tip, ErrorLevel.Error);
                                continue;
                            }
                            if (!RowCloseStatusEnum.ROWCLOSE.getValue().equals(rowCloseStatus)) continue;
                            tip = String.format(ResManager.loadKDString((String)"\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff1a\u5173\u95ed\u72b6\u6001\u5fc5\u987b\u662f\u6b63\u5e38\u624d\u80fd\u53cd\u7ec8\u6b62\u3002", (String)"BizStatusValidator_12", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), i);
                            this.addMessage(data, tip, ErrorLevel.Error);
                        }
                    }
                }
                break;
            }
            case "rowunclose": {
                String option = this.getOption().getVariableValue("bos_listselectedrowcollection");
                ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)SerializationUtils.fromJsonString((String)option, ListSelectedRowCollection.class);
                ArrayList<Object> selRowList = new ArrayList<Object>(Arrays.asList(selectedRows.getEntryPrimaryKeyValues()));
                if (CommonUtils.isNull(selRowList)) break;
                for (ExtendedDataEntity data : this.dataEntities) {
                    DynamicObject bill = data.getDataEntity();
                    String closeStatus = bill.getString("closestatus");
                    if (BizCloseStatusEnum.CLOSE.getValue().equals(closeStatus)) {
                        this.addMessage(data, ResManager.loadKDString((String)"\u5df2\u5173\u95ed\u7684\u5355\u636e\u65e0\u6cd5\u6267\u884c\u884c\u53cd\u5173\u95ed\u64cd\u4f5c\u3002", (String)"BizStatusValidator_13", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), ErrorLevel.Error);
                        continue;
                    }
                    for (ListSelectedRow selectedRow : selectedRows) {
                        String entryEntityKey = selectedRow.getEntryEntityKey();
                        Object entryEntityId = selectedRow.getEntryPrimaryKeyValue();
                        int i = 0;
                        for (DynamicObject entry : bill.getDynamicObjectCollection(entryEntityKey)) {
                            ++i;
                            if (!(entryEntityId instanceof Long) || !(entry.getPkValue() instanceof Long) || !entryEntityId.equals(entry.getPkValue())) continue;
                            String rowCloseStatus = entry.getString("rowclosestatus");
                            if (!RowCloseStatusEnum.UNROWCLOSE.getValue().equals(rowCloseStatus)) continue;
                            String tip = String.format(ResManager.loadKDString((String)"\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff1a\u5173\u95ed\u72b6\u6001\u5fc5\u987b\u662f\u5173\u95ed\u624d\u80fd\u53cd\u5173\u95ed\u3002", (String)"BizStatusValidator_14", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), i);
                            this.addMessage(data, tip, ErrorLevel.Error);
                        }
                    }
                }
                break;
            }
            case "delete": {
                for (ExtendedDataEntity data : this.dataEntities) {
                    DynamicObject bill = data.getDataEntity();
                    if (bill.getDynamicObjectType().getProperty("cancelstatus") == null) continue;
                    String cancelStatus = bill.getString("cancelstatus");
                    if (!BizCancelStatusEnum.CANCEL.getValue().equals(cancelStatus)) continue;
                    this.addMessage(data, ResManager.loadKDString((String)"\u53ea\u80fd\u5220\u9664\u672a\u4f5c\u5e9f\u7684\u6570\u636e\u3002", (String)"BizStatusValidator_15", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), ErrorLevel.Error);
                }
                break;
            }
        }
    }
}

