/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.opvalidate.validator;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class MaterialValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>();
        }
        preparePropertys.add("materialgroup");
        preparePropertys.add("material");
        preparePropertys.add("materialmasterid");
        preparePropertys.add("materialname");
        return preparePropertys;
    }

    public void validate() {
        if (this.getDataEntities() == null || this.getDataEntities().length == 0) {
            return;
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            boolean hasMaterialGroup = false;
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            if (entrys == null || entrys.size() <= 0) continue;
            for (int i = 0; i < entrys.size(); ++i) {
                String materialName;
                String materialName2;
                Boolean isDisposable;
                DynamicObject entry = (DynamicObject)entrys.get(i);
                if (!hasMaterialGroup || entry.getDynamicObjectType().getProperty("material") != null) {
                    hasMaterialGroup = true;
                }
                DynamicObject material = entry.getDynamicObject("material");
                DynamicObject materialgroup = null;
                if (hasMaterialGroup) {
                    materialgroup = entry.getDynamicObject("materialgroup");
                }
                if (CommonUtils.isNull((Object)material) && CommonUtils.isNull((Object)materialgroup)) {
                    String tipMsg = String.format(ResManager.loadKDString((String)"\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff1a\u7269\u6599\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MaterialValidator_1", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), i + 1);
                    this.addMessage(dataEntity, tipMsg, ErrorLevel.Error);
                    continue;
                }
                DynamicObject materialmasterid = null;
                if (material != null && !CommonUtils.isNull((Object)(materialmasterid = "bd_material".equals(material.getDataEntityType().getName()) ? material : material.getDynamicObject("masterid"))) && (isDisposable = Boolean.valueOf(materialmasterid.getBoolean("isdisposable"))).booleanValue() && StringUtils.isBlank((CharSequence)(materialName2 = entry.getString("materialname")))) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff1a\u54c1\u7c7b\u7269\u6599\u7684\u7269\u6599\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"MaterialValidator_2", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), i + 1), ErrorLevel.Error);
                    continue;
                }
                if (CommonUtils.isNull((Object)materialgroup) || !CommonUtils.isNull((Object)material) || !CommonUtils.isNull((Object)materialmasterid) || !StringUtils.isBlank((CharSequence)(materialName = entry.getString("materialname")))) continue;
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff1a\u7269\u6599\u5206\u7c7b\u7684\u7269\u6599\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"MaterialValidator_3", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), i + 1), ErrorLevel.Error);
            }
        }
    }
}

