/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.opvalidate.validator;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.common.utils.MethodParameterUtil;

public class TaxRateValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>();
        }
        String customparameter = (String)this.getValidation().get("customparameter");
        String taxrateid = MethodParameterUtil.getProperytMappingValue((Object)customparameter, (String)"taxrateid");
        String taxrate = MethodParameterUtil.getProperytMappingValue((Object)customparameter, (String)"taxrate");
        preparePropertys.add(taxrateid);
        preparePropertys.add(taxrate);
        return preparePropertys;
    }

    public void validate() {
        if (this.getDataEntities() == null || this.getDataEntities().length == 0) {
            return;
        }
        String customparameter = (String)this.getValidation().get("customparameter");
        String billentry = MethodParameterUtil.getProperytMappingValue((Object)customparameter, (String)"billentry");
        String taxrateid = MethodParameterUtil.getProperytMappingValue((Object)customparameter, (String)"taxrateid");
        String taxrate = MethodParameterUtil.getProperytMappingValue((Object)customparameter, (String)"taxrate");
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection(billentry);
            if (entrys == null || entrys.size() == 0) {
                return;
            }
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                DynamicObject taxrateId = entry.getDynamicObject(taxrateid);
                BigDecimal taxrateValue = entry.getBigDecimal(taxrate);
                if (taxrateId != null && (taxrateValue == null || taxrateValue.compareTo(taxrateId.getBigDecimal("taxrate")) != 0)) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff1a\u540e\u53f0\u201c\u7a0e\u7387%%\u201d\u5b57\u6bb5\u503c\u4e0e\u201c\u7a0e\u7387\u201d\u5b57\u6bb5\u7684\u503c\u4e0d\u4e00\u81f4\u3002", (String)"TaxRateValidator_0", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), i + 1), ErrorLevel.Error);
                }
                if (taxrateId != null || taxrateValue == null || !BigDecimalUtil.isNotZero((BigDecimal)taxrateValue)) continue;
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff1a\u201c\u7a0e\u7387\u201d\u4e3a\u7a7a\u65f6\uff0c\u540e\u53f0\u201c\u7a0e\u7387%%\u201d\u5b57\u6bb5\u503c\u4e5f\u5e94\u8be5\u4e3a\u7a7a\u3002", (String)"TaxRateValidator_1", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), i + 1), ErrorLevel.Error);
            }
        }
    }
}

