/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.basedata.business.helper.allowCtrl;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class BillImportHelper {
    private static final String EntityID_Org_structure = "bos_org_structure";
    private static final String EntityID_Org_org = "bos_org";
    private static final String PROP_LONGNUMBER = "longnumber";
    public static final String ID = "id";
    public static final String NUMBER = "number";

    public static Map<?, ?> format4ImportAndApi(Object sourceData) {
        if (sourceData instanceof JSONObject) {
            return BillImportHelper.format4Api((Map)SerializationUtils.fromJsonString((String)sourceData.toString(), Map.class));
        }
        if (sourceData instanceof Map) {
            return BillImportHelper.format4Api((Map)sourceData);
        }
        return null;
    }

    private static Map<String, Object> format4Api(Map sourceData) {
        if (sourceData == null || sourceData.get("importprop") != null) {
            return sourceData;
        }
        if (sourceData.get(NUMBER) != null) {
            sourceData.put("importprop", NUMBER);
        }
        if (sourceData.get(ID) != null) {
            sourceData.put("importprop", ID);
        }
        if (sourceData.get("operatornumber") != null) {
            sourceData.put("importprop", "operatornumber");
        }
        if (sourceData.get("operatorname") != null) {
            sourceData.put("importprop", "operatorname");
        }
        if (sourceData.get("phone") != null) {
            sourceData.put("importprop", "phone");
        }
        return sourceData;
    }

    public static DynamicObject getBaseDataFromCache(Map<String, Object> sourceData, String propName, String propEntityName, String select, QFilter[] qFilters, Map tempCache) {
        if (sourceData == null) {
            return null;
        }
        Map<?, ?> propMap = BillImportHelper.format4ImportAndApi(sourceData.get(propName));
        if (propMap != null) {
            String importProp = (String)propMap.get("importprop");
            DynamicObject value = (DynamicObject)tempCache.get(propName + "_" + propMap.get(importProp));
            if (value == null && !ID.equals(importProp)) {
                if (select == null) {
                    select = ID;
                }
                if (qFilters == null) {
                    qFilters = new QFilter[]{new QFilter(importProp, "=", (Object)((String)propMap.get(importProp)))};
                }
                value = BusinessDataServiceHelper.loadSingleFromCache((String)propEntityName, (String)select, (QFilter[])qFilters);
            }
            if (value == null && ID.equals(importProp)) {
                value = BusinessDataServiceHelper.newDynamicObject((String)propEntityName);
                value.set(ID, propMap.get(ID));
            }
            return value;
        }
        return null;
    }

    public static QFilter getBaseDataOrgFilterFromCache(DynamicObject org, String propName, String propEntityName, Map tempCache) {
        QFilter baseDataOrgFilter = (QFilter)tempCache.get(org.getPkValue() + "_" + propName + "OrgFilter");
        if (baseDataOrgFilter == null) {
            baseDataOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)propEntityName, (Long)((Long)org.getPkValue()));
            tempCache.put(org.getPkValue() + "_" + propName + "OrgFilter", baseDataOrgFilter);
        }
        return baseDataOrgFilter;
    }

    public static boolean isImport(String billcretype) {
        return !"2".equals(billcretype);
    }

    public static boolean isManual(String billcretype) {
        return !"1".equals(billcretype) && !"2".equals(billcretype);
    }

    public static Set<Long> getGroupOrgId(String entity, Long useOrgs) {
        DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entity);
        HashSet<String> longnumberSet = new HashSet<String>();
        ORM ormOv = ORM.create();
        DataSet ds = ormOv.queryDataSet(BillImportHelper.class.getName(), EntityID_Org_structure, PROP_LONGNUMBER, new QFilter[]{new QFilter("org", "=", (Object)useOrgs), new QFilter("view.id", "=", (Object)ctrlview.getLong(ID))});
        Object object = null;
        try {
            for (Row row : ds) {
                if (row.getString(PROP_LONGNUMBER) == null) continue;
                longnumberSet.add(row.getString(PROP_LONGNUMBER));
            }
        }
        catch (Throwable iter) {
            object = iter;
            throw iter;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable iter) {
                        ((Throwable)object).addSuppressed(iter);
                    }
                } else {
                    ds.close();
                }
            }
        }
        HashSet<String> numberSets = new HashSet<String>();
        for (String longnumber : longnumberSet) {
            String[] numbers = longnumber.split("!");
            numberSets.addAll(new HashSet<String>(Arrays.asList(numbers)));
        }
        HashSet<Long> ids = new HashSet<Long>();
        try (DataSet ds2 = ormOv.queryDataSet(BillImportHelper.class.getName(), EntityID_Org_org, ID, new QFilter[]{new QFilter(NUMBER, "in", numberSets)});){
            for (Row row : ds2) {
                if (row.getLong(ID) == null) continue;
                ids.add(row.getLong(ID));
            }
        }
        return ids;
    }

    public static List<Long> getHasPermissionOrg(String entityName, String orgViewType) {
        List hasPermissionOrgs = null;
        hasPermissionOrgs = OrgViewServiceHelper.getAllPermissionOrgs((String)entityName, (String)orgViewType);
        if (CommonUtils.isNull((Object)hasPermissionOrgs)) {
            return null;
        }
        Map tempInvStart = null;
        ArrayList<Long> orgIDs = new ArrayList<Long>();
        if ("05".equals(orgViewType)) {
            QFilter qFilter = new QFilter("startstatus", "=", (Object)"B");
            tempInvStart = BusinessDataServiceHelper.loadFromCache((String)"im_invstart", (String)"id,org,startdate", (QFilter[])new QFilter[]{qFilter});
            if (CommonUtils.isNull((Object)tempInvStart)) {
                return null;
            }
            for (DynamicObject invStart : tempInvStart.values()) {
                DynamicObject org = invStart.getDynamicObject("org");
                if (org == null) continue;
                orgIDs.add((Long)org.getPkValue());
            }
        }
        ArrayList<Long> orgs = new ArrayList<Long>();
        for (Map tempOrg : hasPermissionOrgs) {
            Long tempOrgId = Long.valueOf((String)tempOrg.get(ID));
            if (tempInvStart != null && orgIDs != null && orgIDs.size() >= 1 && !orgIDs.contains(tempOrgId)) continue;
            orgs.add(tempOrgId);
        }
        return orgs;
    }
}

