/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.partitiontask;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.partitiontask.bean.CombinPartitionTaskInfo;
import kd.mpscmm.msbd.partitiontask.exception.PartitionTaskErrorCode;

public class CombinPartitionTaskBuilder {
    private CombinPartitionTaskInfo taskInfo = new CombinPartitionTaskInfo();

    public CombinPartitionTaskBuilder setCombinSchemeId(Long schemeId) {
        this.taskInfo.setCombinSchemeId(schemeId);
        return this;
    }

    public CombinPartitionTaskBuilder setCombinSchemeNumber(String schemeNumber) {
        DynamicObject schemeInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"msbd_combinscheme", (String)"id", (QFilter[])new QFilter("number", "=", (Object)schemeNumber).toArray());
        if (schemeInfo == null) {
            throw new KDBizException(PartitionTaskErrorCode.getTaskNumberError(), new Object[]{schemeNumber});
        }
        this.taskInfo.setCombinSchemeId(schemeInfo.getLong("id"));
        return this;
    }

    public CombinPartitionTaskBuilder setCustomerParam(Map<Integer, Map<String, Object>> params) {
        this.taskInfo.setParamMap(params);
        return this;
    }

    public CombinPartitionTaskBuilder setMutexKey(String mutexKey) {
        if (mutexKey.length() > 255) {
            throw new KDBizException(PartitionTaskErrorCode.getMutexKeyOverSizeError(), new Object[0]);
        }
        this.taskInfo.setMutexKey(mutexKey);
        return this;
    }

    public CombinPartitionTaskInfo build() {
        if (this.taskInfo.getCombinSchemeId() == null) {
            throw new IllegalArgumentException("combinSchemeId can not be null!");
        }
        return this.taskInfo;
    }
}

