/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.partitiontask.bean;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.partitiontask.exception.PartitionTaskErrorCode;

public class CombinPartitionTaskInfo {
    private static final Log logger = LogFactory.getLog((String)"kd.mpscmm.msbd.partitiontask.bean.CombinPartitionTaskInfo");
    private Long combinSchemeId;
    private Map<Integer, Map<String, Object>> paramMap;
    private String mutexKey;
    private String appId;

    public Long getCombinSchemeId() {
        return this.combinSchemeId;
    }

    public void setCombinSchemeId(Long combinSchemeId) {
        this.combinSchemeId = combinSchemeId;
    }

    public Map<Integer, Map<String, Object>> getParamMap() {
        return this.paramMap;
    }

    public void setParamMap(Map<Integer, Map<String, Object>> paramMap) {
        this.paramMap = paramMap;
    }

    public String getMutexKey() {
        return this.mutexKey;
    }

    public void setMutexKey(String mutexKey) {
        this.mutexKey = mutexKey;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String toString() {
        return "CombinPartitionTaskInfo{combinSchemeId=" + this.combinSchemeId + ", paramMap=" + this.paramMap + ", mutexKey='" + this.mutexKey + '\'' + '}';
    }

    public void execute() {
        DynamicObject combinScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)this.combinSchemeId, (String)"msbd_combinscheme");
        if (combinScheme == null) {
            throw new KDBizException(PartitionTaskErrorCode.getTaskIdError(), new Object[]{this.combinSchemeId});
        }
        String schemeName = combinScheme.getString("name");
        DynamicObject combinTaskLogInfo = this.buildCombinTaskInfo(this.paramMap, combinScheme);
        Long combinTaskId = combinTaskLogInfo.getLong("id");
        if (StringUtils.isEmpty((String)this.appId)) {
            this.appId = "im";
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("taskid", combinTaskId);
        paramMap.put("mutexkey", this.mutexKey);
        paramMap.put("appId", this.appId);
        JobInfo jobInfo = new JobInfo();
        jobInfo.setName(schemeName);
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setParams(paramMap);
        jobInfo.setAppId(this.appId);
        jobInfo.setTaskClassname("kd.mpscmm.msbd.partitiontask.task.CombinPartitionTask");
        jobInfo.setRunByLang(Lang.get());
        JobClient.dispatch((JobInfo)jobInfo);
    }

    private DynamicObject buildCombinTaskInfo(Map<Integer, Map<String, Object>> paramMap, DynamicObject combinScheme) {
        DynamicObject taskInfo = BusinessDataServiceHelper.newDynamicObject((String)"msbd_tasklog");
        long id = DB.genLongId((String)"t_msbd_tasklog");
        taskInfo.set("id", (Object)id);
        taskInfo.set("masterid", (Object)id);
        taskInfo.set("status", (Object)"C");
        taskInfo.set("enable", (Object)"1");
        taskInfo.set("creator_id", (Object)RequestContext.get().getCurrUserId());
        long time = TimeServiceHelper.now().getTime();
        taskInfo.set("number", (Object)combinScheme.getString("number").concat(String.valueOf(time)));
        taskInfo.set("name", (Object)combinScheme.getString("name").concat(String.valueOf(time)));
        taskInfo.set("taskstatus", (Object)"C");
        taskInfo.set("createtime", (Object)TimeServiceHelper.now());
        taskInfo.set("iscombin", (Object)"1");
        taskInfo.set("times", (Object)0);
        taskInfo.set("combinscheme", (Object)combinScheme.getLong("id"));
        try {
            String requestJSON = JSONUtils.toString(paramMap);
            taskInfo.set("param_tag", (Object)requestJSON);
            if (requestJSON.length() > 255) {
                taskInfo.set("param", (Object)requestJSON.substring(0, 255));
            } else {
                taskInfo.set("param", (Object)requestJSON);
            }
        }
        catch (IOException e) {
            logger.error("\u8bf7\u6c42\u53c2\u6570\u89e3\u6790\u4e3ajson\u5931\u8d25", (Throwable)e);
            throw new KDException((Throwable)e, PartitionTaskErrorCode.getParamParseError(), new Object[0]);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskInfo});
        return taskInfo;
    }
}

