/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.partitiontask.bean;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.partitiontask.exception.PartitionTaskErrorCode;
import kd.mpscmm.msbd.partitiontask.task.PartitionTaskHelper;

public class PartitionTaskInfo {
    private static final Log logger = LogFactory.getLog((String)"kd.mpscmm.msbd.partitiontask.bean.PartitionTaskInfo");
    private Long schemeId;
    private String mutexKey;
    private String appId;
    private Map<String, Object> customerParam = new HashMap<String, Object>();

    public Long getSchemeId() {
        return this.schemeId;
    }

    public void setSchemeId(Long schemeId) {
        this.schemeId = schemeId;
    }

    public String getMutexKey() {
        return this.mutexKey;
    }

    public void setMutexKey(String mutexKey) {
        this.mutexKey = mutexKey;
    }

    public Map<String, Object> getCustomerParam() {
        return this.customerParam;
    }

    public void setCustomerParam(Map<String, Object> customerParam) {
        this.customerParam = customerParam;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String toString() {
        return "PartitionTask{schemeId=" + this.schemeId + ", mutexString='" + this.mutexKey + '\'' + '}';
    }

    public Long execute() {
        DynamicObject taskScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)this.schemeId, (String)"msbd_tasklogscheme", (String)"name");
        if (taskScheme == null) {
            throw new KDBizException(PartitionTaskErrorCode.getTaskIdError(), new Object[]{this.schemeId});
        }
        Map<String, Object> schemeParams = PartitionTaskHelper.buildSchemeParams(this.schemeId);
        String schemeName = taskScheme.getString("name");
        DynamicObject mainTaskLogInfo = this.buildMainTaskLogInfo(schemeParams, this.customerParam);
        Long mainTaskId = mainTaskLogInfo.getLong("id");
        if (StringUtils.isEmpty((String)this.appId)) {
            this.appId = "im";
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("taskid", mainTaskId);
        paramMap.put("mutexkey", this.mutexKey);
        paramMap.put("appId", this.appId);
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setName(schemeName);
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setParams(paramMap);
        jobInfo.setAppId(this.appId);
        jobInfo.setTaskClassname("kd.mpscmm.msbd.partitiontask.task.MainPartitionTask");
        PartitionTaskHelper.initRunningCount(mainTaskId.toString(), 1);
        JobClient.dispatch((JobInfo)jobInfo);
        return mainTaskId;
    }

    private DynamicObject buildMainTaskLogInfo(Map<String, Object> mainTaskParams, Map<String, Object> requestParams) {
        DynamicObject taskInfo = BusinessDataServiceHelper.newDynamicObject((String)"msbd_tasklog");
        long id = DB.genLongId((String)"t_msbd_tasklog");
        taskInfo.set("id", (Object)id);
        taskInfo.set("maintasklogid", (Object)id);
        taskInfo.set("status", (Object)"C");
        taskInfo.set("enable", (Object)"1");
        taskInfo.set("creator_id", (Object)RequestContext.get().getCurrUserId());
        taskInfo.set("number", mainTaskParams.get("number"));
        taskInfo.set("name", mainTaskParams.get("name"));
        taskInfo.set("taskstatus", (Object)"C");
        taskInfo.set("createtime", (Object)TimeServiceHelper.now());
        taskInfo.set("ismaintask", (Object)"1");
        taskInfo.set("times", (Object)0);
        taskInfo.set("schemeid", mainTaskParams.get("schemeid"));
        try {
            String requestJSON = JSONUtils.toString(requestParams);
            taskInfo.set("param_tag", (Object)requestJSON);
            if (requestJSON.length() > 255) {
                taskInfo.set("param", (Object)requestJSON.substring(0, 255));
            } else {
                taskInfo.set("param", (Object)requestJSON);
            }
        }
        catch (IOException e) {
            logger.error("\u8bf7\u6c42\u53c2\u6570\u89e3\u6790\u4e3ajson\u5931\u8d25", (Throwable)e);
            throw new KDException((Throwable)e, PartitionTaskErrorCode.getParamParseError(), new Object[0]);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskInfo});
        return taskInfo;
    }
}

