/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.partitiontask.formplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.partitiontask.api.ISubTaskLinkForm;
import kd.mpscmm.msbd.partitiontask.exception.PartitionTaskErrorCode;
import kd.mpscmm.msbd.partitiontask.task.PartitionTaskHelper;

public class TasklogListPlugin
extends AbstractListPlugin {
    public static final String TBLRETRY = "tblretry";
    public static final String TBLCANCEL = "tblcancel";
    public static final String LINKFORM = "linkform";
    public static final String STOPCOMBINTASK = "stopcombintask";

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "tblretry": {
                this.retryTask();
                break;
            }
            case "tblcancel": {
                this.closeTask();
                break;
            }
            case "linkform": {
                this.linkForm();
                break;
            }
            case "stopcombintask": {
                this.stopCombinTask();
            }
        }
    }

    private void stopCombinTask() {
        Object[] selectIds = this.getSelectedRows().getPrimaryKeyValues();
        if (selectIds == null || selectIds.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u4e00\u6761\u6267\u884c\u4e2d\u7684\u7ec4\u5408\u4efb\u52a1\u3002", (String)"selectOneCombinTask", (String)"mpscmm-msbd-partitiontask", (Object[])new Object[0]));
            return;
        }
        DynamicObject subTask = QueryServiceHelper.queryOne((String)"msbd_tasklog", (String)"id", (QFilter[])new QFilter("id", "=", selectIds[0]).and("iscombin", "=", (Object)true).and("taskstatus", "=", (Object)"B").toArray());
        if (subTask == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u4e00\u6761\u6267\u884c\u4e2d\u7684\u7ec4\u5408\u4efb\u52a1\u3002", (String)"selectOneCombinTask", (String)"mpscmm-msbd-partitiontask", (Object[])new Object[0]));
            return;
        }
        PartitionTaskHelper.markStop(subTask.getString("id"));
    }

    private void linkForm() {
        Object[] selectIds = this.getSelectedRows().getPrimaryKeyValues();
        if (selectIds == null || selectIds.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u4e00\u6761\u5b50\u4efb\u52a1\u3002", (String)"selectOneSubTask", (String)"mpscmm-msbd-partitiontask", (Object[])new Object[0]));
        } else {
            DynamicObject subTask = BusinessDataServiceHelper.loadSingle((String)"msbd_tasklog", (String)"id,param_tag,schemeid.id,schemeid.linkbillimpl as linkbillimpl", (QFilter[])new QFilter("id", "=", selectIds[0]).and("ismaintask", "=", (Object)Boolean.FALSE).and("iscombin", "=", (Object)false).toArray());
            if (subTask == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u4e00\u6761\u5b50\u4efb\u52a1\u3002", (String)"selectOneSubTask", (String)"mpscmm-msbd-partitiontask", (Object[])new Object[0]));
                return;
            }
            String linkBillImpl = subTask.getDynamicObject("schemeid").getString("linkbillimpl");
            if (StringUtils.isEmpty((String)linkBillImpl)) {
                throw new KDBizException(PartitionTaskErrorCode.getImplementsLinkForm(), new Object[0]);
            }
            Object subTaskImpl = TypesContainer.getOrRegisterSingletonInstance((String)linkBillImpl);
            if (subTaskImpl instanceof ISubTaskLinkForm) {
                String paramTag = subTask.getString("param_tag");
                Map<String, Object> paramMap = new HashMap<String, Object>();
                if (!StringUtils.isEmpty((String)paramTag)) {
                    paramMap = (Map)SerializationUtils.fromJsonString((String)paramTag, Map.class);
                }
                ((ISubTaskLinkForm)subTaskImpl).openForm(paramMap);
            } else {
                throw new KDBizException(PartitionTaskErrorCode.getImplementsLinkForm(), new Object[0]);
            }
        }
    }

    private List<Long> getSelectErrSubTaskIds() {
        DynamicObjectCollection selectRowObjs;
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectRows = billList.getSelectedRows();
        HashSet<Long> selectRowIds = new HashSet<Long>(selectRows.size());
        for (ListSelectedRow row : selectRows) {
            Long tasklogid = (Long)row.getPrimaryKeyValue();
            selectRowIds.add(tasklogid);
        }
        if (!selectRowIds.isEmpty() && !(selectRowObjs = QueryServiceHelper.query((String)"msbd_tasklog", (String)"id", (QFilter[])new QFilter("id", "in", selectRowIds).and("ismaintask", "=", (Object)Boolean.FALSE).and("iscombin", "=", (Object)false).and("taskstatus", "=", (Object)"D").toArray(), (String)"id")).isEmpty()) {
            ArrayList<Long> errSubTasks = new ArrayList<Long>(selectRowObjs.size());
            for (DynamicObject selectRowObj : selectRowObjs) {
                errSubTasks.add(selectRowObj.getLong("id"));
            }
            return errSubTasks;
        }
        return Collections.emptyList();
    }

    private void retryTask() {
        List<Long> errSubTasks = this.getSelectErrSubTaskIds();
        if (errSubTasks.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u62e9\u72b6\u6001\u4e3a\u9519\u8bef\u7684\u5b50\u4efb\u52a1\u3002", (String)"TasklogListPlugin_0", (String)"mpscmm-msbd-partitiontask", (Object[])new Object[0]));
        } else {
            PartitionTaskHelper.retryTask(errSubTasks, null);
            this.getView().updateView();
        }
    }

    private void closeTask() {
        List<Long> errSubTasks = this.getSelectErrSubTaskIds();
        if (errSubTasks.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u62e9\u72b6\u6001\u4e3a\u9519\u8bef\u7684\u5b50\u4efb\u52a1\u3002", (String)"TasklogListPlugin_0", (String)"mpscmm-msbd-partitiontask", (Object[])new Object[0]));
        } else {
            PartitionTaskHelper.closeTask(errSubTasks);
            DynamicObjectCollection subTasks = QueryServiceHelper.query((String)"msbd_tasklog", (String)"dispatchtaskid", (QFilter[])new QFilter("id", "in", errSubTasks).toArray());
            ArrayList<String> taskIds = new ArrayList<String>();
            for (DynamicObject subTask : subTasks) {
                taskIds.add(subTask.getString("dispatchtaskid"));
            }
            PartitionTaskHelper.deleteJobs(taskIds);
            this.getView().updateView();
        }
    }
}

