/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.partitiontask.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.partitiontask.PartitionTaskBuilder;
import kd.mpscmm.msbd.partitiontask.bean.PartitionTaskInfo;
import kd.mpscmm.msbd.partitiontask.exception.PartitionTaskErrorCode;
import kd.mpscmm.msbd.partitiontask.task.PartitionTaskHelper;

public class CombinPartitionTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog((String)"kd.mpscmm.msbd.partitiontask.task.CombinPartitionTask");
    public static Long INTERVAL = 10000L;

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        Long combinTaskId = (Long)params.get("taskid");
        String mutexKey = (String)params.get("mutexkey");
        String execAppId = (String)params.get("appId");
        if (StringUtils.isEmpty((String)execAppId)) {
            execAppId = "im";
        }
        DynamicObject combinTask = BusinessDataServiceHelper.loadSingle((Object)combinTaskId, (String)"msbd_tasklog");
        DynamicObject combinScheme = combinTask.getDynamicObject("combinscheme");
        boolean stopOnFail = combinScheme.getBoolean("stoponfail");
        ArrayList<String> allMainTaskIdList = new ArrayList<String>();
        try {
            PartitionTaskHelper.checkAndAddMutex(mutexKey, combinTaskId);
            PartitionTaskHelper.setRunTask(combinTaskId, this.taskId);
            PartitionTaskHelper.initRunningFalg(combinTaskId.toString());
            String paramTag = combinTask.getString("param_tag");
            Map paramMap = (Map)SerializationUtils.fromJsonString((String)paramTag, Map.class);
            DynamicObjectCollection entryCol = combinScheme.getDynamicObjectCollection("entryentity");
            HashMap<String, String> seqMap = new HashMap<String, String>(entryCol.size());
            int size = entryCol.size();
            for (int i = 0; i < size; ++i) {
                DynamicObject entry = (DynamicObject)entryCol.get(i);
                seqMap.put(entry.getString("id"), i + "");
            }
            entryCol.sort((entry1, entry2) -> entry1.getInt("execorder") - entry1.getInt("execorder"));
            int preExecOrder = 0;
            ArrayList<String> execMainTaskIdList = new ArrayList<String>();
            for (DynamicObject entry : entryCol) {
                Long mainTaskId;
                DynamicObject scheme = entry.getDynamicObject("scheme");
                String seq = (String)seqMap.get(entry.getString("id"));
                PartitionTaskBuilder builder = new PartitionTaskBuilder();
                Map param = (Map)paramMap.get(seq);
                PartitionTaskInfo task = builder.setSchemeId(scheme.getLong("id")).setParam(param).setAppId(execAppId).build();
                int execOrder = entry.getInt("execorder");
                if (execOrder == preExecOrder) {
                    mainTaskId = task.execute();
                } else {
                    while (PartitionTaskHelper.isTaskListRunning(execMainTaskIdList)) {
                        if (!PartitionTaskHelper.isContinueRunning(combinTaskId.toString()).booleanValue()) {
                            throw new KDBizException(PartitionTaskErrorCode.getUserCancelError(), new Object[0]);
                        }
                        if (stopOnFail && PartitionTaskHelper.isTaskListFail(execMainTaskIdList)) {
                            throw new KDBizException(PartitionTaskErrorCode.getStopOnFailError(), new Object[0]);
                        }
                        try {
                            Thread.sleep(INTERVAL);
                        }
                        catch (InterruptedException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    mainTaskId = task.execute();
                    execMainTaskIdList.clear();
                }
                preExecOrder = execOrder;
                if (mainTaskId == null) continue;
                execMainTaskIdList.add(mainTaskId.toString());
                allMainTaskIdList.add(mainTaskId.toString());
            }
            while (PartitionTaskHelper.isTaskListRunning(allMainTaskIdList)) {
                if (!PartitionTaskHelper.isContinueRunning(combinTaskId.toString()).booleanValue()) {
                    throw new KDBizException(PartitionTaskErrorCode.getUserCancelError(), new Object[0]);
                }
                try {
                    Thread.sleep(INTERVAL);
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            PartitionTaskHelper.setSuccessTask(combinTaskId);
            PartitionTaskHelper.deleteJob(this.taskId);
        }
        catch (Exception e) {
            logger.error("\u7ec4\u5408\u4efb\u52a1\u6267\u884c\u5931\u8d25", (Throwable)e);
            PartitionTaskHelper.setErrTask(combinTaskId, e.getMessage());
            throw new KDException(PartitionTaskErrorCode.getExecTaskError(), new Object[]{e});
        }
        finally {
            this.doStop(combinTaskId.toString(), allMainTaskIdList, mutexKey, combinTaskId);
        }
    }

    private void doStop(String combinTaskId, List<String> mainTaskIdList, String mutexKey, Long taskId) {
        PartitionTaskHelper.clearRunningFalg(combinTaskId);
        PartitionTaskHelper.releaseMutex(mutexKey, taskId);
        for (String mainTaskId : mainTaskIdList) {
            PartitionTaskHelper.subTaskRunningCountClear(mainTaskId);
        }
    }
}

