/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.partitiontask.task;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.partitiontask.api.IPartitionTaskExecutor;
import kd.mpscmm.msbd.partitiontask.exception.PartitionTaskErrorCode;
import kd.mpscmm.msbd.partitiontask.task.PartitionTaskHelper;

public class MainPartitionTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(MainPartitionTask.class);
    private static final int SAVE_SIZE = 2000;

    public void execute(RequestContext ctx, Map<String, Object> paramMap) throws KDException {
        Long mainTaskId = (Long)paramMap.get("taskid");
        String mutexKey = (String)paramMap.get("mutexkey");
        String execAppId = (String)paramMap.get("appId");
        Map<Long, String> subTaskIdNameMap = null;
        try {
            int maxParallel;
            List<Map<String, Object>> paramsList;
            DynamicObject mainTaskLogInfo = BusinessDataServiceHelper.loadSingle((Object)mainTaskId, (String)"msbd_tasklog");
            PartitionTaskHelper.setRunTask(mainTaskId, this.taskId);
            String paramTag = mainTaskLogInfo.getString("param_tag");
            Map requestParams = (Map)SerializationUtils.fromJsonString((String)paramTag, Map.class);
            Long schemeId = mainTaskLogInfo.getDynamicObject("schemeid").getLong("id");
            Map<String, Object> schemeParams = PartitionTaskHelper.buildSchemeParams(schemeId);
            PartitionTaskHelper.checkAndAddMutex(mutexKey, mainTaskId);
            try {
                paramsList = this.analyseAndPartitionParams(schemeParams, requestParams);
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, PartitionTaskErrorCode.getCallMethodError(), new Object[0]);
            }
            if (paramsList == null || paramsList.isEmpty()) {
                throw new KDException(PartitionTaskErrorCode.getNotReturnResult(), new Object[0]);
            }
            subTaskIdNameMap = this.buildSubTaskLogInfo(mainTaskId, schemeParams, paramsList, mutexKey);
            PartitionTaskHelper.initRunningCount(mainTaskLogInfo.getString("id"), subTaskIdNameMap.size());
            boolean runByOrder = (Boolean)schemeParams.get("runbyorder");
            int n = maxParallel = runByOrder ? 1 : (Integer)schemeParams.get("maxparallel");
            if (maxParallel == 0) {
                maxParallel = Integer.MAX_VALUE;
            }
            try (DLock lock = DLock.create((String)mainTaskLogInfo.getString("id"), (String)ResManager.loadKDString((String)"\u5206\u6279\u6846\u67b6\u4efb\u52a1\u9501%s", (String)"mainTaskLock", (String)"mpscmm-msbd-partitiontask", (Object[])new Object[]{mainTaskLogInfo.getString("id")}));){
                lock.lock();
                int curIndex = 0;
                for (Map.Entry<Long, String> task : subTaskIdNameMap.entrySet()) {
                    PartitionTaskHelper.dispatchSubJob(task.getValue(), task.getKey(), execAppId);
                    if (++curIndex < maxParallel) continue;
                    break;
                }
            }
            PartitionTaskHelper.setSuccessTask(mainTaskId);
            PartitionTaskHelper.deleteJob(this.taskId);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            PartitionTaskHelper.setErrTask(mainTaskId, e.getMessage());
            ArrayList<String> subTaskIdList = new ArrayList<String>();
            if (subTaskIdNameMap != null && !subTaskIdNameMap.isEmpty()) {
                for (Long subTaskId : subTaskIdNameMap.keySet()) {
                    subTaskIdList.add(subTaskId.toString());
                }
                PartitionTaskHelper.setBatchErrTask(subTaskIdList, ResManager.loadKDString((String)"mainTaskError", (String)"mainTaskError", (String)"mpscmm-msbd-partitiontask", (Object[])new Object[0]));
            }
            PartitionTaskHelper.subTaskRunningCountClear(mainTaskId.toString());
            PartitionTaskHelper.releaseMutex(mutexKey, mainTaskId);
            throw new KDException((Throwable)e, PartitionTaskErrorCode.getExecTaskError(), new Object[0]);
        }
    }

    private List<Map<String, Object>> analyseAndPartitionParams(Map<String, Object> schemeParams, Map<String, Object> requestParams) throws Exception {
        Object splitTaskExecutor = TypesContainer.getOrRegisterSingletonInstance((String)((String)schemeParams.get("mainTaskClass")));
        if (splitTaskExecutor instanceof IPartitionTaskExecutor) {
            return ((IPartitionTaskExecutor)splitTaskExecutor).analyseAndPartitionParams(schemeParams, requestParams);
        }
        throw new KDException(PartitionTaskErrorCode.getImplementsPartitionTask(), new Object[0]);
    }

    private Map<Long, String> buildSubTaskLogInfo(Long mainTaskId, Map<String, Object> mainTaskParams, List<Map<String, Object>> paramsList, String mutexKey) {
        String mainNumber = ((String)mainTaskParams.get("number")).concat("#");
        String mainName = ((String)mainTaskParams.get("name")).concat("#");
        boolean retryWhenFail = (Boolean)mainTaskParams.get("retrywhenfail");
        int retryTime = retryWhenFail ? (Integer)mainTaskParams.get("retrytime") : 0;
        int size = paramsList.size();
        int index = 1;
        HashMap<Long, String> subTaskIdNameMap = new HashMap<Long, String>(size);
        ArrayList<DynamicObject> subTaskList = new ArrayList<DynamicObject>(2000);
        long[] subTaskIds = DB.genLongIds((String)"t_msbd_tasklog", (int)size);
        for (Map<String, Object> params : paramsList) {
            long curSubTaskId = subTaskIds[index - 1];
            DynamicObject taskInfo = BusinessDataServiceHelper.newDynamicObject((String)"msbd_tasklog");
            taskInfo.set("id", (Object)curSubTaskId);
            taskInfo.set("masterid", (Object)curSubTaskId);
            taskInfo.set("status", (Object)"C");
            taskInfo.set("enable", (Object)"1");
            taskInfo.set("creator_id", (Object)RequestContext.get().getCurrUserId());
            taskInfo.set("maintasklogid", (Object)mainTaskId);
            taskInfo.set("number", (Object)mainNumber.concat(String.valueOf(index)));
            taskInfo.set("name", (Object)mainName.concat(String.valueOf(index)));
            taskInfo.set("taskstatus", (Object)"C");
            taskInfo.set("createtime", (Object)TimeServiceHelper.now());
            taskInfo.set("ismaintask", (Object)"0");
            taskInfo.set("times", (Object)0);
            taskInfo.set("retrytimeremain", (Object)retryTime);
            taskInfo.set("schemeid", mainTaskParams.get("schemeid"));
            try {
                if (!StringUtils.isEmpty((String)mutexKey)) {
                    params.put("mutexkey", mutexKey);
                }
                String paramJSON = JSONUtils.toString(params);
                taskInfo.set("param_tag", (Object)paramJSON);
                if (paramJSON.length() > 255) {
                    taskInfo.set("param", (Object)paramJSON.substring(0, 255));
                } else {
                    taskInfo.set("param", (Object)paramJSON);
                }
            }
            catch (IOException e) {
                logger.error("\u8bf7\u6c42\u53c2\u6570\u89e3\u6790\u4e3ajson\u5931\u8d25", (Throwable)e);
                throw new KDException((Throwable)e, PartitionTaskErrorCode.getParamParseError(), new Object[0]);
            }
            subTaskList.add(taskInfo);
            subTaskIdNameMap.put(taskInfo.getLong("id"), taskInfo.getString("name"));
            ++index;
            if (subTaskList.size() < 2000) continue;
            SaveServiceHelper.save((DynamicObject[])subTaskList.toArray(new DynamicObject[0]));
            subTaskList.clear();
        }
        if (!subTaskList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])subTaskList.toArray(new DynamicObject[0]));
        }
        return subTaskIdNameMap;
    }
}

